"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerImageAsset = exports.NetworkMode = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const ecr = require("@aws-cdk/aws-ecr");
const core_1 = require("@aws-cdk/core");
const cxapi = require("@aws-cdk/cx-api");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line
const assets_1 = require("@aws-cdk/assets");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * networking mode on build time supported by docker
 */
class NetworkMode {
    /**
     * @param mode The networking mode to use for docker build
     */
    constructor(mode) {
        this.mode = mode;
    }
    /**
     * Reuse another container's network stack
     *
     * @param containerId The target container's id or name
     */
    static fromContainer(containerId) {
        return new NetworkMode(`container:${containerId}`);
    }
    /**
     * Used to specify a custom networking mode
     * Use this if the networking mode name is not yet supported by the CDK.
     *
     * @param mode The networking mode to use for docker build
     */
    static custom(mode) {
        return new NetworkMode(mode);
    }
}
exports.NetworkMode = NetworkMode;
_a = JSII_RTTI_SYMBOL_1;
NetworkMode[_a] = { fqn: "@aws-cdk/aws-ecr-assets.NetworkMode", version: "1.153.0" };
/**
 * The default networking mode if omitted, create a network stack on the default Docker bridge
 */
NetworkMode.DEFAULT = new NetworkMode('default');
/**
 * Use the Docker host network stack
 */
NetworkMode.HOST = new NetworkMode('host');
/**
 * Disable the network stack, only the loopback device will be created
 */
NetworkMode.NONE = new NetworkMode('none');
/**
 * An asset that represents a Docker image.
 *
 * The image will be created in build time and uploaded to an ECR repository.
 */
class DockerImageAsset extends core_2.Construct {
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ecr_assets_DockerImageAssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        // none of the properties use tokens
        validateProps(props);
        // resolve full path
        const dir = path.resolve(props.directory);
        if (!fs.existsSync(dir)) {
            throw new Error(`Cannot find image directory at ${dir}`);
        }
        // validate the docker file exists
        this.dockerfilePath = props.file || 'Dockerfile';
        const file = path.join(dir, this.dockerfilePath);
        if (!fs.existsSync(file)) {
            throw new Error(`Cannot find file at ${file}`);
        }
        const defaultIgnoreMode = core_1.FeatureFlags.of(this).isEnabled(cxapi.DOCKER_IGNORE_SUPPORT)
            ? core_1.IgnoreMode.DOCKER : core_1.IgnoreMode.GLOB;
        let ignoreMode = (_c = props.ignoreMode) !== null && _c !== void 0 ? _c : defaultIgnoreMode;
        let exclude = props.exclude || [];
        const ignore = path.join(dir, '.dockerignore');
        if (fs.existsSync(ignore)) {
            const dockerIgnorePatterns = fs.readFileSync(ignore).toString().split('\n').filter(e => !!e);
            exclude = [
                ...dockerIgnorePatterns,
                ...exclude,
                // Ensure .dockerignore is included no matter what.
                '!.dockerignore',
            ];
        }
        // Ensure the Dockerfile is included no matter what.
        exclude.push('!' + path.basename(file));
        // Ensure the cdk.out folder is not included to avoid infinite loops.
        const cdkout = (_e = (_d = core_1.Stage.of(this)) === null || _d === void 0 ? void 0 : _d.outdir) !== null && _e !== void 0 ? _e : 'cdk.out';
        exclude.push(cdkout);
        if (props.repositoryName) {
            core_1.Annotations.of(this).addWarning('DockerImageAsset.repositoryName is deprecated. Override "core.Stack.addDockerImageAsset" to control asset locations');
        }
        // include build context in "extra" so it will impact the hash
        const extraHash = {};
        if (((_f = props.invalidation) === null || _f === void 0 ? void 0 : _f.extraHash) !== false && props.extraHash) {
            extraHash.user = props.extraHash;
        }
        if (((_g = props.invalidation) === null || _g === void 0 ? void 0 : _g.buildArgs) !== false && props.buildArgs) {
            extraHash.buildArgs = props.buildArgs;
        }
        if (((_h = props.invalidation) === null || _h === void 0 ? void 0 : _h.target) !== false && props.target) {
            extraHash.target = props.target;
        }
        if (((_j = props.invalidation) === null || _j === void 0 ? void 0 : _j.file) !== false && props.file) {
            extraHash.file = props.file;
        }
        if (((_k = props.invalidation) === null || _k === void 0 ? void 0 : _k.repositoryName) !== false && props.repositoryName) {
            extraHash.repositoryName = props.repositoryName;
        }
        if (((_l = props.invalidation) === null || _l === void 0 ? void 0 : _l.networkMode) !== false && props.networkMode) {
            extraHash.networkMode = props.networkMode;
        }
        // add "salt" to the hash in order to invalidate the image in the upgrade to
        // 1.21.0 which removes the AdoptedRepository resource (and will cause the
        // deletion of the ECR repository the app used).
        extraHash.version = '1.21.0';
        const staging = new core_1.AssetStaging(this, 'Staging', {
            ...props,
            follow: (_m = props.followSymlinks) !== null && _m !== void 0 ? _m : toSymlinkFollow(props.follow),
            exclude,
            ignoreMode,
            sourcePath: dir,
            extraHash: Object.keys(extraHash).length === 0
                ? undefined
                : JSON.stringify(extraHash),
        });
        this.sourceHash = staging.assetHash;
        this.assetHash = staging.assetHash;
        const stack = core_1.Stack.of(this);
        this.assetPath = staging.relativeStagedPath(stack);
        this.dockerBuildArgs = props.buildArgs;
        this.dockerBuildTarget = props.target;
        const location = stack.synthesizer.addDockerImageAsset({
            directoryName: this.assetPath,
            dockerBuildArgs: this.dockerBuildArgs,
            dockerBuildTarget: this.dockerBuildTarget,
            dockerFile: props.file,
            sourceHash: staging.assetHash,
            networkMode: (_o = props.networkMode) === null || _o === void 0 ? void 0 : _o.mode,
        });
        this.repository = ecr.Repository.fromRepositoryName(this, 'Repository', location.repositoryName);
        this.imageUri = location.imageUri;
    }
    /**
     * Adds CloudFormation template metadata to the specified resource with
     * information that indicates which resource property is mapped to this local
     * asset. This can be used by tools such as SAM CLI to provide local
     * experience such as local invocation and debugging of Lambda functions.
     *
     * Asset metadata will only be included if the stack is synthesized with the
     * "aws:cdk:enable-asset-metadata" context key defined, which is the default
     * behavior when synthesizing via the CDK Toolkit.
     *
     * @see https://github.com/aws/aws-cdk/issues/1432
     *
     * @param resource The CloudFormation resource which is using this asset [disable-awslint:ref-via-interface]
     * @param resourceProperty The property name where this asset is referenced
     */
    addResourceMetadata(resource, resourceProperty) {
        if (!this.node.tryGetContext(cxapi.ASSET_RESOURCE_METADATA_ENABLED_CONTEXT)) {
            return; // not enabled
        }
        // tell tools such as SAM CLI that the resourceProperty of this resource
        // points to a local path and include the path to de dockerfile, docker build args, and target,
        // in order to enable local invocation of this function.
        resource.cfnOptions.metadata = resource.cfnOptions.metadata || {};
        resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_PATH_KEY] = this.assetPath;
        resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_DOCKERFILE_PATH_KEY] = this.dockerfilePath;
        resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_DOCKER_BUILD_ARGS_KEY] = this.dockerBuildArgs;
        resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_DOCKER_BUILD_TARGET_KEY] = this.dockerBuildTarget;
        resource.cfnOptions.metadata[cxapi.ASSET_RESOURCE_METADATA_PROPERTY_KEY] = resourceProperty;
    }
}
exports.DockerImageAsset = DockerImageAsset;
_b = JSII_RTTI_SYMBOL_1;
DockerImageAsset[_b] = { fqn: "@aws-cdk/aws-ecr-assets.DockerImageAsset", version: "1.153.0" };
function validateProps(props) {
    for (const [key, value] of Object.entries(props)) {
        if (core_1.Token.isUnresolved(value)) {
            throw new Error(`Cannot use Token as value of '${key}': this value is used before deployment starts`);
        }
    }
    validateBuildArgs(props.buildArgs);
}
function validateBuildArgs(buildArgs) {
    for (const [key, value] of Object.entries(buildArgs || {})) {
        if (core_1.Token.isUnresolved(key) || core_1.Token.isUnresolved(value)) {
            throw new Error('Cannot use tokens in keys or values of "buildArgs" since they are needed before deployment');
        }
    }
}
function toSymlinkFollow(follow) {
    switch (follow) {
        case undefined: return undefined;
        case assets_1.FollowMode.NEVER: return core_1.SymlinkFollowMode.NEVER;
        case assets_1.FollowMode.ALWAYS: return core_1.SymlinkFollowMode.ALWAYS;
        case assets_1.FollowMode.BLOCK_EXTERNAL: return core_1.SymlinkFollowMode.BLOCK_EXTERNAL;
        case assets_1.FollowMode.EXTERNAL: return core_1.SymlinkFollowMode.EXTERNAL;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW1hZ2UtYXNzZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbWFnZS1hc3NldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx5QkFBeUI7QUFDekIsNkJBQTZCO0FBQzdCLHdDQUF3QztBQUN4Qyx3Q0FBaUs7QUFDaksseUNBQXlDO0FBR3pDLGlHQUFpRztBQUNqRywyQkFBMkI7QUFDM0IsNENBQXlFO0FBQ3pFLGlHQUFpRztBQUNqRyw4REFBOEQ7QUFDOUQsd0NBQTJEO0FBRTNEOztHQUVHO0FBQ0gsTUFBYSxXQUFXO0lBbUN0Qjs7T0FFRztJQUNILFlBQW9DLElBQVk7UUFBWixTQUFJLEdBQUosSUFBSSxDQUFRO0tBQUk7SUF0QnBEOzs7O09BSUc7SUFDSSxNQUFNLENBQUMsYUFBYSxDQUFDLFdBQW1CO1FBQzdDLE9BQU8sSUFBSSxXQUFXLENBQUMsYUFBYSxXQUFXLEVBQUUsQ0FBQyxDQUFDO0tBQ3BEO0lBRUQ7Ozs7O09BS0c7SUFDSSxNQUFNLENBQUMsTUFBTSxDQUFDLElBQVk7UUFDL0IsT0FBTyxJQUFJLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztLQUM5Qjs7QUFqQ0gsa0NBdUNDOzs7QUF0Q0M7O0dBRUc7QUFDb0IsbUJBQU8sR0FBRyxJQUFJLFdBQVcsQ0FBQyxTQUFTLENBQUMsQ0FBQztBQUU1RDs7R0FFRztBQUNvQixnQkFBSSxHQUFHLElBQUksV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0FBRXREOztHQUVHO0FBQ29CLGdCQUFJLEdBQUcsSUFBSSxXQUFXLENBQUMsTUFBTSxDQUFDLENBQUM7QUFnSnhEOzs7O0dBSUc7QUFDSCxNQUFhLGdCQUFpQixTQUFRLGdCQUFhO0lBbURqRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCOztRQUNwRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7Ozs7O1FBRWpCLG9DQUFvQztRQUNwQyxhQUFhLENBQUMsS0FBSyxDQUFDLENBQUM7UUFFckIsb0JBQW9CO1FBQ3BCLE1BQU0sR0FBRyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxDQUFDO1FBQzFDLElBQUksQ0FBQyxFQUFFLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQ3ZCLE1BQU0sSUFBSSxLQUFLLENBQUMsa0NBQWtDLEdBQUcsRUFBRSxDQUFDLENBQUM7U0FDMUQ7UUFFRCxrQ0FBa0M7UUFDbEMsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsSUFBSSxJQUFJLFlBQVksQ0FBQztRQUNqRCxNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxJQUFJLENBQUMsY0FBYyxDQUFDLENBQUM7UUFDakQsSUFBSSxDQUFDLEVBQUUsQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUU7WUFDeEIsTUFBTSxJQUFJLEtBQUssQ0FBQyx1QkFBdUIsSUFBSSxFQUFFLENBQUMsQ0FBQztTQUNoRDtRQUVELE1BQU0saUJBQWlCLEdBQUcsbUJBQVksQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxxQkFBcUIsQ0FBQztZQUNwRixDQUFDLENBQUMsaUJBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLGlCQUFVLENBQUMsSUFBSSxDQUFDO1FBQ3hDLElBQUksVUFBVSxTQUFHLEtBQUssQ0FBQyxVQUFVLG1DQUFJLGlCQUFpQixDQUFDO1FBRXZELElBQUksT0FBTyxHQUFhLEtBQUssQ0FBQyxPQUFPLElBQUksRUFBRSxDQUFDO1FBRTVDLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLGVBQWUsQ0FBQyxDQUFDO1FBRS9DLElBQUksRUFBRSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsRUFBRTtZQUN6QixNQUFNLG9CQUFvQixHQUFHLEVBQUUsQ0FBQyxZQUFZLENBQUMsTUFBTSxDQUFDLENBQUMsUUFBUSxFQUFFLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUU3RixPQUFPLEdBQUc7Z0JBQ1IsR0FBRyxvQkFBb0I7Z0JBQ3ZCLEdBQUcsT0FBTztnQkFFVixtREFBbUQ7Z0JBQ25ELGdCQUFnQjthQUNqQixDQUFDO1NBQ0g7UUFFRCxvREFBb0Q7UUFDcEQsT0FBTyxDQUFDLElBQUksQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO1FBQ3hDLHFFQUFxRTtRQUNyRSxNQUFNLE1BQU0sZUFBRyxZQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQywwQ0FBRSxNQUFNLG1DQUFJLFNBQVMsQ0FBQztRQUNuRCxPQUFPLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBRXJCLElBQUksS0FBSyxDQUFDLGNBQWMsRUFBRTtZQUN4QixrQkFBVyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxVQUFVLENBQUMscUhBQXFILENBQUMsQ0FBQztTQUN4SjtRQUVELDhEQUE4RDtRQUM5RCxNQUFNLFNBQVMsR0FBNkIsRUFBRSxDQUFDO1FBQy9DLElBQUksT0FBQSxLQUFLLENBQUMsWUFBWSwwQ0FBRSxTQUFTLE1BQUssS0FBSyxJQUFJLEtBQUssQ0FBQyxTQUFTLEVBQUU7WUFBRSxTQUFTLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7U0FBRTtRQUNyRyxJQUFJLE9BQUEsS0FBSyxDQUFDLFlBQVksMENBQUUsU0FBUyxNQUFLLEtBQUssSUFBSSxLQUFLLENBQUMsU0FBUyxFQUFFO1lBQUUsU0FBUyxDQUFDLFNBQVMsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1NBQUU7UUFDMUcsSUFBSSxPQUFBLEtBQUssQ0FBQyxZQUFZLDBDQUFFLE1BQU0sTUFBSyxLQUFLLElBQUksS0FBSyxDQUFDLE1BQU0sRUFBRTtZQUFFLFNBQVMsQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztTQUFFO1FBQzlGLElBQUksT0FBQSxLQUFLLENBQUMsWUFBWSwwQ0FBRSxJQUFJLE1BQUssS0FBSyxJQUFJLEtBQUssQ0FBQyxJQUFJLEVBQUU7WUFBRSxTQUFTLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLENBQUM7U0FBRTtRQUN0RixJQUFJLE9BQUEsS0FBSyxDQUFDLFlBQVksMENBQUUsY0FBYyxNQUFLLEtBQUssSUFBSSxLQUFLLENBQUMsY0FBYyxFQUFFO1lBQUUsU0FBUyxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1NBQUU7UUFDOUgsSUFBSSxPQUFBLEtBQUssQ0FBQyxZQUFZLDBDQUFFLFdBQVcsTUFBSyxLQUFLLElBQUksS0FBSyxDQUFDLFdBQVcsRUFBRTtZQUFFLFNBQVMsQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDLFdBQVcsQ0FBQztTQUFFO1FBRWxILDRFQUE0RTtRQUM1RSwwRUFBMEU7UUFDMUUsZ0RBQWdEO1FBQ2hELFNBQVMsQ0FBQyxPQUFPLEdBQUcsUUFBUSxDQUFDO1FBRTdCLE1BQU0sT0FBTyxHQUFHLElBQUksbUJBQVksQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFO1lBQ2hELEdBQUcsS0FBSztZQUNSLE1BQU0sUUFBRSxLQUFLLENBQUMsY0FBYyxtQ0FBSSxlQUFlLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQztZQUM3RCxPQUFPO1lBQ1AsVUFBVTtZQUNWLFVBQVUsRUFBRSxHQUFHO1lBQ2YsU0FBUyxFQUFFLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsTUFBTSxLQUFLLENBQUM7Z0JBQzVDLENBQUMsQ0FBQyxTQUFTO2dCQUNYLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQztTQUM5QixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsVUFBVSxHQUFHLE9BQU8sQ0FBQyxTQUFTLENBQUM7UUFDcEMsSUFBSSxDQUFDLFNBQVMsR0FBRyxPQUFPLENBQUMsU0FBUyxDQUFDO1FBRW5DLE1BQU0sS0FBSyxHQUFHLFlBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDN0IsSUFBSSxDQUFDLFNBQVMsR0FBRyxPQUFPLENBQUMsa0JBQWtCLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbkQsSUFBSSxDQUFDLGVBQWUsR0FBRyxLQUFLLENBQUMsU0FBUyxDQUFDO1FBQ3ZDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDO1FBRXRDLE1BQU0sUUFBUSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUMsbUJBQW1CLENBQUM7WUFDckQsYUFBYSxFQUFFLElBQUksQ0FBQyxTQUFTO1lBQzdCLGVBQWUsRUFBRSxJQUFJLENBQUMsZUFBZTtZQUNyQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLFVBQVUsRUFBRSxLQUFLLENBQUMsSUFBSTtZQUN0QixVQUFVLEVBQUUsT0FBTyxDQUFDLFNBQVM7WUFDN0IsV0FBVyxRQUFFLEtBQUssQ0FBQyxXQUFXLDBDQUFFLElBQUk7U0FDckMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLFVBQVUsR0FBRyxHQUFHLENBQUMsVUFBVSxDQUFDLGtCQUFrQixDQUFDLElBQUksRUFBRSxZQUFZLEVBQUUsUUFBUSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ2pHLElBQUksQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDLFFBQVEsQ0FBQztLQUNuQztJQUVEOzs7Ozs7Ozs7Ozs7OztPQWNHO0lBQ0ksbUJBQW1CLENBQUMsUUFBcUIsRUFBRSxnQkFBd0I7UUFDeEUsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyx1Q0FBdUMsQ0FBQyxFQUFFO1lBQzNFLE9BQU8sQ0FBQyxjQUFjO1NBQ3ZCO1FBRUQsd0VBQXdFO1FBQ3hFLCtGQUErRjtRQUMvRix3REFBd0Q7UUFDeEQsUUFBUSxDQUFDLFVBQVUsQ0FBQyxRQUFRLEdBQUcsUUFBUSxDQUFDLFVBQVUsQ0FBQyxRQUFRLElBQUksRUFBRyxDQUFDO1FBQ25FLFFBQVEsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxnQ0FBZ0MsQ0FBQyxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUM7UUFDdEYsUUFBUSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLDJDQUEyQyxDQUFDLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQztRQUN0RyxRQUFRLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsNkNBQTZDLENBQUMsR0FBRyxJQUFJLENBQUMsZUFBZSxDQUFDO1FBQ3pHLFFBQVEsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQywrQ0FBK0MsQ0FBQyxHQUFHLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztRQUM3RyxRQUFRLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsb0NBQW9DLENBQUMsR0FBRyxnQkFBZ0IsQ0FBQztLQUM3Rjs7QUEvS0gsNENBaUxDOzs7QUFFRCxTQUFTLGFBQWEsQ0FBQyxLQUE0QjtJQUNqRCxLQUFLLE1BQU0sQ0FBQyxHQUFHLEVBQUUsS0FBSyxDQUFDLElBQUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUFLLENBQUMsRUFBRTtRQUNoRCxJQUFJLFlBQUssQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDN0IsTUFBTSxJQUFJLEtBQUssQ0FBQyxpQ0FBaUMsR0FBRyxnREFBZ0QsQ0FBQyxDQUFDO1NBQ3ZHO0tBQ0Y7SUFFRCxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUM7QUFDckMsQ0FBQztBQUVELFNBQVMsaUJBQWlCLENBQUMsU0FBcUM7SUFDOUQsS0FBSyxNQUFNLENBQUMsR0FBRyxFQUFFLEtBQUssQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsU0FBUyxJQUFJLEVBQUUsQ0FBQyxFQUFFO1FBQzFELElBQUksWUFBSyxDQUFDLFlBQVksQ0FBQyxHQUFHLENBQUMsSUFBSSxZQUFLLENBQUMsWUFBWSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ3hELE1BQU0sSUFBSSxLQUFLLENBQUMsNEZBQTRGLENBQUMsQ0FBQztTQUMvRztLQUNGO0FBQ0gsQ0FBQztBQUVELFNBQVMsZUFBZSxDQUFDLE1BQW1CO0lBQzFDLFFBQVEsTUFBTSxFQUFFO1FBQ2QsS0FBSyxTQUFTLENBQUMsQ0FBQyxPQUFPLFNBQVMsQ0FBQztRQUNqQyxLQUFLLG1CQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxLQUFLLENBQUM7UUFDdEQsS0FBSyxtQkFBVSxDQUFDLE1BQU0sQ0FBQyxDQUFDLE9BQU8sd0JBQWlCLENBQUMsTUFBTSxDQUFDO1FBQ3hELEtBQUssbUJBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxPQUFPLHdCQUFpQixDQUFDLGNBQWMsQ0FBQztRQUN4RSxLQUFLLG1CQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsT0FBTyx3QkFBaUIsQ0FBQyxRQUFRLENBQUM7S0FDN0Q7QUFDSCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZnMgZnJvbSAnZnMnO1xuaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCAqIGFzIGVjciBmcm9tICdAYXdzLWNkay9hd3MtZWNyJztcbmltcG9ydCB7IEFubm90YXRpb25zLCBBc3NldFN0YWdpbmcsIEZlYXR1cmVGbGFncywgRmlsZUZpbmdlcnByaW50T3B0aW9ucywgSWdub3JlTW9kZSwgU3RhY2ssIFN5bWxpbmtGb2xsb3dNb2RlLCBUb2tlbiwgU3RhZ2UsIENmblJlc291cmNlIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgKiBhcyBjeGFwaSBmcm9tICdAYXdzLWNkay9jeC1hcGknO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbi8vIGtlZXAgdGhpcyBpbXBvcnQgc2VwYXJhdGUgZnJvbSBvdGhlciBpbXBvcnRzIHRvIHJlZHVjZSBjaGFuY2UgZm9yIG1lcmdlIGNvbmZsaWN0cyB3aXRoIHYyLW1haW5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZVxuaW1wb3J0IHsgRmluZ2VycHJpbnRPcHRpb25zLCBGb2xsb3dNb2RlLCBJQXNzZXQgfSBmcm9tICdAYXdzLWNkay9hc3NldHMnO1xuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCBhcyBDb3JlQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbi8qKlxuICogbmV0d29ya2luZyBtb2RlIG9uIGJ1aWxkIHRpbWUgc3VwcG9ydGVkIGJ5IGRvY2tlclxuICovXG5leHBvcnQgY2xhc3MgTmV0d29ya01vZGUge1xuICAvKipcbiAgICogVGhlIGRlZmF1bHQgbmV0d29ya2luZyBtb2RlIGlmIG9taXR0ZWQsIGNyZWF0ZSBhIG5ldHdvcmsgc3RhY2sgb24gdGhlIGRlZmF1bHQgRG9ja2VyIGJyaWRnZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBERUZBVUxUID0gbmV3IE5ldHdvcmtNb2RlKCdkZWZhdWx0Jyk7XG5cbiAgLyoqXG4gICAqIFVzZSB0aGUgRG9ja2VyIGhvc3QgbmV0d29yayBzdGFja1xuICAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBIT1NUID0gbmV3IE5ldHdvcmtNb2RlKCdob3N0Jyk7XG5cbiAgLyoqXG4gICAqIERpc2FibGUgdGhlIG5ldHdvcmsgc3RhY2ssIG9ubHkgdGhlIGxvb3BiYWNrIGRldmljZSB3aWxsIGJlIGNyZWF0ZWRcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgTk9ORSA9IG5ldyBOZXR3b3JrTW9kZSgnbm9uZScpO1xuXG4gIC8qKlxuICAgKiBSZXVzZSBhbm90aGVyIGNvbnRhaW5lcidzIG5ldHdvcmsgc3RhY2tcbiAgICpcbiAgICogQHBhcmFtIGNvbnRhaW5lcklkIFRoZSB0YXJnZXQgY29udGFpbmVyJ3MgaWQgb3IgbmFtZVxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tQ29udGFpbmVyKGNvbnRhaW5lcklkOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gbmV3IE5ldHdvcmtNb2RlKGBjb250YWluZXI6JHtjb250YWluZXJJZH1gKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBVc2VkIHRvIHNwZWNpZnkgYSBjdXN0b20gbmV0d29ya2luZyBtb2RlXG4gICAqIFVzZSB0aGlzIGlmIHRoZSBuZXR3b3JraW5nIG1vZGUgbmFtZSBpcyBub3QgeWV0IHN1cHBvcnRlZCBieSB0aGUgQ0RLLlxuICAgKlxuICAgKiBAcGFyYW0gbW9kZSBUaGUgbmV0d29ya2luZyBtb2RlIHRvIHVzZSBmb3IgZG9ja2VyIGJ1aWxkXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGN1c3RvbShtb2RlOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gbmV3IE5ldHdvcmtNb2RlKG1vZGUpO1xuICB9XG5cbiAgLyoqXG4gICAqIEBwYXJhbSBtb2RlIFRoZSBuZXR3b3JraW5nIG1vZGUgdG8gdXNlIGZvciBkb2NrZXIgYnVpbGRcbiAgICovXG4gIHByaXZhdGUgY29uc3RydWN0b3IocHVibGljIHJlYWRvbmx5IG1vZGU6IHN0cmluZykge31cbn1cblxuLyoqXG4gKiBPcHRpb25zIHRvIGNvbnRyb2wgaW52YWxpZGF0aW9uIG9mIGBEb2NrZXJJbWFnZUFzc2V0YCBhc3NldCBoYXNoZXNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBEb2NrZXJJbWFnZUFzc2V0SW52YWxpZGF0aW9uT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBVc2UgYGV4dHJhSGFzaGAgd2hpbGUgY2FsY3VsYXRpbmcgdGhlIGFzc2V0IGhhc2hcbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgZXh0cmFIYXNoPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVXNlIGBidWlsZEFyZ3NgIHdoaWxlIGNhbGN1bGF0aW5nIHRoZSBhc3NldCBoYXNoXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGJ1aWxkQXJncz86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFVzZSBgdGFyZ2V0YCB3aGlsZSBjYWxjdWxhdGluZyB0aGUgYXNzZXQgaGFzaFxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSB0YXJnZXQ/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBVc2UgYGZpbGVgIHdoaWxlIGNhbGN1bGF0aW5nIHRoZSBhc3NldCBoYXNoXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGZpbGU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBVc2UgYHJlcG9zaXRvcnlOYW1lYCB3aGlsZSBjYWxjdWxhdGluZyB0aGUgYXNzZXQgaGFzaFxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSByZXBvc2l0b3J5TmFtZT86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFVzZSBgbmV0d29ya01vZGVgIHdoaWxlIGNhbGN1bGF0aW5nIHRoZSBhc3NldCBoYXNoXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IG5ldHdvcmtNb2RlPzogYm9vbGVhbjtcbn1cblxuLyoqXG4gKiBPcHRpb25zIGZvciBEb2NrZXJJbWFnZUFzc2V0XG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgRG9ja2VySW1hZ2VBc3NldE9wdGlvbnMgZXh0ZW5kcyBGaW5nZXJwcmludE9wdGlvbnMsIEZpbGVGaW5nZXJwcmludE9wdGlvbnMge1xuICAvKipcbiAgICogRUNSIHJlcG9zaXRvcnkgbmFtZVxuICAgKlxuICAgKiBTcGVjaWZ5IHRoaXMgcHJvcGVydHkgaWYgeW91IG5lZWQgdG8gc3RhdGljYWxseSBhZGRyZXNzIHRoZSBpbWFnZSwgZS5nLlxuICAgKiBmcm9tIGEgS3ViZXJuZXRlcyBQb2QuIE5vdGUsIHRoaXMgaXMgb25seSB0aGUgcmVwb3NpdG9yeSBuYW1lLCB3aXRob3V0IHRoZVxuICAgKiByZWdpc3RyeSBhbmQgdGhlIHRhZyBwYXJ0cy5cbiAgICpcbiAgICogQGRlZmF1bHQgLSB0aGUgZGVmYXVsdCBFQ1IgcmVwb3NpdG9yeSBmb3IgQ0RLIGFzc2V0c1xuICAgKiBAZGVwcmVjYXRlZCB0byBjb250cm9sIHRoZSBsb2NhdGlvbiBvZiBkb2NrZXIgaW1hZ2UgYXNzZXRzLCBwbGVhc2Ugb3ZlcnJpZGVcbiAgICogYFN0YWNrLmFkZERvY2tlckltYWdlQXNzZXRgLiB0aGlzIGZlYXR1cmUgd2lsbCBiZSByZW1vdmVkIGluIGZ1dHVyZVxuICAgKiByZWxlYXNlcy5cbiAgICovXG4gIHJlYWRvbmx5IHJlcG9zaXRvcnlOYW1lPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBCdWlsZCBhcmdzIHRvIHBhc3MgdG8gdGhlIGBkb2NrZXIgYnVpbGRgIGNvbW1hbmQuXG4gICAqXG4gICAqIFNpbmNlIERvY2tlciBidWlsZCBhcmd1bWVudHMgYXJlIHJlc29sdmVkIGJlZm9yZSBkZXBsb3ltZW50LCBrZXlzIGFuZFxuICAgKiB2YWx1ZXMgY2Fubm90IHJlZmVyIHRvIHVucmVzb2x2ZWQgdG9rZW5zIChzdWNoIGFzIGBsYW1iZGEuZnVuY3Rpb25Bcm5gIG9yXG4gICAqIGBxdWV1ZS5xdWV1ZVVybGApLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIGJ1aWxkIGFyZ3MgYXJlIHBhc3NlZFxuICAgKi9cbiAgcmVhZG9ubHkgYnVpbGRBcmdzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfTtcblxuICAvKipcbiAgICogRG9ja2VyIHRhcmdldCB0byBidWlsZCB0b1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIHRhcmdldFxuICAgKi9cbiAgcmVhZG9ubHkgdGFyZ2V0Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBQYXRoIHRvIHRoZSBEb2NrZXJmaWxlIChyZWxhdGl2ZSB0byB0aGUgZGlyZWN0b3J5KS5cbiAgICpcbiAgICogQGRlZmF1bHQgJ0RvY2tlcmZpbGUnXG4gICAqL1xuICByZWFkb25seSBmaWxlPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBOZXR3b3JraW5nIG1vZGUgZm9yIHRoZSBSVU4gY29tbWFuZHMgZHVyaW5nIGJ1aWxkLiBTdXBwb3J0IGRvY2tlciBBUEkgMS4yNSsuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm8gbmV0d29ya2luZyBtb2RlIHNwZWNpZmllZCAodGhlIGRlZmF1bHQgbmV0d29ya2luZyBtb2RlIGBOZXR3b3JrTW9kZS5ERUZBVUxUYCB3aWxsIGJlIHVzZWQpXG4gICAqL1xuICByZWFkb25seSBuZXR3b3JrTW9kZT86IE5ldHdvcmtNb2RlO1xuXG4gIC8qKlxuICAgKiBPcHRpb25zIHRvIGNvbnRyb2wgd2hpY2ggcGFyYW1ldGVycyBhcmUgdXNlZCB0byBpbnZhbGlkYXRlIHRoZSBhc3NldCBoYXNoLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIGhhc2ggYWxsIHBhcmFtZXRlcnNcbiAgICovXG4gIHJlYWRvbmx5IGludmFsaWRhdGlvbj86IERvY2tlckltYWdlQXNzZXRJbnZhbGlkYXRpb25PcHRpb25zO1xufVxuXG4vKipcbiAqIFByb3BzIGZvciBEb2NrZXJJbWFnZUFzc2V0c1xuICovXG5leHBvcnQgaW50ZXJmYWNlIERvY2tlckltYWdlQXNzZXRQcm9wcyBleHRlbmRzIERvY2tlckltYWdlQXNzZXRPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBkaXJlY3Rvcnkgd2hlcmUgdGhlIERvY2tlcmZpbGUgaXMgc3RvcmVkXG4gICAqXG4gICAqIEFueSBkaXJlY3RvcnkgaW5zaWRlIHdpdGggYSBuYW1lIHRoYXQgbWF0Y2hlcyB0aGUgQ0RLIG91dHB1dCBmb2xkZXIgKGNkay5vdXQgYnkgZGVmYXVsdCkgd2lsbCBiZSBleGNsdWRlZCBmcm9tIHRoZSBhc3NldFxuICAgKi9cbiAgcmVhZG9ubHkgZGlyZWN0b3J5OiBzdHJpbmc7XG59XG5cbi8qKlxuICogQW4gYXNzZXQgdGhhdCByZXByZXNlbnRzIGEgRG9ja2VyIGltYWdlLlxuICpcbiAqIFRoZSBpbWFnZSB3aWxsIGJlIGNyZWF0ZWQgaW4gYnVpbGQgdGltZSBhbmQgdXBsb2FkZWQgdG8gYW4gRUNSIHJlcG9zaXRvcnkuXG4gKi9cbmV4cG9ydCBjbGFzcyBEb2NrZXJJbWFnZUFzc2V0IGV4dGVuZHMgQ29yZUNvbnN0cnVjdCBpbXBsZW1lbnRzIElBc3NldCB7XG4gIC8qKlxuICAgKiBUaGUgZnVsbCBVUkkgb2YgdGhlIGltYWdlIChpbmNsdWRpbmcgYSB0YWcpLiBVc2UgdGhpcyByZWZlcmVuY2UgdG8gcHVsbFxuICAgKiB0aGUgYXNzZXQuXG4gICAqL1xuICBwdWJsaWMgaW1hZ2VVcmk6IHN0cmluZztcblxuICAvKipcbiAgICogUmVwb3NpdG9yeSB3aGVyZSB0aGUgaW1hZ2UgaXMgc3RvcmVkXG4gICAqL1xuICBwdWJsaWMgcmVwb3NpdG9yeTogZWNyLklSZXBvc2l0b3J5O1xuXG4gIC8qKlxuICAgKiBBIGhhc2ggb2YgdGhlIHNvdXJjZSBvZiB0aGlzIGFzc2V0LCB3aGljaCBpcyBhdmFpbGFibGUgYXQgY29uc3RydWN0aW9uIHRpbWUuIEFzIHRoaXMgaXMgYSBwbGFpblxuICAgKiBzdHJpbmcsIGl0IGNhbiBiZSB1c2VkIGluIGNvbnN0cnVjdCBJRHMgaW4gb3JkZXIgdG8gZW5mb3JjZSBjcmVhdGlvbiBvZiBhIG5ldyByZXNvdXJjZSB3aGVuXG4gICAqIHRoZSBjb250ZW50IGhhc2ggaGFzIGNoYW5nZWQuXG4gICAqIEBkZXByZWNhdGVkIHVzZSBhc3NldEhhc2hcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBzb3VyY2VIYXNoOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEEgaGFzaCBvZiB0aGlzIGFzc2V0LCB3aGljaCBpcyBhdmFpbGFibGUgYXQgY29uc3RydWN0aW9uIHRpbWUuIEFzIHRoaXMgaXMgYSBwbGFpbiBzdHJpbmcsIGl0XG4gICAqIGNhbiBiZSB1c2VkIGluIGNvbnN0cnVjdCBJRHMgaW4gb3JkZXIgdG8gZW5mb3JjZSBjcmVhdGlvbiBvZiBhIG5ldyByZXNvdXJjZSB3aGVuIHRoZSBjb250ZW50XG4gICAqIGhhc2ggaGFzIGNoYW5nZWQuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXNzZXRIYXNoOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBwYXRoIHRvIHRoZSBhc3NldCwgcmVsYXRpdmUgdG8gdGhlIGN1cnJlbnQgQ2xvdWQgQXNzZW1ibHlcbiAgICpcbiAgICogSWYgYXNzZXQgc3RhZ2luZyBpcyBkaXNhYmxlZCwgdGhpcyB3aWxsIGp1c3QgYmUgdGhlIG9yaWdpbmFsIHBhdGguXG4gICAqXG4gICAqIElmIGFzc2V0IHN0YWdpbmcgaXMgZW5hYmxlZCBpdCB3aWxsIGJlIHRoZSBzdGFnZWQgcGF0aC5cbiAgICovXG4gIHByaXZhdGUgcmVhZG9ubHkgYXNzZXRQYXRoOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBwYXRoIHRvIHRoZSBEb2NrZXJmaWxlLCByZWxhdGl2ZSB0byB0aGUgYXNzZXRQYXRoXG4gICAqL1xuICBwcml2YXRlIHJlYWRvbmx5IGRvY2tlcmZpbGVQYXRoPzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBCdWlsZCBhcmdzIHRvIHBhc3MgdG8gdGhlIGBkb2NrZXIgYnVpbGRgIGNvbW1hbmQuXG4gICAqL1xuICBwcml2YXRlIHJlYWRvbmx5IGRvY2tlckJ1aWxkQXJncz86IHsgW2tleTogc3RyaW5nXTogc3RyaW5nIH07XG5cbiAgLyoqXG4gICAqIERvY2tlciB0YXJnZXQgdG8gYnVpbGQgdG9cbiAgICovXG4gIHByaXZhdGUgcmVhZG9ubHkgZG9ja2VyQnVpbGRUYXJnZXQ/OiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IERvY2tlckltYWdlQXNzZXRQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAvLyBub25lIG9mIHRoZSBwcm9wZXJ0aWVzIHVzZSB0b2tlbnNcbiAgICB2YWxpZGF0ZVByb3BzKHByb3BzKTtcblxuICAgIC8vIHJlc29sdmUgZnVsbCBwYXRoXG4gICAgY29uc3QgZGlyID0gcGF0aC5yZXNvbHZlKHByb3BzLmRpcmVjdG9yeSk7XG4gICAgaWYgKCFmcy5leGlzdHNTeW5jKGRpcikpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgQ2Fubm90IGZpbmQgaW1hZ2UgZGlyZWN0b3J5IGF0ICR7ZGlyfWApO1xuICAgIH1cblxuICAgIC8vIHZhbGlkYXRlIHRoZSBkb2NrZXIgZmlsZSBleGlzdHNcbiAgICB0aGlzLmRvY2tlcmZpbGVQYXRoID0gcHJvcHMuZmlsZSB8fCAnRG9ja2VyZmlsZSc7XG4gICAgY29uc3QgZmlsZSA9IHBhdGguam9pbihkaXIsIHRoaXMuZG9ja2VyZmlsZVBhdGgpO1xuICAgIGlmICghZnMuZXhpc3RzU3luYyhmaWxlKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBDYW5ub3QgZmluZCBmaWxlIGF0ICR7ZmlsZX1gKTtcbiAgICB9XG5cbiAgICBjb25zdCBkZWZhdWx0SWdub3JlTW9kZSA9IEZlYXR1cmVGbGFncy5vZih0aGlzKS5pc0VuYWJsZWQoY3hhcGkuRE9DS0VSX0lHTk9SRV9TVVBQT1JUKVxuICAgICAgPyBJZ25vcmVNb2RlLkRPQ0tFUiA6IElnbm9yZU1vZGUuR0xPQjtcbiAgICBsZXQgaWdub3JlTW9kZSA9IHByb3BzLmlnbm9yZU1vZGUgPz8gZGVmYXVsdElnbm9yZU1vZGU7XG5cbiAgICBsZXQgZXhjbHVkZTogc3RyaW5nW10gPSBwcm9wcy5leGNsdWRlIHx8IFtdO1xuXG4gICAgY29uc3QgaWdub3JlID0gcGF0aC5qb2luKGRpciwgJy5kb2NrZXJpZ25vcmUnKTtcblxuICAgIGlmIChmcy5leGlzdHNTeW5jKGlnbm9yZSkpIHtcbiAgICAgIGNvbnN0IGRvY2tlcklnbm9yZVBhdHRlcm5zID0gZnMucmVhZEZpbGVTeW5jKGlnbm9yZSkudG9TdHJpbmcoKS5zcGxpdCgnXFxuJykuZmlsdGVyKGUgPT4gISFlKTtcblxuICAgICAgZXhjbHVkZSA9IFtcbiAgICAgICAgLi4uZG9ja2VySWdub3JlUGF0dGVybnMsXG4gICAgICAgIC4uLmV4Y2x1ZGUsXG5cbiAgICAgICAgLy8gRW5zdXJlIC5kb2NrZXJpZ25vcmUgaXMgaW5jbHVkZWQgbm8gbWF0dGVyIHdoYXQuXG4gICAgICAgICchLmRvY2tlcmlnbm9yZScsXG4gICAgICBdO1xuICAgIH1cblxuICAgIC8vIEVuc3VyZSB0aGUgRG9ja2VyZmlsZSBpcyBpbmNsdWRlZCBubyBtYXR0ZXIgd2hhdC5cbiAgICBleGNsdWRlLnB1c2goJyEnICsgcGF0aC5iYXNlbmFtZShmaWxlKSk7XG4gICAgLy8gRW5zdXJlIHRoZSBjZGsub3V0IGZvbGRlciBpcyBub3QgaW5jbHVkZWQgdG8gYXZvaWQgaW5maW5pdGUgbG9vcHMuXG4gICAgY29uc3QgY2Rrb3V0ID0gU3RhZ2Uub2YodGhpcyk/Lm91dGRpciA/PyAnY2RrLm91dCc7XG4gICAgZXhjbHVkZS5wdXNoKGNka291dCk7XG5cbiAgICBpZiAocHJvcHMucmVwb3NpdG9yeU5hbWUpIHtcbiAgICAgIEFubm90YXRpb25zLm9mKHRoaXMpLmFkZFdhcm5pbmcoJ0RvY2tlckltYWdlQXNzZXQucmVwb3NpdG9yeU5hbWUgaXMgZGVwcmVjYXRlZC4gT3ZlcnJpZGUgXCJjb3JlLlN0YWNrLmFkZERvY2tlckltYWdlQXNzZXRcIiB0byBjb250cm9sIGFzc2V0IGxvY2F0aW9ucycpO1xuICAgIH1cblxuICAgIC8vIGluY2x1ZGUgYnVpbGQgY29udGV4dCBpbiBcImV4dHJhXCIgc28gaXQgd2lsbCBpbXBhY3QgdGhlIGhhc2hcbiAgICBjb25zdCBleHRyYUhhc2g6IHsgW2ZpZWxkOiBzdHJpbmddOiBhbnkgfSA9IHt9O1xuICAgIGlmIChwcm9wcy5pbnZhbGlkYXRpb24/LmV4dHJhSGFzaCAhPT0gZmFsc2UgJiYgcHJvcHMuZXh0cmFIYXNoKSB7IGV4dHJhSGFzaC51c2VyID0gcHJvcHMuZXh0cmFIYXNoOyB9XG4gICAgaWYgKHByb3BzLmludmFsaWRhdGlvbj8uYnVpbGRBcmdzICE9PSBmYWxzZSAmJiBwcm9wcy5idWlsZEFyZ3MpIHsgZXh0cmFIYXNoLmJ1aWxkQXJncyA9IHByb3BzLmJ1aWxkQXJnczsgfVxuICAgIGlmIChwcm9wcy5pbnZhbGlkYXRpb24/LnRhcmdldCAhPT0gZmFsc2UgJiYgcHJvcHMudGFyZ2V0KSB7IGV4dHJhSGFzaC50YXJnZXQgPSBwcm9wcy50YXJnZXQ7IH1cbiAgICBpZiAocHJvcHMuaW52YWxpZGF0aW9uPy5maWxlICE9PSBmYWxzZSAmJiBwcm9wcy5maWxlKSB7IGV4dHJhSGFzaC5maWxlID0gcHJvcHMuZmlsZTsgfVxuICAgIGlmIChwcm9wcy5pbnZhbGlkYXRpb24/LnJlcG9zaXRvcnlOYW1lICE9PSBmYWxzZSAmJiBwcm9wcy5yZXBvc2l0b3J5TmFtZSkgeyBleHRyYUhhc2gucmVwb3NpdG9yeU5hbWUgPSBwcm9wcy5yZXBvc2l0b3J5TmFtZTsgfVxuICAgIGlmIChwcm9wcy5pbnZhbGlkYXRpb24/Lm5ldHdvcmtNb2RlICE9PSBmYWxzZSAmJiBwcm9wcy5uZXR3b3JrTW9kZSkgeyBleHRyYUhhc2gubmV0d29ya01vZGUgPSBwcm9wcy5uZXR3b3JrTW9kZTsgfVxuXG4gICAgLy8gYWRkIFwic2FsdFwiIHRvIHRoZSBoYXNoIGluIG9yZGVyIHRvIGludmFsaWRhdGUgdGhlIGltYWdlIGluIHRoZSB1cGdyYWRlIHRvXG4gICAgLy8gMS4yMS4wIHdoaWNoIHJlbW92ZXMgdGhlIEFkb3B0ZWRSZXBvc2l0b3J5IHJlc291cmNlIChhbmQgd2lsbCBjYXVzZSB0aGVcbiAgICAvLyBkZWxldGlvbiBvZiB0aGUgRUNSIHJlcG9zaXRvcnkgdGhlIGFwcCB1c2VkKS5cbiAgICBleHRyYUhhc2gudmVyc2lvbiA9ICcxLjIxLjAnO1xuXG4gICAgY29uc3Qgc3RhZ2luZyA9IG5ldyBBc3NldFN0YWdpbmcodGhpcywgJ1N0YWdpbmcnLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIGZvbGxvdzogcHJvcHMuZm9sbG93U3ltbGlua3MgPz8gdG9TeW1saW5rRm9sbG93KHByb3BzLmZvbGxvdyksXG4gICAgICBleGNsdWRlLFxuICAgICAgaWdub3JlTW9kZSxcbiAgICAgIHNvdXJjZVBhdGg6IGRpcixcbiAgICAgIGV4dHJhSGFzaDogT2JqZWN0LmtleXMoZXh0cmFIYXNoKS5sZW5ndGggPT09IDBcbiAgICAgICAgPyB1bmRlZmluZWRcbiAgICAgICAgOiBKU09OLnN0cmluZ2lmeShleHRyYUhhc2gpLFxuICAgIH0pO1xuXG4gICAgdGhpcy5zb3VyY2VIYXNoID0gc3RhZ2luZy5hc3NldEhhc2g7XG4gICAgdGhpcy5hc3NldEhhc2ggPSBzdGFnaW5nLmFzc2V0SGFzaDtcblxuICAgIGNvbnN0IHN0YWNrID0gU3RhY2sub2YodGhpcyk7XG4gICAgdGhpcy5hc3NldFBhdGggPSBzdGFnaW5nLnJlbGF0aXZlU3RhZ2VkUGF0aChzdGFjayk7XG4gICAgdGhpcy5kb2NrZXJCdWlsZEFyZ3MgPSBwcm9wcy5idWlsZEFyZ3M7XG4gICAgdGhpcy5kb2NrZXJCdWlsZFRhcmdldCA9IHByb3BzLnRhcmdldDtcblxuICAgIGNvbnN0IGxvY2F0aW9uID0gc3RhY2suc3ludGhlc2l6ZXIuYWRkRG9ja2VySW1hZ2VBc3NldCh7XG4gICAgICBkaXJlY3RvcnlOYW1lOiB0aGlzLmFzc2V0UGF0aCxcbiAgICAgIGRvY2tlckJ1aWxkQXJnczogdGhpcy5kb2NrZXJCdWlsZEFyZ3MsXG4gICAgICBkb2NrZXJCdWlsZFRhcmdldDogdGhpcy5kb2NrZXJCdWlsZFRhcmdldCxcbiAgICAgIGRvY2tlckZpbGU6IHByb3BzLmZpbGUsXG4gICAgICBzb3VyY2VIYXNoOiBzdGFnaW5nLmFzc2V0SGFzaCxcbiAgICAgIG5ldHdvcmtNb2RlOiBwcm9wcy5uZXR3b3JrTW9kZT8ubW9kZSxcbiAgICB9KTtcblxuICAgIHRoaXMucmVwb3NpdG9yeSA9IGVjci5SZXBvc2l0b3J5LmZyb21SZXBvc2l0b3J5TmFtZSh0aGlzLCAnUmVwb3NpdG9yeScsIGxvY2F0aW9uLnJlcG9zaXRvcnlOYW1lKTtcbiAgICB0aGlzLmltYWdlVXJpID0gbG9jYXRpb24uaW1hZ2VVcmk7XG4gIH1cblxuICAvKipcbiAgICogQWRkcyBDbG91ZEZvcm1hdGlvbiB0ZW1wbGF0ZSBtZXRhZGF0YSB0byB0aGUgc3BlY2lmaWVkIHJlc291cmNlIHdpdGhcbiAgICogaW5mb3JtYXRpb24gdGhhdCBpbmRpY2F0ZXMgd2hpY2ggcmVzb3VyY2UgcHJvcGVydHkgaXMgbWFwcGVkIHRvIHRoaXMgbG9jYWxcbiAgICogYXNzZXQuIFRoaXMgY2FuIGJlIHVzZWQgYnkgdG9vbHMgc3VjaCBhcyBTQU0gQ0xJIHRvIHByb3ZpZGUgbG9jYWxcbiAgICogZXhwZXJpZW5jZSBzdWNoIGFzIGxvY2FsIGludm9jYXRpb24gYW5kIGRlYnVnZ2luZyBvZiBMYW1iZGEgZnVuY3Rpb25zLlxuICAgKlxuICAgKiBBc3NldCBtZXRhZGF0YSB3aWxsIG9ubHkgYmUgaW5jbHVkZWQgaWYgdGhlIHN0YWNrIGlzIHN5bnRoZXNpemVkIHdpdGggdGhlXG4gICAqIFwiYXdzOmNkazplbmFibGUtYXNzZXQtbWV0YWRhdGFcIiBjb250ZXh0IGtleSBkZWZpbmVkLCB3aGljaCBpcyB0aGUgZGVmYXVsdFxuICAgKiBiZWhhdmlvciB3aGVuIHN5bnRoZXNpemluZyB2aWEgdGhlIENESyBUb29sa2l0LlxuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZ2l0aHViLmNvbS9hd3MvYXdzLWNkay9pc3N1ZXMvMTQzMlxuICAgKlxuICAgKiBAcGFyYW0gcmVzb3VyY2UgVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHdoaWNoIGlzIHVzaW5nIHRoaXMgYXNzZXQgW2Rpc2FibGUtYXdzbGludDpyZWYtdmlhLWludGVyZmFjZV1cbiAgICogQHBhcmFtIHJlc291cmNlUHJvcGVydHkgVGhlIHByb3BlcnR5IG5hbWUgd2hlcmUgdGhpcyBhc3NldCBpcyByZWZlcmVuY2VkXG4gICAqL1xuICBwdWJsaWMgYWRkUmVzb3VyY2VNZXRhZGF0YShyZXNvdXJjZTogQ2ZuUmVzb3VyY2UsIHJlc291cmNlUHJvcGVydHk6IHN0cmluZykge1xuICAgIGlmICghdGhpcy5ub2RlLnRyeUdldENvbnRleHQoY3hhcGkuQVNTRVRfUkVTT1VSQ0VfTUVUQURBVEFfRU5BQkxFRF9DT05URVhUKSkge1xuICAgICAgcmV0dXJuOyAvLyBub3QgZW5hYmxlZFxuICAgIH1cblxuICAgIC8vIHRlbGwgdG9vbHMgc3VjaCBhcyBTQU0gQ0xJIHRoYXQgdGhlIHJlc291cmNlUHJvcGVydHkgb2YgdGhpcyByZXNvdXJjZVxuICAgIC8vIHBvaW50cyB0byBhIGxvY2FsIHBhdGggYW5kIGluY2x1ZGUgdGhlIHBhdGggdG8gZGUgZG9ja2VyZmlsZSwgZG9ja2VyIGJ1aWxkIGFyZ3MsIGFuZCB0YXJnZXQsXG4gICAgLy8gaW4gb3JkZXIgdG8gZW5hYmxlIGxvY2FsIGludm9jYXRpb24gb2YgdGhpcyBmdW5jdGlvbi5cbiAgICByZXNvdXJjZS5jZm5PcHRpb25zLm1ldGFkYXRhID0gcmVzb3VyY2UuY2ZuT3B0aW9ucy5tZXRhZGF0YSB8fCB7IH07XG4gICAgcmVzb3VyY2UuY2ZuT3B0aW9ucy5tZXRhZGF0YVtjeGFwaS5BU1NFVF9SRVNPVVJDRV9NRVRBREFUQV9QQVRIX0tFWV0gPSB0aGlzLmFzc2V0UGF0aDtcbiAgICByZXNvdXJjZS5jZm5PcHRpb25zLm1ldGFkYXRhW2N4YXBpLkFTU0VUX1JFU09VUkNFX01FVEFEQVRBX0RPQ0tFUkZJTEVfUEFUSF9LRVldID0gdGhpcy5kb2NrZXJmaWxlUGF0aDtcbiAgICByZXNvdXJjZS5jZm5PcHRpb25zLm1ldGFkYXRhW2N4YXBpLkFTU0VUX1JFU09VUkNFX01FVEFEQVRBX0RPQ0tFUl9CVUlMRF9BUkdTX0tFWV0gPSB0aGlzLmRvY2tlckJ1aWxkQXJncztcbiAgICByZXNvdXJjZS5jZm5PcHRpb25zLm1ldGFkYXRhW2N4YXBpLkFTU0VUX1JFU09VUkNFX01FVEFEQVRBX0RPQ0tFUl9CVUlMRF9UQVJHRVRfS0VZXSA9IHRoaXMuZG9ja2VyQnVpbGRUYXJnZXQ7XG4gICAgcmVzb3VyY2UuY2ZuT3B0aW9ucy5tZXRhZGF0YVtjeGFwaS5BU1NFVF9SRVNPVVJDRV9NRVRBREFUQV9QUk9QRVJUWV9LRVldID0gcmVzb3VyY2VQcm9wZXJ0eTtcbiAgfVxuXG59XG5cbmZ1bmN0aW9uIHZhbGlkYXRlUHJvcHMocHJvcHM6IERvY2tlckltYWdlQXNzZXRQcm9wcykge1xuICBmb3IgKGNvbnN0IFtrZXksIHZhbHVlXSBvZiBPYmplY3QuZW50cmllcyhwcm9wcykpIHtcbiAgICBpZiAoVG9rZW4uaXNVbnJlc29sdmVkKHZhbHVlKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBDYW5ub3QgdXNlIFRva2VuIGFzIHZhbHVlIG9mICcke2tleX0nOiB0aGlzIHZhbHVlIGlzIHVzZWQgYmVmb3JlIGRlcGxveW1lbnQgc3RhcnRzYCk7XG4gICAgfVxuICB9XG5cbiAgdmFsaWRhdGVCdWlsZEFyZ3MocHJvcHMuYnVpbGRBcmdzKTtcbn1cblxuZnVuY3Rpb24gdmFsaWRhdGVCdWlsZEFyZ3MoYnVpbGRBcmdzPzogeyBba2V5OiBzdHJpbmddOiBzdHJpbmcgfSkge1xuICBmb3IgKGNvbnN0IFtrZXksIHZhbHVlXSBvZiBPYmplY3QuZW50cmllcyhidWlsZEFyZ3MgfHwge30pKSB7XG4gICAgaWYgKFRva2VuLmlzVW5yZXNvbHZlZChrZXkpIHx8IFRva2VuLmlzVW5yZXNvbHZlZCh2YWx1ZSkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignQ2Fubm90IHVzZSB0b2tlbnMgaW4ga2V5cyBvciB2YWx1ZXMgb2YgXCJidWlsZEFyZ3NcIiBzaW5jZSB0aGV5IGFyZSBuZWVkZWQgYmVmb3JlIGRlcGxveW1lbnQnKTtcbiAgICB9XG4gIH1cbn1cblxuZnVuY3Rpb24gdG9TeW1saW5rRm9sbG93KGZvbGxvdz86IEZvbGxvd01vZGUpOiBTeW1saW5rRm9sbG93TW9kZSB8IHVuZGVmaW5lZCB7XG4gIHN3aXRjaCAoZm9sbG93KSB7XG4gICAgY2FzZSB1bmRlZmluZWQ6IHJldHVybiB1bmRlZmluZWQ7XG4gICAgY2FzZSBGb2xsb3dNb2RlLk5FVkVSOiByZXR1cm4gU3ltbGlua0ZvbGxvd01vZGUuTkVWRVI7XG4gICAgY2FzZSBGb2xsb3dNb2RlLkFMV0FZUzogcmV0dXJuIFN5bWxpbmtGb2xsb3dNb2RlLkFMV0FZUztcbiAgICBjYXNlIEZvbGxvd01vZGUuQkxPQ0tfRVhURVJOQUw6IHJldHVybiBTeW1saW5rRm9sbG93TW9kZS5CTE9DS19FWFRFUk5BTDtcbiAgICBjYXNlIEZvbGxvd01vZGUuRVhURVJOQUw6IHJldHVybiBTeW1saW5rRm9sbG93TW9kZS5FWFRFUk5BTDtcbiAgfVxufVxuIl19