"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TarballImageAsset = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const ecr = require("@aws-cdk/aws-ecr");
const core_1 = require("@aws-cdk/core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * An asset that represents a Docker image.
 *
 * The image will loaded from an existing tarball and uploaded to an ECR repository.
 */
class TarballImageAsset extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_ecr_assets_TarballImageAssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (!fs.existsSync(props.tarballFile)) {
            throw new Error(`Cannot find file at ${props.tarballFile}`);
        }
        const stagedTarball = new core_1.AssetStaging(this, 'Staging', { sourcePath: props.tarballFile });
        this.sourceHash = stagedTarball.assetHash;
        this.assetHash = stagedTarball.assetHash;
        const stage = core_1.Stage.of(this);
        const relativePathInOutDir = stage ? path.relative(stage.assetOutdir, stagedTarball.absoluteStagedPath) : stagedTarball.absoluteStagedPath;
        const stack = core_1.Stack.of(this);
        const location = stack.synthesizer.addDockerImageAsset({
            sourceHash: stagedTarball.assetHash,
            executable: [
                'sh',
                '-c',
                `docker load -i ${relativePathInOutDir} | sed "s/Loaded image: //g"`,
            ],
        });
        this.repository = ecr.Repository.fromRepositoryName(this, 'Repository', location.repositoryName);
        this.imageUri = location.imageUri;
    }
}
exports.TarballImageAsset = TarballImageAsset;
_a = JSII_RTTI_SYMBOL_1;
TarballImageAsset[_a] = { fqn: "@aws-cdk/aws-ecr-assets.TarballImageAsset", version: "1.153.0" };
//# sourceMappingURL=data:application/json;base64,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