﻿'''_3907.py

ConnectorCompoundPowerFlow
'''


from typing import List

from mastapy.system_model.analyses_and_results.power_flows import _3774
from mastapy._internal import constructor, conversion
from mastapy.system_model.analyses_and_results.power_flows.compound import _3948
from mastapy._internal.python_net import python_net_import

_CONNECTOR_COMPOUND_POWER_FLOW = python_net_import('SMT.MastaAPI.SystemModel.AnalysesAndResults.PowerFlows.Compound', 'ConnectorCompoundPowerFlow')


__docformat__ = 'restructuredtext en'
__all__ = ('ConnectorCompoundPowerFlow',)


class ConnectorCompoundPowerFlow(_3948.MountableComponentCompoundPowerFlow):
    '''ConnectorCompoundPowerFlow

    This is a mastapy class.
    '''

    TYPE = _CONNECTOR_COMPOUND_POWER_FLOW

    __hash__ = None

    def __init__(self, instance_to_wrap: 'ConnectorCompoundPowerFlow.TYPE'):
        super().__init__(instance_to_wrap)
        self._freeze()

    @property
    def component_analysis_cases(self) -> 'List[_3774.ConnectorPowerFlow]':
        '''List[ConnectorPowerFlow]: 'ComponentAnalysisCases' is the original name of this property.

        Note:
            This property is readonly.
        '''

        value = conversion.pn_to_mp_objects_in_list(self.wrapped.ComponentAnalysisCases, constructor.new(_3774.ConnectorPowerFlow))
        return value

    @property
    def component_analysis_cases_ready(self) -> 'List[_3774.ConnectorPowerFlow]':
        '''List[ConnectorPowerFlow]: 'ComponentAnalysisCasesReady' is the original name of this property.

        Note:
            This property is readonly.
        '''

        value = conversion.pn_to_mp_objects_in_list(self.wrapped.ComponentAnalysisCasesReady, constructor.new(_3774.ConnectorPowerFlow))
        return value
