/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import solver.SolverConfig;
import solver.SolverInfo;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0016J+\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J+\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J+\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\t2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lsolver/CVC5SolverInfo;", "Lsolver/SolverInfo;", "()V", "DEFAULT_CVC_COMMAND", "", "defaultCommand", "getDefaultCommand", "()Ljava/lang/String;", "commandForStdInMode", "", "clOptions", "getBitVectorConfigs", "Lsolver/SolverConfig;", "timelimit", "Ljava/time/Duration;", "memlimitBytes", "", "incrementalMode", "", "(Ljava/time/Duration;Ljava/lang/Long;Z)Ljava/util/List;", "getCmdToChangeTimelimit", "getNonLinearConfigs", "getOptionForIncremental", "getOptionForRandomSeed", "randomSeed", "", "getOptionForTimelimit", "getQuantifierConfigs", "readResolve", "", "supportsLogicFeatures", "features", "Lsolver/SolverConfig$LogicFeatures;", "GeneralUtils"})
@SourceDebugExtension(value={"SMAP\nCVC5SolverInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CVC5SolverInfo.kt\nsolver/CVC5SolverInfo\n+ 2 ExtStdlib.kt\nutils/ExtStdlibKt\n*L\n1#1,107:1\n27#2:108\n27#2:109\n27#2:110\n*S KotlinDebug\n*F\n+ 1 CVC5SolverInfo.kt\nsolver/CVC5SolverInfo\n*L\n59#1:108\n60#1:109\n61#1:110\n*E\n"})
public final class CVC5SolverInfo
extends SolverInfo {
    @NotNull
    public static final CVC5SolverInfo INSTANCE = new CVC5SolverInfo();
    @NotNull
    private static final String DEFAULT_CVC_COMMAND = "cvc5";

    private CVC5SolverInfo() {
        super("CVC5");
    }

    @Override
    @NotNull
    public List<String> getOptionForIncremental() {
        return CollectionsKt.listOf("--incremental");
    }

    @Override
    @NotNull
    public List<String> getOptionForTimelimit(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return CollectionsKt.listOf("--tlimit-per=" + timelimit.toMillis());
    }

    @Override
    public boolean supportsLogicFeatures(@NotNull SolverConfig.LogicFeatures features) {
        Intrinsics.checkNotNullParameter(features, "features");
        return true;
    }

    @Override
    @NotNull
    public List<String> getOptionForRandomSeed(int randomSeed) {
        return CollectionsKt.listOf("--seed=" + randomSeed);
    }

    @Override
    @NotNull
    public String getCmdToChangeTimelimit(@NotNull Duration timelimit) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return "(set-option :tlimit-per " + timelimit.toMillis() + ")";
    }

    @Override
    @NotNull
    public List<String> commandForStdInMode(@NotNull List<String> clOptions) {
        Intrinsics.checkNotNullParameter(clOptions, "clOptions");
        String[] stringArray = new String[]{DEFAULT_CVC_COMMAND, "--lang", "smt2", "--dag-thresh=0"};
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)clOptions);
    }

    @Override
    @NotNull
    public String getDefaultCommand() {
        return DEFAULT_CVC_COMMAND;
    }

    @NotNull
    public final List<SolverConfig> getQuantifierConfigs(@NotNull Duration timelimit, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return CollectionsKt.listOf(SolverConfig.copy$default(SolverConfig.Companion.getCvc5().getQ(), null, null, null, null, incrementalMode, timelimit, memlimitBytes, null, null, null, null, 1935, null));
    }

    @NotNull
    public final List<SolverConfig> getNonLinearConfigs(@NotNull Duration timelimit, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        return CollectionsKt.listOf(SolverConfig.copy$default(SolverConfig.Companion.getCvc5().getNonlin(), null, null, null, null, incrementalMode, timelimit, memlimitBytes, null, null, null, null, 1935, null));
    }

    @NotNull
    public final List<SolverConfig> getBitVectorConfigs(@NotNull Duration timelimit, @Nullable Long memlimitBytes, boolean incrementalMode) {
        Intrinsics.checkNotNullParameter(timelimit, "timelimit");
        boolean $i$f$unused = false;
        $i$f$unused = false;
        $i$f$unused = incrementalMode;
        boolean $i$f$unused2 = false;
        return CollectionsKt.emptyList();
    }

    private final Object readResolve() {
        return INSTANCE;
    }
}

