/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.AstBaseBlocks;
import com.certora.evmverifier.cvl.ImportedContract;
import com.certora.evmverifier.cvl.ImportedSpecFile;
import com.certora.evmverifier.cvl.KotlinizeResult;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlinizable.Kotlinizable;
import kotlinizable.Kotlinizer;
import spec.TypeResolver;
import spec.cvlast.CVLAst;
import spec.cvlast.CVLDefinition;
import spec.cvlast.CVLFunction;
import spec.cvlast.CVLGhostDeclaration;
import spec.cvlast.CVLHook;
import spec.cvlast.CVLInvariant;
import spec.cvlast.CVLScope;
import spec.cvlast.IRule;
import spec.cvlast.MethodBlockAnnotation;
import spec.cvlast.OverrideDeclarations;
import spec.cvlast.SortDeclaration;
import spec.cvlast.UseDeclarations;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public class Ast
implements Kotlinizable<CVLAst> {
    public AstBaseBlocks astBaseBlocks;
    public List<ImportedContract> importedContracts;
    public List<ImportedSpecFile> importedSpecFiles;

    public Ast(AstBaseBlocks _astBaseBlocks, List<ImportedContract> _contracts, List<ImportedSpecFile> _importedSpecFiles) {
        this.astBaseBlocks = _astBaseBlocks;
        this.importedContracts = _contracts;
        this.importedSpecFiles = _importedSpecFiles;
    }

    @Override
    public CollectingResult<CVLAst, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
        ArrayList<CollectingResult<Unit, CVLError>> contractAliases = new ArrayList<CollectingResult<Unit, CVLError>>();
        for (ImportedContract imp : this.importedContracts) {
            contractAliases.add(resolver.registerContractAlias(imp));
        }
        CollectingResult contractAliasesFlattened = CollectingResult.Companion.flatten(contractAliases);
        CollectingResult<List<MethodBlockAnnotation>, CVLError> methodBlockAnnotation = this.astBaseBlocks.kotlinizeImportedMethods(resolver, scope);
        CollectingResult<List<SortDeclaration>, CVLError> sorts = this.astBaseBlocks.kotlinizeSorts(resolver, scope);
        resolver.registerSorts(sorts.resultOrNull());
        CollectingResult<UseDeclarations, CVLError> useDeclarations = this.astBaseBlocks.kotlinizeUseDeclarations(resolver, scope);
        CollectingResult<List<IRule>, CVLError> rules = this.astBaseBlocks.kotlinizeRules(resolver, scope);
        CollectingResult<List<CVLFunction>, CVLError> subs = this.astBaseBlocks.kotlinizeSubs(resolver, scope);
        CollectingResult<List<CVLInvariant>, CVLError> invs = this.astBaseBlocks.kotlinizeInvariants(resolver, scope);
        CollectingResult<List<CVLGhostDeclaration>, CVLError> ghostDecls = this.astBaseBlocks.kotlinizeGhostDecls(resolver, scope);
        CollectingResult<List<CVLDefinition>, CVLError> defs2 = this.astBaseBlocks.kotlinizeMacroDefinitions(resolver, scope);
        CollectingResult<List<CVLHook>, CVLError> hooks = this.astBaseBlocks.kotlinizeHooks(resolver, scope);
        CollectingResult contractImports = Kotlinizer.kotlinizeList(this.importedContracts, scope, resolver);
        CollectingResult specImports = Kotlinizer.kotlinizeList(this.importedSpecFiles, scope, resolver);
        CollectingResult<OverrideDeclarations, CVLError> overrideDeclarations = this.astBaseBlocks.kotlinizeOverrideDeclarations(resolver, scope);
        return KotlinizeResult.bindMany(() -> KotlinizeResult.lift(new CVLAst((List)methodBlockAnnotation.force(), (UseDeclarations)useDeclarations.force(), (List)rules.force(), (List)subs.force(), (List)invs.force(), (List)sorts.force(), (List)ghostDecls.force(), (List)defs2.force(), (List)hooks.force(), (List)contractImports.force(), (List)specImports.force(), (OverrideDeclarations)overrideDeclarations.force(), scope)), methodBlockAnnotation, useDeclarations, rules, subs, invs, sorts, ghostDecls, defs2, hooks, contractImports, specImports, overrideDeclarations, contractAliasesFlattened);
    }

    public CollectingResult<CVLAst, CVLError> toCVLAst(TypeResolver resolver, CVLScope scope) {
        return this.kotlinize(resolver, scope);
    }
}

