"""
Utilities for generating OpenAPI specifications

WORK-IN-PROGRESS, DON'T USE!
"""

from collections import defaultdict
from dataclasses import dataclass, field
from typing import TypeAlias

from pkgs.serialization_util.serialization_helpers import JsonValue

from . import builder
from .open_api_util import OpenAPIType

MODIFY_NOTICE = "# DO NOT MODIFY -- This file is generated by type_spec"

GlobalContextInfo: TypeAlias = dict[str, str | dict[str, str]]
TagGroupToNamedTags: TypeAlias = dict[str, str | list[str]]
TagPathsToRef: TypeAlias = dict[str, dict[str, str]]


@dataclass
class EmitOpenAPITag:
    name: str
    description: str

    def __hash__(self) -> int:
        return hash(self.name)

    def __eq__(self, other: object) -> bool:
        if not isinstance(other, EmitOpenAPITag):
            return False
        return self.name == other.name


@dataclass
class EmitOpenAPIPath:
    path: str
    ref: str


@dataclass
class EmitOpenAPIServer:
    url: str


@dataclass(kw_only=True)
class EmitOpenAPIGuide:
    ref_name: str
    title: str
    html_content: str


@dataclass
class EmitOpenAPIGlobalContext:
    version: str
    info: GlobalContextInfo
    servers: list[EmitOpenAPIServer]

    tags: set[EmitOpenAPITag] = field(default_factory=set)
    tag_groups: defaultdict[str, set[str]] = field(
        default_factory=lambda: defaultdict(set)
    )
    paths: list[EmitOpenAPIPath] = field(default_factory=list)


@dataclass(kw_only=True)
class EmitOpenAPIEndpointExample:
    ref_name: str
    summary: str
    description: str
    arguments: dict[str, JsonValue]
    data: dict[str, JsonValue]


EmitOpenAPIStabilityLevel = builder.StabilityLevel


@dataclass
class EmitOpenAPIEndpoint:
    method: str
    tags: list[str]
    summary: str
    description: str
    is_beta: bool
    stability_level: EmitOpenAPIStabilityLevel | None
    examples: list[EmitOpenAPIEndpointExample]
    guides: list[EmitOpenAPIGuide]


@dataclass
class EmitOpenAPIContext:
    namespace: builder.SpecNamespace
    namespaces: set[builder.SpecNamespace] = field(default_factory=set)

    endpoint: EmitOpenAPIEndpoint | None = None
    types: dict[str, OpenAPIType] = field(default_factory=dict)


def resolve_namespace_ref(
    *, source_path: list[str], ref_path: list[str], ref: str
) -> str:
    to_root = "/".join(".." for _ in source_path)
    location = "/".join(ref_path)
    return f"{to_root}/common/{location}.yaml#{ref}"
