# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/dvc.experiment.ipynb.

# %% auto 0
__all__ = ['log', 'parse_params', 'parse_metrics', 'parse_experiment', 'parse_experiments', 'load_experiments']

# %% ../../nbs/dvc.experiment.ipynb 3
import json
from typing import Generator

from ..logging import get_logger

log = get_logger(__name__)

# %% ../../nbs/dvc.experiment.ipynb 4
def parse_params(record):
    params_node = record.get("data", {}).get("params", {})
    params = {}
    for k, v in params_node.items():
        params.update(v.get("data", {}))
    return params

def parse_metrics(record):
    metrics_node = record.get("data", {}).get("metrics", {})
    metrics = {}
    for k, v in metrics_node.items():
        metrics.update(v.get("data", {}))
    return metrics

def parse_experiment(record):
    return {
        'id': record['rev'],
        'name': record['name'],
        'params': parse_params(record),
        'metrics': parse_metrics(record),
    }


def parse_experiments(data: list[dict]) -> Generator[dict, None, None]:
    for node in data:
        if node.get("error"):
            continue
        commit = node.get("rev")
        if experiments := (node.get('experiments') or []):
            for experiment in experiments:
                for rev in (experiment.get('revs') or []):
                    if not rev.get("error"):
                        yield {"commit": commit, **parse_experiment(rev)}
        else:
            yield {"commit": commit, **parse_experiment(node)}

def load_experiments(json_filepath):
    with open(json_filepath, 'r') as f:
        data = json.load(f)
    return list(parse_experiments(data))
