# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NgwafAlertJiraIntegrationArgs', 'NgwafAlertJiraIntegration']

@pulumi.input_type
class NgwafAlertJiraIntegrationArgs:
    def __init__(__self__, *,
                 host: pulumi.Input[_builtins.str],
                 key: pulumi.Input[_builtins.str],
                 project: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 issue_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NgwafAlertJiraIntegration resource.
        :param pulumi.Input[_builtins.str] host: The name of the Jira instance.
        :param pulumi.Input[_builtins.str] key: The Jira key.
        :param pulumi.Input[_builtins.str] project: The Jira project where the issue will be created.
        :param pulumi.Input[_builtins.str] username: The Jira username of the user who created the ticket.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        :param pulumi.Input[_builtins.str] description: The description of the alert.
        :param pulumi.Input[_builtins.str] issue_type: The Jira issue type associated with the ticket.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if issue_type is not None:
            pulumi.set(__self__, "issue_type", issue_type)

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Jira instance.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The Jira key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Input[_builtins.str]:
        """
        The Jira project where the issue will be created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The Jira username of the user who created the ticket.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="issueType")
    def issue_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Jira issue type associated with the ticket.
        """
        return pulumi.get(self, "issue_type")

    @issue_type.setter
    def issue_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issue_type", value)


@pulumi.input_type
class _NgwafAlertJiraIntegrationState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 issue_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafAlertJiraIntegration resources.
        :param pulumi.Input[_builtins.str] description: The description of the alert.
        :param pulumi.Input[_builtins.str] host: The name of the Jira instance.
        :param pulumi.Input[_builtins.str] issue_type: The Jira issue type associated with the ticket.
        :param pulumi.Input[_builtins.str] key: The Jira key.
        :param pulumi.Input[_builtins.str] project: The Jira project where the issue will be created.
        :param pulumi.Input[_builtins.str] username: The Jira username of the user who created the ticket.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if issue_type is not None:
            pulumi.set(__self__, "issue_type", issue_type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Jira instance.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host", value)

    @_builtins.property
    @pulumi.getter(name="issueType")
    def issue_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Jira issue type associated with the ticket.
        """
        return pulumi.get(self, "issue_type")

    @issue_type.setter
    def issue_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issue_type", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Jira key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Jira project where the issue will be created.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Jira username of the user who created the ticket.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("fastly:index/ngwafAlertJiraIntegration:NgwafAlertJiraIntegration")
class NgwafAlertJiraIntegration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 issue_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides Fastly Next-Gen WAF Alert Jira integrations, which provide a connection to Jira.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo_jira_alert = fastly.NgwafAlertJiraIntegration("demo_jira_alert",
            description="A description",
            host="https://mycompany.atlassian.net",
            issue_type="task",
            key="a1b2c3d4e5f6789012345678901234567",
            project="test",
            username="user",
            workspace_id=demo["id"])
        ```

        ## Import

        Fastly Next-Gen WAF Alert Jira integrations can be imported using their ID and the ID of the workspace they belong to.

        ```sh
        $ pulumi import fastly:index/ngwafAlertJiraIntegration:NgwafAlertJiraIntegration example <workspace_id>/<alert_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the alert.
        :param pulumi.Input[_builtins.str] host: The name of the Jira instance.
        :param pulumi.Input[_builtins.str] issue_type: The Jira issue type associated with the ticket.
        :param pulumi.Input[_builtins.str] key: The Jira key.
        :param pulumi.Input[_builtins.str] project: The Jira project where the issue will be created.
        :param pulumi.Input[_builtins.str] username: The Jira username of the user who created the ticket.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafAlertJiraIntegrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides Fastly Next-Gen WAF Alert Jira integrations, which provide a connection to Jira.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        demo_jira_alert = fastly.NgwafAlertJiraIntegration("demo_jira_alert",
            description="A description",
            host="https://mycompany.atlassian.net",
            issue_type="task",
            key="a1b2c3d4e5f6789012345678901234567",
            project="test",
            username="user",
            workspace_id=demo["id"])
        ```

        ## Import

        Fastly Next-Gen WAF Alert Jira integrations can be imported using their ID and the ID of the workspace they belong to.

        ```sh
        $ pulumi import fastly:index/ngwafAlertJiraIntegration:NgwafAlertJiraIntegration example <workspace_id>/<alert_id>
        ```

        :param str resource_name: The name of the resource.
        :param NgwafAlertJiraIntegrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafAlertJiraIntegrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 host: Optional[pulumi.Input[_builtins.str]] = None,
                 issue_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafAlertJiraIntegrationArgs.__new__(NgwafAlertJiraIntegrationArgs)

            __props__.__dict__["description"] = description
            if host is None and not opts.urn:
                raise TypeError("Missing required property 'host'")
            __props__.__dict__["host"] = host
            __props__.__dict__["issue_type"] = issue_type
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = None if key is None else pulumi.Output.secret(key)
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NgwafAlertJiraIntegration, __self__).__init__(
            'fastly:index/ngwafAlertJiraIntegration:NgwafAlertJiraIntegration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            host: Optional[pulumi.Input[_builtins.str]] = None,
            issue_type: Optional[pulumi.Input[_builtins.str]] = None,
            key: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafAlertJiraIntegration':
        """
        Get an existing NgwafAlertJiraIntegration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the alert.
        :param pulumi.Input[_builtins.str] host: The name of the Jira instance.
        :param pulumi.Input[_builtins.str] issue_type: The Jira issue type associated with the ticket.
        :param pulumi.Input[_builtins.str] key: The Jira key.
        :param pulumi.Input[_builtins.str] project: The Jira project where the issue will be created.
        :param pulumi.Input[_builtins.str] username: The Jira username of the user who created the ticket.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafAlertJiraIntegrationState.__new__(_NgwafAlertJiraIntegrationState)

        __props__.__dict__["description"] = description
        __props__.__dict__["host"] = host
        __props__.__dict__["issue_type"] = issue_type
        __props__.__dict__["key"] = key
        __props__.__dict__["project"] = project
        __props__.__dict__["username"] = username
        __props__.__dict__["workspace_id"] = workspace_id
        return NgwafAlertJiraIntegration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the alert.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def host(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Jira instance.
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="issueType")
    def issue_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Jira issue type associated with the ticket.
        """
        return pulumi.get(self, "issue_type")

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Output[_builtins.str]:
        """
        The Jira key.
        """
        return pulumi.get(self, "key")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The Jira project where the issue will be created.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The Jira username of the user who created the ticket.
        """
        return pulumi.get(self, "username")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

