# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NgwafWorkspaceRuleArgs', 'NgwafWorkspaceRule']

@pulumi.input_type
class NgwafWorkspaceRuleArgs:
    def __init__(__self__, *,
                 actions: pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleActionArgs']]],
                 description: pulumi.Input[_builtins.str],
                 enabled: pulumi.Input[_builtins.bool],
                 type: pulumi.Input[_builtins.str],
                 workspace_id: pulumi.Input[_builtins.str],
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleConditionArgs']]]] = None,
                 group_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleGroupConditionArgs']]]] = None,
                 group_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input['NgwafWorkspaceRuleRateLimitArgs']] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NgwafWorkspaceRule resource.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleActionArgs']]] actions: List of actions to perform when the rule matches.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently enabled.
        :param pulumi.Input[_builtins.str] type: The type of the rule. Accepted values are `request`, `signal`, `rate_limit`, and `templated_signal`.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleConditionArgs']]] conditions: Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleGroupConditionArgs']]] group_conditions: List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] group_operator: Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        :param pulumi.Input['NgwafWorkspaceRuleRateLimitArgs'] rate_limit: Block specifically for rate*limit rules.
        :param pulumi.Input[_builtins.str] request_logging: Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        """
        pulumi.set(__self__, "actions", actions)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "workspace_id", workspace_id)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if group_conditions is not None:
            pulumi.set(__self__, "group_conditions", group_conditions)
        if group_operator is not None:
            pulumi.set(__self__, "group_operator", group_operator)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if request_logging is not None:
            pulumi.set(__self__, "request_logging", request_logging)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleActionArgs']]]:
        """
        List of actions to perform when the rule matches.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleActionArgs']]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Input[_builtins.str]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the rule is currently enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the rule. Accepted values are `request`, `signal`, `rate_limit`, and `templated_signal`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleConditionArgs']]]]:
        """
        Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter(name="groupConditions")
    def group_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleGroupConditionArgs']]]]:
        """
        List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        """
        return pulumi.get(self, "group_conditions")

    @group_conditions.setter
    def group_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleGroupConditionArgs']]]]):
        pulumi.set(self, "group_conditions", value)

    @_builtins.property
    @pulumi.getter(name="groupOperator")
    def group_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        """
        return pulumi.get(self, "group_operator")

    @group_operator.setter
    def group_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_operator", value)

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input['NgwafWorkspaceRuleRateLimitArgs']]:
        """
        Block specifically for rate*limit rules.
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input['NgwafWorkspaceRuleRateLimitArgs']]):
        pulumi.set(self, "rate_limit", value)

    @_builtins.property
    @pulumi.getter(name="requestLogging")
    def request_logging(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        """
        return pulumi.get(self, "request_logging")

    @request_logging.setter
    def request_logging(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_logging", value)


@pulumi.input_type
class _NgwafWorkspaceRuleState:
    def __init__(__self__, *,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleActionArgs']]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleConditionArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_conditions: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleGroupConditionArgs']]]] = None,
                 group_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input['NgwafWorkspaceRuleRateLimitArgs']] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafWorkspaceRule resources.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleActionArgs']]] actions: List of actions to perform when the rule matches.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleConditionArgs']]] conditions: Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently enabled.
        :param pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleGroupConditionArgs']]] group_conditions: List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] group_operator: Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        :param pulumi.Input['NgwafWorkspaceRuleRateLimitArgs'] rate_limit: Block specifically for rate*limit rules.
        :param pulumi.Input[_builtins.str] request_logging: Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        :param pulumi.Input[_builtins.str] type: The type of the rule. Accepted values are `request`, `signal`, `rate_limit`, and `templated_signal`.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        if actions is not None:
            pulumi.set(__self__, "actions", actions)
        if conditions is not None:
            pulumi.set(__self__, "conditions", conditions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if group_conditions is not None:
            pulumi.set(__self__, "group_conditions", group_conditions)
        if group_operator is not None:
            pulumi.set(__self__, "group_operator", group_operator)
        if rate_limit is not None:
            pulumi.set(__self__, "rate_limit", rate_limit)
        if request_logging is not None:
            pulumi.set(__self__, "request_logging", request_logging)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleActionArgs']]]]:
        """
        List of actions to perform when the rule matches.
        """
        return pulumi.get(self, "actions")

    @actions.setter
    def actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleActionArgs']]]]):
        pulumi.set(self, "actions", value)

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleConditionArgs']]]]:
        """
        Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        """
        return pulumi.get(self, "conditions")

    @conditions.setter
    def conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleConditionArgs']]]]):
        pulumi.set(self, "conditions", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the rule is currently enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="groupConditions")
    def group_conditions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleGroupConditionArgs']]]]:
        """
        List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        """
        return pulumi.get(self, "group_conditions")

    @group_conditions.setter
    def group_conditions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NgwafWorkspaceRuleGroupConditionArgs']]]]):
        pulumi.set(self, "group_conditions", value)

    @_builtins.property
    @pulumi.getter(name="groupOperator")
    def group_operator(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        """
        return pulumi.get(self, "group_operator")

    @group_operator.setter
    def group_operator(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_operator", value)

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> Optional[pulumi.Input['NgwafWorkspaceRuleRateLimitArgs']]:
        """
        Block specifically for rate*limit rules.
        """
        return pulumi.get(self, "rate_limit")

    @rate_limit.setter
    def rate_limit(self, value: Optional[pulumi.Input['NgwafWorkspaceRuleRateLimitArgs']]):
        pulumi.set(self, "rate_limit", value)

    @_builtins.property
    @pulumi.getter(name="requestLogging")
    def request_logging(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        """
        return pulumi.get(self, "request_logging")

    @request_logging.setter
    def request_logging(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_logging", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the rule. Accepted values are `request`, `signal`, `rate_limit`, and `templated_signal`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("fastly:index/ngwafWorkspaceRule:NgwafWorkspaceRule")
class NgwafWorkspaceRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleActionArgs', 'NgwafWorkspaceRuleActionArgsDict']]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleConditionArgs', 'NgwafWorkspaceRuleConditionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleGroupConditionArgs', 'NgwafWorkspaceRuleGroupConditionArgsDict']]]]] = None,
                 group_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input[Union['NgwafWorkspaceRuleRateLimitArgs', 'NgwafWorkspaceRuleRateLimitArgsDict']]] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Fastly Next-Gen WAF Workspace Rule, scoped to a specific NGWAF workspace.\\
        These rules define conditions and actions that trigger WAF enforcement at the workspace level.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.NgwafWorkspace("example",
            name="example",
            description="Test NGWAF Workspace",
            mode="block",
            ip_anonymization="hashed",
            client_ip_headers=[
                "X-Forwarded-For",
                "X-Real-IP",
            ],
            default_blocking_response_code=429,
            attack_signal_thresholds={})
        example_ngwaf_workspace_rule = fastly.NgwafWorkspaceRule("example",
            workspace_id=example.id,
            type="request",
            description="example",
            enabled=True,
            request_logging="sampled",
            group_operator="all",
            actions=[{
                "type": "block",
            }],
            conditions=[
                {
                    "field": "ip",
                    "operator": "equals",
                    "value": "127.0.0.1",
                },
                {
                    "field": "path",
                    "operator": "equals",
                    "value": "/login",
                },
                {
                    "field": "agent_name",
                    "operator": "equals",
                    "value": "host-001",
                },
            ],
            group_conditions=[
                {
                    "group_operator": "all",
                    "conditions": [
                        {
                            "field": "country",
                            "operator": "equals",
                            "value": "AD",
                        },
                        {
                            "field": "method",
                            "operator": "equals",
                            "value": "POST",
                        },
                    ],
                },
                {
                    "group_operator": "any",
                    "conditions": [
                        {
                            "field": "protocol_version",
                            "operator": "equals",
                            "value": "HTTP/1.0",
                        },
                        {
                            "field": "method",
                            "operator": "equals",
                            "value": "HEAD",
                        },
                        {
                            "field": "domain",
                            "operator": "equals",
                            "value": "example.com",
                        },
                    ],
                },
            ])
        ```

        ## Import

        Fastly Next-Gen WAF workspace rules can be imported using the format `<workspaceID>/<ruleID>`, e.g.:

        ```sh
        $ pulumi import fastly:index/ngwafWorkspaceRule:NgwafWorkspaceRule demo <workspaceID>/<ruleID>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleActionArgs', 'NgwafWorkspaceRuleActionArgsDict']]]] actions: List of actions to perform when the rule matches.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleConditionArgs', 'NgwafWorkspaceRuleConditionArgsDict']]]] conditions: Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleGroupConditionArgs', 'NgwafWorkspaceRuleGroupConditionArgsDict']]]] group_conditions: List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] group_operator: Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        :param pulumi.Input[Union['NgwafWorkspaceRuleRateLimitArgs', 'NgwafWorkspaceRuleRateLimitArgsDict']] rate_limit: Block specifically for rate*limit rules.
        :param pulumi.Input[_builtins.str] request_logging: Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        :param pulumi.Input[_builtins.str] type: The type of the rule. Accepted values are `request`, `signal`, `rate_limit`, and `templated_signal`.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafWorkspaceRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Fastly Next-Gen WAF Workspace Rule, scoped to a specific NGWAF workspace.\\
        These rules define conditions and actions that trigger WAF enforcement at the workspace level.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.NgwafWorkspace("example",
            name="example",
            description="Test NGWAF Workspace",
            mode="block",
            ip_anonymization="hashed",
            client_ip_headers=[
                "X-Forwarded-For",
                "X-Real-IP",
            ],
            default_blocking_response_code=429,
            attack_signal_thresholds={})
        example_ngwaf_workspace_rule = fastly.NgwafWorkspaceRule("example",
            workspace_id=example.id,
            type="request",
            description="example",
            enabled=True,
            request_logging="sampled",
            group_operator="all",
            actions=[{
                "type": "block",
            }],
            conditions=[
                {
                    "field": "ip",
                    "operator": "equals",
                    "value": "127.0.0.1",
                },
                {
                    "field": "path",
                    "operator": "equals",
                    "value": "/login",
                },
                {
                    "field": "agent_name",
                    "operator": "equals",
                    "value": "host-001",
                },
            ],
            group_conditions=[
                {
                    "group_operator": "all",
                    "conditions": [
                        {
                            "field": "country",
                            "operator": "equals",
                            "value": "AD",
                        },
                        {
                            "field": "method",
                            "operator": "equals",
                            "value": "POST",
                        },
                    ],
                },
                {
                    "group_operator": "any",
                    "conditions": [
                        {
                            "field": "protocol_version",
                            "operator": "equals",
                            "value": "HTTP/1.0",
                        },
                        {
                            "field": "method",
                            "operator": "equals",
                            "value": "HEAD",
                        },
                        {
                            "field": "domain",
                            "operator": "equals",
                            "value": "example.com",
                        },
                    ],
                },
            ])
        ```

        ## Import

        Fastly Next-Gen WAF workspace rules can be imported using the format `<workspaceID>/<ruleID>`, e.g.:

        ```sh
        $ pulumi import fastly:index/ngwafWorkspaceRule:NgwafWorkspaceRule demo <workspaceID>/<ruleID>
        ```

        :param str resource_name: The name of the resource.
        :param NgwafWorkspaceRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafWorkspaceRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleActionArgs', 'NgwafWorkspaceRuleActionArgsDict']]]]] = None,
                 conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleConditionArgs', 'NgwafWorkspaceRuleConditionArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 group_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleGroupConditionArgs', 'NgwafWorkspaceRuleGroupConditionArgsDict']]]]] = None,
                 group_operator: Optional[pulumi.Input[_builtins.str]] = None,
                 rate_limit: Optional[pulumi.Input[Union['NgwafWorkspaceRuleRateLimitArgs', 'NgwafWorkspaceRuleRateLimitArgsDict']]] = None,
                 request_logging: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafWorkspaceRuleArgs.__new__(NgwafWorkspaceRuleArgs)

            if actions is None and not opts.urn:
                raise TypeError("Missing required property 'actions'")
            __props__.__dict__["actions"] = actions
            __props__.__dict__["conditions"] = conditions
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            if enabled is None and not opts.urn:
                raise TypeError("Missing required property 'enabled'")
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["group_conditions"] = group_conditions
            __props__.__dict__["group_operator"] = group_operator
            __props__.__dict__["rate_limit"] = rate_limit
            __props__.__dict__["request_logging"] = request_logging
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
        super(NgwafWorkspaceRule, __self__).__init__(
            'fastly:index/ngwafWorkspaceRule:NgwafWorkspaceRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleActionArgs', 'NgwafWorkspaceRuleActionArgsDict']]]]] = None,
            conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleConditionArgs', 'NgwafWorkspaceRuleConditionArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            group_conditions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleGroupConditionArgs', 'NgwafWorkspaceRuleGroupConditionArgsDict']]]]] = None,
            group_operator: Optional[pulumi.Input[_builtins.str]] = None,
            rate_limit: Optional[pulumi.Input[Union['NgwafWorkspaceRuleRateLimitArgs', 'NgwafWorkspaceRuleRateLimitArgsDict']]] = None,
            request_logging: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafWorkspaceRule':
        """
        Get an existing NgwafWorkspaceRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleActionArgs', 'NgwafWorkspaceRuleActionArgsDict']]]] actions: List of actions to perform when the rule matches.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleConditionArgs', 'NgwafWorkspaceRuleConditionArgsDict']]]] conditions: Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        :param pulumi.Input[_builtins.str] description: The description of the rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether the rule is currently enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['NgwafWorkspaceRuleGroupConditionArgs', 'NgwafWorkspaceRuleGroupConditionArgsDict']]]] group_conditions: List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        :param pulumi.Input[_builtins.str] group_operator: Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        :param pulumi.Input[Union['NgwafWorkspaceRuleRateLimitArgs', 'NgwafWorkspaceRuleRateLimitArgsDict']] rate_limit: Block specifically for rate*limit rules.
        :param pulumi.Input[_builtins.str] request_logging: Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        :param pulumi.Input[_builtins.str] type: The type of the rule. Accepted values are `request`, `signal`, `rate_limit`, and `templated_signal`.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafWorkspaceRuleState.__new__(_NgwafWorkspaceRuleState)

        __props__.__dict__["actions"] = actions
        __props__.__dict__["conditions"] = conditions
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["group_conditions"] = group_conditions
        __props__.__dict__["group_operator"] = group_operator
        __props__.__dict__["rate_limit"] = rate_limit
        __props__.__dict__["request_logging"] = request_logging
        __props__.__dict__["type"] = type
        __props__.__dict__["workspace_id"] = workspace_id
        return NgwafWorkspaceRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def actions(self) -> pulumi.Output[Sequence['outputs.NgwafWorkspaceRuleAction']]:
        """
        List of actions to perform when the rule matches.
        """
        return pulumi.get(self, "actions")

    @_builtins.property
    @pulumi.getter
    def conditions(self) -> pulumi.Output[Optional[Sequence['outputs.NgwafWorkspaceRuleCondition']]]:
        """
        Flat list of individual conditions. Each must include `field`, `operator`, and `value`.
        """
        return pulumi.get(self, "conditions")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the rule is currently enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="groupConditions")
    def group_conditions(self) -> pulumi.Output[Optional[Sequence['outputs.NgwafWorkspaceRuleGroupCondition']]]:
        """
        List of grouped conditions with nested logic. Each group must define a `group_operator` and at least one condition.
        """
        return pulumi.get(self, "group_conditions")

    @_builtins.property
    @pulumi.getter(name="groupOperator")
    def group_operator(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Logical operator to apply to group conditions. Accepted values are `any` and `all`.
        """
        return pulumi.get(self, "group_operator")

    @_builtins.property
    @pulumi.getter(name="rateLimit")
    def rate_limit(self) -> pulumi.Output[Optional['outputs.NgwafWorkspaceRuleRateLimit']]:
        """
        Block specifically for rate*limit rules.
        """
        return pulumi.get(self, "rate_limit")

    @_builtins.property
    @pulumi.getter(name="requestLogging")
    def request_logging(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Logging behavior for matching requests. Accepted values are `sampled` and `none`.
        """
        return pulumi.get(self, "request_logging")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the rule. Accepted values are `request`, `signal`, `rate_limit`, and `templated_signal`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

