# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NgwafWorkspaceSignalArgs', 'NgwafWorkspaceSignal']

@pulumi.input_type
class NgwafWorkspaceSignalArgs:
    def __init__(__self__, *,
                 workspace_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NgwafWorkspaceSignal resource.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        :param pulumi.Input[_builtins.str] description: The description of the signal.
        :param pulumi.Input[_builtins.str] name: The name of the signal. Special characters and periods are not accepted.
        """
        pulumi.set(__self__, "workspace_id", workspace_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the signal.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the signal. Special characters and periods are not accepted.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NgwafWorkspaceSignalState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafWorkspaceSignal resources.
        :param pulumi.Input[_builtins.str] description: The description of the signal.
        :param pulumi.Input[_builtins.str] name: The name of the signal. Special characters and periods are not accepted.
        :param pulumi.Input[_builtins.str] reference_id: The generated reference ID of the signal.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if reference_id is not None:
            pulumi.set(__self__, "reference_id", reference_id)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the signal.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the signal. Special characters and periods are not accepted.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generated reference ID of the signal.
        """
        return pulumi.get(self, "reference_id")

    @reference_id.setter
    def reference_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "reference_id", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("fastly:index/ngwafWorkspaceSignal:NgwafWorkspaceSignal")
class NgwafWorkspaceSignal(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Fastly Next-Gen WAF Workspace Signal, scoped to a specific NGWAF workspace.\\
        These signals define conditions and actions that trigger WAF enforcement at the workspace level.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.NgwafWorkspace("example",
            name="example",
            description="Test NGWAF Workspace",
            mode="block",
            ip_anonymization="hashed",
            client_ip_headers=[
                "X-Forwarded-For",
                "X-Real-IP",
            ],
            default_blocking_response_code=429,
            attack_signal_thresholds={})
        example_ngwaf_workspace_signal = fastly.NgwafWorkspaceSignal("example",
            workspace_id=example.id,
            description="example",
            name="Test Name")
        ```

        ## Import

        Fastly Next-Gen WAF workspace signals can be imported using the format `<workspaceID>/<signalID>`, e.g.:

        ```sh
        $ pulumi import fastly:index/ngwafWorkspaceSignal:NgwafWorkspaceSignal demo <workspaceID>/<signalID>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the signal.
        :param pulumi.Input[_builtins.str] name: The name of the signal. Special characters and periods are not accepted.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafWorkspaceSignalArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Fastly Next-Gen WAF Workspace Signal, scoped to a specific NGWAF workspace.\\
        These signals define conditions and actions that trigger WAF enforcement at the workspace level.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.NgwafWorkspace("example",
            name="example",
            description="Test NGWAF Workspace",
            mode="block",
            ip_anonymization="hashed",
            client_ip_headers=[
                "X-Forwarded-For",
                "X-Real-IP",
            ],
            default_blocking_response_code=429,
            attack_signal_thresholds={})
        example_ngwaf_workspace_signal = fastly.NgwafWorkspaceSignal("example",
            workspace_id=example.id,
            description="example",
            name="Test Name")
        ```

        ## Import

        Fastly Next-Gen WAF workspace signals can be imported using the format `<workspaceID>/<signalID>`, e.g.:

        ```sh
        $ pulumi import fastly:index/ngwafWorkspaceSignal:NgwafWorkspaceSignal demo <workspaceID>/<signalID>
        ```

        :param str resource_name: The name of the resource.
        :param NgwafWorkspaceSignalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafWorkspaceSignalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafWorkspaceSignalArgs.__new__(NgwafWorkspaceSignalArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'workspace_id'")
            __props__.__dict__["workspace_id"] = workspace_id
            __props__.__dict__["reference_id"] = None
        super(NgwafWorkspaceSignal, __self__).__init__(
            'fastly:index/ngwafWorkspaceSignal:NgwafWorkspaceSignal',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            reference_id: Optional[pulumi.Input[_builtins.str]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafWorkspaceSignal':
        """
        Get an existing NgwafWorkspaceSignal resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the signal.
        :param pulumi.Input[_builtins.str] name: The name of the signal. Special characters and periods are not accepted.
        :param pulumi.Input[_builtins.str] reference_id: The generated reference ID of the signal.
        :param pulumi.Input[_builtins.str] workspace_id: The ID of the workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafWorkspaceSignalState.__new__(_NgwafWorkspaceSignalState)

        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["reference_id"] = reference_id
        __props__.__dict__["workspace_id"] = workspace_id
        return NgwafWorkspaceSignal(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the signal.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the signal. Special characters and periods are not accepted.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="referenceId")
    def reference_id(self) -> pulumi.Output[_builtins.str]:
        """
        The generated reference ID of the signal.
        """
        return pulumi.get(self, "reference_id")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the workspace.
        """
        return pulumi.get(self, "workspace_id")

