"""
Class object for LyricLocation
Documentation: https://github.com/timmo001/aiolyric

Generated by generator/generator.py - 2020-08-31 13:55:49.220121
"""
from typing import List
from .base import LyricBase, LyricBaseClient
from .device import LyricDevice


class Locationrolemapping(LyricBase):
    @property
    def locationID(self):
        return self.attributes.get("locationID", None)

    @property
    def role(self):
        return self.attributes.get("role", None)

    @property
    def locationName(self):
        return self.attributes.get("locationName", None)

    @property
    def status(self):
        return self.attributes.get("status", None)


class Users(LyricBase):
    @property
    def userID(self):
        return self.attributes.get("userID", None)

    @property
    def username(self):
        return self.attributes.get("username", None)

    @property
    def firstname(self):
        return self.attributes.get("firstname", None)

    @property
    def lastname(self):
        return self.attributes.get("lastname", None)

    @property
    def created(self):
        return self.attributes.get("created", None)

    @property
    def deleted(self):
        return self.attributes.get("deleted", None)

    @property
    def activated(self):
        return self.attributes.get("activated", True)

    @property
    def connectedHomeAccountExists(self):
        return self.attributes.get("connectedHomeAccountExists", True)

    @property
    def locationRoleMapping(self):
        return [
            Locationrolemapping(x)
            for x in self.attributes.get("locationRoleMapping", [])
        ]

    @property
    def isOptOut(self):
        return self.attributes.get("isOptOut", None)

    @property
    def isCurrentUser(self):
        return self.attributes.get("isCurrentUser", True)


class Time(LyricBase):
    @property
    def start(self):
        return self.attributes.get("start", None)

    @property
    def end(self):
        return self.attributes.get("end", None)


class Schedules(LyricBase):
    @property
    def time(self):
        return [Time(x) for x in self.attributes.get("time", [])]

    @property
    def days(self):
        return self.attributes.get("days", [])


class ConfigurationFacerecognition(LyricBase):
    @property
    def enabled(self):
        return self.attributes.get("enabled", False)

    @property
    def maxPersons(self):
        return self.attributes.get("maxPersons", None)

    @property
    def maxEtas(self):
        return self.attributes.get("maxEtas", None)

    @property
    def maxEtaPersons(self):
        return self.attributes.get("maxEtaPersons", None)

    @property
    def schedules(self):
        return [Schedules(x) for x in self.attributes.get("schedules", [])]


class Configuration(LyricBase):
    @property
    def faceRecognition(self):
        return ConfigurationFacerecognition(self.attributes.get("faceRecognition", {}))


class LyricLocation(LyricBaseClient):
    @property
    def locationID(self):
        return self.attributes.get("locationID", None)

    @property
    def name(self):
        return self.attributes.get("name", None)

    @property
    def country(self):
        return self.attributes.get("country", None)

    @property
    def zipcode(self):
        return self.attributes.get("zipcode", None)

    @property
    def devices(self) -> List[LyricDevice]:
        devices = []
        for x in self.attributes.get("devices", []):
            x["locationID"] = self.locationID
            devices.append(LyricDevice(self.client, x))
        return devices

    @property
    def devices_dict(self) -> dict:
        devices_dict: dict = {}
        for device in self.devices:
            devices_dict[device.macID] = device
        return devices_dict

    @property
    def users(self):
        return [Users(x) for x in self.attributes.get("users", [])]

    @property
    def timeZone(self):
        return self.attributes.get("timeZone", None)

    @property
    def ianaTimeZone(self):
        return self.attributes.get("ianaTimeZone", None)

    @property
    def daylightSavingTimeEnabled(self):
        return self.attributes.get("daylightSavingTimeEnabled", True)

    @property
    def geoFenceEnabled(self):
        return self.attributes.get("geoFenceEnabled", False)

    @property
    def predictiveAIREnabled(self):
        return self.attributes.get("predictiveAIREnabled", False)

    @property
    def comfortLevel(self):
        return self.attributes.get("comfortLevel", None)

    @property
    def geoFenceNotificationEnabled(self):
        return self.attributes.get("geoFenceNotificationEnabled", False)

    @property
    def geoFenceNotificationTypeId(self):
        return self.attributes.get("geoFenceNotificationTypeId", None)

    @property
    def configuration(self):
        return Configuration(self.attributes.get("configuration", {}))
