# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CertificateAuthenticationProfileArgs', 'CertificateAuthenticationProfile']

@pulumi.input_type
class CertificateAuthenticationProfileArgs:
    def __init__(__self__, *,
                 allowed_as_user_name: Optional[pulumi.Input[builtins.bool]] = None,
                 certificate_attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_identity_store_name: Optional[pulumi.Input[builtins.str]] = None,
                 match_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 username_from: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a CertificateAuthenticationProfile resource.
        :param pulumi.Input[builtins.bool] allowed_as_user_name: Allow as username - Default value: `false`
        :param pulumi.Input[builtins.str] certificate_attribute_name: Attribute name of the Certificate Profile - used only when CERTIFICATE is chosen in `username_from`. - Choices:
               `SUBJECT_COMMON_NAME`, `SUBJECT_ALTERNATIVE_NAME`, `SUBJECT_SERIAL_NUMBER`, `SUBJECT`,
               `SUBJECT_ALTERNATIVE_NAME_OTHER_NAME`, `SUBJECT_ALTERNATIVE_NAME_EMAIL`, `SUBJECT_ALTERNATIVE_NAME_DNS` - Default value:
               `SUBJECT_COMMON_NAME`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] external_identity_store_name: Referred IDStore name for the Certificate Profile or `[not applicable]` in case no identity store is chosen - Default
               value: `[not applicable]`
        :param pulumi.Input[builtins.str] match_mode: Match mode of the Certificate Profile. Allowed values: NEVER, RESOLVE_IDENTITY_AMBIGUITY, BINARY_COMPARISON - Choices:
               `NEVER`, `RESOLVE_IDENTITY_AMBIGUITY`, `BINARY_COMPARISON` - Default value: `NEVER`
        :param pulumi.Input[builtins.str] name: The name of the certificate profile
        :param pulumi.Input[builtins.str] username_from: The attribute in the certificate where the user name should be taken from. Allowed values: `CERTIFICATE` (for a specific
               attribute as defined in certificateAttributeName), `UPN` (for using any Subject or Alternative Name Attributes in the
               Certificate - an option only in AD) - Choices: `CERTIFICATE`, `UPN` - Default value: `CERTIFICATE`
        """
        if allowed_as_user_name is not None:
            pulumi.set(__self__, "allowed_as_user_name", allowed_as_user_name)
        if certificate_attribute_name is not None:
            pulumi.set(__self__, "certificate_attribute_name", certificate_attribute_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_identity_store_name is not None:
            pulumi.set(__self__, "external_identity_store_name", external_identity_store_name)
        if match_mode is not None:
            pulumi.set(__self__, "match_mode", match_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if username_from is not None:
            pulumi.set(__self__, "username_from", username_from)

    @property
    @pulumi.getter(name="allowedAsUserName")
    def allowed_as_user_name(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow as username - Default value: `false`
        """
        return pulumi.get(self, "allowed_as_user_name")

    @allowed_as_user_name.setter
    def allowed_as_user_name(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allowed_as_user_name", value)

    @property
    @pulumi.getter(name="certificateAttributeName")
    def certificate_attribute_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Attribute name of the Certificate Profile - used only when CERTIFICATE is chosen in `username_from`. - Choices:
        `SUBJECT_COMMON_NAME`, `SUBJECT_ALTERNATIVE_NAME`, `SUBJECT_SERIAL_NUMBER`, `SUBJECT`,
        `SUBJECT_ALTERNATIVE_NAME_OTHER_NAME`, `SUBJECT_ALTERNATIVE_NAME_EMAIL`, `SUBJECT_ALTERNATIVE_NAME_DNS` - Default value:
        `SUBJECT_COMMON_NAME`
        """
        return pulumi.get(self, "certificate_attribute_name")

    @certificate_attribute_name.setter
    def certificate_attribute_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_attribute_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalIdentityStoreName")
    def external_identity_store_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Referred IDStore name for the Certificate Profile or `[not applicable]` in case no identity store is chosen - Default
        value: `[not applicable]`
        """
        return pulumi.get(self, "external_identity_store_name")

    @external_identity_store_name.setter
    def external_identity_store_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_identity_store_name", value)

    @property
    @pulumi.getter(name="matchMode")
    def match_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Match mode of the Certificate Profile. Allowed values: NEVER, RESOLVE_IDENTITY_AMBIGUITY, BINARY_COMPARISON - Choices:
        `NEVER`, `RESOLVE_IDENTITY_AMBIGUITY`, `BINARY_COMPARISON` - Default value: `NEVER`
        """
        return pulumi.get(self, "match_mode")

    @match_mode.setter
    def match_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the certificate profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="usernameFrom")
    def username_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The attribute in the certificate where the user name should be taken from. Allowed values: `CERTIFICATE` (for a specific
        attribute as defined in certificateAttributeName), `UPN` (for using any Subject or Alternative Name Attributes in the
        Certificate - an option only in AD) - Choices: `CERTIFICATE`, `UPN` - Default value: `CERTIFICATE`
        """
        return pulumi.get(self, "username_from")

    @username_from.setter
    def username_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username_from", value)


@pulumi.input_type
class _CertificateAuthenticationProfileState:
    def __init__(__self__, *,
                 allowed_as_user_name: Optional[pulumi.Input[builtins.bool]] = None,
                 certificate_attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_identity_store_name: Optional[pulumi.Input[builtins.str]] = None,
                 match_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 username_from: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CertificateAuthenticationProfile resources.
        :param pulumi.Input[builtins.bool] allowed_as_user_name: Allow as username - Default value: `false`
        :param pulumi.Input[builtins.str] certificate_attribute_name: Attribute name of the Certificate Profile - used only when CERTIFICATE is chosen in `username_from`. - Choices:
               `SUBJECT_COMMON_NAME`, `SUBJECT_ALTERNATIVE_NAME`, `SUBJECT_SERIAL_NUMBER`, `SUBJECT`,
               `SUBJECT_ALTERNATIVE_NAME_OTHER_NAME`, `SUBJECT_ALTERNATIVE_NAME_EMAIL`, `SUBJECT_ALTERNATIVE_NAME_DNS` - Default value:
               `SUBJECT_COMMON_NAME`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] external_identity_store_name: Referred IDStore name for the Certificate Profile or `[not applicable]` in case no identity store is chosen - Default
               value: `[not applicable]`
        :param pulumi.Input[builtins.str] match_mode: Match mode of the Certificate Profile. Allowed values: NEVER, RESOLVE_IDENTITY_AMBIGUITY, BINARY_COMPARISON - Choices:
               `NEVER`, `RESOLVE_IDENTITY_AMBIGUITY`, `BINARY_COMPARISON` - Default value: `NEVER`
        :param pulumi.Input[builtins.str] name: The name of the certificate profile
        :param pulumi.Input[builtins.str] username_from: The attribute in the certificate where the user name should be taken from. Allowed values: `CERTIFICATE` (for a specific
               attribute as defined in certificateAttributeName), `UPN` (for using any Subject or Alternative Name Attributes in the
               Certificate - an option only in AD) - Choices: `CERTIFICATE`, `UPN` - Default value: `CERTIFICATE`
        """
        if allowed_as_user_name is not None:
            pulumi.set(__self__, "allowed_as_user_name", allowed_as_user_name)
        if certificate_attribute_name is not None:
            pulumi.set(__self__, "certificate_attribute_name", certificate_attribute_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if external_identity_store_name is not None:
            pulumi.set(__self__, "external_identity_store_name", external_identity_store_name)
        if match_mode is not None:
            pulumi.set(__self__, "match_mode", match_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if username_from is not None:
            pulumi.set(__self__, "username_from", username_from)

    @property
    @pulumi.getter(name="allowedAsUserName")
    def allowed_as_user_name(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Allow as username - Default value: `false`
        """
        return pulumi.get(self, "allowed_as_user_name")

    @allowed_as_user_name.setter
    def allowed_as_user_name(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "allowed_as_user_name", value)

    @property
    @pulumi.getter(name="certificateAttributeName")
    def certificate_attribute_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Attribute name of the Certificate Profile - used only when CERTIFICATE is chosen in `username_from`. - Choices:
        `SUBJECT_COMMON_NAME`, `SUBJECT_ALTERNATIVE_NAME`, `SUBJECT_SERIAL_NUMBER`, `SUBJECT`,
        `SUBJECT_ALTERNATIVE_NAME_OTHER_NAME`, `SUBJECT_ALTERNATIVE_NAME_EMAIL`, `SUBJECT_ALTERNATIVE_NAME_DNS` - Default value:
        `SUBJECT_COMMON_NAME`
        """
        return pulumi.get(self, "certificate_attribute_name")

    @certificate_attribute_name.setter
    def certificate_attribute_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_attribute_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="externalIdentityStoreName")
    def external_identity_store_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Referred IDStore name for the Certificate Profile or `[not applicable]` in case no identity store is chosen - Default
        value: `[not applicable]`
        """
        return pulumi.get(self, "external_identity_store_name")

    @external_identity_store_name.setter
    def external_identity_store_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_identity_store_name", value)

    @property
    @pulumi.getter(name="matchMode")
    def match_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Match mode of the Certificate Profile. Allowed values: NEVER, RESOLVE_IDENTITY_AMBIGUITY, BINARY_COMPARISON - Choices:
        `NEVER`, `RESOLVE_IDENTITY_AMBIGUITY`, `BINARY_COMPARISON` - Default value: `NEVER`
        """
        return pulumi.get(self, "match_mode")

    @match_mode.setter
    def match_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "match_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the certificate profile
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="usernameFrom")
    def username_from(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The attribute in the certificate where the user name should be taken from. Allowed values: `CERTIFICATE` (for a specific
        attribute as defined in certificateAttributeName), `UPN` (for using any Subject or Alternative Name Attributes in the
        Certificate - an option only in AD) - Choices: `CERTIFICATE`, `UPN` - Default value: `CERTIFICATE`
        """
        return pulumi.get(self, "username_from")

    @username_from.setter
    def username_from(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username_from", value)


class CertificateAuthenticationProfile(pulumi.CustomResource):

    pulumi_type = "ise:identitymanagement/certificateAuthenticationProfile:CertificateAuthenticationProfile"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_as_user_name: Optional[pulumi.Input[builtins.bool]] = None,
                 certificate_attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_identity_store_name: Optional[pulumi.Input[builtins.str]] = None,
                 match_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 username_from: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a Certificate Authentication Profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.identitymanagement.CertificateAuthenticationProfile("example",
            name="CertProf1",
            description="My cert profile",
            allowed_as_user_name=False,
            external_identity_store_name="[not applicable]",
            certificate_attribute_name="SUBJECT_COMMON_NAME",
            match_mode="NEVER",
            username_from="CERTIFICATE")
        ```

        ## Import

        ```sh
        $ pulumi import ise:identitymanagement/certificateAuthenticationProfile:CertificateAuthenticationProfile example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allowed_as_user_name: Allow as username - Default value: `false`
        :param pulumi.Input[builtins.str] certificate_attribute_name: Attribute name of the Certificate Profile - used only when CERTIFICATE is chosen in `username_from`. - Choices:
               `SUBJECT_COMMON_NAME`, `SUBJECT_ALTERNATIVE_NAME`, `SUBJECT_SERIAL_NUMBER`, `SUBJECT`,
               `SUBJECT_ALTERNATIVE_NAME_OTHER_NAME`, `SUBJECT_ALTERNATIVE_NAME_EMAIL`, `SUBJECT_ALTERNATIVE_NAME_DNS` - Default value:
               `SUBJECT_COMMON_NAME`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] external_identity_store_name: Referred IDStore name for the Certificate Profile or `[not applicable]` in case no identity store is chosen - Default
               value: `[not applicable]`
        :param pulumi.Input[builtins.str] match_mode: Match mode of the Certificate Profile. Allowed values: NEVER, RESOLVE_IDENTITY_AMBIGUITY, BINARY_COMPARISON - Choices:
               `NEVER`, `RESOLVE_IDENTITY_AMBIGUITY`, `BINARY_COMPARISON` - Default value: `NEVER`
        :param pulumi.Input[builtins.str] name: The name of the certificate profile
        :param pulumi.Input[builtins.str] username_from: The attribute in the certificate where the user name should be taken from. Allowed values: `CERTIFICATE` (for a specific
               attribute as defined in certificateAttributeName), `UPN` (for using any Subject or Alternative Name Attributes in the
               Certificate - an option only in AD) - Choices: `CERTIFICATE`, `UPN` - Default value: `CERTIFICATE`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[CertificateAuthenticationProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Certificate Authentication Profile.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.identitymanagement.CertificateAuthenticationProfile("example",
            name="CertProf1",
            description="My cert profile",
            allowed_as_user_name=False,
            external_identity_store_name="[not applicable]",
            certificate_attribute_name="SUBJECT_COMMON_NAME",
            match_mode="NEVER",
            username_from="CERTIFICATE")
        ```

        ## Import

        ```sh
        $ pulumi import ise:identitymanagement/certificateAuthenticationProfile:CertificateAuthenticationProfile example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param CertificateAuthenticationProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateAuthenticationProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_as_user_name: Optional[pulumi.Input[builtins.bool]] = None,
                 certificate_attribute_name: Optional[pulumi.Input[builtins.str]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 external_identity_store_name: Optional[pulumi.Input[builtins.str]] = None,
                 match_mode: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 username_from: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateAuthenticationProfileArgs.__new__(CertificateAuthenticationProfileArgs)

            __props__.__dict__["allowed_as_user_name"] = allowed_as_user_name
            __props__.__dict__["certificate_attribute_name"] = certificate_attribute_name
            __props__.__dict__["description"] = description
            __props__.__dict__["external_identity_store_name"] = external_identity_store_name
            __props__.__dict__["match_mode"] = match_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["username_from"] = username_from
        super(CertificateAuthenticationProfile, __self__).__init__(
            'ise:identitymanagement/certificateAuthenticationProfile:CertificateAuthenticationProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_as_user_name: Optional[pulumi.Input[builtins.bool]] = None,
            certificate_attribute_name: Optional[pulumi.Input[builtins.str]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            external_identity_store_name: Optional[pulumi.Input[builtins.str]] = None,
            match_mode: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            username_from: Optional[pulumi.Input[builtins.str]] = None) -> 'CertificateAuthenticationProfile':
        """
        Get an existing CertificateAuthenticationProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.bool] allowed_as_user_name: Allow as username - Default value: `false`
        :param pulumi.Input[builtins.str] certificate_attribute_name: Attribute name of the Certificate Profile - used only when CERTIFICATE is chosen in `username_from`. - Choices:
               `SUBJECT_COMMON_NAME`, `SUBJECT_ALTERNATIVE_NAME`, `SUBJECT_SERIAL_NUMBER`, `SUBJECT`,
               `SUBJECT_ALTERNATIVE_NAME_OTHER_NAME`, `SUBJECT_ALTERNATIVE_NAME_EMAIL`, `SUBJECT_ALTERNATIVE_NAME_DNS` - Default value:
               `SUBJECT_COMMON_NAME`
        :param pulumi.Input[builtins.str] description: Description
        :param pulumi.Input[builtins.str] external_identity_store_name: Referred IDStore name for the Certificate Profile or `[not applicable]` in case no identity store is chosen - Default
               value: `[not applicable]`
        :param pulumi.Input[builtins.str] match_mode: Match mode of the Certificate Profile. Allowed values: NEVER, RESOLVE_IDENTITY_AMBIGUITY, BINARY_COMPARISON - Choices:
               `NEVER`, `RESOLVE_IDENTITY_AMBIGUITY`, `BINARY_COMPARISON` - Default value: `NEVER`
        :param pulumi.Input[builtins.str] name: The name of the certificate profile
        :param pulumi.Input[builtins.str] username_from: The attribute in the certificate where the user name should be taken from. Allowed values: `CERTIFICATE` (for a specific
               attribute as defined in certificateAttributeName), `UPN` (for using any Subject or Alternative Name Attributes in the
               Certificate - an option only in AD) - Choices: `CERTIFICATE`, `UPN` - Default value: `CERTIFICATE`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateAuthenticationProfileState.__new__(_CertificateAuthenticationProfileState)

        __props__.__dict__["allowed_as_user_name"] = allowed_as_user_name
        __props__.__dict__["certificate_attribute_name"] = certificate_attribute_name
        __props__.__dict__["description"] = description
        __props__.__dict__["external_identity_store_name"] = external_identity_store_name
        __props__.__dict__["match_mode"] = match_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["username_from"] = username_from
        return CertificateAuthenticationProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedAsUserName")
    def allowed_as_user_name(self) -> pulumi.Output[builtins.bool]:
        """
        Allow as username - Default value: `false`
        """
        return pulumi.get(self, "allowed_as_user_name")

    @property
    @pulumi.getter(name="certificateAttributeName")
    def certificate_attribute_name(self) -> pulumi.Output[builtins.str]:
        """
        Attribute name of the Certificate Profile - used only when CERTIFICATE is chosen in `username_from`. - Choices:
        `SUBJECT_COMMON_NAME`, `SUBJECT_ALTERNATIVE_NAME`, `SUBJECT_SERIAL_NUMBER`, `SUBJECT`,
        `SUBJECT_ALTERNATIVE_NAME_OTHER_NAME`, `SUBJECT_ALTERNATIVE_NAME_EMAIL`, `SUBJECT_ALTERNATIVE_NAME_DNS` - Default value:
        `SUBJECT_COMMON_NAME`
        """
        return pulumi.get(self, "certificate_attribute_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="externalIdentityStoreName")
    def external_identity_store_name(self) -> pulumi.Output[builtins.str]:
        """
        Referred IDStore name for the Certificate Profile or `[not applicable]` in case no identity store is chosen - Default
        value: `[not applicable]`
        """
        return pulumi.get(self, "external_identity_store_name")

    @property
    @pulumi.getter(name="matchMode")
    def match_mode(self) -> pulumi.Output[builtins.str]:
        """
        Match mode of the Certificate Profile. Allowed values: NEVER, RESOLVE_IDENTITY_AMBIGUITY, BINARY_COMPARISON - Choices:
        `NEVER`, `RESOLVE_IDENTITY_AMBIGUITY`, `BINARY_COMPARISON` - Default value: `NEVER`
        """
        return pulumi.get(self, "match_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the certificate profile
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="usernameFrom")
    def username_from(self) -> pulumi.Output[builtins.str]:
        """
        The attribute in the certificate where the user name should be taken from. Allowed values: `CERTIFICATE` (for a specific
        attribute as defined in certificateAttributeName), `UPN` (for using any Subject or Alternative Name Attributes in the
        Certificate - an option only in AD) - Choices: `CERTIFICATE`, `UPN` - Default value: `CERTIFICATE`
        """
        return pulumi.get(self, "username_from")

