/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.core.load;

import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.load.Dereferencing;
import com.github.fge.jsonschema.core.load.URIManager;
import com.github.fge.jsonschema.core.load.configuration.LoadingConfiguration;
import com.github.fge.jsonschema.core.load.uri.URITranslator;
import com.github.fge.jsonschema.core.messages.JsonSchemaCoreMessageBundle;
import com.github.fge.jsonschema.core.ref.JsonRef;
import com.github.fge.jsonschema.core.report.ProcessingMessage;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import io.ray.shaded.com.fasterxml.jackson.databind.JsonNode;
import io.ray.shaded.com.google.common.cache.CacheBuilder;
import io.ray.shaded.com.google.common.cache.CacheLoader;
import io.ray.shaded.com.google.common.cache.LoadingCache;
import io.ray.shaded.com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SchemaLoader {
    private static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonSchemaCoreMessageBundle.class);
    private final URIManager manager;
    private final URITranslator translator;
    private final LoadingCache<URI, JsonNode> cache;
    private final Dereferencing dereferencing;
    private final Map<URI, JsonNode> preloadedSchemas;

    public SchemaLoader(LoadingConfiguration cfg) {
        this.translator = new URITranslator(cfg.getTranslatorConfiguration());
        this.dereferencing = cfg.getDereferencing();
        this.manager = new URIManager(cfg);
        this.preloadedSchemas = ImmutableMap.copyOf(cfg.getPreloadedSchemas());
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
        if (cfg.getCacheSize() != -1) {
            builder.maximumSize(cfg.getCacheSize());
        }
        this.cache = builder.build(new CacheLoader<URI, JsonNode>(){

            @Override
            @Nonnull
            public JsonNode load(@Nonnull URI key) throws ProcessingException {
                return SchemaLoader.this.manager.getContent(key);
            }
        });
    }

    public SchemaLoader() {
        this(LoadingConfiguration.byDefault());
    }

    public SchemaTree load(JsonNode schema) {
        BUNDLE.checkNotNull(schema, "loadingCfg.nullSchema");
        return this.dereferencing.newTree(schema);
    }

    public SchemaTree get(URI uri) throws ProcessingException {
        JsonRef ref = JsonRef.fromURI(this.translator.translate(uri));
        if (!ref.isAbsolute()) {
            throw new ProcessingException(new ProcessingMessage().setMessage(BUNDLE.getMessage("refProcessing.uriNotAbsolute")).putArgument("uri", ref));
        }
        URI realURI = ref.toURI();
        try {
            JsonNode node = this.preloadedSchemas.get(realURI);
            if (node == null) {
                node = this.cache.get(realURI);
            }
            return this.dereferencing.newTree(ref, node);
        }
        catch (ExecutionException e) {
            throw (ProcessingException)e.getCause();
        }
    }

    public String toString() {
        return this.cache.toString();
    }
}

