# PyFileMaker - Integrating FileMaker and Python 
# (c) 2006-2008 Klokan Petr Pridal, klokan@klokan.cz 
# (c) 2002-2006 Pieter Claerhout, pieter@yellowduck.be
# 
# http://code.google.com/p/pyfilemaker/
# http://www.yellowduck.be/filemaker/

# Import the main modules
from exceptions import StandardError

FMErrorNum = {}
FMErrorNum[-1] = 'Unknown error'
FMErrorNum[0] = 'No error (success)'
FMErrorNum[1] = 'User canceled action'
FMErrorNum[2] = 'Memory error'
FMErrorNum[3] = 'Command is unavailable (for example, wrong operating system, wrong mode, etc.)'
FMErrorNum[4] = 'Command is unknown'
FMErrorNum[5] = 'Command is invalid (for example, a Set Field script step does not have a calculation specified)'
FMErrorNum[6] = 'File is read-only'
FMErrorNum[7] = 'Running out of memory'
FMErrorNum[8] = 'Empty result'
FMErrorNum[9] = 'Insufficient privileges'
FMErrorNum[10] = 'Requested data is missing'
FMErrorNum[11] = 'Name is not valid'
FMErrorNum[12] = 'Name already exists'
FMErrorNum[13] = 'File or object is in use'
FMErrorNum[14] = 'Out of range'
FMErrorNum[15] = "Can't divide by zero"
FMErrorNum[16] = 'Operation failed, request retry (for example, a user query)'
FMErrorNum[17] = 'Attempt to convert foreign character set to UTF-16 failed'
FMErrorNum[18] = 'Client must provide account information to proceed'
FMErrorNum[19] = 'String contains characters other than A-Z, a-z, 0-9 (ASCII)'
FMErrorNum[100] = 'File is missing'
FMErrorNum[101] = 'Record is missing'
FMErrorNum[102] = 'Field is missing'
FMErrorNum[103] = 'Relationship is missing'
FMErrorNum[104] = 'Script is missing'
FMErrorNum[105] = 'Layout is missing'
FMErrorNum[106] = 'Table is missing'
FMErrorNum[107] = 'Index is missing'
FMErrorNum[108] = 'Value list is missing'
FMErrorNum[109] = 'Privilege set is missing'
FMErrorNum[110] = 'Related tables are missing'
FMErrorNum[111] = 'Field repetition is invalid'
FMErrorNum[112] = 'Window is missing'
FMErrorNum[113] = 'Function is missing'
FMErrorNum[114] = 'File reference is missing'
FMErrorNum[130] = 'Files are damaged or missing and must be reinstalled'
FMErrorNum[131] = 'Language pack files are missing (such as template files)'
FMErrorNum[200] = 'Record access is denied'
FMErrorNum[201] = 'Field cannot be modified'
FMErrorNum[202] = 'Field access is denied'
FMErrorNum[203] = 'No records in file to print or password doesn\'t allow print access'
FMErrorNum[204] = 'No access to field(s) in sort order'
FMErrorNum[205] = 'Cannot create new records; import will overwrite existing data'
FMErrorNum[206] = 'Cannot change password or file is not modifiable'
FMErrorNum[207] = 'Cannot access field definitions or file is not modifiable'
FMErrorNum[208] = 'Password does not contain enough characters'
FMErrorNum[209] = 'New password must be different from existing one'
FMErrorNum[210] = 'User account is inactive'
FMErrorNum[211] = 'Password has expired'
FMErrorNum[212] = 'Invalid user account and/or password. Please try again'
FMErrorNum[213] = 'User account and/or password does not exist'
FMErrorNum[214] = 'Too many login attempts'
FMErrorNum[215] = 'Administrator privileges cannot be duplicated'
FMErrorNum[216] = 'Guest account cannot be duplicated'
FMErrorNum[217] = 'User does not have sufficient privileges to modify administrator account'
FMErrorNum[300] = 'The file is locked or in use'
FMErrorNum[301] = 'Record is in use by another user'
FMErrorNum[302] = 'Script definitions are in use by another user'
FMErrorNum[303] = 'Paper size is in use by another user'
FMErrorNum[304] = 'Password definitions are in use by another user'
FMErrorNum[305] = 'Relationship or value list definitions are in use by another user'
FMErrorNum[306] = 'Record modification ID does not match'
FMErrorNum[400] = 'Find criteria is empty'
FMErrorNum[401] = 'No records match the request'
FMErrorNum[402] = 'Selected field is not a match field for a lookup'
FMErrorNum[403] = 'Exceeding maximum record limit for trial version of FileMaker Pro'
FMErrorNum[404] = 'Sort order is invalid'
FMErrorNum[405] = 'Number of records specified exceeds number of records that can be omitted'
FMErrorNum[406] = 'Replace/Reserialize criteria is invalid'
FMErrorNum[407] = 'One or both match fields are missing (invalid relationship)'
FMErrorNum[408] = 'Specified field has inappropriate data type for this operation'
FMErrorNum[409] = 'Import order is invalid'
FMErrorNum[410] = 'Export order is invalid'
FMErrorNum[411] = 'Cannot perform delete because related records cannot be deleted'
FMErrorNum[412] = 'Wrong version of FileMaker Pro used to recover file'
FMErrorNum[413] = 'Specified field has inappropriate field type'
FMErrorNum[414] = 'Layout cannot display the result'
FMErrorNum[500] = 'Date value does not meet validation entry options'
FMErrorNum[501] = 'Time value does not meet validation entry options'
FMErrorNum[502] = 'Number value does not meet validation entry options'
FMErrorNum[503] = 'Value in field is not within the range specified in validation entry options'
FMErrorNum[504] = 'Value in field is not unique as required in validation entry options'
FMErrorNum[505] = 'Value in field is not an existing value in the database as required in validation entry options'
FMErrorNum[506] = 'Value in field is not listed on the value list specified in validation entry option'
FMErrorNum[507] = 'Value in field failed calculation test of validation entry option'
FMErrorNum[508] = 'Invalid value entered in Find mode'
FMErrorNum[509] = 'Field requires a valid value'
FMErrorNum[510] = 'Related value is empty or unavailable'
FMErrorNum[511] = 'Value in field exceeds maximum number of allowed characters'
FMErrorNum[600] = 'Print error has occurred'
FMErrorNum[601] = 'Combined header and footer exceed one page'
FMErrorNum[602] = 'Body doesn\'t fit on a page for current column setup'
FMErrorNum[603] = 'Print connection lost'
FMErrorNum[700] = 'File is of the wrong file type for import'
FMErrorNum[701] = 'Data Access Manager can\'t find database extension file'
FMErrorNum[702] = 'The Data Access Manager was unable to open the session'
FMErrorNum[703] = 'The Data Access Manager was unable to open the session; try later'
FMErrorNum[704] = 'Data Access Manager failed when sending a query'
FMErrorNum[705] = 'Data Access Manager failed when executing a query'
FMErrorNum[706] = 'EPSF file has no preview image'
FMErrorNum[707] = 'Graphic translator cannot be found'
FMErrorNum[708] = 'Can\'t import the file or need color computer to import file'
FMErrorNum[709] = 'QuickTime movie import failed'
FMErrorNum[710] = 'Unable to update QuickTime file reference because the database is read-only'
FMErrorNum[711] = 'Import translator can not be found'
FMErrorNum[712] = 'XTND version is incompatible'
FMErrorNum[713] = 'Couldn\'t initialize the XTND system'
FMErrorNum[714] = 'Password privileges do not allow the operation'
FMErrorNum[715] = 'Specified Excel worksheet or named range is missing'
FMErrorNum[716] = 'A SQL query using DELETE, INSERT, or UPDATE is not allowed for ODBC import'
FMErrorNum[717] = 'There is not enough XML/XSL information to proceed with the import or export'
FMErrorNum[718] = 'Error in parsing XML file (from Xerces)'
FMErrorNum[719] = 'Error in transforming XML using XSL (from Xalan)'
FMErrorNum[720] = 'Error when exporting; intended format does not support repeating fields'
FMErrorNum[721] = 'Unknown error occurred in the parser or the transformer'
FMErrorNum[722] = 'Cannot import data into a file that has no fiel'
FMErrorNum[723] = 'You do not have permission to add records to or modify records in the target table'
FMErrorNum[724] = 'You do not have permission to add records to the target table'
FMErrorNum[725] = 'You do not have permission to modify records in the target table'
FMErrorNum[726] = 'There are more records in the import file than in the target table. Not all records were imported'
FMErrorNum[727] = 'There are more records in the target table than in the import file. Not all records were updated'
FMErrorNum[729] = 'Errors occurred during import. Records could not be imported'
FMErrorNum[730] = 'Unsupported Excel version. (Convert file to Excel 7.0 (Excel 95), Excel 97, 2000, or XP format and try again)'
FMErrorNum[731] = 'The file you are importing from contains no data'
FMErrorNum[732] = 'This file cannot be inserted because it contains other files'
FMErrorNum[733] = 'A table cannot be imported into itself'
FMErrorNum[734] = 'This file type cannot be displayed as a picture'
FMErrorNum[735] = 'This file type cannot be displayed as a picture. It will be inserted and displayed as a file'
FMErrorNum[800] = 'Unable to create file on disk'
FMErrorNum[801] = 'Unable to create temporary file on System disk'
FMErrorNum[802] = 'Unable to open file'
FMErrorNum[803] = 'File is single user or host cannot be found'
FMErrorNum[804] = 'File cannot be opened as read-only in its current state'
FMErrorNum[805] = 'File is damaged; use Recover command'
FMErrorNum[806] = 'File cannot be opened with this version of FileMaker Pro'
FMErrorNum[807] = 'File is not a FileMaker Pro file or is severely damaged'
FMErrorNum[808] = 'Cannot open file because access privileges are damaged'
FMErrorNum[809] = 'Disk/volume is full'
FMErrorNum[810] = 'Disk/volume is locked'
FMErrorNum[811] = 'Temporary file cannot be opened as FileMaker Pro file'
FMErrorNum[812] = 'Cannot open the file because it exceeds host capacity'
FMErrorNum[813] = 'Record Synchronization error on network'
FMErrorNum[814] = 'File(s) cannot be opened because maximum number is open'
FMErrorNum[815] = 'Couldn\'t open lookup file'
FMErrorNum[816] = 'Unable to convert file'
FMErrorNum[817] = 'Unable to open file because it does not belong to this solution'
FMErrorNum[818] = 'FileMaker Pro cannot network for some reason'
FMErrorNum[819] = 'Cannot save a local copy of a remote file'
FMErrorNum[820] = 'File is in the process of being closed'
FMErrorNum[821] = 'Host forced a disconnect'
FMErrorNum[822] = 'FMI files not found; reinstall missing files'
FMErrorNum[823] = 'Cannot set file to single-user, guests are connected'
FMErrorNum[824] = 'File is damaged or not a FileMaker file'
FMErrorNum[900] = 'General spelling engine error'
FMErrorNum[901] = 'Main spelling dictionary not installed'
FMErrorNum[902] = 'Could not launch the Help system'
FMErrorNum[903] = 'Command cannot be used in a shared file'
FMErrorNum[904] = 'Command can only be used in a file hosted under FileMaker Server'
FMErrorNum[905] = 'No active field selected--command can only be used if there is an active field'
FMErrorNum[950] = 'Adding repeating related fields is not supported'
FMErrorNum[951] = 'An unexpected error occurred'
FMErrorNum[952] = 'Mail format not found (Web Companion)'
FMErrorNum[953] = 'Mail value missing (Web Companion)'
FMErrorNum[954] = 'Unsupported XML grammar'
FMErrorNum[955] = 'No database name'
FMErrorNum[956] = 'Maximum number of database sessions exceeded'
FMErrorNum[957] = 'Conflicting commands'
FMErrorNum[958] = 'Parameter missing in query'
FMErrorNum[971] = 'The user name is invalid'
FMErrorNum[972] = 'The password is invalid'
FMErrorNum[973] = 'The database is invalid'
FMErrorNum[974] = 'Permission Denied'
FMErrorNum[975] = 'The field has restricted access'
FMErrorNum[976] = 'Security is disabled'
FMErrorNum[977] = 'Invalid client IP address'
FMErrorNum[978] = 'The number of allowed guests has been exceeded (for the 10 guest limit over a 12 hour period)'


class FMError( StandardError ):
	"""Exception related to operation with FM."""

class FMFieldError( StandardError ):
	"""Exception for missing field inside of FM (e.g. FMError 102)."""


def FMErrorByNum( num ):
	"""This function raises an error based on the specified error code."""

	if not num in FMErrorNum.keys():
		raise FMError, FMErrorNum[-1]
	elif num == 102:
		raise FMFieldError, FMErrorNum[num]
	else:
		raise FMError, FMErrorNum[num]
