# MIT License
# Copyright (c) 2020-2024 Pau Freixes

from ._address import MemcachedHostAddress, MemcachedUnixSocketPath
from .base import Client, ClusterEvents, ClusterManagment, Item
from .client import create_client
from .client_errors import (
    ClusterNoAvailableNodes,
    CommandError,
    NotFoundCommandError,
    NotStoredStorageCommandError,
    StorageCommandError,
)
from .connection_pool import ConnectionPoolMetrics
from .default_values import (
    DEFAULT_AUTOBATCHING_ENABLED,
    DEFAULT_AUTOBATCHING_MAX_KEYS,
    DEFAULT_CONNECTION_TIMEOUT,
    DEFAULT_MAX_CONNECTIONS,
    DEFAULT_PURGE_UNHEALTHY_NODES,
    DEFAULT_PURGE_UNUSED_CONNECTIONS_AFTER,
    DEFAULT_SSL,
    DEFAULT_SSL_VERIFY,
    DEFAULT_TIMEOUT,
)

__all__ = (
    "Client",
    "ClusterEvents",
    "ClusterManagment",
    "ClusterNoAvailableNodes",
    "ConnectionPoolMetrics",
    "create_client",
    "DEFAULT_AUTOBATCHING_ENABLED",
    "DEFAULT_AUTOBATCHING_MAX_KEYS",
    "DEFAULT_TIMEOUT",
    "DEFAULT_CONNECTION_TIMEOUT",
    "DEFAULT_MAX_CONNECTIONS",
    "DEFAULT_PURGE_UNUSED_CONNECTIONS_AFTER",
    "DEFAULT_PURGE_UNHEALTHY_NODES",
    "DEFAULT_SSL",
    "DEFAULT_SSL_VERIFY",
    "Item",
    "MemcachedHostAddress",
    "MemcachedUnixSocketPath",
    "CommandError",
    "NotFoundCommandError",
    "NotStoredStorageCommandError",
    "StorageCommandError",
)
