/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.roi.encoder;

import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.roi.encoder.ROI;
import jj2000.j2k.roi.encoder.ROIMaskGenerator;
import jj2000.j2k.roi.encoder.SubbandRectROIMask;
import jj2000.j2k.wavelet.Subband;

public class RectROIMaskGenerator
extends ROIMaskGenerator {
    private int[] ulxs;
    private int[] ulys;
    private int[] lrxs;
    private int[] lrys;
    private int[] nrROIs;
    private SubbandRectROIMask[] sMasks;

    public RectROIMaskGenerator(ROI[] ROIs, int nrc) {
        super(ROIs, nrc);
        int nr = ROIs.length;
        this.nrROIs = new int[nrc];
        this.sMasks = new SubbandRectROIMask[nrc];
        for (int r = nr - 1; r >= 0; --r) {
            int n = ROIs[r].comp;
            this.nrROIs[n] = this.nrROIs[n] + 1;
        }
    }

    @Override
    public boolean getROIMask(DataBlkInt db, Subband sb, int magbits, int c) {
        int x = db.ulx;
        int y = db.uly;
        int w = db.w;
        int h2 = db.h;
        int[] mask = db.getDataInt();
        int ulx = 0;
        int uly = 0;
        int lrx = 0;
        int lry = 0;
        if (!this.tileMaskMade[c]) {
            this.makeMask(sb, magbits, c);
            this.tileMaskMade[c] = true;
        }
        if (!this.roiInTile) {
            return false;
        }
        SubbandRectROIMask srm = (SubbandRectROIMask)this.sMasks[c].getSubbandRectROIMask(x, y);
        int[] culxs = srm.ulxs;
        int[] culys = srm.ulys;
        int[] clrxs = srm.lrxs;
        int[] clrys = srm.lrys;
        int maxROI = culxs.length - 1;
        x -= srm.ulx;
        y -= srm.uly;
        for (int r = maxROI; r >= 0; --r) {
            int maxk;
            ulx = culxs[r] - x;
            if (ulx < 0) {
                ulx = 0;
            } else if (ulx >= w) {
                ulx = w;
            }
            uly = culys[r] - y;
            if (uly < 0) {
                uly = 0;
            } else if (uly >= h2) {
                uly = h2;
            }
            lrx = clrxs[r] - x;
            if (lrx < 0) {
                lrx = -1;
            } else if (lrx >= w) {
                lrx = w - 1;
            }
            lry = clrys[r] - y;
            if (lry < 0) {
                lry = -1;
            } else if (lry >= h2) {
                lry = h2 - 1;
            }
            int i = w * lry + lrx;
            int maxj = lrx - ulx;
            int wrap = w - maxj - 1;
            for (int k = maxk = lry - uly; k >= 0; --k) {
                int j = maxj;
                while (j >= 0) {
                    mask[i] = magbits;
                    --j;
                    --i;
                }
                i -= wrap;
            }
        }
        return true;
    }

    public String toString() {
        return "Fast rectangular ROI mask generator";
    }

    @Override
    public void makeMask(Subband sb, int magbits, int n) {
        int nr = this.nrROIs[n];
        int tileulx = sb.ulcx;
        int tileuly = sb.ulcy;
        int tilew = sb.w;
        int tileh = sb.h;
        ROI[] ROIs = this.rois;
        this.ulxs = new int[nr];
        this.ulys = new int[nr];
        this.lrxs = new int[nr];
        this.lrys = new int[nr];
        nr = 0;
        for (int r = ROIs.length - 1; r >= 0; --r) {
            if (ROIs[r].comp != n) continue;
            int ulx = ROIs[r].ulx;
            int uly = ROIs[r].uly;
            int lrx = ROIs[r].w + ulx - 1;
            int lry = ROIs[r].h + uly - 1;
            if (ulx > tileulx + tilew - 1 || uly > tileuly + tileh - 1 || lrx < tileulx || lry < tileuly) continue;
            lrx -= tileulx;
            lry -= tileuly;
            ulx = (ulx -= tileulx) < 0 ? 0 : ulx;
            uly = uly < 0 ? 0 : (uly -= tileuly);
            lrx = lrx > tilew - 1 ? tilew - 1 : lrx;
            lry = lry > tileh - 1 ? tileh - 1 : lry;
            this.ulxs[nr] = ulx;
            this.ulys[nr] = uly;
            this.lrxs[nr] = lrx;
            this.lrys[nr] = lry;
            ++nr;
        }
        this.roiInTile = nr != 0;
        this.sMasks[n] = new SubbandRectROIMask(sb, this.ulxs, this.ulys, this.lrxs, this.lrys, nr);
    }
}

