/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import loci.common.IniList;
import loci.common.IniTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(IniParser.class);
    private String commentDelimiter = "#";
    private boolean slashContinues = true;

    public void setCommentDelimiter(String delimiter) {
        this.commentDelimiter = delimiter;
    }

    public void setBackslashContinuesLine(boolean slashContinues) {
        this.slashContinues = slashContinues;
    }

    public IniList parseINI(String path) throws IOException {
        return this.parseINI(IniParser.openTextResource(path));
    }

    public IniList parseINI(String path, Class<?> c) throws IOException {
        return this.parseINI(IniParser.openTextResource(path, c));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IniList parseINI(File file2) throws IOException {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(file2);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            IniList iniList = this.parseINI(br);
            return iniList;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
    }

    public IniList parseINI(BufferedReader in) throws IOException {
        int num;
        IniList list = new IniList();
        IniTable attrs = null;
        String chapter = null;
        int no = 1;
        StringBuffer sb = new StringBuffer();
        while ((num = this.readLine(in, sb)) != 0) {
            int equals;
            String line = sb.toString();
            LOGGER.debug("Line {}: {}", (Object)no, (Object)line);
            if (line.equals("")) {
                no += num;
                continue;
            }
            if (this.isHeader(line, '{')) {
                chapter = this.parseHeader(line, '{', '}');
                continue;
            }
            if (this.isHeader(line, '[')) {
                attrs = new IniTable();
                list.add(attrs);
                String header = this.parseHeader(line, '[', ']');
                if (chapter != null) {
                    header = chapter + ": " + header;
                }
                attrs.put("header", header);
                no += num;
                continue;
            }
            if (attrs == null) {
                attrs = new IniTable();
                attrs.put("header", "DEFAULT_HEADER");
                list.add(attrs);
            }
            if ((equals = line.indexOf(61)) < 0) {
                LOGGER.debug("Ignoring line {}", (Object)no);
                continue;
            }
            String key = line.substring(0, equals).trim();
            String value = line.substring(equals + 1).trim();
            attrs.put(key, value);
            no += num;
        }
        return list;
    }

    public static BufferedReader openTextResource(String path) {
        return IniParser.openTextResource(path, IniParser.class);
    }

    public static BufferedReader openTextResource(String path, Class<?> c) {
        try {
            return new BufferedReader(new InputStreamReader(c.getResourceAsStream(path), "UTF-8"));
        }
        catch (IOException e) {
            LOGGER.error("Could not open BufferedReader", e);
            return null;
        }
    }

    private boolean isHeader(String line, char start) {
        return line != null && line.length() > 1 && line.charAt(0) == start;
    }

    private String parseHeader(String line, char start, char end) {
        if (line == null || line.length() <= 1) {
            return null;
        }
        if (line.charAt(0) != start) {
            return null;
        }
        if (line.charAt(line.length() - 1) == end) {
            return line.substring(1, line.length() - 1);
        }
        return line.substring(1);
    }

    private int readLine(BufferedReader in, StringBuffer sb) throws IOException {
        String line;
        int no = 0;
        sb.setLength(0);
        boolean blockText = false;
        while ((line = in.readLine()) != null) {
            int comment;
            ++no;
            if (this.commentDelimiter != null && (comment = line.indexOf(this.commentDelimiter)) >= 0) {
                line = line.substring(0, comment);
            }
            if (!blockText) {
                line = line.trim();
            }
            boolean slash = this.slashContinues && line.trim().endsWith("\\");
            boolean bl = blockText = this.slashContinues && line.trim().endsWith("\\n");
            if (blockText) {
                line = line.substring(0, line.length() - 2) + "\n";
            } else if (slash) {
                line = line.substring(0, line.length() - 1).trim() + " ";
            }
            sb.append(line);
            if (slash || blockText) continue;
            break;
        }
        return no;
    }
}

