/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.SVSCoreMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffIFDEntry;
import loci.formats.tiff.TiffParser;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVSReader
extends BaseTiffReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(SVSReader.class);
    private static final String APERIO_IMAGE_DESCRIPTION_PREFIX = "Aperio Image";
    private static final String DATE_FORMAT = "MM/dd/yy HH:mm:ss";
    private Double[] zPosition;
    private String[] comments;
    private Double emissionWavelength;
    private Double excitationWavelength;
    private Double exposureTime;
    private Double exposureScale;
    private Double magnification;
    private String date;
    private String time;
    private ArrayList<String> dyeNames = new ArrayList();
    private transient Color displayColor = null;
    private int labelIndex = -1;
    private int macroIndex = -1;
    private int extraImages = 0;

    public SVSReader() {
        super("Aperio SVS", new String[]{"svs"});
        this.domains = new String[]{"Histology"};
        this.suffixNecessary = true;
        this.noSubresolutions = true;
        this.canSeparateSeries = false;
    }

    public SVSReader(String name, String[] suffixes) {
        super(name, suffixes);
    }

    @Override
    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isThisType(String name, boolean open) {
        boolean isThisType = super.isThisType(name, open);
        if (isThisType) return isThisType;
        if (!open) return isThisType;
        try (RandomAccessInputStream stream = new RandomAccessInputStream(name);){
            TiffParser tiffParser = new TiffParser(stream);
            tiffParser.setDoCaching(false);
            if (!tiffParser.isValidHeader()) {
                boolean bl = false;
                return bl;
            }
            IFD ifd = tiffParser.getFirstIFD();
            if (ifd == null) {
                boolean bl = false;
                return bl;
            }
            Object description = ifd.get(270);
            if (description != null) {
                String imageDescription = null;
                if (description instanceof TiffIFDEntry) {
                    Object value = tiffParser.getIFDValue((TiffIFDEntry)description);
                    if (value != null) {
                        imageDescription = value.toString();
                    }
                } else if (description instanceof String) {
                    imageDescription = (String)description;
                }
                if (imageDescription != null && imageDescription.startsWith(APERIO_IMAGE_DESCRIPTION_PREFIX)) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.debug("I/O exception during isThisType() evaluation.", e);
            return false;
        }
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        if (this.core.size() == 1) {
            return super.openBytes(no, buf, x, y, w, h2);
        }
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        if (this.tiffParser == null) {
            this.initTiffParser();
        }
        int ifd = ((SVSCoreMetadata)this.getCurrentCore()).ifdIndex[no];
        this.tiffParser.getSamples((IFD)this.ifds.get(ifd), buf, x, y, w, h2);
        return buf;
    }

    @Override
    public byte[] openThumbBytes(int no) throws FormatException, IOException {
        if (this.core.size() == 1 || this.getSeries() >= this.getSeriesCount() - this.extraImages) {
            return FormatTools.openThumbBytes(this, no);
        }
        int smallestSeries = this.getSeriesCount() - this.extraImages - 1;
        if (smallestSeries >= 0) {
            int thisSeries = this.getSeries();
            int resolution = this.getResolution();
            this.setSeries(smallestSeries);
            if (!this.hasFlattenedResolutions()) {
                this.setResolution(1);
            }
            byte[] thumb = FormatTools.openThumbBytes(this, no);
            this.setSeries(thisSeries);
            this.setResolution(resolution);
            return thumb;
        }
        return super.openThumbBytes(no);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.zPosition = null;
            this.comments = null;
            this.emissionWavelength = null;
            this.excitationWavelength = null;
            this.exposureTime = null;
            this.exposureScale = null;
            this.magnification = null;
            this.date = null;
            this.time = null;
            this.dyeNames.clear();
            this.displayColor = null;
            this.extraImages = 0;
            this.labelIndex = -1;
            this.macroIndex = -1;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int ifd = ((SVSCoreMetadata)this.getCurrentCore()).ifdIndex[0];
            return (int)((IFD)this.ifds.get(ifd)).getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileWidth();
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            int ifd = ((SVSCoreMetadata)this.getCurrentCore()).ifdIndex[0];
            return (int)((IFD)this.ifds.get(ifd)).getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("", e);
            return super.getOptimalTileHeight();
        }
    }

    @Override
    protected void initStandardMetadata() throws FormatException, IOException {
        int s2;
        super.initStandardMetadata();
        this.ifds = this.tiffParser.getMainIFDs();
        int seriesCount = this.ifds.size();
        this.core.clear();
        for (int i = 0; i < seriesCount; ++i) {
            this.core.add(new SVSCoreMetadata());
        }
        this.zPosition = new Double[seriesCount];
        this.comments = new String[seriesCount];
        HashSet<Double> uniqueZ = new HashSet<Double>();
        for (int i = 0; i < seriesCount; ++i) {
            String[] lines;
            this.setSeries(i);
            int index = this.getIFDIndex(i, 0);
            this.tiffParser.fillInIFD((IFD)this.ifds.get(index));
            String comment = ((IFD)this.ifds.get(index)).getComment();
            if (comment == null) {
                if (this.labelIndex == -1) {
                    this.labelIndex = i;
                    continue;
                }
                if (this.macroIndex != -1) continue;
                this.macroIndex = i;
                continue;
            }
            this.comments[i] = comment;
            for (String line : lines = comment.split("\n")) {
                String[] tokens;
                for (String t : tokens = line.split("[|]")) {
                    if (t.indexOf(61) >= 0) {
                        String key = t.substring(0, t.indexOf(61)).trim();
                        String value = t.substring(t.indexOf(61) + 1).trim();
                        if (key.equals("TotalDepth")) {
                            this.zPosition[index] = new Double(0.0);
                            continue;
                        }
                        if (!key.equals("OffsetZ")) continue;
                        this.zPosition[index] = DataTools.parseDouble(value);
                        continue;
                    }
                    if (t.toLowerCase().indexOf("label") >= 0) {
                        this.labelIndex = i;
                        continue;
                    }
                    if (t.toLowerCase().indexOf("macro") < 0) continue;
                    this.macroIndex = i;
                }
            }
            if (this.zPosition[index] == null) continue;
            uniqueZ.add(this.zPosition[index]);
        }
        this.setSeries(0);
        int resolutions = this.getSeriesCount();
        if (this.labelIndex >= 0) {
            --resolutions;
        }
        if (this.macroIndex >= 0) {
            --resolutions;
        }
        this.extraImages = this.getSeriesCount() - resolutions;
        IFD firstIFD = (IFD)this.ifds.get(this.getIFDIndex(0, 0));
        for (s2 = 1; s2 < resolutions; ++s2) {
            int index = this.getIFDIndex(s2, 0);
            IFD ifd = (IFD)this.ifds.get(index);
            this.tiffParser.fillInIFD(ifd);
            if (ifd.getPixelType() == firstIFD.getPixelType()) continue;
            this.ifds.set(index, null);
        }
        s2 = 0;
        while (s2 < this.ifds.size()) {
            if (this.ifds.get(s2) != null) {
                ++s2;
                continue;
            }
            this.ifds.remove(s2);
        }
        if (uniqueZ.size() == 0) {
            uniqueZ.add(0.0);
        }
        this.zPosition = uniqueZ.toArray(new Double[uniqueZ.size()]);
        Arrays.sort((Object[])this.zPosition);
        seriesCount = (this.ifds.size() - this.extraImages) / uniqueZ.size() + this.extraImages;
        this.core.clear();
        if (seriesCount > this.extraImages) {
            this.core.add();
            for (int r = 0; r < seriesCount - this.extraImages; ++r) {
                this.core.add(0, new SVSCoreMetadata());
            }
            for (int extra = 0; extra < this.extraImages; ++extra) {
                this.core.add(new SVSCoreMetadata());
            }
        } else {
            for (s2 = 0; s2 < seriesCount; ++s2) {
                this.core.add(new SVSCoreMetadata());
            }
        }
        for (s2 = 0; s2 < seriesCount; ++s2) {
            String[] lines;
            String comment;
            int[] pos = this.core.flattenedIndexes(s2);
            this.setCoreIndex(s2);
            SVSCoreMetadata ms = (SVSCoreMetadata)this.core.get(pos[0], pos[1]);
            if (s2 == 0 && seriesCount > this.extraImages) {
                ms.resolutionCount = seriesCount - this.extraImages;
            }
            IFD ifd = (IFD)this.ifds.get(this.getIFDIndex(s2, 0));
            this.tiffParser.fillInIFD(ifd);
            PhotoInterp p = ifd.getPhotometricInterpretation();
            int samples = ifd.getSamplesPerPixel();
            ms.rgb = samples > 1 || p == PhotoInterp.RGB;
            ms.sizeX = (int)ifd.getImageWidth();
            ms.sizeY = (int)ifd.getImageLength();
            ms.sizeZ = s2 < seriesCount - this.extraImages ? uniqueZ.size() : 1;
            ms.ifdIndex = new int[ms.sizeZ];
            for (int z = 0; z < ms.sizeZ; ++z) {
                ms.ifdIndex[z] = this.getIFDIndex(s2, z);
            }
            ms.sizeT = 1;
            ms.sizeC = ms.rgb ? samples : 1;
            ms.littleEndian = ifd.isLittleEndian();
            ms.indexed = p == PhotoInterp.RGB_PALETTE && (this.get8BitLookupTable() != null || this.get16BitLookupTable() != null);
            ms.imageCount = ms.sizeZ * ms.sizeT;
            ms.pixelType = ifd.getPixelType();
            ms.metadataComplete = true;
            ms.interleaved = false;
            ms.falseColor = false;
            ms.dimensionOrder = "XYCZT";
            boolean bl = ms.thumbnail = s2 != 0;
            if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM || (comment = ((IFD)this.ifds.get(ms.ifdIndex[0])).getComment()) == null) continue;
            for (String line : lines = comment.split("\n")) {
                String[] tokens;
                block36: for (String t : tokens = line.split("[|]")) {
                    if (t.indexOf(61) == -1) {
                        this.addGlobalMeta("Comment", t);
                        ((SVSCoreMetadata)this.getCurrentCore()).comment = t;
                        continue;
                    }
                    String key = t.substring(0, t.indexOf(61)).trim();
                    String value = t.substring(t.indexOf(61) + 1).trim();
                    this.addSeriesMeta(key, value);
                    switch (key) {
                        case "MPP": {
                            ((SVSCoreMetadata)this.getCurrentCore()).pixelSize = FormatTools.getPhysicalSizeX(DataTools.parseDouble(value));
                            continue block36;
                        }
                        case "Date": {
                            this.date = value;
                            continue block36;
                        }
                        case "Time": {
                            this.time = value;
                            continue block36;
                        }
                        case "Emission Wavelength": {
                            this.emissionWavelength = DataTools.parseDouble(value);
                            continue block36;
                        }
                        case "Excitation Wavelength": {
                            this.excitationWavelength = DataTools.parseDouble(value);
                            continue block36;
                        }
                        case "Exposure Time": {
                            this.exposureTime = DataTools.parseDouble(value);
                            continue block36;
                        }
                        case "Exposure Scale": {
                            this.exposureScale = DataTools.parseDouble(value);
                            continue block36;
                        }
                        case "AppMag": {
                            this.magnification = DataTools.parseDouble(value);
                            continue block36;
                        }
                        case "Dye": {
                            this.dyeNames.add(value);
                            continue block36;
                        }
                        case "DisplayColor": {
                            int color = Integer.parseInt(value);
                            this.displayColor = new Color(color << 8 | 0xFF);
                        }
                    }
                }
            }
        }
        this.setSeries(0);
        this.core.reorder();
    }

    @Override
    protected void initMetadataStore() throws FormatException {
        super.initMetadataStore();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, this.getImageCount() > 1);
        String instrument = MetadataTools.createLSID("Instrument", 0);
        String objective = MetadataTools.createLSID("Objective", 0, 0);
        store.setInstrumentID(instrument, 0);
        store.setObjectiveID(objective, 0, 0);
        store.setObjectiveNominalMagnification(this.magnification, 0, 0);
        int lastImage = this.core.size() - 1;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            Length pixelSize;
            this.setSeries(i);
            store.setImageInstrumentRef(instrument, i);
            store.setObjectiveSettingsID(objective, i);
            if (this.hasFlattenedResolutions() || i > this.extraImages) {
                store.setImageName("Series " + (i + 1), i);
            } else if (i == 0) {
                store.setImageName("", i);
            } else if (i == this.labelIndex) {
                store.setImageName("label image", i);
            } else if (i == this.macroIndex) {
                store.setImageName("macro image", i);
            }
            String comment = ((SVSCoreMetadata)this.getCurrentCore()).comment;
            store.setImageDescription(comment, i);
            if (this.getDatestamp() != null) {
                store.setImageAcquisitionDate(this.getDatestamp(), i);
            }
            for (int c = 0; c < this.getEffectiveSizeC(); ++c) {
                if (this.getEmission() != null) {
                    store.setChannelEmissionWavelength(this.getEmission(), i, c);
                }
                if (this.getExcitation() != null) {
                    store.setChannelExcitationWavelength(this.getExcitation(), i, c);
                }
                if (c >= this.dyeNames.size()) continue;
                store.setChannelName(this.dyeNames.get(c), i, c);
            }
            if (this.getImageCount() > 1) {
                for (int p = 0; p < this.getImageCount(); ++p) {
                    if (p >= this.zPosition.length || this.zPosition[p] == null) continue;
                    store.setPlanePositionZ(FormatTools.createLength(this.zPosition[p], UNITS.REFERENCEFRAME), i, p);
                }
            }
            if ((pixelSize = ((SVSCoreMetadata)this.getCurrentCore()).pixelSize) == null || !(pixelSize.value(UNITS.MICROMETER).doubleValue() - 1.0E-6 > 0.0)) continue;
            store.setPixelsPhysicalSizeX(pixelSize, i);
            store.setPixelsPhysicalSizeY(pixelSize, i);
        }
        this.setSeries(0);
    }

    private int getIFDIndex(int coreIndex, int no) {
        int index = coreIndex;
        int coreCount = this.core.flattenedSize() - this.extraImages;
        if (coreIndex > 0 && coreIndex < coreCount) {
            index = ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount > 1 ? ++index : coreCount - coreIndex;
        }
        if (coreIndex > 0 && coreIndex < coreCount || no > 0) {
            for (int i = 0; i < no; ++i) {
                index += coreCount;
            }
            if (coreIndex == 0) {
                ++index;
            }
        } else if (coreIndex >= coreCount && ((CoreMetadata)this.core.get((int)0, (int)0)).imageCount > 1) {
            for (int i = 0; i < coreCount; ++i) {
                index += ((CoreMetadata)this.core.get((int)0, (int)i)).imageCount;
            }
            index -= coreCount - 1;
        }
        return index;
    }

    protected Length getEmission() {
        if (this.emissionWavelength != null && this.emissionWavelength > 0.0) {
            return FormatTools.getEmissionWavelength(this.emissionWavelength);
        }
        return null;
    }

    protected Length getExcitation() {
        if (this.excitationWavelength != null && this.excitationWavelength > 0.0) {
            return FormatTools.getExcitationWavelength(this.excitationWavelength);
        }
        return null;
    }

    protected Double getExposureTime() {
        if (this.exposureTime == null || this.exposureScale == null) {
            LOGGER.debug("Ignoring exposure time = {}, scale = {}", (Object)this.exposureTime, (Object)this.exposureScale);
            return null;
        }
        return this.exposureTime * this.exposureScale * 1000.0;
    }

    protected Timestamp getDatestamp() {
        if (this.date != null && this.time != null) {
            try {
                return new Timestamp(DateTools.formatDate(this.date + " " + this.time, DATE_FORMAT));
            }
            catch (Exception e) {
                LOGGER.debug("Failed to parse '" + this.date + " " + this.time + "'", e);
            }
        }
        return null;
    }

    protected Length[] getPhysicalSizes() {
        Length[] psizes = new Length[this.getSeriesCount()];
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            int[] pos = this.core.flattenedIndexes(i);
            SVSCoreMetadata c = (SVSCoreMetadata)this.core.get(pos[0], pos[1]);
            psizes[i] = c.pixelSize;
        }
        return psizes;
    }

    protected double getMagnification() {
        return this.magnification;
    }

    protected ArrayList<String> getDyeNames() {
        return this.dyeNames;
    }

    protected Color getDisplayColor() {
        return this.displayColor;
    }
}

