/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;
import loci.formats.meta.MetadataRetrieve;
import ome.units.UNITS;
import ome.units.quantity.Time;

public class AVIWriter
extends FormatWriter {
    private static final long SAVE_MOVI = 4092L;
    private static final long SAVE_FILE_SIZE = 4L;
    private static final long SAVE_STRF_SIZE = 168L;
    private static final long SAVE_STRN_POS = 1236L;
    private static final long SAVE_JUNK_SIG = 1260L;
    private static final long SAVE_LIST1_SIZE = 16L;
    private static final long SAVE_LIST1_SUBSIZE = 92L;
    private static final long FRAME_OFFSET = 48L;
    private static final long FRAME_OFFSET_2 = 140L;
    private static final long PADDING_BYTES = 2816L;
    private static final long SAVE_LIST2_SIZE = 4088L;
    private static final String DATA_SIGNATURE = "00db";
    private int planesWritten = 0;
    private int bytesPerPixel;
    private int xDim;
    private int yDim;
    private int zDim;
    private int tDim;
    private int xPad;
    private int microSecPerFrame;
    private List<Long> savedbLength;
    private long idx1Pos;
    private long endPos;
    private long saveidx1Length;

    public AVIWriter() {
        super("Audio Video Interleave", "avi");
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        this.checkParams(no, buf, x, y, w, h2);
        if (!this.isFullPlane(x, y, w, h2)) {
            throw new FormatException("AVIWriter does not yet support saving image tiles.");
        }
        int nChannels = this.getSamplesPerPixel();
        if (!this.initialized[this.series][no]) {
            this.initialized[this.series][no] = true;
        }
        int width = this.xDim - this.xPad;
        int height = buf.length / (width * this.bytesPerPixel);
        this.out.seek(this.idx1Pos);
        this.out.writeBytes(DATA_SIGNATURE);
        this.savedbLength.add(new Long(this.out.getFilePointer()));
        this.out.writeInt(this.bytesPerPixel * this.xDim * this.yDim);
        int rowPad = this.xPad * this.bytesPerPixel;
        byte[] rowBuffer = new byte[width * this.bytesPerPixel + rowPad];
        for (int row = height - 1; row >= 0; --row) {
            for (int col = 0; col < width; ++col) {
                int offset = row * width + col;
                if (this.interleaved) {
                    offset *= nChannels;
                }
                byte r = buf[offset];
                if (nChannels > 1) {
                    byte g2 = buf[offset + (this.interleaved ? 1 : width * height)];
                    byte b = 0;
                    if (nChannels > 2) {
                        b = buf[offset + (this.interleaved ? 2 : 2 * width * height)];
                    }
                    rowBuffer[col * this.bytesPerPixel] = b;
                    rowBuffer[col * this.bytesPerPixel + 1] = g2;
                }
                rowBuffer[col * this.bytesPerPixel + this.bytesPerPixel - 1] = r;
            }
            this.out.write(rowBuffer);
        }
        ++this.planesWritten;
        this.idx1Pos = this.out.getFilePointer();
        this.out.seek(4088L);
        this.out.writeInt((int)(this.idx1Pos - 4092L));
        this.out.seek(this.idx1Pos);
        this.out.writeBytes("idx1");
        this.saveidx1Length = this.out.getFilePointer();
        this.out.writeInt(4 + this.planesWritten * 16);
        for (int z = 0; z < this.planesWritten; ++z) {
            this.out.writeBytes(DATA_SIGNATURE);
            if (z == 0) {
                this.out.writeInt(16);
            } else {
                this.out.writeInt(0);
            }
            this.out.writeInt((int)(this.savedbLength.get(z) - 4L - 4092L));
            this.out.writeInt(this.bytesPerPixel * this.xDim * this.yDim);
        }
        this.endPos = this.out.getFilePointer();
        this.out.seek(4L);
        this.out.writeInt((int)(this.endPos - 8L));
        this.out.seek(this.saveidx1Length);
        this.out.writeInt((int)(this.endPos - (this.saveidx1Length + 4L)));
        this.out.seek(48L);
        this.out.writeInt(this.planesWritten);
        this.out.seek(140L);
        this.out.writeInt(this.planesWritten);
    }

    @Override
    public boolean canDoStacks() {
        return true;
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return new int[]{1};
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.planesWritten = 0;
        this.bytesPerPixel = 0;
        this.xPad = 0;
        this.tDim = 0;
        this.zDim = 0;
        this.yDim = 0;
        this.xDim = 0;
        this.microSecPerFrame = 0;
        this.savedbLength = null;
        this.idx1Pos = 0L;
        this.endPos = 0L;
        this.saveidx1Length = 0L;
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        double timeIncValue;
        super.setId(id);
        this.savedbLength = new ArrayList<Long>();
        if (this.out.length() > 0L) {
            try (RandomAccessInputStream in = new RandomAccessInputStream(this.currentId);){
                in.order(true);
                in.seek(48L);
                this.planesWritten = in.readInt();
                in.seek(4L);
                this.endPos = (long)in.readInt() + 4L + 4L;
                in.seek(4088L);
                this.idx1Pos = (long)in.readInt() + 4088L + 4L;
                this.saveidx1Length = this.idx1Pos + 4L;
                if (this.planesWritten > 0) {
                    in.seek(this.saveidx1Length + 4L);
                }
                for (int z = 0; z < this.planesWritten; ++z) {
                    in.skipBytes(8);
                    this.savedbLength.add((long)(in.readInt() + 4) + 4092L);
                    in.skipBytes(4);
                }
            }
            this.out.seek(this.idx1Pos);
        } else {
            this.planesWritten = 0;
        }
        this.out.order(true);
        MetadataRetrieve meta = this.getMetadataRetrieve();
        this.tDim = (Integer)meta.getPixelsSizeZ(this.series).getValue();
        this.zDim = (Integer)meta.getPixelsSizeT(this.series).getValue();
        this.yDim = (Integer)meta.getPixelsSizeY(this.series).getValue();
        this.xDim = (Integer)meta.getPixelsSizeX(this.series).getValue();
        String type = meta.getPixelsType(this.series).toString();
        int pixelType = FormatTools.pixelTypeFromString(type);
        this.bytesPerPixel = FormatTools.getBytesPerPixel(pixelType);
        this.bytesPerPixel *= this.getSamplesPerPixel();
        Time timeIncrement = meta.getPixelsTimeIncrement(this.series);
        if (timeIncrement != null && (timeIncValue = timeIncrement.value(UNITS.SECOND).doubleValue()) != 0.0) {
            this.fps = new Double(1.0 / timeIncValue).intValue();
        }
        this.xPad = 0;
        int xMod = this.xDim % 4;
        if (xMod != 0) {
            this.xPad = 4 - xMod;
            this.xDim += this.xPad;
        }
        byte[][] lut = null;
        if (this.getColorModel() instanceof IndexColorModel) {
            lut = new byte[4][256];
            IndexColorModel model = (IndexColorModel)this.getColorModel();
            model.getReds(lut[0]);
            model.getGreens(lut[1]);
            model.getBlues(lut[2]);
            model.getAlphas(lut[3]);
        }
        if (this.out.length() == 0L) {
            int i;
            this.out.writeBytes("RIFF");
            this.out.writeInt(0);
            this.out.writeBytes("AVI ");
            this.out.writeBytes("LIST");
            this.out.writeInt(this.bytesPerPixel == 1 ? 1240 : 216);
            this.out.writeBytes("hdrl");
            this.out.writeBytes("avih");
            this.out.writeInt(56);
            this.microSecPerFrame = (int)(1.0 / (double)this.fps * 1000000.0);
            this.out.writeInt(this.microSecPerFrame);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(16);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(1);
            this.out.writeInt(0);
            this.out.writeInt(this.xDim - this.xPad);
            this.out.writeInt(this.yDim);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeBytes("LIST");
            this.out.writeInt(this.bytesPerPixel == 1 ? 1164 : 140);
            this.out.writeBytes("strl");
            this.out.writeBytes("strh");
            this.out.writeInt(56);
            this.out.writeBytes("vids");
            this.out.writeBytes("DIB ");
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(1);
            this.out.writeInt(this.fps);
            this.out.writeInt(0);
            this.out.writeInt(this.tDim * this.zDim);
            this.out.writeInt(0);
            this.out.writeInt(-1);
            this.out.writeInt(0);
            this.out.writeShort(0);
            this.out.writeShort(0);
            this.out.writeShort(0);
            this.out.writeShort(0);
            this.out.writeBytes("strf");
            this.out.writeInt(this.bytesPerPixel == 1 ? 1068 : 44);
            this.out.writeInt(40);
            this.out.writeInt(this.xDim);
            this.out.writeInt(this.yDim);
            this.out.writeShort(1);
            int bitsPerPixel = this.bytesPerPixel == 3 ? 24 : 8;
            this.out.writeShort((short)bitsPerPixel);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(0);
            this.out.writeInt(0);
            int nColors = 256;
            this.out.writeInt(nColors);
            this.out.writeInt(0);
            if (this.bytesPerPixel == 1) {
                if (lut != null) {
                    for (i = 0; i < 256; ++i) {
                        this.out.write(lut[2][i]);
                        this.out.write(lut[1][i]);
                        this.out.write(lut[0][i]);
                        this.out.write(lut[3][i]);
                    }
                } else {
                    byte[] lutWrite = new byte[1024];
                    for (int i2 = 0; i2 < 256; ++i2) {
                        lutWrite[4 * i2] = (byte)i2;
                        lutWrite[4 * i2 + 1] = (byte)i2;
                        lutWrite[4 * i2 + 2] = (byte)i2;
                        lutWrite[4 * i2 + 3] = 0;
                    }
                    this.out.write(lutWrite);
                }
            }
            this.out.seek(168L);
            this.out.writeInt(1064);
            this.out.seek(1236L);
            this.out.writeBytes("strn");
            this.out.writeInt(16);
            this.out.writeBytes("FileAVI write  ");
            this.out.seek(16L);
            this.out.writeInt(1240);
            this.out.seek(92L);
            this.out.writeInt(1164);
            this.out.seek(1260L);
            this.out.writeBytes("JUNK");
            this.out.writeInt(2816);
            i = 0;
            while ((long)i < 1408L) {
                this.out.writeShort(0);
                ++i;
            }
            this.out.writeBytes("LIST");
            this.out.writeInt(4);
            this.out.writeBytes("movi");
            this.idx1Pos = this.out.getFilePointer();
        }
    }
}

