/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.util.EscapeStrings;
import ucar.unidata.util.StringUtil2;

public class DiskCache {
    private static Logger logger;
    private static String root;
    private static boolean standardPolicy;
    private static boolean checkExist;
    public static boolean simulateUnwritableDir;

    public static void setRootDirectory(String cacheDir) {
        if (!cacheDir.endsWith("/")) {
            cacheDir = cacheDir + "/";
        }
        root = StringUtil2.replace(cacheDir, '\\', "/");
        DiskCache.makeRootDirectory();
    }

    public static void makeRootDirectory() {
        File dir = new File(root);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalStateException("DiskCache.setRootDirectory(): could not create root directory <" + root + ">.");
        }
        checkExist = true;
    }

    public static String getRootDirectory() {
        return root;
    }

    public static void setCachePolicy(boolean alwaysInCache) {
        standardPolicy = alwaysInCache;
    }

    public static File getFileStandardPolicy(String fileLocation) {
        return DiskCache.getFile(fileLocation, standardPolicy);
    }

    public static File getFile(String fileLocation, boolean alwaysInCache) {
        if (alwaysInCache) {
            return DiskCache.getCacheFile(fileLocation);
        }
        File f = new File(fileLocation);
        if (f.exists()) {
            return f;
        }
        try {
            if (!simulateUnwritableDir && f.createNewFile()) {
                boolean ret = f.delete();
                assert (ret);
                return f;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return DiskCache.getCacheFile(fileLocation);
    }

    public static File getCacheFile(String fileLocation) {
        File f = new File(DiskCache.makeCachePath(fileLocation));
        if (f.exists() && !f.setLastModified(System.currentTimeMillis())) {
            logger.warn("Failed to setLastModified on " + f.getPath());
        }
        if (!checkExist) {
            File dir = f.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                logger.warn("Failed to mkdirs on " + dir.getPath());
            }
            checkExist = true;
        }
        return f;
    }

    private static String makeCachePath(String fileLocation) {
        Escaper urlPathEscaper = UrlEscapers.urlPathSegmentEscaper();
        fileLocation = fileLocation.replace('\\', '/');
        String cachePath = urlPathEscaper.escape(fileLocation);
        cachePath = cachePath.replace(":", "%3A");
        return root + cachePath;
    }

    public static void showCache(PrintStream pw) {
        pw.println("Cache files");
        pw.println("Size   LastModified       Filename");
        File dir = new File(root);
        File[] children = dir.listFiles();
        if (children == null) {
            return;
        }
        for (File file2 : children) {
            String org = EscapeStrings.urlDecode(file2.getName());
            pw.println(" " + file2.length() + " " + new Date(file2.lastModified()) + " " + org);
        }
    }

    public static void cleanCache(Date cutoff, StringBuilder sbuff) {
        File dir;
        File[] children;
        if (sbuff != null) {
            sbuff.append("CleanCache files before ").append(cutoff).append("\n");
        }
        if ((children = (dir = new File(root)).listFiles()) == null) {
            return;
        }
        for (File file2 : children) {
            Date lastMod = new Date(file2.lastModified());
            if (!lastMod.before(cutoff)) continue;
            boolean ret = file2.delete();
            if (sbuff == null) continue;
            sbuff.append(" delete ").append(file2).append(" (").append(lastMod).append(")\n");
            if (ret) continue;
            sbuff.append("Error deleting ").append(file2).append("\n");
        }
    }

    public static void cleanCache(long maxBytes, StringBuilder sbuff) {
        DiskCache.cleanCache(maxBytes, new FileAgeComparator(), sbuff);
    }

    public static void cleanCache(long maxBytes, Comparator<File> fileComparator, StringBuilder sbuff) {
        if (sbuff != null) {
            sbuff.append("DiskCache clean maxBytes= ").append(maxBytes).append("on dir ").append(root).append("\n");
        }
        File dir = new File(root);
        long total = 0L;
        long total_delete = 0L;
        File[] files = dir.listFiles();
        if (files != null) {
            List<File> fileList = Arrays.asList(files);
            fileList.sort(fileComparator);
            for (File file2 : fileList) {
                if (file2.length() + total > maxBytes) {
                    total_delete += file2.length();
                    if (sbuff != null) {
                        sbuff.append(" delete ").append(file2).append(" (").append(file2.length()).append(")\n");
                    }
                    if (file2.delete() || sbuff == null) continue;
                    sbuff.append("Error deleting ").append(file2).append("\n");
                    continue;
                }
                total += file2.length();
            }
        }
        if (sbuff != null) {
            sbuff.append("Total bytes deleted= ").append(total_delete).append("\n");
            sbuff.append("Total bytes left in cache= ").append(total).append("\n");
        }
    }

    static {
        String policy;
        logger = LoggerFactory.getLogger("cacheLogger");
        root = System.getProperty("nj22.cache");
        if (root == null) {
            String home = System.getProperty("user.home");
            if (home == null) {
                home = System.getProperty("user.dir");
            }
            if (home == null) {
                home = ".";
            }
            root = home + "/.unidata/cache/";
        }
        if ((policy = System.getProperty("nj22.cachePolicy")) != null) {
            standardPolicy = policy.equalsIgnoreCase("true");
        }
    }

    private static class FileAgeComparator
    implements Comparator<File> {
        private FileAgeComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            long f1Age = f1.lastModified();
            long f2Age = f2.lastModified();
            return Long.compare(f2Age, f1Age);
        }
    }
}

