/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.io.Serializable;
import java.util.Formatter;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.LatLonPoint;

public class LatLonPointImpl
implements LatLonPoint,
Serializable {
    protected double lat;
    protected double lon;

    public static boolean betweenLon(double lon, double lonBeg, double lonEnd) {
        lonBeg = LatLonPointImpl.lonNormal(lonBeg, lon);
        lonEnd = LatLonPointImpl.lonNormal(lonEnd, lon);
        return lon >= lonBeg && lon <= lonEnd;
    }

    public static double getClockwiseDistanceTo(double from, double to) {
        double distance;
        for (distance = to - from; distance < 0.0; distance += 360.0) {
        }
        return distance;
    }

    public static double range180(double lon) {
        return LatLonPointImpl.lonNormal(lon);
    }

    public static double lonNormal360(double lon) {
        return LatLonPointImpl.lonNormal(lon, 180.0);
    }

    public static double lonNormal(double lon, double center) {
        return center + Math.IEEEremainder(lon - center, 360.0);
    }

    public static double lonNormalFrom(double lon, double start) {
        while (lon < start) {
            lon += 360.0;
        }
        while (lon > start + 360.0) {
            lon -= 360.0;
        }
        return lon;
    }

    public static double lonNormal(double lon) {
        if (lon < -180.0 || lon > 180.0) {
            return Math.IEEEremainder(lon, 360.0);
        }
        return lon;
    }

    public static double lonDiff(double lon1, double lon2) {
        return Math.IEEEremainder(lon1 - lon2, 360.0);
    }

    public static double latNormal(double lat) {
        if (lat < -90.0) {
            return -90.0;
        }
        if (lat > 90.0) {
            return 90.0;
        }
        return lat;
    }

    public static String latToString(double lat, int ndec) {
        boolean is_north;
        boolean bl = is_north = lat >= 0.0;
        if (!is_north) {
            lat = -lat;
        }
        String f = "%." + ndec + "f";
        Formatter latBuff = new Formatter();
        latBuff.format(f, lat);
        latBuff.format("%s", is_north ? "N" : "S");
        return latBuff.toString();
    }

    public static String lonToString(double lon, int ndec) {
        boolean is_east;
        double wlon = LatLonPointImpl.lonNormal(lon);
        boolean bl = is_east = wlon >= 0.0;
        if (!is_east) {
            wlon = -wlon;
        }
        String f = "%." + ndec + "f";
        Formatter latBuff = new Formatter();
        latBuff.format(f, wlon);
        latBuff.format("%s", is_east ? "E" : "W");
        return latBuff.toString();
    }

    public LatLonPointImpl() {
        this.lat = 0.0;
        this.lon = 0.0;
    }

    public LatLonPointImpl(LatLonPoint pt) {
        this(pt.getLatitude(), pt.getLongitude());
    }

    public LatLonPointImpl(double lat, double lon) {
        this.setLatitude(lat);
        this.setLongitude(lon);
    }

    @Override
    public double getLongitude() {
        return this.lon;
    }

    @Override
    public double getLatitude() {
        return this.lat;
    }

    public void set(LatLonPoint pt) {
        this.setLongitude(pt.getLongitude());
        this.setLatitude(pt.getLatitude());
    }

    public void set(double lat, double lon) {
        this.setLongitude(lon);
        this.setLatitude(lat);
    }

    public void set(float lat, float lon) {
        this.setLongitude(lon);
        this.setLatitude(lat);
    }

    public void setLongitude(double lon) {
        this.lon = LatLonPointImpl.lonNormal(lon);
    }

    public void setLatitude(double lat) {
        this.lat = LatLonPointImpl.latNormal(lat);
    }

    @Override
    public boolean nearlyEquals(LatLonPoint that, double maxRelDiff) {
        boolean lonOk = Misc.nearlyEquals(that.getLongitude(), this.lon, maxRelDiff);
        if (!lonOk) {
            lonOk = Misc.nearlyEquals(LatLonPointImpl.lonNormal360(that.getLongitude()), LatLonPointImpl.lonNormal360(this.lon), maxRelDiff);
        }
        return lonOk && Misc.nearlyEquals(that.getLatitude(), this.lat, maxRelDiff);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LatLonPoint)) {
            return false;
        }
        LatLonPoint that = (LatLonPoint)other;
        if (Double.compare(that.getLatitude(), this.getLatitude()) != 0) {
            return false;
        }
        return Double.compare(that.getLongitude(), this.getLongitude()) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.lat);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return this.toString(4);
    }

    public String toString(int sigDigits) {
        Formatter sbuff = new Formatter();
        sbuff.format("%s %s", LatLonPointImpl.latToString(this.lat, sigDigits), LatLonPointImpl.lonToString(this.lon, sigDigits));
        return sbuff.toString();
    }
}

