/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection.proj4;

import java.util.Formatter;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.proj4.MapMath;
import ucar.unidata.util.Parameter;

public class AlbersEqualAreaEllipse
extends ProjectionImpl {
    private static final double EPS10 = 1.0E-10;
    private static final double TOL7 = 1.0E-7;
    private static final int N_ITER = 15;
    private static final double EPSILON = 1.0E-7;
    private static final double TOL = 1.0E-10;
    private double lat0deg;
    private double lon0deg;
    private double lat0rad;
    private double lon0rad;
    private double par1deg;
    private double par2deg;
    private double phi1;
    private double phi2;
    private double falseEasting;
    private double falseNorthing;
    private Earth earth;
    private double e;
    private double es;
    private double one_es;
    private double totalScale;
    private double ec;
    private double n;
    private double c;
    private double dd;
    private double n2;
    private double rho0;

    @Override
    public ProjectionImpl constructCopy() {
        AlbersEqualAreaEllipse result = new AlbersEqualAreaEllipse(this.getOriginLat(), this.getOriginLon(), this.getParallelOne(), this.getParallelTwo(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarth());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    public AlbersEqualAreaEllipse() {
        this(23.0, -96.0, 29.5, 45.5, 0.0, 0.0, new Earth(6378137.0, 0.0, 298.257222101));
    }

    public AlbersEqualAreaEllipse(double lat0, double lon0, double par1, double par2, double falseEasting, double falseNorthing, Earth earth) {
        super("AlbersEqualAreaEllipse", false);
        this.lat0deg = lat0;
        this.lon0deg = lon0;
        this.lat0rad = Math.toRadians(lat0);
        this.lon0rad = Math.toRadians(lat0);
        this.par1deg = par1;
        this.par2deg = par2;
        this.phi1 = Math.toRadians(par1);
        this.phi2 = Math.toRadians(par2);
        this.falseEasting = falseEasting;
        this.falseNorthing = falseNorthing;
        this.earth = earth;
        this.e = earth.getEccentricity();
        this.es = earth.getEccentricitySquared();
        this.one_es = 1.0 - this.es;
        this.totalScale = earth.getMajor() * 0.001;
        this.precalculate();
        this.addParameter("grid_mapping_name", "albers_conical_equal_area");
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("longitude_of_central_meridian", lon0);
        if (par2 == par1) {
            this.addParameter("standard_parallel", par1);
        } else {
            double[] data = new double[]{par1, par2};
            this.addParameter(new Parameter("standard_parallel", data));
        }
        if (falseEasting != 0.0 || falseNorthing != 0.0) {
            this.addParameter("false_easting", falseEasting);
            this.addParameter("false_northing", falseNorthing);
            this.addParameter("units", "km");
        }
        this.addParameter("semi_major_axis", earth.getMajor());
        this.addParameter("inverse_flattening", 1.0 / earth.getFlattening());
    }

    private void precalculate() {
        boolean secant;
        double sinphi;
        if (Math.abs(this.phi1 + this.phi2) < 1.0E-10) {
            throw new IllegalArgumentException("Math.abs(par1 + par2) < 1.e-10");
        }
        this.n = sinphi = Math.sin(this.phi1);
        double cosphi = Math.cos(this.phi1);
        boolean bl = secant = Math.abs(this.phi1 - this.phi2) >= 1.0E-10;
        if (!this.earth.isSpherical()) {
            if (MapMath.enfn(this.es) == null) {
                throw new IllegalArgumentException("0");
            }
            double m1 = MapMath.msfn(sinphi, cosphi, this.es);
            double ml1 = MapMath.qsfn(sinphi, this.e, this.one_es);
            if (secant) {
                sinphi = Math.sin(this.phi2);
                cosphi = Math.cos(this.phi2);
                double m22 = MapMath.msfn(sinphi, cosphi, this.es);
                double ml2 = MapMath.qsfn(sinphi, this.e, this.one_es);
                this.n = (m1 * m1 - m22 * m22) / (ml2 - ml1);
            }
            this.ec = 1.0 - 0.5 * this.one_es * Math.log((1.0 - this.e) / (1.0 + this.e)) / this.e;
            this.c = m1 * m1 + this.n * ml1;
            this.dd = 1.0 / this.n;
            this.rho0 = this.dd * Math.sqrt(this.c - this.n * MapMath.qsfn(Math.sin(this.lat0rad), this.e, this.one_es));
        } else {
            if (secant) {
                this.n = 0.5 * (this.n + Math.sin(this.phi2));
            }
            this.n2 = this.n + this.n;
            this.c = cosphi * cosphi + this.n2 * sinphi;
            this.dd = 1.0 / this.n;
            this.rho0 = this.dd * Math.sqrt(this.c - this.n2 * Math.sin(this.lat0rad));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlbersEqualAreaEllipse that = (AlbersEqualAreaEllipse)o;
        if (Double.compare(that.falseEasting, this.falseEasting) != 0) {
            return false;
        }
        if (Double.compare(that.falseNorthing, this.falseNorthing) != 0) {
            return false;
        }
        if (Double.compare(that.lat0deg, this.lat0deg) != 0) {
            return false;
        }
        if (Double.compare(that.lon0deg, this.lon0deg) != 0) {
            return false;
        }
        if (Double.compare(that.par1deg, this.par1deg) != 0) {
            return false;
        }
        if (Double.compare(that.par2deg, this.par2deg) != 0) {
            return false;
        }
        return this.earth.equals(that.earth);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.lat0deg);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.lon0deg);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.par1deg);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.par2deg);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.falseEasting);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.falseNorthing);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.earth.hashCode();
        return result;
    }

    public Earth getEarth() {
        return this.earth;
    }

    public double getParallelTwo() {
        return this.par2deg;
    }

    public double getParallelOne() {
        return this.par1deg;
    }

    public double getOriginLon() {
        return this.lon0deg;
    }

    public double getOriginLat() {
        return this.lat0deg;
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Albers Equal Area Ellipsoidal Earth";
    }

    @Override
    public String paramsToString() {
        Formatter f = new Formatter();
        f.format("origin lat,lon=%f,%f parellels=%f,%f earth=%s", this.lat0deg, this.lon0deg, this.par1deg, this.par2deg, this.earth);
        return f.toString();
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2);
    }

    private double computeTheta(double lon) {
        double dlon = LatLonPointImpl.lonNormal(lon - this.lon0deg);
        return this.n * Math.toRadians(dlon);
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = Math.toRadians(latLon.getLatitude());
        double theta = this.computeTheta(latLon.getLongitude());
        double term = this.earth.isSpherical() ? this.n2 * Math.sin(fromLat) : this.n * MapMath.qsfn(Math.sin(fromLat), this.e, this.one_es);
        double rho = this.c - term;
        if (rho < 0.0) {
            throw new RuntimeException("F");
        }
        rho = this.dd * Math.sqrt(rho);
        double toX = rho * Math.sin(theta);
        double toY = this.rho0 - rho * Math.cos(theta);
        result.setLocation(this.totalScale * toX + this.falseEasting, this.totalScale * toY + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double toLat;
        double toLon;
        double fromX = (world.getX() - this.falseEasting) / this.totalScale;
        double fromY = (world.getY() - this.falseNorthing) / this.totalScale;
        double rho = MapMath.distance(fromX, fromY = this.rho0 - fromY);
        if (rho == 0.0) {
            toLon = 0.0;
            toLat = this.n > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        } else {
            if (this.n < 0.0) {
                rho = -rho;
                fromX = -fromX;
                fromY = -fromY;
            }
            double lpphi = rho / this.dd;
            if (!this.earth.isSpherical()) {
                if (Math.abs(this.ec - Math.abs(lpphi = (this.c - lpphi * lpphi) / this.n)) > 1.0E-7) {
                    if (Math.abs(lpphi) > 2.0) {
                        throw new IllegalArgumentException("AlbersEqualAreaEllipse x,y=" + world);
                    }
                    if ((lpphi = AlbersEqualAreaEllipse.phi1_(lpphi, this.e, this.one_es)) == Double.MAX_VALUE) {
                        throw new RuntimeException("I");
                    }
                } else {
                    lpphi = lpphi < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                }
            } else {
                lpphi = Math.abs(lpphi = (this.c - lpphi * lpphi) / this.n2) <= 1.0 ? Math.asin(lpphi) : (lpphi < 0.0 ? -1.5707963267948966 : 1.5707963267948966);
            }
            toLon = Math.atan2(fromX, fromY) / this.n;
            toLat = lpphi;
        }
        result.setLatitude(Math.toDegrees(toLat));
        result.setLongitude(Math.toDegrees(toLon) + this.lon0deg);
        return result;
    }

    private static double phi1_(double qs, double Te, double Tone_es) {
        double dphi;
        double phi = Math.asin(0.5 * qs);
        if (Te < 1.0E-7) {
            return phi;
        }
        int countIter = 15;
        do {
            double sinpi = Math.sin(phi);
            double cospi = Math.cos(phi);
            double con = Te * sinpi;
            double com = 1.0 - con * con;
            dphi = 0.5 * com * com / cospi * (qs / Tone_es - sinpi / com + 0.5 / Te * Math.log((1.0 - con) / (1.0 + con)));
            phi += dphi;
        } while (Math.abs(dphi) > 1.0E-10 && --countIter != 0);
        return countIter != 0 ? phi : Double.MAX_VALUE;
    }
}

