import os
import pandas as pd
from Snoopy.Statistics import DiscreteSD

data_dir = os.path.dirname(os.path.abspath(__file__))
_rec34_rev2_file = os.path.join(data_dir, "rec34_rev2.csv")

_rec34_rev2_df = pd.read_csv(_rec34_rev2_file, index_col = 0)
_rec34_rev2_df.columns.name = "t0m1"
_rec34_rev2_df.name = "Rec. 34 rev 2"
rec34_rev2 =  DiscreteSD( _rec34_rev2_df )


# Rec34 rev2 discretized every 0.5m.
_rec34_rev2_hs05_df = pd.read_csv( os.path.join(data_dir, "rec34_rev2_hs05.csv"), index_col = 0)
_rec34_rev2_hs05_df.columns.name = "t0m1"
_rec34_rev2_hs05_df.name = "Rec. 34 rev 2 - dhs=0.5m"
rec34_rev2_hs05 =  DiscreteSD( _rec34_rev2_hs05_df )





# TODO : Move in data/*.csv

tz_ = [1.5 ,  2.5 ,  3.5 ,  4.5 ,  5.5 ,  6.5 ,  7.5 ,  8.5  , 9.5 ,  10.5 ,  11.5 ,  12.5  , 13.5 ,  14.5 ,  15.5 ,  16.5 ,  17.5 ,  18.5 ]
hs_ = [0.5  ,1.5  ,2.5  ,3.5  ,4.5  ,5.5  ,6.5  ,7.5  ,8.5  ,9.5,  10.5,  11.5,  12.5,  13.5,  14.5,  15.5  ,16.5  ]
rec34_SD = pd.DataFrame(  index = hs_ , columns = tz_ ,dtype = "float" )
rec34_SD.iloc[0,:]  = [ 0.0  ,   0.0  ,   1.3   ,  133.7  ,   865.6 ,   1186.    ,  634.2   ,  186.3  ,    36.9   ,    5.6  ,     0.7  ,   0.1 ,    0.0   ,    0.0   ,    0.0  ,   0.0  ,     0.0  ,   0.0  ]
rec34_SD.iloc[1,:]  = [ 0.0  ,   0.0  ,   0.0   ,   29.3  ,   986.  ,   4976.    , 7738.    , 5569.7  ,  2375.7   ,  703.5  ,   160.7  ,  30.5 ,    5.1   ,    0.8   ,    0.1  ,   0.0  ,     0.0  ,   0.0  ]
rec34_SD.iloc[2,:]  = [ 0.0  ,   0.0  ,   0.0   ,    2.2  ,   197.5 ,   2158.8   , 6230.    , 7449.5  ,  4860.4   , 2066.   ,   644.5  , 160.2 ,   33.7   ,    6.3   ,    1.1  ,   0.2  ,     0.0  ,   0.0  ]
rec34_SD.iloc[3,:]  = [ 0.0  ,   0.0  ,   0.0   ,    0.2  ,    34.9 ,    695.5   , 3226.5   , 5675.   ,  5099.1   , 2838.   ,  1114.1  , 337.7 ,   84.3   ,   18.2   ,    3.5  ,   0.6  ,     0.1  ,   0.0  ]
rec34_SD.iloc[4,:]  = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     6.  ,    196.1   , 1354.3   , 3288.5  ,  3857.5   , 2685.5  ,  1275.2  , 455.1 ,  130.9   ,   31.9   ,    6.9  ,   1.3  ,     0.2  ,   0.0  ]
rec34_SD.iloc[5,:]  = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     1.  ,     51.    ,  498.4   , 1602.9  ,  2372.7   , 2008.3  ,  1126.   , 463.6 ,  150.9   ,   41.    ,    9.7  ,   2.1  ,     0.4  ,   0.1  ]
rec34_SD.iloc[6,:]  = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.2 ,     12.6   ,  167.    ,  690.3  ,  1257.9   , 1268.6  ,   825.9  , 386.8 ,  140.8   ,   42.2   ,   10.9  ,   2.5  ,     0.5  ,   0.1  ]
rec34_SD.iloc[7,:]  = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.0 ,      3.    ,   52.1   ,  270.1  ,   594.4   ,  703.2  ,   524.9  , 276.7 ,  111.7   ,   36.7   ,   10.2  ,   2.5  ,     0.6  ,   0.1  ]
rec34_SD.iloc[8,:]  = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.0 ,      0.7   ,   15.4   ,   97.9  ,   255.9   ,  350.6  ,   296.9  , 174.6 ,   77.6   ,   27.7   ,    8.4  ,   2.2  ,     0.5  ,   0.1  ]
rec34_SD.iloc[9,:]  = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.0 ,      0.2   ,    4.3   ,   33.2  ,   101.9   ,  159.9  ,   152.2  ,  99.2 ,   48.3   ,   18.7   ,    6.1  ,   1.7  ,     0.4  ,   0.1  ]
rec34_SD.iloc[10,:] = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.0 ,      0.0   ,    1.2   ,   10.7  ,    37.9   ,   67.5  ,    71.7  ,  51.5 ,   27.3   ,   11.4   ,    4.   ,   1.2  ,     0.3  ,   0.1  ]
rec34_SD.iloc[11,:] = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.0 ,      0.0   ,    0.3   ,    3.3  ,    13.3   ,   26.6  ,    31.4  ,  24.7 ,   14.2   ,    6.4   ,    2.4  ,   0.7  ,     0.2  ,   0.1  ]
rec34_SD.iloc[12,:] = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.0 ,      0.0   ,    0.1   ,    1.   ,     4.4   ,    9.9  ,    12.8  ,  11.  ,    6.8   ,    3.3   ,    1.3  ,   0.4  ,     0.1  ,   0.0  ]
rec34_SD.iloc[13,:] = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.0 ,      0.0   ,    0.0   ,    0.3  ,     1.4   ,    3.5  ,     5.   ,   4.6 ,    3.1   ,    1.6   ,    0.7  ,   0.2  ,     0.1  ,   0.0  ]
rec34_SD.iloc[14,:] = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.0 ,      0.0   ,    0.0   ,    0.1  ,     0.4   ,    1.2  ,     1.8  ,   1.8 ,    1.3   ,    0.7   ,    0.3  ,   0.1  ,     0.0  ,   0.0  ]
rec34_SD.iloc[15,:] = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.0 ,      0.0   ,    0.0   ,    0.0  ,     0.1   ,    0.4  ,     0.6  ,   0.7 ,    0.5   ,    0.1   ,    0.1  ,   0.1  ,     0.0  ,   0.0  ]
rec34_SD.iloc[16,:] = [ 0.0  ,   0.0  ,   0.0   ,    0.0  ,     0.0 ,      0.0   ,    0.0   ,    0.0  ,     0.0   ,    0.1  ,     0.2  ,   0.2 ,    0.2   ,    0.1   ,    0.1  ,   0.0  ,     0.0  ,   0.0  ]
rec34_SD.name = "Rec. 34"
rec34_SD = rec34_SD.rename_axis( "Hs" ).rename_axis("Tz", axis = 1)
rec34_SD = DiscreteSD(rec34_SD)


tz_ = [3.5  ,   4.5  ,   5.5  ,   6.5  ,   7.5 ,    8.5  ,   9.5 ,    10.5 ,   11.5  ,  12.5 ,   13.5   , 14.5,    15.5  ,  16.5  ,  17.5]
hs_ = [ 1 , 2,  3,  4,  5,  6,  7,  8,  9,  10,  11,  12,  13,  14]
ww_SD = pd.DataFrame(  index = hs_ , columns = tz_  ,dtype = "float" )
ww_SD.iloc[0,:]  = [    311   ,  2734  ,  6402 ,   7132  ,  5071 ,   2711 ,   1202  ,  470  ,   169    , 57   ,   19  ,    6     ,  2   ,    1  ,     0   ]
ww_SD.iloc[1,:]  = [    20    ,  764   ,  4453 ,   8841  ,  9045 ,   6020 ,   3000  ,  1225 ,   435    , 140  ,   42  ,    12    ,  3   ,    1  ,     0   ]
ww_SD.iloc[2,:]  = [    0     ,  57    ,  902  ,   3474  ,  5549 ,   4973 ,   3004  ,  1377 ,   518    , 169  ,   50  ,    14    ,  4   ,    1  ,     0   ]
ww_SD.iloc[3,:]  = [    0     ,  4     ,  150  ,   1007  ,  2401 ,   2881 ,   2156  ,  1154 ,   485    , 171  ,   53  ,    15    ,  4   ,    1  ,     0   ]
ww_SD.iloc[4,:]  = [    0     ,  0     ,  25   ,   258   ,  859  ,   1338 ,   1230  ,  776  ,   372    , 146  ,   49  ,    15    ,  4   ,    1  ,     0   ]
ww_SD.iloc[5,:]  = [    0     ,  0     ,  4    ,   63    ,  277  ,   540  ,   597   ,  440  ,   240    , 105  ,   39  ,    13    ,  4   ,    1  ,     0   ]
ww_SD.iloc[6,:]  = [    0     ,  0     ,  1    ,   15    ,  84   ,   198  ,   258   ,  219  ,   136    , 66   ,   27  ,    10    ,  3   ,    1  ,     0   ]
ww_SD.iloc[7,:]  = [    0     ,  0     ,  0    ,   4     ,  25   ,   69   ,   103   ,  99   ,   69     , 37   ,   17  ,    6     ,  2   ,    1  ,     0   ]
ww_SD.iloc[8,:]  = [    0     ,  0     ,  0    ,   1     ,  7    ,   23   ,   39    ,  42   ,   32     , 19   ,   9   ,    4     ,  1   ,    1  ,     0   ]
ww_SD.iloc[9,:]  = [    0     ,  0     ,  0    ,   0     ,  2    ,   7    ,   14    ,  16   ,   14     , 9    ,   5   ,    2     ,  1   ,    0  ,     0   ]
ww_SD.iloc[10,:] = [    0     ,  0     ,  0    ,   0     ,  1    ,   2    ,   5     ,  6    ,   6      , 4    ,   2   ,    1     ,  1   ,    0  ,     0   ]
ww_SD.iloc[11,:] = [    0     ,  0     ,  0    ,   0     ,  0    ,   1    ,   2     ,  2    ,   2      , 2    ,   1   ,    1     ,  0   ,    0  ,     0   ]
ww_SD.iloc[12,:] = [    0     ,  0     ,  0    ,   0     ,  0    ,   0    ,   1     ,  1    ,   1      , 1    ,   0   ,    0     ,  0   ,    0  ,     0   ]
ww_SD.iloc[13,:] = [    0     ,  0     ,  0    ,   0     ,  0    ,   0    ,   0     ,  0    ,   1      , 0    ,   0   ,    0     ,  0   ,    0  ,     0   ]
ww_SD.name = "World-wide"
ww_SD = ww_SD.rename_axis( "Hs" ).rename_axis("Tz", axis = 1)
ww_SD = DiscreteSD(ww_SD)