#!/usr/bin/env python
#
# Copyright 2007 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
"""ANTLR3 runtime package"""































from __future__ import absolute_import
from __future__ import division
from __future__ import print_function
from google.appengine._internal.antlr3.constants import EOF
from google.appengine._internal.antlr3.exceptions import NoViableAltException, BacktrackingFailed
from six.moves import range


class DFA(object):
  """@brief A DFA implemented as a set of transition tables.

    Any state that has a semantic predicate edge is special; those states
    are generated with if-then-else structures in a specialStateTransition()
    which is generated by cyclicDFA template.

    """

  def __init__(self, recognizer, decisionNumber, eot, eof, min, max, accept,
               special, transition):

    self.recognizer = recognizer

    self.decisionNumber = decisionNumber
    self.eot = eot
    self.eof = eof
    self.min = min
    self.max = max
    self.accept = accept
    self.special = special
    self.transition = transition

  def predict(self, input):
    """
        From the input stream, predict what alternative will succeed
        using this DFA (representing the covering regular approximation
        to the underlying CFL).  Return an alternative number 1..n.  Throw
         an exception upon error.
        """
    mark = input.mark()
    s = 0
    try:
      for _ in range(50000):


        specialState = self.special[s]
        if specialState >= 0:

          s = self.specialStateTransition(specialState, input)
          if s == -1:
            self.noViableAlt(s, input)
            return 0
          input.consume()
          continue

        if self.accept[s] >= 1:

          return self.accept[s]


        c = input.LA(1)




        if c >= self.min[s] and c <= self.max[s]:

          snext = self.transition[s][c - self.min[s]]


          if snext < 0:





            if self.eot[s] >= 0:


              s = self.eot[s]
              input.consume()





              continue


            self.noViableAlt(s, input)
            return 0

          s = snext
          input.consume()
          continue

        if self.eot[s] >= 0:


          s = self.eot[s]
          input.consume()
          continue


        if c == EOF and self.eof[s] >= 0:


          return self.accept[self.eof[s]]


        self.noViableAlt(s, input)
        return 0

      else:
        raise RuntimeError("DFA bang!")

    finally:
      input.rewind(mark)

  def noViableAlt(self, s, input):
    if self.recognizer._state.backtracking > 0:
      raise BacktrackingFailed

    nvae = NoViableAltException(self.getDescription(), self.decisionNumber, s,
                                input)

    self.error(nvae)
    raise nvae

  def error(self, nvae):
    """A hook for debugging interface"""
    pass

  def specialStateTransition(self, s, input):
    return -1

  def getDescription(self):
    return "n/a"






  def unpack(cls, string):
    """@brief Unpack the runlength encoded table data.

        Terence implemented packed table initializers, because Java has a
        size restriction on .class files and the lookup tables can grow
        pretty large. The generated JavaLexer.java of the Java.g example
        would be about 15MB with uncompressed array initializers.

        Python does not have any size restrictions, but the compilation of
        such large source files seems to be pretty memory hungry. The memory
        consumption of the python process grew to >1.5GB when importing a
        15MB lexer, eating all my swap space and I was to impacient to see,
        if it could finish at all. With packed initializers that are unpacked
        at import time of the lexer module, everything works like a charm.

        """

    ret = []
    for i in range(len(string) // 2):
      (n, v) = ord(string[i * 2]), ord(string[i * 2 + 1])


      if v == 0xFFFF:
        v = -1

      ret += [v] * n

    return ret

  unpack = classmethod(unpack)
