"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbToLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
const core_2 = require("@aws-solutions-constructs/core");
class AlbToLambda extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckAlbProps(props);
        // Obtain VPC for construct (existing or created)
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: props.publicApi ? {} : { enableDnsHostnames: true, enableDnsSupport: true }
        });
        this.loadBalancer = defaults.ObtainAlb(this, id, this.vpc, props.publicApi, props.existingLoadBalancerObj, props.loadBalancerProps, props.logAlbAccessLogs, props.albLoggingBucketProps);
        // Obtain Lambda function for construct (existing or created)
        this.lambdaFunction = defaults.buildLambdaFunction(this, {
            existingLambdaObj: props.existingLambdaObj,
            lambdaFunctionProps: props.lambdaFunctionProps,
            vpc: this.vpc,
        });
        let newListener;
        if (this.loadBalancer.listeners.length === 0) {
            newListener = true;
        }
        else {
            newListener = false;
        }
        // If there's no listener, then we add one here
        if (newListener) {
            this.listener = defaults.AddListener(this, id, this.loadBalancer, props.listenerProps);
        }
        else {
            this.listener = core_2.GetActiveListener(this.loadBalancer.listeners);
        }
        const newTargetGroup = defaults.AddLambdaTarget(this, `tg${this.loadBalancer.listeners.length + 1}`, this.listener, this.lambdaFunction, props.ruleProps, props.targetProps);
        // this.listener needs to be set on the construct.
        // could be above: else { defaults.GetActiveListener }
        // do we then move that funcionality back into the construct (not the function). If so do
        // we leave it in AddNewTarget or just do it here and pass the listener?
        if (newListener && this.listener) {
            const levelOneListener = this.listener.node.defaultChild;
            const cfnTargetGroup = newTargetGroup.node.defaultChild;
            levelOneListener.addDependsOn(cfnTargetGroup);
        }
    }
}
exports.AlbToLambda = AlbToLambda;
_a = JSII_RTTI_SYMBOL_1;
AlbToLambda[_a] = { fqn: "@aws-solutions-constructs/aws-alb-lambda.AlbToLambda", version: "1.138.0" };
//# sourceMappingURL=data:application/json;base64,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