/*
cgo stubs for package whatsapp.
File is generated by gopy. Do not edit.
gopy build -output=generated -no-make=true -build-tags="mupdf extlib" .
*/

package main

/*

#cgo CFLAGS: "-I/root/.local/share/uv/python/cpython-3.12.12-linux-x86_64-gnu/include/python3.12" -Wno-error -Wno-implicit-function-declaration -Wno-int-conversion
#cgo LDFLAGS: "-L/root/.local/share/uv/python/cpython-3.12.12-linux-x86_64-gnu/lib" "-lpython3.12" -lpthread -ldl -lutil -lm

// #define Py_LIMITED_API // need full API for PyRun*
#include <Python.h>
typedef uint8_t bool;
// static inline is trick for avoiding need for extra .c file
// the following are used for build value -- switch on reflect.Kind
// or the types equivalent
static inline PyObject* gopy_build_bool(uint8_t val) {
	return Py_BuildValue("b", val);
}
static inline PyObject* gopy_build_int64(int64_t val) {
	return Py_BuildValue("k", val);
}
static inline PyObject* gopy_build_uint64(uint64_t val) {
	return Py_BuildValue("K", val);
}
static inline PyObject* gopy_build_float64(double val) {
	return Py_BuildValue("d", val);
}
static inline PyObject* gopy_build_string(const char* val) {
	return Py_BuildValue("s", val);
}
static inline void gopy_decref(PyObject* obj) { // macro
	Py_XDECREF(obj);
}
static inline void gopy_incref(PyObject* obj) { // macro
	Py_XINCREF(obj);
}
static inline int gopy_method_check(PyObject* obj) { // macro
	return PyMethod_Check(obj);
}
static inline void gopy_err_handle() {
	if(PyErr_Occurred() != NULL) {
		PyErr_Print();
	}
}

*/
import "C"
import (
	"errors"
	"reflect"
	"unsafe"

	"github.com/go-python/gopy/gopyh" // handler

	"context"
	"database/sql/driver"

	whatsapp "codeberg.org/slidge/slidge-whatsapp/slidge_whatsapp"
	"codeberg.org/slidge/slidge-whatsapp/slidge_whatsapp/media"
	"go.mau.fi/libsignal/protocol"
	"go.mau.fi/whatsmeow/types"
)

// main doesn't do anything in lib / pkg mode, but is essential for exe mode
func main() {

}

// initialization functions -- can be called from python after library is loaded
// GoPyInitRunFile runs a separate python file -- call in GoPyInit if it
// steals the main thread e.g., for GUI event loop, as in GoGi startup.

//export GoPyInit
func GoPyInit() {

}

// type for the handle -- int64 for speed (can switch to string)
type GoHandle int64
type CGoHandle C.longlong

// DecRef decrements the reference count for the specified handle
// and deletes it it goes to zero.
//
//export DecRef
func DecRef(handle CGoHandle) {
	gopyh.DecRef(gopyh.CGoHandle(handle))
}

// IncRef increments the reference count for the specified handle.
//
//export IncRef
func IncRef(handle CGoHandle) {
	gopyh.IncRef(gopyh.CGoHandle(handle))
}

// NumHandles returns the number of handles currently in use.
//
//export NumHandles
func NumHandles() int {
	return gopyh.NumHandles()
}

// boolGoToPy converts a Go bool to python-compatible C.char
func boolGoToPy(b bool) C.char {
	if b {
		return 1
	}
	return 0
}

// boolPyToGo converts a python-compatible C.Char to Go bool
func boolPyToGo(b C.char) bool {
	if b != 0 {
		return true
	}
	return false
}

func complex64GoToPy(c complex64) *C.PyObject {
	return C.PyComplex_FromDoubles(C.double(real(c)), C.double(imag(c)))
}

func complex64PyToGo(o *C.PyObject) complex64 {
	v := C.PyComplex_AsCComplex(o)
	return complex(float32(v.real), float32(v.imag))
}

func complex128GoToPy(c complex128) *C.PyObject {
	return C.PyComplex_FromDoubles(C.double(real(c)), C.double(imag(c)))
}

func complex128PyToGo(o *C.PyObject) complex128 {
	v := C.PyComplex_AsCComplex(o)
	return complex(float64(v.real), float64(v.imag))
}

// errorGoToPy converts a Go error to python-compatible C.CString
func errorGoToPy(e error) *C.char {
	if e != nil {
		return C.CString(e.Error())
	}
	return C.CString("")
}

// --- generated code for package: whatsapp below: ---

// ---- External Types Outside of Targeted Packages ---

// Converters for pointer handles for type: *media.Spec
func ptrFromHandle_Ptr_media_Spec(h CGoHandle) *media.Spec {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*media.Spec")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(media.Spec{})).(*media.Spec)
}
func handleFromPtr_Ptr_media_Spec(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*media.Spec", p))
}

// Converters for pointer handles for type: *protocol.SignalAddress
func ptrFromHandle_Ptr_protocol_SignalAddress(h CGoHandle) *protocol.SignalAddress {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*protocol.SignalAddress")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(protocol.SignalAddress{})).(*protocol.SignalAddress)
}
func handleFromPtr_Ptr_protocol_SignalAddress(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*protocol.SignalAddress", p))
}

// Converters for non-pointer handles for type: media.Spec
func ptrFromHandle_media_Spec(h CGoHandle) *media.Spec {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "media.Spec")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(media.Spec{})).(*media.Spec)
}
func handleFromPtr_media_Spec(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("media.Spec", p))
}

// Converters for pointer handles for type: context.Context
func ptrFromHandle_context_Context(h CGoHandle) context.Context {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "context.Context")
	if p == nil {
		return nil
	}
	return p.(context.Context)
}
func handleFromPtr_context_Context(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("context.Context", p))
}

// Converters for pointer handles for type: driver.Value
func ptrFromHandle_driver_Value(h CGoHandle) driver.Value {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "driver.Value")
	if p == nil {
		return nil
	}
	return p.(driver.Value)
}
func handleFromPtr_driver_Value(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("driver.Value", p))
}

// Converters for non-pointer handles for type: protocol.SignalAddress
func ptrFromHandle_protocol_SignalAddress(h CGoHandle) *protocol.SignalAddress {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "protocol.SignalAddress")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(protocol.SignalAddress{})).(*protocol.SignalAddress)
}
func handleFromPtr_protocol_SignalAddress(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("protocol.SignalAddress", p))
}

// Converters for non-pointer handles for type: types.JID
func ptrFromHandle_types_JID(h CGoHandle) *types.JID {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "types.JID")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(types.JID{})).(*types.JID)
}
func handleFromPtr_types_JID(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("types.JID", p))
}

// ---- Package: go ---

// ---- Types ---

// Converters for implicit pointer handles for type: []bool
func ptrFromHandle_Slice_bool(h CGoHandle) *[]bool {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]bool")
	if p == nil {
		return nil
	}
	return p.(*[]bool)
}
func deptrFromHandle_Slice_bool(h CGoHandle) []bool {
	p := ptrFromHandle_Slice_bool(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_bool(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]bool", p))
}

// --- wrapping slice: []bool ---
//
//export Slice_bool_CTor
func Slice_bool_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_bool(&[]bool{}))
}

//export Slice_bool_len
func Slice_bool_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_bool(handle))
}

//export Slice_bool_elem
func Slice_bool_elem(handle CGoHandle, _idx int) C.char {
	s := deptrFromHandle_Slice_bool(handle)
	return boolGoToPy(s[_idx])
}

//export Slice_bool_subslice
func Slice_bool_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_bool(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_bool(&ss))
}

//export Slice_bool_set
func Slice_bool_set(handle CGoHandle, _idx int, _vl C.char) {
	s := deptrFromHandle_Slice_bool(handle)
	s[_idx] = boolPyToGo(_vl)
}

//export Slice_bool_append
func Slice_bool_append(handle CGoHandle, _vl C.char) {
	s := ptrFromHandle_Slice_bool(handle)
	*s = append(*s, boolPyToGo(_vl))
}

// Converters for implicit pointer handles for type: []byte
func ptrFromHandle_Slice_byte(h CGoHandle) *[]byte {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]byte")
	if p == nil {
		return nil
	}
	return p.(*[]byte)
}
func deptrFromHandle_Slice_byte(h CGoHandle) []byte {
	p := ptrFromHandle_Slice_byte(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_byte(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]byte", p))
}

// --- wrapping slice: []byte ---
//
//export Slice_byte_CTor
func Slice_byte_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_byte(&[]byte{}))
}

//export Slice_byte_len
func Slice_byte_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_byte(handle))
}

//export Slice_byte_elem
func Slice_byte_elem(handle CGoHandle, _idx int) C.char {
	s := deptrFromHandle_Slice_byte(handle)
	return C.char(s[_idx])
}

//export Slice_byte_subslice
func Slice_byte_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_byte(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_byte(&ss))
}

//export Slice_byte_set
func Slice_byte_set(handle CGoHandle, _idx int, _vl C.char) {
	s := deptrFromHandle_Slice_byte(handle)
	s[_idx] = byte(_vl)
}

//export Slice_byte_append
func Slice_byte_append(handle CGoHandle, _vl C.char) {
	s := ptrFromHandle_Slice_byte(handle)
	*s = append(*s, byte(_vl))
}

//export Slice_byte_from_bytes
func Slice_byte_from_bytes(o *C.PyObject) CGoHandle {
	size := C.PyBytes_Size(o)
	ptr := unsafe.Pointer(C.PyBytes_AsString(o))
	data := make([]byte, size)
	tmp := unsafe.Slice((*byte)(ptr), size)
	copy(data, tmp)
	return handleFromPtr_Slice_byte(&data)
}

//export Slice_byte_to_bytes
func Slice_byte_to_bytes(handle CGoHandle) *C.PyObject {
	s := deptrFromHandle_Slice_byte(handle)
	ptr := unsafe.Pointer(&s[0])
	size := len(s)
	return C.PyBytes_FromStringAndSize((*C.char)(ptr), C.long(size))
}

// Converters for implicit pointer handles for type: []error
func ptrFromHandle_Slice_error(h CGoHandle) *[]error {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]error")
	if p == nil {
		return nil
	}
	return p.(*[]error)
}
func deptrFromHandle_Slice_error(h CGoHandle) []error {
	p := ptrFromHandle_Slice_error(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_error(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]error", p))
}

// --- wrapping slice: []error ---
//
//export Slice_error_CTor
func Slice_error_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_error(&[]error{}))
}

//export Slice_error_len
func Slice_error_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_error(handle))
}

//export Slice_error_elem
func Slice_error_elem(handle CGoHandle, _idx int) *C.char {
	s := deptrFromHandle_Slice_error(handle)
	return errorGoToPy(s[_idx])
}

//export Slice_error_subslice
func Slice_error_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_error(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_error(&ss))
}

//export Slice_error_set
func Slice_error_set(handle CGoHandle, _idx int, _vl *C.char) {
	s := deptrFromHandle_Slice_error(handle)
	s[_idx] = errors.New(C.GoString(_vl))
}

//export Slice_error_append
func Slice_error_append(handle CGoHandle, _vl *C.char) {
	s := ptrFromHandle_Slice_error(handle)
	*s = append(*s, errors.New(C.GoString(_vl)))
}

// Converters for implicit pointer handles for type: []float32
func ptrFromHandle_Slice_float32(h CGoHandle) *[]float32 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]float32")
	if p == nil {
		return nil
	}
	return p.(*[]float32)
}
func deptrFromHandle_Slice_float32(h CGoHandle) []float32 {
	p := ptrFromHandle_Slice_float32(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_float32(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]float32", p))
}

// --- wrapping slice: []float32 ---
//
//export Slice_float32_CTor
func Slice_float32_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_float32(&[]float32{}))
}

//export Slice_float32_len
func Slice_float32_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_float32(handle))
}

//export Slice_float32_elem
func Slice_float32_elem(handle CGoHandle, _idx int) C.float {
	s := deptrFromHandle_Slice_float32(handle)
	return C.float(s[_idx])
}

//export Slice_float32_subslice
func Slice_float32_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_float32(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_float32(&ss))
}

//export Slice_float32_set
func Slice_float32_set(handle CGoHandle, _idx int, _vl C.float) {
	s := deptrFromHandle_Slice_float32(handle)
	s[_idx] = float32(_vl)
}

//export Slice_float32_append
func Slice_float32_append(handle CGoHandle, _vl C.float) {
	s := ptrFromHandle_Slice_float32(handle)
	*s = append(*s, float32(_vl))
}

// Converters for implicit pointer handles for type: []float64
func ptrFromHandle_Slice_float64(h CGoHandle) *[]float64 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]float64")
	if p == nil {
		return nil
	}
	return p.(*[]float64)
}
func deptrFromHandle_Slice_float64(h CGoHandle) []float64 {
	p := ptrFromHandle_Slice_float64(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_float64(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]float64", p))
}

// --- wrapping slice: []float64 ---
//
//export Slice_float64_CTor
func Slice_float64_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_float64(&[]float64{}))
}

//export Slice_float64_len
func Slice_float64_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_float64(handle))
}

//export Slice_float64_elem
func Slice_float64_elem(handle CGoHandle, _idx int) C.double {
	s := deptrFromHandle_Slice_float64(handle)
	return C.double(s[_idx])
}

//export Slice_float64_subslice
func Slice_float64_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_float64(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_float64(&ss))
}

//export Slice_float64_set
func Slice_float64_set(handle CGoHandle, _idx int, _vl C.double) {
	s := deptrFromHandle_Slice_float64(handle)
	s[_idx] = float64(_vl)
}

//export Slice_float64_append
func Slice_float64_append(handle CGoHandle, _vl C.double) {
	s := ptrFromHandle_Slice_float64(handle)
	*s = append(*s, float64(_vl))
}

// Converters for implicit pointer handles for type: []int
func ptrFromHandle_Slice_int(h CGoHandle) *[]int {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]int")
	if p == nil {
		return nil
	}
	return p.(*[]int)
}
func deptrFromHandle_Slice_int(h CGoHandle) []int {
	p := ptrFromHandle_Slice_int(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_int(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]int", p))
}

// --- wrapping slice: []int ---
//
//export Slice_int_CTor
func Slice_int_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_int(&[]int{}))
}

//export Slice_int_len
func Slice_int_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_int(handle))
}

//export Slice_int_elem
func Slice_int_elem(handle CGoHandle, _idx int) C.longlong {
	s := deptrFromHandle_Slice_int(handle)
	return C.longlong(s[_idx])
}

//export Slice_int_subslice
func Slice_int_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_int(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_int(&ss))
}

//export Slice_int_set
func Slice_int_set(handle CGoHandle, _idx int, _vl C.longlong) {
	s := deptrFromHandle_Slice_int(handle)
	s[_idx] = int(_vl)
}

//export Slice_int_append
func Slice_int_append(handle CGoHandle, _vl C.longlong) {
	s := ptrFromHandle_Slice_int(handle)
	*s = append(*s, int(_vl))
}

// Converters for implicit pointer handles for type: []int16
func ptrFromHandle_Slice_int16(h CGoHandle) *[]int16 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]int16")
	if p == nil {
		return nil
	}
	return p.(*[]int16)
}
func deptrFromHandle_Slice_int16(h CGoHandle) []int16 {
	p := ptrFromHandle_Slice_int16(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_int16(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]int16", p))
}

// --- wrapping slice: []int16 ---
//
//export Slice_int16_CTor
func Slice_int16_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_int16(&[]int16{}))
}

//export Slice_int16_len
func Slice_int16_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_int16(handle))
}

//export Slice_int16_elem
func Slice_int16_elem(handle CGoHandle, _idx int) C.short {
	s := deptrFromHandle_Slice_int16(handle)
	return C.short(s[_idx])
}

//export Slice_int16_subslice
func Slice_int16_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_int16(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_int16(&ss))
}

//export Slice_int16_set
func Slice_int16_set(handle CGoHandle, _idx int, _vl C.short) {
	s := deptrFromHandle_Slice_int16(handle)
	s[_idx] = int16(_vl)
}

//export Slice_int16_append
func Slice_int16_append(handle CGoHandle, _vl C.short) {
	s := ptrFromHandle_Slice_int16(handle)
	*s = append(*s, int16(_vl))
}

// Converters for implicit pointer handles for type: []int32
func ptrFromHandle_Slice_int32(h CGoHandle) *[]int32 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]int32")
	if p == nil {
		return nil
	}
	return p.(*[]int32)
}
func deptrFromHandle_Slice_int32(h CGoHandle) []int32 {
	p := ptrFromHandle_Slice_int32(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_int32(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]int32", p))
}

// --- wrapping slice: []int32 ---
//
//export Slice_int32_CTor
func Slice_int32_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_int32(&[]int32{}))
}

//export Slice_int32_len
func Slice_int32_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_int32(handle))
}

//export Slice_int32_elem
func Slice_int32_elem(handle CGoHandle, _idx int) C.long {
	s := deptrFromHandle_Slice_int32(handle)
	return C.long(s[_idx])
}

//export Slice_int32_subslice
func Slice_int32_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_int32(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_int32(&ss))
}

//export Slice_int32_set
func Slice_int32_set(handle CGoHandle, _idx int, _vl C.long) {
	s := deptrFromHandle_Slice_int32(handle)
	s[_idx] = int32(_vl)
}

//export Slice_int32_append
func Slice_int32_append(handle CGoHandle, _vl C.long) {
	s := ptrFromHandle_Slice_int32(handle)
	*s = append(*s, int32(_vl))
}

// Converters for implicit pointer handles for type: []int64
func ptrFromHandle_Slice_int64(h CGoHandle) *[]int64 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]int64")
	if p == nil {
		return nil
	}
	return p.(*[]int64)
}
func deptrFromHandle_Slice_int64(h CGoHandle) []int64 {
	p := ptrFromHandle_Slice_int64(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_int64(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]int64", p))
}

// --- wrapping slice: []int64 ---
//
//export Slice_int64_CTor
func Slice_int64_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_int64(&[]int64{}))
}

//export Slice_int64_len
func Slice_int64_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_int64(handle))
}

//export Slice_int64_elem
func Slice_int64_elem(handle CGoHandle, _idx int) C.longlong {
	s := deptrFromHandle_Slice_int64(handle)
	return C.longlong(s[_idx])
}

//export Slice_int64_subslice
func Slice_int64_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_int64(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_int64(&ss))
}

//export Slice_int64_set
func Slice_int64_set(handle CGoHandle, _idx int, _vl C.longlong) {
	s := deptrFromHandle_Slice_int64(handle)
	s[_idx] = int64(_vl)
}

//export Slice_int64_append
func Slice_int64_append(handle CGoHandle, _vl C.longlong) {
	s := ptrFromHandle_Slice_int64(handle)
	*s = append(*s, int64(_vl))
}

// Converters for implicit pointer handles for type: []int8
func ptrFromHandle_Slice_int8(h CGoHandle) *[]int8 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]int8")
	if p == nil {
		return nil
	}
	return p.(*[]int8)
}
func deptrFromHandle_Slice_int8(h CGoHandle) []int8 {
	p := ptrFromHandle_Slice_int8(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_int8(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]int8", p))
}

// --- wrapping slice: []int8 ---
//
//export Slice_int8_CTor
func Slice_int8_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_int8(&[]int8{}))
}

//export Slice_int8_len
func Slice_int8_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_int8(handle))
}

//export Slice_int8_elem
func Slice_int8_elem(handle CGoHandle, _idx int) C.char {
	s := deptrFromHandle_Slice_int8(handle)
	return C.char(s[_idx])
}

//export Slice_int8_subslice
func Slice_int8_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_int8(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_int8(&ss))
}

//export Slice_int8_set
func Slice_int8_set(handle CGoHandle, _idx int, _vl C.char) {
	s := deptrFromHandle_Slice_int8(handle)
	s[_idx] = int8(_vl)
}

//export Slice_int8_append
func Slice_int8_append(handle CGoHandle, _vl C.char) {
	s := ptrFromHandle_Slice_int8(handle)
	*s = append(*s, int8(_vl))
}

// Converters for implicit pointer handles for type: []rune
func ptrFromHandle_Slice_rune(h CGoHandle) *[]rune {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]rune")
	if p == nil {
		return nil
	}
	return p.(*[]rune)
}
func deptrFromHandle_Slice_rune(h CGoHandle) []rune {
	p := ptrFromHandle_Slice_rune(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_rune(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]rune", p))
}

// --- wrapping slice: []rune ---
//
//export Slice_rune_CTor
func Slice_rune_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_rune(&[]rune{}))
}

//export Slice_rune_len
func Slice_rune_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_rune(handle))
}

//export Slice_rune_elem
func Slice_rune_elem(handle CGoHandle, _idx int) C.long {
	s := deptrFromHandle_Slice_rune(handle)
	return C.long(s[_idx])
}

//export Slice_rune_subslice
func Slice_rune_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_rune(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_rune(&ss))
}

//export Slice_rune_set
func Slice_rune_set(handle CGoHandle, _idx int, _vl C.long) {
	s := deptrFromHandle_Slice_rune(handle)
	s[_idx] = rune(_vl)
}

//export Slice_rune_append
func Slice_rune_append(handle CGoHandle, _vl C.long) {
	s := ptrFromHandle_Slice_rune(handle)
	*s = append(*s, rune(_vl))
}

// Converters for implicit pointer handles for type: []string
func ptrFromHandle_Slice_string(h CGoHandle) *[]string {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]string")
	if p == nil {
		return nil
	}
	return p.(*[]string)
}
func deptrFromHandle_Slice_string(h CGoHandle) []string {
	p := ptrFromHandle_Slice_string(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_string(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]string", p))
}

// --- wrapping slice: []string ---
//
//export Slice_string_CTor
func Slice_string_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_string(&[]string{}))
}

//export Slice_string_len
func Slice_string_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_string(handle))
}

//export Slice_string_elem
func Slice_string_elem(handle CGoHandle, _idx int) *C.char {
	s := deptrFromHandle_Slice_string(handle)
	return C.CString(s[_idx])
}

//export Slice_string_subslice
func Slice_string_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_string(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_string(&ss))
}

//export Slice_string_set
func Slice_string_set(handle CGoHandle, _idx int, _vl *C.char) {
	s := deptrFromHandle_Slice_string(handle)
	s[_idx] = C.GoString(_vl)
}

//export Slice_string_append
func Slice_string_append(handle CGoHandle, _vl *C.char) {
	s := ptrFromHandle_Slice_string(handle)
	*s = append(*s, C.GoString(_vl))
}

// Converters for implicit pointer handles for type: []uint
func ptrFromHandle_Slice_uint(h CGoHandle) *[]uint {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]uint")
	if p == nil {
		return nil
	}
	return p.(*[]uint)
}
func deptrFromHandle_Slice_uint(h CGoHandle) []uint {
	p := ptrFromHandle_Slice_uint(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_uint(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]uint", p))
}

// --- wrapping slice: []uint ---
//
//export Slice_uint_CTor
func Slice_uint_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_uint(&[]uint{}))
}

//export Slice_uint_len
func Slice_uint_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_uint(handle))
}

//export Slice_uint_elem
func Slice_uint_elem(handle CGoHandle, _idx int) C.ulonglong {
	s := deptrFromHandle_Slice_uint(handle)
	return C.ulonglong(s[_idx])
}

//export Slice_uint_subslice
func Slice_uint_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_uint(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_uint(&ss))
}

//export Slice_uint_set
func Slice_uint_set(handle CGoHandle, _idx int, _vl C.ulonglong) {
	s := deptrFromHandle_Slice_uint(handle)
	s[_idx] = uint(_vl)
}

//export Slice_uint_append
func Slice_uint_append(handle CGoHandle, _vl C.ulonglong) {
	s := ptrFromHandle_Slice_uint(handle)
	*s = append(*s, uint(_vl))
}

// Converters for implicit pointer handles for type: []uint16
func ptrFromHandle_Slice_uint16(h CGoHandle) *[]uint16 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]uint16")
	if p == nil {
		return nil
	}
	return p.(*[]uint16)
}
func deptrFromHandle_Slice_uint16(h CGoHandle) []uint16 {
	p := ptrFromHandle_Slice_uint16(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_uint16(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]uint16", p))
}

// --- wrapping slice: []uint16 ---
//
//export Slice_uint16_CTor
func Slice_uint16_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_uint16(&[]uint16{}))
}

//export Slice_uint16_len
func Slice_uint16_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_uint16(handle))
}

//export Slice_uint16_elem
func Slice_uint16_elem(handle CGoHandle, _idx int) C.ushort {
	s := deptrFromHandle_Slice_uint16(handle)
	return C.ushort(s[_idx])
}

//export Slice_uint16_subslice
func Slice_uint16_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_uint16(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_uint16(&ss))
}

//export Slice_uint16_set
func Slice_uint16_set(handle CGoHandle, _idx int, _vl C.ushort) {
	s := deptrFromHandle_Slice_uint16(handle)
	s[_idx] = uint16(_vl)
}

//export Slice_uint16_append
func Slice_uint16_append(handle CGoHandle, _vl C.ushort) {
	s := ptrFromHandle_Slice_uint16(handle)
	*s = append(*s, uint16(_vl))
}

// Converters for implicit pointer handles for type: []uint32
func ptrFromHandle_Slice_uint32(h CGoHandle) *[]uint32 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]uint32")
	if p == nil {
		return nil
	}
	return p.(*[]uint32)
}
func deptrFromHandle_Slice_uint32(h CGoHandle) []uint32 {
	p := ptrFromHandle_Slice_uint32(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_uint32(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]uint32", p))
}

// --- wrapping slice: []uint32 ---
//
//export Slice_uint32_CTor
func Slice_uint32_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_uint32(&[]uint32{}))
}

//export Slice_uint32_len
func Slice_uint32_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_uint32(handle))
}

//export Slice_uint32_elem
func Slice_uint32_elem(handle CGoHandle, _idx int) C.ulong {
	s := deptrFromHandle_Slice_uint32(handle)
	return C.ulong(s[_idx])
}

//export Slice_uint32_subslice
func Slice_uint32_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_uint32(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_uint32(&ss))
}

//export Slice_uint32_set
func Slice_uint32_set(handle CGoHandle, _idx int, _vl C.ulong) {
	s := deptrFromHandle_Slice_uint32(handle)
	s[_idx] = uint32(_vl)
}

//export Slice_uint32_append
func Slice_uint32_append(handle CGoHandle, _vl C.ulong) {
	s := ptrFromHandle_Slice_uint32(handle)
	*s = append(*s, uint32(_vl))
}

// Converters for implicit pointer handles for type: []uint64
func ptrFromHandle_Slice_uint64(h CGoHandle) *[]uint64 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]uint64")
	if p == nil {
		return nil
	}
	return p.(*[]uint64)
}
func deptrFromHandle_Slice_uint64(h CGoHandle) []uint64 {
	p := ptrFromHandle_Slice_uint64(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_uint64(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]uint64", p))
}

// --- wrapping slice: []uint64 ---
//
//export Slice_uint64_CTor
func Slice_uint64_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_uint64(&[]uint64{}))
}

//export Slice_uint64_len
func Slice_uint64_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_uint64(handle))
}

//export Slice_uint64_elem
func Slice_uint64_elem(handle CGoHandle, _idx int) C.ulonglong {
	s := deptrFromHandle_Slice_uint64(handle)
	return C.ulonglong(s[_idx])
}

//export Slice_uint64_subslice
func Slice_uint64_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_uint64(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_uint64(&ss))
}

//export Slice_uint64_set
func Slice_uint64_set(handle CGoHandle, _idx int, _vl C.ulonglong) {
	s := deptrFromHandle_Slice_uint64(handle)
	s[_idx] = uint64(_vl)
}

//export Slice_uint64_append
func Slice_uint64_append(handle CGoHandle, _vl C.ulonglong) {
	s := ptrFromHandle_Slice_uint64(handle)
	*s = append(*s, uint64(_vl))
}

// Converters for implicit pointer handles for type: []uint8
func ptrFromHandle_Slice_uint8(h CGoHandle) *[]uint8 {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]uint8")
	if p == nil {
		return nil
	}
	return p.(*[]uint8)
}
func deptrFromHandle_Slice_uint8(h CGoHandle) []uint8 {
	p := ptrFromHandle_Slice_uint8(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_uint8(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]uint8", p))
}

// --- wrapping slice: []uint8 ---
//
//export Slice_uint8_CTor
func Slice_uint8_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_uint8(&[]uint8{}))
}

//export Slice_uint8_len
func Slice_uint8_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_uint8(handle))
}

//export Slice_uint8_elem
func Slice_uint8_elem(handle CGoHandle, _idx int) C.uchar {
	s := deptrFromHandle_Slice_uint8(handle)
	return C.uchar(s[_idx])
}

//export Slice_uint8_subslice
func Slice_uint8_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_uint8(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_uint8(&ss))
}

//export Slice_uint8_set
func Slice_uint8_set(handle CGoHandle, _idx int, _vl C.uchar) {
	s := deptrFromHandle_Slice_uint8(handle)
	s[_idx] = uint8(_vl)
}

//export Slice_uint8_append
func Slice_uint8_append(handle CGoHandle, _vl C.uchar) {
	s := ptrFromHandle_Slice_uint8(handle)
	*s = append(*s, uint8(_vl))
}

// ---- Package: whatsapp ---

// ---- Types ---

// Converters for pointer handles for type: *whatsapp.Album
func ptrFromHandle_Ptr_whatsapp_Album(h CGoHandle) *whatsapp.Album {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Album")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Album{})).(*whatsapp.Album)
}
func handleFromPtr_Ptr_whatsapp_Album(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Album", p))
}

// Converters for pointer handles for type: *whatsapp.Attachment
func ptrFromHandle_Ptr_whatsapp_Attachment(h CGoHandle) *whatsapp.Attachment {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Attachment")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Attachment{})).(*whatsapp.Attachment)
}
func handleFromPtr_Ptr_whatsapp_Attachment(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Attachment", p))
}

// Converters for pointer handles for type: *whatsapp.Avatar
func ptrFromHandle_Ptr_whatsapp_Avatar(h CGoHandle) *whatsapp.Avatar {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Avatar")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Avatar{})).(*whatsapp.Avatar)
}
func handleFromPtr_Ptr_whatsapp_Avatar(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Avatar", p))
}

// Converters for pointer handles for type: *whatsapp.Call
func ptrFromHandle_Ptr_whatsapp_Call(h CGoHandle) *whatsapp.Call {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Call")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Call{})).(*whatsapp.Call)
}
func handleFromPtr_Ptr_whatsapp_Call(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Call", p))
}

// Converters for pointer handles for type: *whatsapp.ChatState
func ptrFromHandle_Ptr_whatsapp_ChatState(h CGoHandle) *whatsapp.ChatState {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.ChatState")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.ChatState{})).(*whatsapp.ChatState)
}
func handleFromPtr_Ptr_whatsapp_ChatState(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.ChatState", p))
}

// Converters for pointer handles for type: *whatsapp.Connect
func ptrFromHandle_Ptr_whatsapp_Connect(h CGoHandle) *whatsapp.Connect {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Connect")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Connect{})).(*whatsapp.Connect)
}
func handleFromPtr_Ptr_whatsapp_Connect(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Connect", p))
}

// Converters for pointer handles for type: *whatsapp.Contact
func ptrFromHandle_Ptr_whatsapp_Contact(h CGoHandle) *whatsapp.Contact {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Contact")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Contact{})).(*whatsapp.Contact)
}
func handleFromPtr_Ptr_whatsapp_Contact(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Contact", p))
}

// Converters for pointer handles for type: *whatsapp.EventPayload
func ptrFromHandle_Ptr_whatsapp_EventPayload(h CGoHandle) *whatsapp.EventPayload {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.EventPayload")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.EventPayload{})).(*whatsapp.EventPayload)
}
func handleFromPtr_Ptr_whatsapp_EventPayload(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.EventPayload", p))
}

// Converters for pointer handles for type: *whatsapp.Gateway
func ptrFromHandle_Ptr_whatsapp_Gateway(h CGoHandle) *whatsapp.Gateway {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Gateway")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Gateway{})).(*whatsapp.Gateway)
}
func handleFromPtr_Ptr_whatsapp_Gateway(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Gateway", p))
}

// Converters for pointer handles for type: *whatsapp.Group
func ptrFromHandle_Ptr_whatsapp_Group(h CGoHandle) *whatsapp.Group {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Group")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Group{})).(*whatsapp.Group)
}
func handleFromPtr_Ptr_whatsapp_Group(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Group", p))
}

// Converters for pointer handles for type: *whatsapp.GroupParticipant
func ptrFromHandle_Ptr_whatsapp_GroupParticipant(h CGoHandle) *whatsapp.GroupParticipant {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.GroupParticipant")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.GroupParticipant{})).(*whatsapp.GroupParticipant)
}
func handleFromPtr_Ptr_whatsapp_GroupParticipant(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.GroupParticipant", p))
}

// Converters for pointer handles for type: *whatsapp.GroupSubject
func ptrFromHandle_Ptr_whatsapp_GroupSubject(h CGoHandle) *whatsapp.GroupSubject {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.GroupSubject")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.GroupSubject{})).(*whatsapp.GroupSubject)
}
func handleFromPtr_Ptr_whatsapp_GroupSubject(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.GroupSubject", p))
}

// Converters for pointer handles for type: *whatsapp.LinkedDevice
func ptrFromHandle_Ptr_whatsapp_LinkedDevice(h CGoHandle) *whatsapp.LinkedDevice {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.LinkedDevice")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.LinkedDevice{})).(*whatsapp.LinkedDevice)
}
func handleFromPtr_Ptr_whatsapp_LinkedDevice(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.LinkedDevice", p))
}

// Converters for pointer handles for type: *whatsapp.Location
func ptrFromHandle_Ptr_whatsapp_Location(h CGoHandle) *whatsapp.Location {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Location")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Location{})).(*whatsapp.Location)
}
func handleFromPtr_Ptr_whatsapp_Location(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Location", p))
}

// Converters for pointer handles for type: *whatsapp.LoggedOut
func ptrFromHandle_Ptr_whatsapp_LoggedOut(h CGoHandle) *whatsapp.LoggedOut {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.LoggedOut")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.LoggedOut{})).(*whatsapp.LoggedOut)
}
func handleFromPtr_Ptr_whatsapp_LoggedOut(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.LoggedOut", p))
}

// Converters for pointer handles for type: *whatsapp.Message
func ptrFromHandle_Ptr_whatsapp_Message(h CGoHandle) *whatsapp.Message {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Message")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Message{})).(*whatsapp.Message)
}
func handleFromPtr_Ptr_whatsapp_Message(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Message", p))
}

// Converters for pointer handles for type: *whatsapp.Poll
func ptrFromHandle_Ptr_whatsapp_Poll(h CGoHandle) *whatsapp.Poll {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Poll")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Poll{})).(*whatsapp.Poll)
}
func handleFromPtr_Ptr_whatsapp_Poll(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Poll", p))
}

// Converters for pointer handles for type: *whatsapp.PollOption
func ptrFromHandle_Ptr_whatsapp_PollOption(h CGoHandle) *whatsapp.PollOption {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.PollOption")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.PollOption{})).(*whatsapp.PollOption)
}
func handleFromPtr_Ptr_whatsapp_PollOption(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.PollOption", p))
}

// Converters for pointer handles for type: *whatsapp.Presence
func ptrFromHandle_Ptr_whatsapp_Presence(h CGoHandle) *whatsapp.Presence {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Presence")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Presence{})).(*whatsapp.Presence)
}
func handleFromPtr_Ptr_whatsapp_Presence(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Presence", p))
}

// Converters for pointer handles for type: *whatsapp.Preview
func ptrFromHandle_Ptr_whatsapp_Preview(h CGoHandle) *whatsapp.Preview {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Preview")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Preview{})).(*whatsapp.Preview)
}
func handleFromPtr_Ptr_whatsapp_Preview(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Preview", p))
}

// Converters for pointer handles for type: *whatsapp.Receipt
func ptrFromHandle_Ptr_whatsapp_Receipt(h CGoHandle) *whatsapp.Receipt {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Receipt")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Receipt{})).(*whatsapp.Receipt)
}
func handleFromPtr_Ptr_whatsapp_Receipt(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Receipt", p))
}

// Converters for pointer handles for type: *whatsapp.Session
func ptrFromHandle_Ptr_whatsapp_Session(h CGoHandle) *whatsapp.Session {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "*whatsapp.Session")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session)
}
func handleFromPtr_Ptr_whatsapp_Session(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("*whatsapp.Session", p))
}

// Converters for implicit pointer handles for type: []whatsapp.Attachment
func ptrFromHandle_Slice_whatsapp_Attachment(h CGoHandle) *[]whatsapp.Attachment {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]whatsapp.Attachment")
	if p == nil {
		return nil
	}
	return p.(*[]whatsapp.Attachment)
}
func deptrFromHandle_Slice_whatsapp_Attachment(h CGoHandle) []whatsapp.Attachment {
	p := ptrFromHandle_Slice_whatsapp_Attachment(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_whatsapp_Attachment(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]whatsapp.Attachment", p))
}

// --- wrapping slice: []whatsapp.Attachment ---
//
//export Slice_whatsapp_Attachment_CTor
func Slice_whatsapp_Attachment_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_whatsapp_Attachment(&[]whatsapp.Attachment{}))
}

//export Slice_whatsapp_Attachment_len
func Slice_whatsapp_Attachment_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_whatsapp_Attachment(handle))
}

//export Slice_whatsapp_Attachment_elem
func Slice_whatsapp_Attachment_elem(handle CGoHandle, _idx int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_Attachment(handle)
	return handleFromPtr_whatsapp_Attachment(&(s[_idx]))
}

//export Slice_whatsapp_Attachment_subslice
func Slice_whatsapp_Attachment_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_Attachment(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_whatsapp_Attachment(&ss))
}

//export Slice_whatsapp_Attachment_set
func Slice_whatsapp_Attachment_set(handle CGoHandle, _idx int, _vl CGoHandle) {
	s := deptrFromHandle_Slice_whatsapp_Attachment(handle)
	s[_idx] = *ptrFromHandle_whatsapp_Attachment(_vl)
}

//export Slice_whatsapp_Attachment_append
func Slice_whatsapp_Attachment_append(handle CGoHandle, _vl CGoHandle) {
	s := ptrFromHandle_Slice_whatsapp_Attachment(handle)
	*s = append(*s, *ptrFromHandle_whatsapp_Attachment(_vl))
}

// Converters for implicit pointer handles for type: []whatsapp.Contact
func ptrFromHandle_Slice_whatsapp_Contact(h CGoHandle) *[]whatsapp.Contact {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]whatsapp.Contact")
	if p == nil {
		return nil
	}
	return p.(*[]whatsapp.Contact)
}
func deptrFromHandle_Slice_whatsapp_Contact(h CGoHandle) []whatsapp.Contact {
	p := ptrFromHandle_Slice_whatsapp_Contact(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_whatsapp_Contact(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]whatsapp.Contact", p))
}

// --- wrapping slice: []whatsapp.Contact ---
//
//export Slice_whatsapp_Contact_CTor
func Slice_whatsapp_Contact_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_whatsapp_Contact(&[]whatsapp.Contact{}))
}

//export Slice_whatsapp_Contact_len
func Slice_whatsapp_Contact_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_whatsapp_Contact(handle))
}

//export Slice_whatsapp_Contact_elem
func Slice_whatsapp_Contact_elem(handle CGoHandle, _idx int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_Contact(handle)
	return handleFromPtr_whatsapp_Contact(&(s[_idx]))
}

//export Slice_whatsapp_Contact_subslice
func Slice_whatsapp_Contact_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_Contact(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_whatsapp_Contact(&ss))
}

//export Slice_whatsapp_Contact_set
func Slice_whatsapp_Contact_set(handle CGoHandle, _idx int, _vl CGoHandle) {
	s := deptrFromHandle_Slice_whatsapp_Contact(handle)
	s[_idx] = *ptrFromHandle_whatsapp_Contact(_vl)
}

//export Slice_whatsapp_Contact_append
func Slice_whatsapp_Contact_append(handle CGoHandle, _vl CGoHandle) {
	s := ptrFromHandle_Slice_whatsapp_Contact(handle)
	*s = append(*s, *ptrFromHandle_whatsapp_Contact(_vl))
}

// Converters for implicit pointer handles for type: []whatsapp.Group
func ptrFromHandle_Slice_whatsapp_Group(h CGoHandle) *[]whatsapp.Group {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]whatsapp.Group")
	if p == nil {
		return nil
	}
	return p.(*[]whatsapp.Group)
}
func deptrFromHandle_Slice_whatsapp_Group(h CGoHandle) []whatsapp.Group {
	p := ptrFromHandle_Slice_whatsapp_Group(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_whatsapp_Group(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]whatsapp.Group", p))
}

// --- wrapping slice: []whatsapp.Group ---
//
//export Slice_whatsapp_Group_CTor
func Slice_whatsapp_Group_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_whatsapp_Group(&[]whatsapp.Group{}))
}

//export Slice_whatsapp_Group_len
func Slice_whatsapp_Group_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_whatsapp_Group(handle))
}

//export Slice_whatsapp_Group_elem
func Slice_whatsapp_Group_elem(handle CGoHandle, _idx int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_Group(handle)
	return handleFromPtr_whatsapp_Group(&(s[_idx]))
}

//export Slice_whatsapp_Group_subslice
func Slice_whatsapp_Group_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_Group(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_whatsapp_Group(&ss))
}

//export Slice_whatsapp_Group_set
func Slice_whatsapp_Group_set(handle CGoHandle, _idx int, _vl CGoHandle) {
	s := deptrFromHandle_Slice_whatsapp_Group(handle)
	s[_idx] = *ptrFromHandle_whatsapp_Group(_vl)
}

//export Slice_whatsapp_Group_append
func Slice_whatsapp_Group_append(handle CGoHandle, _vl CGoHandle) {
	s := ptrFromHandle_Slice_whatsapp_Group(handle)
	*s = append(*s, *ptrFromHandle_whatsapp_Group(_vl))
}

// Converters for implicit pointer handles for type: []whatsapp.GroupParticipant
func ptrFromHandle_Slice_whatsapp_GroupParticipant(h CGoHandle) *[]whatsapp.GroupParticipant {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]whatsapp.GroupParticipant")
	if p == nil {
		return nil
	}
	return p.(*[]whatsapp.GroupParticipant)
}
func deptrFromHandle_Slice_whatsapp_GroupParticipant(h CGoHandle) []whatsapp.GroupParticipant {
	p := ptrFromHandle_Slice_whatsapp_GroupParticipant(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_whatsapp_GroupParticipant(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]whatsapp.GroupParticipant", p))
}

// --- wrapping slice: []whatsapp.GroupParticipant ---
//
//export Slice_whatsapp_GroupParticipant_CTor
func Slice_whatsapp_GroupParticipant_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_whatsapp_GroupParticipant(&[]whatsapp.GroupParticipant{}))
}

//export Slice_whatsapp_GroupParticipant_len
func Slice_whatsapp_GroupParticipant_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_whatsapp_GroupParticipant(handle))
}

//export Slice_whatsapp_GroupParticipant_elem
func Slice_whatsapp_GroupParticipant_elem(handle CGoHandle, _idx int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_GroupParticipant(handle)
	return handleFromPtr_whatsapp_GroupParticipant(&(s[_idx]))
}

//export Slice_whatsapp_GroupParticipant_subslice
func Slice_whatsapp_GroupParticipant_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_GroupParticipant(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_whatsapp_GroupParticipant(&ss))
}

//export Slice_whatsapp_GroupParticipant_set
func Slice_whatsapp_GroupParticipant_set(handle CGoHandle, _idx int, _vl CGoHandle) {
	s := deptrFromHandle_Slice_whatsapp_GroupParticipant(handle)
	s[_idx] = *ptrFromHandle_whatsapp_GroupParticipant(_vl)
}

//export Slice_whatsapp_GroupParticipant_append
func Slice_whatsapp_GroupParticipant_append(handle CGoHandle, _vl CGoHandle) {
	s := ptrFromHandle_Slice_whatsapp_GroupParticipant(handle)
	*s = append(*s, *ptrFromHandle_whatsapp_GroupParticipant(_vl))
}

// Converters for implicit pointer handles for type: []whatsapp.Message
func ptrFromHandle_Slice_whatsapp_Message(h CGoHandle) *[]whatsapp.Message {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]whatsapp.Message")
	if p == nil {
		return nil
	}
	return p.(*[]whatsapp.Message)
}
func deptrFromHandle_Slice_whatsapp_Message(h CGoHandle) []whatsapp.Message {
	p := ptrFromHandle_Slice_whatsapp_Message(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_whatsapp_Message(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]whatsapp.Message", p))
}

// --- wrapping slice: []whatsapp.Message ---
//
//export Slice_whatsapp_Message_CTor
func Slice_whatsapp_Message_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_whatsapp_Message(&[]whatsapp.Message{}))
}

//export Slice_whatsapp_Message_len
func Slice_whatsapp_Message_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_whatsapp_Message(handle))
}

//export Slice_whatsapp_Message_elem
func Slice_whatsapp_Message_elem(handle CGoHandle, _idx int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_Message(handle)
	return handleFromPtr_whatsapp_Message(&(s[_idx]))
}

//export Slice_whatsapp_Message_subslice
func Slice_whatsapp_Message_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_Message(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_whatsapp_Message(&ss))
}

//export Slice_whatsapp_Message_set
func Slice_whatsapp_Message_set(handle CGoHandle, _idx int, _vl CGoHandle) {
	s := deptrFromHandle_Slice_whatsapp_Message(handle)
	s[_idx] = *ptrFromHandle_whatsapp_Message(_vl)
}

//export Slice_whatsapp_Message_append
func Slice_whatsapp_Message_append(handle CGoHandle, _vl CGoHandle) {
	s := ptrFromHandle_Slice_whatsapp_Message(handle)
	*s = append(*s, *ptrFromHandle_whatsapp_Message(_vl))
}

// Converters for implicit pointer handles for type: []whatsapp.PollOption
func ptrFromHandle_Slice_whatsapp_PollOption(h CGoHandle) *[]whatsapp.PollOption {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]whatsapp.PollOption")
	if p == nil {
		return nil
	}
	return p.(*[]whatsapp.PollOption)
}
func deptrFromHandle_Slice_whatsapp_PollOption(h CGoHandle) []whatsapp.PollOption {
	p := ptrFromHandle_Slice_whatsapp_PollOption(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_whatsapp_PollOption(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]whatsapp.PollOption", p))
}

// --- wrapping slice: []whatsapp.PollOption ---
//
//export Slice_whatsapp_PollOption_CTor
func Slice_whatsapp_PollOption_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_whatsapp_PollOption(&[]whatsapp.PollOption{}))
}

//export Slice_whatsapp_PollOption_len
func Slice_whatsapp_PollOption_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_whatsapp_PollOption(handle))
}

//export Slice_whatsapp_PollOption_elem
func Slice_whatsapp_PollOption_elem(handle CGoHandle, _idx int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_PollOption(handle)
	return handleFromPtr_whatsapp_PollOption(&(s[_idx]))
}

//export Slice_whatsapp_PollOption_subslice
func Slice_whatsapp_PollOption_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_PollOption(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_whatsapp_PollOption(&ss))
}

//export Slice_whatsapp_PollOption_set
func Slice_whatsapp_PollOption_set(handle CGoHandle, _idx int, _vl CGoHandle) {
	s := deptrFromHandle_Slice_whatsapp_PollOption(handle)
	s[_idx] = *ptrFromHandle_whatsapp_PollOption(_vl)
}

//export Slice_whatsapp_PollOption_append
func Slice_whatsapp_PollOption_append(handle CGoHandle, _vl CGoHandle) {
	s := ptrFromHandle_Slice_whatsapp_PollOption(handle)
	*s = append(*s, *ptrFromHandle_whatsapp_PollOption(_vl))
}

// Converters for implicit pointer handles for type: []whatsapp.Receipt
func ptrFromHandle_Slice_whatsapp_Receipt(h CGoHandle) *[]whatsapp.Receipt {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "[]whatsapp.Receipt")
	if p == nil {
		return nil
	}
	return p.(*[]whatsapp.Receipt)
}
func deptrFromHandle_Slice_whatsapp_Receipt(h CGoHandle) []whatsapp.Receipt {
	p := ptrFromHandle_Slice_whatsapp_Receipt(h)
	if p == nil {
		return nil
	}
	return *p
}
func handleFromPtr_Slice_whatsapp_Receipt(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("[]whatsapp.Receipt", p))
}

// --- wrapping slice: []whatsapp.Receipt ---
//
//export Slice_whatsapp_Receipt_CTor
func Slice_whatsapp_Receipt_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_Slice_whatsapp_Receipt(&[]whatsapp.Receipt{}))
}

//export Slice_whatsapp_Receipt_len
func Slice_whatsapp_Receipt_len(handle CGoHandle) int {
	return len(deptrFromHandle_Slice_whatsapp_Receipt(handle))
}

//export Slice_whatsapp_Receipt_elem
func Slice_whatsapp_Receipt_elem(handle CGoHandle, _idx int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_Receipt(handle)
	return handleFromPtr_whatsapp_Receipt(&(s[_idx]))
}

//export Slice_whatsapp_Receipt_subslice
func Slice_whatsapp_Receipt_subslice(handle CGoHandle, _st, _ed int) CGoHandle {
	s := deptrFromHandle_Slice_whatsapp_Receipt(handle)
	ss := s[_st:_ed]
	return CGoHandle(handleFromPtr_Slice_whatsapp_Receipt(&ss))
}

//export Slice_whatsapp_Receipt_set
func Slice_whatsapp_Receipt_set(handle CGoHandle, _idx int, _vl CGoHandle) {
	s := deptrFromHandle_Slice_whatsapp_Receipt(handle)
	s[_idx] = *ptrFromHandle_whatsapp_Receipt(_vl)
}

//export Slice_whatsapp_Receipt_append
func Slice_whatsapp_Receipt_append(handle CGoHandle, _vl CGoHandle) {
	s := ptrFromHandle_Slice_whatsapp_Receipt(handle)
	*s = append(*s, *ptrFromHandle_whatsapp_Receipt(_vl))
}

// Converters for non-pointer handles for type: whatsapp.Album
func ptrFromHandle_whatsapp_Album(h CGoHandle) *whatsapp.Album {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Album")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Album{})).(*whatsapp.Album)
}
func handleFromPtr_whatsapp_Album(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Album", p))
}

// Converters for non-pointer handles for type: whatsapp.Attachment
func ptrFromHandle_whatsapp_Attachment(h CGoHandle) *whatsapp.Attachment {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Attachment")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Attachment{})).(*whatsapp.Attachment)
}
func handleFromPtr_whatsapp_Attachment(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Attachment", p))
}

// Converters for non-pointer handles for type: whatsapp.Avatar
func ptrFromHandle_whatsapp_Avatar(h CGoHandle) *whatsapp.Avatar {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Avatar")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Avatar{})).(*whatsapp.Avatar)
}
func handleFromPtr_whatsapp_Avatar(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Avatar", p))
}

// Converters for non-pointer handles for type: whatsapp.Call
func ptrFromHandle_whatsapp_Call(h CGoHandle) *whatsapp.Call {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Call")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Call{})).(*whatsapp.Call)
}
func handleFromPtr_whatsapp_Call(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Call", p))
}

// Converters for non-pointer handles for type: whatsapp.ChatState
func ptrFromHandle_whatsapp_ChatState(h CGoHandle) *whatsapp.ChatState {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.ChatState")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.ChatState{})).(*whatsapp.ChatState)
}
func handleFromPtr_whatsapp_ChatState(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.ChatState", p))
}

// Converters for non-pointer handles for type: whatsapp.Connect
func ptrFromHandle_whatsapp_Connect(h CGoHandle) *whatsapp.Connect {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Connect")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Connect{})).(*whatsapp.Connect)
}
func handleFromPtr_whatsapp_Connect(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Connect", p))
}

// Converters for non-pointer handles for type: whatsapp.Contact
func ptrFromHandle_whatsapp_Contact(h CGoHandle) *whatsapp.Contact {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Contact")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Contact{})).(*whatsapp.Contact)
}
func handleFromPtr_whatsapp_Contact(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Contact", p))
}

// Converters for non-pointer handles for type: whatsapp.EventPayload
func ptrFromHandle_whatsapp_EventPayload(h CGoHandle) *whatsapp.EventPayload {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.EventPayload")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.EventPayload{})).(*whatsapp.EventPayload)
}
func handleFromPtr_whatsapp_EventPayload(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.EventPayload", p))
}

// Converters for non-pointer handles for type: whatsapp.Gateway
func ptrFromHandle_whatsapp_Gateway(h CGoHandle) *whatsapp.Gateway {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Gateway")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Gateway{})).(*whatsapp.Gateway)
}
func handleFromPtr_whatsapp_Gateway(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Gateway", p))
}

// Converters for non-pointer handles for type: whatsapp.Group
func ptrFromHandle_whatsapp_Group(h CGoHandle) *whatsapp.Group {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Group")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Group{})).(*whatsapp.Group)
}
func handleFromPtr_whatsapp_Group(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Group", p))
}

// Converters for non-pointer handles for type: whatsapp.GroupParticipant
func ptrFromHandle_whatsapp_GroupParticipant(h CGoHandle) *whatsapp.GroupParticipant {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.GroupParticipant")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.GroupParticipant{})).(*whatsapp.GroupParticipant)
}
func handleFromPtr_whatsapp_GroupParticipant(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.GroupParticipant", p))
}

// Converters for non-pointer handles for type: whatsapp.GroupSubject
func ptrFromHandle_whatsapp_GroupSubject(h CGoHandle) *whatsapp.GroupSubject {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.GroupSubject")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.GroupSubject{})).(*whatsapp.GroupSubject)
}
func handleFromPtr_whatsapp_GroupSubject(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.GroupSubject", p))
}

// Converters for non-pointer handles for type: whatsapp.LinkedDevice
func ptrFromHandle_whatsapp_LinkedDevice(h CGoHandle) *whatsapp.LinkedDevice {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.LinkedDevice")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.LinkedDevice{})).(*whatsapp.LinkedDevice)
}
func handleFromPtr_whatsapp_LinkedDevice(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.LinkedDevice", p))
}

// Converters for non-pointer handles for type: whatsapp.Location
func ptrFromHandle_whatsapp_Location(h CGoHandle) *whatsapp.Location {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Location")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Location{})).(*whatsapp.Location)
}
func handleFromPtr_whatsapp_Location(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Location", p))
}

// Converters for non-pointer handles for type: whatsapp.LoggedOut
func ptrFromHandle_whatsapp_LoggedOut(h CGoHandle) *whatsapp.LoggedOut {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.LoggedOut")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.LoggedOut{})).(*whatsapp.LoggedOut)
}
func handleFromPtr_whatsapp_LoggedOut(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.LoggedOut", p))
}

// Converters for non-pointer handles for type: whatsapp.Message
func ptrFromHandle_whatsapp_Message(h CGoHandle) *whatsapp.Message {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Message")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Message{})).(*whatsapp.Message)
}
func handleFromPtr_whatsapp_Message(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Message", p))
}

// Converters for non-pointer handles for type: whatsapp.Poll
func ptrFromHandle_whatsapp_Poll(h CGoHandle) *whatsapp.Poll {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Poll")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Poll{})).(*whatsapp.Poll)
}
func handleFromPtr_whatsapp_Poll(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Poll", p))
}

// Converters for non-pointer handles for type: whatsapp.PollOption
func ptrFromHandle_whatsapp_PollOption(h CGoHandle) *whatsapp.PollOption {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.PollOption")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.PollOption{})).(*whatsapp.PollOption)
}
func handleFromPtr_whatsapp_PollOption(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.PollOption", p))
}

// Converters for non-pointer handles for type: whatsapp.Presence
func ptrFromHandle_whatsapp_Presence(h CGoHandle) *whatsapp.Presence {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Presence")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Presence{})).(*whatsapp.Presence)
}
func handleFromPtr_whatsapp_Presence(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Presence", p))
}

// Converters for non-pointer handles for type: whatsapp.Preview
func ptrFromHandle_whatsapp_Preview(h CGoHandle) *whatsapp.Preview {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Preview")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Preview{})).(*whatsapp.Preview)
}
func handleFromPtr_whatsapp_Preview(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Preview", p))
}

// Converters for non-pointer handles for type: whatsapp.Receipt
func ptrFromHandle_whatsapp_Receipt(h CGoHandle) *whatsapp.Receipt {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Receipt")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Receipt{})).(*whatsapp.Receipt)
}
func handleFromPtr_whatsapp_Receipt(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Receipt", p))
}

// Converters for non-pointer handles for type: whatsapp.Session
func ptrFromHandle_whatsapp_Session(h CGoHandle) *whatsapp.Session {
	p := gopyh.VarFromHandle((gopyh.CGoHandle)(h), "whatsapp.Session")
	if p == nil {
		return nil
	}
	return gopyh.Embed(p, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session)
}
func handleFromPtr_whatsapp_Session(p interface{}) CGoHandle {
	return CGoHandle(gopyh.Register("whatsapp.Session", p))
}

// ---- Global Variables: can only use functions to access ---

// ---- Interfaces ---

// ---- Structs ---

// --- wrapping struct: whatsapp.Connect ---
//
//export whatsapp_Connect_CTor
func whatsapp_Connect_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Connect(&whatsapp.Connect{}))
}

//export whatsapp_Connect_JID_Get
func whatsapp_Connect_JID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Connect(handle)
	return C.CString(op.JID)
}

//export whatsapp_Connect_JID_Set
func whatsapp_Connect_JID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Connect(handle)
	op.JID = C.GoString(val)
}

//export whatsapp_Connect_Error_Get
func whatsapp_Connect_Error_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Connect(handle)
	return C.CString(op.Error)
}

//export whatsapp_Connect_Error_Set
func whatsapp_Connect_Error_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Connect(handle)
	op.Error = C.GoString(val)
}

// --- wrapping struct: whatsapp.Contact ---
//
//export whatsapp_Contact_CTor
func whatsapp_Contact_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Contact(&whatsapp.Contact{}))
}

//export whatsapp_Contact_JID_Get
func whatsapp_Contact_JID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Contact(handle)
	return C.CString(op.JID)
}

//export whatsapp_Contact_JID_Set
func whatsapp_Contact_JID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Contact(handle)
	op.JID = C.GoString(val)
}

//export whatsapp_Contact_Name_Get
func whatsapp_Contact_Name_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Contact(handle)
	return C.CString(op.Name)
}

//export whatsapp_Contact_Name_Set
func whatsapp_Contact_Name_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Contact(handle)
	op.Name = C.GoString(val)
}

// --- wrapping struct: whatsapp.LinkedDevice ---
//
//export whatsapp_LinkedDevice_CTor
func whatsapp_LinkedDevice_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_LinkedDevice(&whatsapp.LinkedDevice{}))
}

//export whatsapp_LinkedDevice_ID_Get
func whatsapp_LinkedDevice_ID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_LinkedDevice(handle)
	return C.CString(op.ID)
}

//export whatsapp_LinkedDevice_ID_Set
func whatsapp_LinkedDevice_ID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_LinkedDevice(handle)
	op.ID = C.GoString(val)
}

//export whatsapp_LinkedDevice_JID
func whatsapp_LinkedDevice_JID(_handle CGoHandle) CGoHandle {
	_saved_thread := C.PyEval_SaveThread()
	defer C.PyEval_RestoreThread(_saved_thread)
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.LinkedDevice")
	if __err != nil {
		return handleFromPtr_types_JID(nil)
	}
	cret := gopyh.Embed(vifc, reflect.TypeOf(whatsapp.LinkedDevice{})).(*whatsapp.LinkedDevice).JID()

	return handleFromPtr_types_JID(&cret)
}

// --- wrapping struct: whatsapp.LoggedOut ---
//
//export whatsapp_LoggedOut_CTor
func whatsapp_LoggedOut_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_LoggedOut(&whatsapp.LoggedOut{}))
}

//export whatsapp_LoggedOut_Reason_Get
func whatsapp_LoggedOut_Reason_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_LoggedOut(handle)
	return C.CString(op.Reason)
}

//export whatsapp_LoggedOut_Reason_Set
func whatsapp_LoggedOut_Reason_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_LoggedOut(handle)
	op.Reason = C.GoString(val)
}

// --- wrapping struct: whatsapp.Presence ---
//
//export whatsapp_Presence_CTor
func whatsapp_Presence_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Presence(&whatsapp.Presence{}))
}

//export whatsapp_Presence_JID_Get
func whatsapp_Presence_JID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Presence(handle)
	return C.CString(op.JID)
}

//export whatsapp_Presence_JID_Set
func whatsapp_Presence_JID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Presence(handle)
	op.JID = C.GoString(val)
}

//export whatsapp_Presence_Kind_Get
func whatsapp_Presence_Kind_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Presence(handle)
	return C.longlong(int(op.Kind))
}

//export whatsapp_Presence_Kind_Set
func whatsapp_Presence_Kind_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Presence(handle)
	op.Kind = whatsapp.PresenceKind(int(val))
}

//export whatsapp_Presence_LastSeen_Get
func whatsapp_Presence_LastSeen_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Presence(handle)
	return C.longlong(op.LastSeen)
}

//export whatsapp_Presence_LastSeen_Set
func whatsapp_Presence_LastSeen_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Presence(handle)
	op.LastSeen = int64(val)
}

// --- wrapping struct: whatsapp.Gateway ---
//
//export whatsapp_Gateway_CTor
func whatsapp_Gateway_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Gateway(&whatsapp.Gateway{}))
}

//export whatsapp_Gateway_DBPath_Get
func whatsapp_Gateway_DBPath_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Gateway(handle)
	return C.CString(op.DBPath)
}

//export whatsapp_Gateway_DBPath_Set
func whatsapp_Gateway_DBPath_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Gateway(handle)
	op.DBPath = C.GoString(val)
}

//export whatsapp_Gateway_Name_Get
func whatsapp_Gateway_Name_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Gateway(handle)
	return C.CString(op.Name)
}

//export whatsapp_Gateway_Name_Set
func whatsapp_Gateway_Name_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Gateway(handle)
	op.Name = C.GoString(val)
}

//export whatsapp_Gateway_LogLevel_Get
func whatsapp_Gateway_LogLevel_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Gateway(handle)
	return C.CString(op.LogLevel)
}

//export whatsapp_Gateway_LogLevel_Set
func whatsapp_Gateway_LogLevel_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Gateway(handle)
	op.LogLevel = C.GoString(val)
}

//export whatsapp_Gateway_TempDir_Get
func whatsapp_Gateway_TempDir_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Gateway(handle)
	return C.CString(op.TempDir)
}

//export whatsapp_Gateway_TempDir_Set
func whatsapp_Gateway_TempDir_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Gateway(handle)
	op.TempDir = C.GoString(val)
}

//export whatsapp_Gateway_Init
func whatsapp_Gateway_Init(_handle CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Gateway")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Gateway{})).(*whatsapp.Gateway).Init()

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Gateway_NewSession
func whatsapp_Gateway_NewSession(_handle CGoHandle, device CGoHandle) CGoHandle {
	_saved_thread := C.PyEval_SaveThread()
	defer C.PyEval_RestoreThread(_saved_thread)
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Gateway")
	if __err != nil {
		return handleFromPtr_Ptr_whatsapp_Session(nil)
	}
	return handleFromPtr_Ptr_whatsapp_Session(gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Gateway{})).(*whatsapp.Gateway).NewSession(*ptrFromHandle_whatsapp_LinkedDevice(device)))

}

//export whatsapp_Gateway_CleanupSession
func whatsapp_Gateway_CleanupSession(_handle CGoHandle, device CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Gateway")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Gateway{})).(*whatsapp.Gateway).CleanupSession(*ptrFromHandle_whatsapp_LinkedDevice(device))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

// --- wrapping struct: whatsapp.Group ---
//
//export whatsapp_Group_CTor
func whatsapp_Group_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Group(&whatsapp.Group{}))
}

//export whatsapp_Group_JID_Get
func whatsapp_Group_JID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Group(handle)
	return C.CString(op.JID)
}

//export whatsapp_Group_JID_Set
func whatsapp_Group_JID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Group(handle)
	op.JID = C.GoString(val)
}

//export whatsapp_Group_Name_Get
func whatsapp_Group_Name_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Group(handle)
	return C.CString(op.Name)
}

//export whatsapp_Group_Name_Set
func whatsapp_Group_Name_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Group(handle)
	op.Name = C.GoString(val)
}

//export whatsapp_Group_Subject_Get
func whatsapp_Group_Subject_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Group(handle)
	return handleFromPtr_whatsapp_GroupSubject(&op.Subject)
}

//export whatsapp_Group_Subject_Set
func whatsapp_Group_Subject_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Group(handle)
	op.Subject = *ptrFromHandle_whatsapp_GroupSubject(val)
}

//export whatsapp_Group_Nickname_Get
func whatsapp_Group_Nickname_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Group(handle)
	return C.CString(op.Nickname)
}

//export whatsapp_Group_Nickname_Set
func whatsapp_Group_Nickname_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Group(handle)
	op.Nickname = C.GoString(val)
}

//export whatsapp_Group_Participants_Get
func whatsapp_Group_Participants_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Group(handle)
	return handleFromPtr_Slice_whatsapp_GroupParticipant(&op.Participants)
}

//export whatsapp_Group_Participants_Set
func whatsapp_Group_Participants_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Group(handle)
	op.Participants = deptrFromHandle_Slice_whatsapp_GroupParticipant(val)
}

//export whatsapp_Group_InviteCode_Get
func whatsapp_Group_InviteCode_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Group(handle)
	return C.CString(op.InviteCode)
}

//export whatsapp_Group_InviteCode_Set
func whatsapp_Group_InviteCode_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Group(handle)
	op.InviteCode = C.GoString(val)
}

// --- wrapping struct: whatsapp.GroupParticipant ---
//
//export whatsapp_GroupParticipant_CTor
func whatsapp_GroupParticipant_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_GroupParticipant(&whatsapp.GroupParticipant{}))
}

//export whatsapp_GroupParticipant_JID_Get
func whatsapp_GroupParticipant_JID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_GroupParticipant(handle)
	return C.CString(op.JID)
}

//export whatsapp_GroupParticipant_JID_Set
func whatsapp_GroupParticipant_JID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_GroupParticipant(handle)
	op.JID = C.GoString(val)
}

//export whatsapp_GroupParticipant_Nickname_Get
func whatsapp_GroupParticipant_Nickname_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_GroupParticipant(handle)
	return C.CString(op.Nickname)
}

//export whatsapp_GroupParticipant_Nickname_Set
func whatsapp_GroupParticipant_Nickname_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_GroupParticipant(handle)
	op.Nickname = C.GoString(val)
}

//export whatsapp_GroupParticipant_Affiliation_Get
func whatsapp_GroupParticipant_Affiliation_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_GroupParticipant(handle)
	return C.longlong(int(op.Affiliation))
}

//export whatsapp_GroupParticipant_Affiliation_Set
func whatsapp_GroupParticipant_Affiliation_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_GroupParticipant(handle)
	op.Affiliation = whatsapp.GroupAffiliation(int(val))
}

//export whatsapp_GroupParticipant_Action_Get
func whatsapp_GroupParticipant_Action_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_GroupParticipant(handle)
	return C.longlong(int(op.Action))
}

//export whatsapp_GroupParticipant_Action_Set
func whatsapp_GroupParticipant_Action_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_GroupParticipant(handle)
	op.Action = whatsapp.GroupParticipantAction(int(val))
}

// --- wrapping struct: whatsapp.Location ---
//
//export whatsapp_Location_CTor
func whatsapp_Location_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Location(&whatsapp.Location{}))
}

//export whatsapp_Location_Latitude_Get
func whatsapp_Location_Latitude_Get(handle CGoHandle) C.double {
	op := ptrFromHandle_whatsapp_Location(handle)
	return C.double(op.Latitude)
}

//export whatsapp_Location_Latitude_Set
func whatsapp_Location_Latitude_Set(handle CGoHandle, val C.double) {
	op := ptrFromHandle_whatsapp_Location(handle)
	op.Latitude = float64(val)
}

//export whatsapp_Location_Longitude_Get
func whatsapp_Location_Longitude_Get(handle CGoHandle) C.double {
	op := ptrFromHandle_whatsapp_Location(handle)
	return C.double(op.Longitude)
}

//export whatsapp_Location_Longitude_Set
func whatsapp_Location_Longitude_Set(handle CGoHandle, val C.double) {
	op := ptrFromHandle_whatsapp_Location(handle)
	op.Longitude = float64(val)
}

//export whatsapp_Location_Accuracy_Get
func whatsapp_Location_Accuracy_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Location(handle)
	return C.longlong(op.Accuracy)
}

//export whatsapp_Location_Accuracy_Set
func whatsapp_Location_Accuracy_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Location(handle)
	op.Accuracy = int(val)
}

//export whatsapp_Location_IsLive_Get
func whatsapp_Location_IsLive_Get(handle CGoHandle) C.char {
	op := ptrFromHandle_whatsapp_Location(handle)
	return boolGoToPy(op.IsLive)
}

//export whatsapp_Location_IsLive_Set
func whatsapp_Location_IsLive_Set(handle CGoHandle, val C.char) {
	op := ptrFromHandle_whatsapp_Location(handle)
	op.IsLive = boolPyToGo(val)
}

//export whatsapp_Location_Name_Get
func whatsapp_Location_Name_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Location(handle)
	return C.CString(op.Name)
}

//export whatsapp_Location_Name_Set
func whatsapp_Location_Name_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Location(handle)
	op.Name = C.GoString(val)
}

//export whatsapp_Location_Address_Get
func whatsapp_Location_Address_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Location(handle)
	return C.CString(op.Address)
}

//export whatsapp_Location_Address_Set
func whatsapp_Location_Address_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Location(handle)
	op.Address = C.GoString(val)
}

//export whatsapp_Location_URL_Get
func whatsapp_Location_URL_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Location(handle)
	return C.CString(op.URL)
}

//export whatsapp_Location_URL_Set
func whatsapp_Location_URL_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Location(handle)
	op.URL = C.GoString(val)
}

// --- wrapping struct: whatsapp.Preview ---
//
//export whatsapp_Preview_CTor
func whatsapp_Preview_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Preview(&whatsapp.Preview{}))
}

//export whatsapp_Preview_Kind_Get
func whatsapp_Preview_Kind_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Preview(handle)
	return C.longlong(int(op.Kind))
}

//export whatsapp_Preview_Kind_Set
func whatsapp_Preview_Kind_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Preview(handle)
	op.Kind = whatsapp.PreviewKind(int(val))
}

//export whatsapp_Preview_URL_Get
func whatsapp_Preview_URL_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Preview(handle)
	return C.CString(op.URL)
}

//export whatsapp_Preview_URL_Set
func whatsapp_Preview_URL_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Preview(handle)
	op.URL = C.GoString(val)
}

//export whatsapp_Preview_Title_Get
func whatsapp_Preview_Title_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Preview(handle)
	return C.CString(op.Title)
}

//export whatsapp_Preview_Title_Set
func whatsapp_Preview_Title_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Preview(handle)
	op.Title = C.GoString(val)
}

//export whatsapp_Preview_Description_Get
func whatsapp_Preview_Description_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Preview(handle)
	return C.CString(op.Description)
}

//export whatsapp_Preview_Description_Set
func whatsapp_Preview_Description_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Preview(handle)
	op.Description = C.GoString(val)
}

//export whatsapp_Preview_Thumbnail_Get
func whatsapp_Preview_Thumbnail_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Preview(handle)
	return handleFromPtr_Slice_byte(&op.Thumbnail)
}

//export whatsapp_Preview_Thumbnail_Set
func whatsapp_Preview_Thumbnail_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Preview(handle)
	op.Thumbnail = deptrFromHandle_Slice_byte(val)
}

// --- wrapping struct: whatsapp.Receipt ---
//
//export whatsapp_Receipt_CTor
func whatsapp_Receipt_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Receipt(&whatsapp.Receipt{}))
}

//export whatsapp_Receipt_Kind_Get
func whatsapp_Receipt_Kind_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	return C.longlong(int(op.Kind))
}

//export whatsapp_Receipt_Kind_Set
func whatsapp_Receipt_Kind_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	op.Kind = whatsapp.ReceiptKind(int(val))
}

//export whatsapp_Receipt_MessageIDs_Get
func whatsapp_Receipt_MessageIDs_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	return handleFromPtr_Slice_string(&op.MessageIDs)
}

//export whatsapp_Receipt_MessageIDs_Set
func whatsapp_Receipt_MessageIDs_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	op.MessageIDs = deptrFromHandle_Slice_string(val)
}

//export whatsapp_Receipt_JID_Get
func whatsapp_Receipt_JID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	return C.CString(op.JID)
}

//export whatsapp_Receipt_JID_Set
func whatsapp_Receipt_JID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	op.JID = C.GoString(val)
}

//export whatsapp_Receipt_GroupJID_Get
func whatsapp_Receipt_GroupJID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	return C.CString(op.GroupJID)
}

//export whatsapp_Receipt_GroupJID_Set
func whatsapp_Receipt_GroupJID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	op.GroupJID = C.GoString(val)
}

//export whatsapp_Receipt_Timestamp_Get
func whatsapp_Receipt_Timestamp_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	return C.longlong(op.Timestamp)
}

//export whatsapp_Receipt_Timestamp_Set
func whatsapp_Receipt_Timestamp_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	op.Timestamp = int64(val)
}

//export whatsapp_Receipt_IsCarbon_Get
func whatsapp_Receipt_IsCarbon_Get(handle CGoHandle) C.char {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	return boolGoToPy(op.IsCarbon)
}

//export whatsapp_Receipt_IsCarbon_Set
func whatsapp_Receipt_IsCarbon_Set(handle CGoHandle, val C.char) {
	op := ptrFromHandle_whatsapp_Receipt(handle)
	op.IsCarbon = boolPyToGo(val)
}

// --- wrapping struct: whatsapp.Session ---
//
//export whatsapp_Session_CTor
func whatsapp_Session_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Session(&whatsapp.Session{}))
}

//export whatsapp_Session_Login
func whatsapp_Session_Login(_handle CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).Login()

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_Logout
func whatsapp_Session_Logout(_handle CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).Logout()

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_Disconnect
func whatsapp_Session_Disconnect(_handle CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).Disconnect()

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_PairPhone
func whatsapp_Session_PairPhone(_handle CGoHandle, phone *C.char) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return C.CString("")
	}
	cret, __err := gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).PairPhone(C.GoString(phone))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return C.CString("")
	}
	return C.CString(cret)
}

//export whatsapp_Session_SendMessage
func whatsapp_Session_SendMessage(_handle CGoHandle, message CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).SendMessage(*ptrFromHandle_whatsapp_Message(message))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_GenerateMessageID
func whatsapp_Session_GenerateMessageID(_handle CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	defer C.PyEval_RestoreThread(_saved_thread)
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return C.CString("")
	}
	return C.CString(gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).GenerateMessageID())

}

//export whatsapp_Session_SendChatState
func whatsapp_Session_SendChatState(_handle CGoHandle, state CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).SendChatState(*ptrFromHandle_whatsapp_ChatState(state))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_SendReceipt
func whatsapp_Session_SendReceipt(_handle CGoHandle, receipt CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).SendReceipt(*ptrFromHandle_whatsapp_Receipt(receipt))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_SendPresence
func whatsapp_Session_SendPresence(_handle CGoHandle, presence C.longlong, statusMessage *C.char) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).SendPresence(whatsapp.PresenceKind(int(presence)), C.GoString(statusMessage))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_GetContacts
func whatsapp_Session_GetContacts(_handle CGoHandle, refresh C.char) CGoHandle {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return handleFromPtr_Slice_whatsapp_Contact(nil)
	}
	cret, __err := gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).GetContacts(boolPyToGo(refresh))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return handleFromPtr_Slice_whatsapp_Contact(nil)
	}
	return handleFromPtr_Slice_whatsapp_Contact(&cret)
}

//export whatsapp_Session_GetGroups
func whatsapp_Session_GetGroups(_handle CGoHandle) CGoHandle {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return handleFromPtr_Slice_whatsapp_Group(nil)
	}
	cret, __err := gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).GetGroups()

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return handleFromPtr_Slice_whatsapp_Group(nil)
	}
	return handleFromPtr_Slice_whatsapp_Group(&cret)
}

//export whatsapp_Session_CreateGroup
func whatsapp_Session_CreateGroup(_handle CGoHandle, name *C.char, participants CGoHandle) CGoHandle {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return handleFromPtr_whatsapp_Group(nil)
	}
	cret, __err := gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).CreateGroup(C.GoString(name), deptrFromHandle_Slice_string(participants))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return handleFromPtr_whatsapp_Group(nil)
	}
	return handleFromPtr_whatsapp_Group(&cret)
}

//export whatsapp_Session_LeaveGroup
func whatsapp_Session_LeaveGroup(_handle CGoHandle, resourceID *C.char) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).LeaveGroup(C.GoString(resourceID))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_GetAvatar
func whatsapp_Session_GetAvatar(_handle CGoHandle, resourceID *C.char, avatarID *C.char) CGoHandle {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return handleFromPtr_whatsapp_Avatar(nil)
	}
	cret, __err := gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).GetAvatar(C.GoString(resourceID), C.GoString(avatarID))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return handleFromPtr_whatsapp_Avatar(nil)
	}
	return handleFromPtr_whatsapp_Avatar(&cret)
}

//export whatsapp_Session_SetAvatar
func whatsapp_Session_SetAvatar(_handle CGoHandle, resourceID *C.char, avatar CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return C.CString("")
	}
	cret, __err := gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).SetAvatar(C.GoString(resourceID), deptrFromHandle_Slice_byte(avatar))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return C.CString("")
	}
	return C.CString(cret)
}

//export whatsapp_Session_SetGroupName
func whatsapp_Session_SetGroupName(_handle CGoHandle, resourceID *C.char, name *C.char) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).SetGroupName(C.GoString(resourceID), C.GoString(name))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_SetGroupTopic
func whatsapp_Session_SetGroupTopic(_handle CGoHandle, resourceID *C.char, topic *C.char) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).SetGroupTopic(C.GoString(resourceID), C.GoString(topic))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_UpdateGroupParticipants
func whatsapp_Session_UpdateGroupParticipants(_handle CGoHandle, resourceID *C.char, participants CGoHandle) CGoHandle {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return handleFromPtr_Slice_whatsapp_GroupParticipant(nil)
	}
	cret, __err := gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).UpdateGroupParticipants(C.GoString(resourceID), deptrFromHandle_Slice_whatsapp_GroupParticipant(participants))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return handleFromPtr_Slice_whatsapp_GroupParticipant(nil)
	}
	return handleFromPtr_Slice_whatsapp_GroupParticipant(&cret)
}

//export whatsapp_Session_FindContact
func whatsapp_Session_FindContact(_handle CGoHandle, phone *C.char) CGoHandle {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return handleFromPtr_whatsapp_Contact(nil)
	}
	cret, __err := gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).FindContact(C.GoString(phone))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return handleFromPtr_whatsapp_Contact(nil)
	}
	return handleFromPtr_whatsapp_Contact(&cret)
}

//export whatsapp_Session_RequestMessageHistory
func whatsapp_Session_RequestMessageHistory(_handle CGoHandle, resourceID *C.char, oldestMessage CGoHandle) *C.char {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return errorGoToPy(nil)
	}
	__err = gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).RequestMessageHistory(C.GoString(resourceID), *ptrFromHandle_whatsapp_Message(oldestMessage))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		return estr
	}
	return C.CString("")
}

//export whatsapp_Session_SetEventHandler
func whatsapp_Session_SetEventHandler(_handle CGoHandle, h *C.PyObject, goRun C.char) {
	_fun_arg := h
	_saved_thread := C.PyEval_SaveThread()
	defer C.PyEval_RestoreThread(_saved_thread)
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Session")
	if __err != nil {
		return
	}
	if boolPyToGo(goRun) {
		go gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).SetEventHandler(func(arg_0 whatsapp.EventKind, arg_1 *whatsapp.EventPayload) {
			if C.PyCallable_Check(_fun_arg) == 0 {
				return
			}
			_gstate := C.PyGILState_Ensure()
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_int64(C.int64_t(arg_0)))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_int64(C.int64_t(handleFromPtr_Ptr_whatsapp_EventPayload(arg_1))))
			C.PyObject_CallObject(_fun_arg, _fcargs)
			C.gopy_decref(_fcargs)
			C.gopy_err_handle()
			C.PyGILState_Release(_gstate)
		})
	} else {
		gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Session{})).(*whatsapp.Session).SetEventHandler(func(arg_0 whatsapp.EventKind, arg_1 *whatsapp.EventPayload) {
			if C.PyCallable_Check(_fun_arg) == 0 {
				return
			}
			_gstate := C.PyGILState_Ensure()
			_fcargs := C.PyTuple_New(2)
			C.PyTuple_SetItem(_fcargs, 0, C.gopy_build_int64(C.int64_t(arg_0)))
			C.PyTuple_SetItem(_fcargs, 1, C.gopy_build_int64(C.int64_t(handleFromPtr_Ptr_whatsapp_EventPayload(arg_1))))
			C.PyObject_CallObject(_fun_arg, _fcargs)
			C.gopy_decref(_fcargs)
			C.gopy_err_handle()
			C.PyGILState_Release(_gstate)
		})
	}
}

// --- wrapping struct: whatsapp.Message ---
//
//export whatsapp_Message_CTor
func whatsapp_Message_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Message(&whatsapp.Message{}))
}

//export whatsapp_Message_Kind_Get
func whatsapp_Message_Kind_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Message(handle)
	return C.longlong(int(op.Kind))
}

//export whatsapp_Message_Kind_Set
func whatsapp_Message_Kind_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.Kind = whatsapp.MessageKind(int(val))
}

//export whatsapp_Message_ID_Get
func whatsapp_Message_ID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Message(handle)
	return C.CString(op.ID)
}

//export whatsapp_Message_ID_Set
func whatsapp_Message_ID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.ID = C.GoString(val)
}

//export whatsapp_Message_JID_Get
func whatsapp_Message_JID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Message(handle)
	return C.CString(op.JID)
}

//export whatsapp_Message_JID_Set
func whatsapp_Message_JID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.JID = C.GoString(val)
}

//export whatsapp_Message_GroupJID_Get
func whatsapp_Message_GroupJID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Message(handle)
	return C.CString(op.GroupJID)
}

//export whatsapp_Message_GroupJID_Set
func whatsapp_Message_GroupJID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.GroupJID = C.GoString(val)
}

//export whatsapp_Message_OriginJID_Get
func whatsapp_Message_OriginJID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Message(handle)
	return C.CString(op.OriginJID)
}

//export whatsapp_Message_OriginJID_Set
func whatsapp_Message_OriginJID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.OriginJID = C.GoString(val)
}

//export whatsapp_Message_Body_Get
func whatsapp_Message_Body_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Message(handle)
	return C.CString(op.Body)
}

//export whatsapp_Message_Body_Set
func whatsapp_Message_Body_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.Body = C.GoString(val)
}

//export whatsapp_Message_Timestamp_Get
func whatsapp_Message_Timestamp_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Message(handle)
	return C.longlong(op.Timestamp)
}

//export whatsapp_Message_Timestamp_Set
func whatsapp_Message_Timestamp_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.Timestamp = int64(val)
}

//export whatsapp_Message_IsCarbon_Get
func whatsapp_Message_IsCarbon_Get(handle CGoHandle) C.char {
	op := ptrFromHandle_whatsapp_Message(handle)
	return boolGoToPy(op.IsCarbon)
}

//export whatsapp_Message_IsCarbon_Set
func whatsapp_Message_IsCarbon_Set(handle CGoHandle, val C.char) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.IsCarbon = boolPyToGo(val)
}

//export whatsapp_Message_IsForwarded_Get
func whatsapp_Message_IsForwarded_Get(handle CGoHandle) C.char {
	op := ptrFromHandle_whatsapp_Message(handle)
	return boolGoToPy(op.IsForwarded)
}

//export whatsapp_Message_IsForwarded_Set
func whatsapp_Message_IsForwarded_Set(handle CGoHandle, val C.char) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.IsForwarded = boolPyToGo(val)
}

//export whatsapp_Message_ReplyID_Get
func whatsapp_Message_ReplyID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Message(handle)
	return C.CString(op.ReplyID)
}

//export whatsapp_Message_ReplyID_Set
func whatsapp_Message_ReplyID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.ReplyID = C.GoString(val)
}

//export whatsapp_Message_ReplyBody_Get
func whatsapp_Message_ReplyBody_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Message(handle)
	return C.CString(op.ReplyBody)
}

//export whatsapp_Message_ReplyBody_Set
func whatsapp_Message_ReplyBody_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.ReplyBody = C.GoString(val)
}

//export whatsapp_Message_Attachments_Get
func whatsapp_Message_Attachments_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Message(handle)
	return handleFromPtr_Slice_whatsapp_Attachment(&op.Attachments)
}

//export whatsapp_Message_Attachments_Set
func whatsapp_Message_Attachments_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.Attachments = deptrFromHandle_Slice_whatsapp_Attachment(val)
}

//export whatsapp_Message_Preview_Get
func whatsapp_Message_Preview_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Message(handle)
	return handleFromPtr_whatsapp_Preview(&op.Preview)
}

//export whatsapp_Message_Preview_Set
func whatsapp_Message_Preview_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.Preview = *ptrFromHandle_whatsapp_Preview(val)
}

//export whatsapp_Message_Location_Get
func whatsapp_Message_Location_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Message(handle)
	return handleFromPtr_whatsapp_Location(&op.Location)
}

//export whatsapp_Message_Location_Set
func whatsapp_Message_Location_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.Location = *ptrFromHandle_whatsapp_Location(val)
}

//export whatsapp_Message_Poll_Get
func whatsapp_Message_Poll_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Message(handle)
	return handleFromPtr_whatsapp_Poll(&op.Poll)
}

//export whatsapp_Message_Poll_Set
func whatsapp_Message_Poll_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.Poll = *ptrFromHandle_whatsapp_Poll(val)
}

//export whatsapp_Message_Album_Get
func whatsapp_Message_Album_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Message(handle)
	return handleFromPtr_whatsapp_Album(&op.Album)
}

//export whatsapp_Message_Album_Set
func whatsapp_Message_Album_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.Album = *ptrFromHandle_whatsapp_Album(val)
}

//export whatsapp_Message_GroupInvite_Get
func whatsapp_Message_GroupInvite_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Message(handle)
	return handleFromPtr_whatsapp_Group(&op.GroupInvite)
}

//export whatsapp_Message_GroupInvite_Set
func whatsapp_Message_GroupInvite_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.GroupInvite = *ptrFromHandle_whatsapp_Group(val)
}

//export whatsapp_Message_MentionJIDs_Get
func whatsapp_Message_MentionJIDs_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Message(handle)
	return handleFromPtr_Slice_string(&op.MentionJIDs)
}

//export whatsapp_Message_MentionJIDs_Set
func whatsapp_Message_MentionJIDs_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.MentionJIDs = deptrFromHandle_Slice_string(val)
}

//export whatsapp_Message_Receipts_Get
func whatsapp_Message_Receipts_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Message(handle)
	return handleFromPtr_Slice_whatsapp_Receipt(&op.Receipts)
}

//export whatsapp_Message_Receipts_Set
func whatsapp_Message_Receipts_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.Receipts = deptrFromHandle_Slice_whatsapp_Receipt(val)
}

//export whatsapp_Message_Reactions_Get
func whatsapp_Message_Reactions_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Message(handle)
	return handleFromPtr_Slice_whatsapp_Message(&op.Reactions)
}

//export whatsapp_Message_Reactions_Set
func whatsapp_Message_Reactions_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.Reactions = deptrFromHandle_Slice_whatsapp_Message(val)
}

//export whatsapp_Message_IsHistory_Get
func whatsapp_Message_IsHistory_Get(handle CGoHandle) C.char {
	op := ptrFromHandle_whatsapp_Message(handle)
	return boolGoToPy(op.IsHistory)
}

//export whatsapp_Message_IsHistory_Set
func whatsapp_Message_IsHistory_Set(handle CGoHandle, val C.char) {
	op := ptrFromHandle_whatsapp_Message(handle)
	op.IsHistory = boolPyToGo(val)
}

// --- wrapping struct: whatsapp.PollOption ---
//
//export whatsapp_PollOption_CTor
func whatsapp_PollOption_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_PollOption(&whatsapp.PollOption{}))
}

//export whatsapp_PollOption_Title_Get
func whatsapp_PollOption_Title_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_PollOption(handle)
	return C.CString(op.Title)
}

//export whatsapp_PollOption_Title_Set
func whatsapp_PollOption_Title_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_PollOption(handle)
	op.Title = C.GoString(val)
}

// --- wrapping struct: whatsapp.Attachment ---
//
//export whatsapp_Attachment_CTor
func whatsapp_Attachment_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Attachment(&whatsapp.Attachment{}))
}

//export whatsapp_Attachment_MIME_Get
func whatsapp_Attachment_MIME_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Attachment(handle)
	return C.CString(op.MIME)
}

//export whatsapp_Attachment_MIME_Set
func whatsapp_Attachment_MIME_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Attachment(handle)
	op.MIME = C.GoString(val)
}

//export whatsapp_Attachment_Filename_Get
func whatsapp_Attachment_Filename_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Attachment(handle)
	return C.CString(op.Filename)
}

//export whatsapp_Attachment_Filename_Set
func whatsapp_Attachment_Filename_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Attachment(handle)
	op.Filename = C.GoString(val)
}

//export whatsapp_Attachment_Caption_Get
func whatsapp_Attachment_Caption_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Attachment(handle)
	return C.CString(op.Caption)
}

//export whatsapp_Attachment_Caption_Set
func whatsapp_Attachment_Caption_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Attachment(handle)
	op.Caption = C.GoString(val)
}

//export whatsapp_Attachment_Data_Get
func whatsapp_Attachment_Data_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Attachment(handle)
	return handleFromPtr_Slice_byte(&op.Data)
}

//export whatsapp_Attachment_Data_Set
func whatsapp_Attachment_Data_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Attachment(handle)
	op.Data = deptrFromHandle_Slice_byte(val)
}

//export whatsapp_Attachment_GetSpec
func whatsapp_Attachment_GetSpec(_handle CGoHandle, ctx CGoHandle) CGoHandle {
	_saved_thread := C.PyEval_SaveThread()
	vifc, __err := gopyh.VarFromHandleTry((gopyh.CGoHandle)(_handle), "*whatsapp.Attachment")
	if __err != nil {
		return handleFromPtr_Ptr_media_Spec(nil)
	}
	cret, __err := gopyh.Embed(vifc, reflect.TypeOf(whatsapp.Attachment{})).(*whatsapp.Attachment).GetSpec(ptrFromHandle_context_Context(ctx))

	C.PyEval_RestoreThread(_saved_thread)
	if __err != nil {
		estr := C.CString(__err.Error())
		C.PyErr_SetString(C.PyExc_RuntimeError, estr)
		C.free(unsafe.Pointer(estr))
		return handleFromPtr_Ptr_media_Spec(nil)
	}
	return handleFromPtr_Ptr_media_Spec(cret)
}

// --- wrapping struct: whatsapp.Call ---
//
//export whatsapp_Call_CTor
func whatsapp_Call_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Call(&whatsapp.Call{}))
}

//export whatsapp_Call_State_Get
func whatsapp_Call_State_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Call(handle)
	return C.longlong(int(op.State))
}

//export whatsapp_Call_State_Set
func whatsapp_Call_State_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Call(handle)
	op.State = whatsapp.CallState(int(val))
}

//export whatsapp_Call_JID_Get
func whatsapp_Call_JID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Call(handle)
	return C.CString(op.JID)
}

//export whatsapp_Call_JID_Set
func whatsapp_Call_JID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Call(handle)
	op.JID = C.GoString(val)
}

//export whatsapp_Call_Timestamp_Get
func whatsapp_Call_Timestamp_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Call(handle)
	return C.longlong(op.Timestamp)
}

//export whatsapp_Call_Timestamp_Set
func whatsapp_Call_Timestamp_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Call(handle)
	op.Timestamp = int64(val)
}

// --- wrapping struct: whatsapp.EventPayload ---
//
//export whatsapp_EventPayload_CTor
func whatsapp_EventPayload_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_EventPayload(&whatsapp.EventPayload{}))
}

//export whatsapp_EventPayload_QRCode_Get
func whatsapp_EventPayload_QRCode_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return C.CString(op.QRCode)
}

//export whatsapp_EventPayload_QRCode_Set
func whatsapp_EventPayload_QRCode_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.QRCode = C.GoString(val)
}

//export whatsapp_EventPayload_PairDeviceID_Get
func whatsapp_EventPayload_PairDeviceID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return C.CString(op.PairDeviceID)
}

//export whatsapp_EventPayload_PairDeviceID_Set
func whatsapp_EventPayload_PairDeviceID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.PairDeviceID = C.GoString(val)
}

//export whatsapp_EventPayload_Connect_Get
func whatsapp_EventPayload_Connect_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return handleFromPtr_whatsapp_Connect(&op.Connect)
}

//export whatsapp_EventPayload_Connect_Set
func whatsapp_EventPayload_Connect_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.Connect = *ptrFromHandle_whatsapp_Connect(val)
}

//export whatsapp_EventPayload_LoggedOut_Get
func whatsapp_EventPayload_LoggedOut_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return handleFromPtr_whatsapp_LoggedOut(&op.LoggedOut)
}

//export whatsapp_EventPayload_LoggedOut_Set
func whatsapp_EventPayload_LoggedOut_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.LoggedOut = *ptrFromHandle_whatsapp_LoggedOut(val)
}

//export whatsapp_EventPayload_Contact_Get
func whatsapp_EventPayload_Contact_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return handleFromPtr_whatsapp_Contact(&op.Contact)
}

//export whatsapp_EventPayload_Contact_Set
func whatsapp_EventPayload_Contact_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.Contact = *ptrFromHandle_whatsapp_Contact(val)
}

//export whatsapp_EventPayload_Presence_Get
func whatsapp_EventPayload_Presence_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return handleFromPtr_whatsapp_Presence(&op.Presence)
}

//export whatsapp_EventPayload_Presence_Set
func whatsapp_EventPayload_Presence_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.Presence = *ptrFromHandle_whatsapp_Presence(val)
}

//export whatsapp_EventPayload_Message_Get
func whatsapp_EventPayload_Message_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return handleFromPtr_whatsapp_Message(&op.Message)
}

//export whatsapp_EventPayload_Message_Set
func whatsapp_EventPayload_Message_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.Message = *ptrFromHandle_whatsapp_Message(val)
}

//export whatsapp_EventPayload_ChatState_Get
func whatsapp_EventPayload_ChatState_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return handleFromPtr_whatsapp_ChatState(&op.ChatState)
}

//export whatsapp_EventPayload_ChatState_Set
func whatsapp_EventPayload_ChatState_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.ChatState = *ptrFromHandle_whatsapp_ChatState(val)
}

//export whatsapp_EventPayload_Receipt_Get
func whatsapp_EventPayload_Receipt_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return handleFromPtr_whatsapp_Receipt(&op.Receipt)
}

//export whatsapp_EventPayload_Receipt_Set
func whatsapp_EventPayload_Receipt_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.Receipt = *ptrFromHandle_whatsapp_Receipt(val)
}

//export whatsapp_EventPayload_Group_Get
func whatsapp_EventPayload_Group_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return handleFromPtr_whatsapp_Group(&op.Group)
}

//export whatsapp_EventPayload_Group_Set
func whatsapp_EventPayload_Group_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.Group = *ptrFromHandle_whatsapp_Group(val)
}

//export whatsapp_EventPayload_Call_Get
func whatsapp_EventPayload_Call_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	return handleFromPtr_whatsapp_Call(&op.Call)
}

//export whatsapp_EventPayload_Call_Set
func whatsapp_EventPayload_Call_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_EventPayload(handle)
	op.Call = *ptrFromHandle_whatsapp_Call(val)
}

// --- wrapping struct: whatsapp.GroupSubject ---
//
//export whatsapp_GroupSubject_CTor
func whatsapp_GroupSubject_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_GroupSubject(&whatsapp.GroupSubject{}))
}

//export whatsapp_GroupSubject_Subject_Get
func whatsapp_GroupSubject_Subject_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_GroupSubject(handle)
	return C.CString(op.Subject)
}

//export whatsapp_GroupSubject_Subject_Set
func whatsapp_GroupSubject_Subject_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_GroupSubject(handle)
	op.Subject = C.GoString(val)
}

//export whatsapp_GroupSubject_SetAt_Get
func whatsapp_GroupSubject_SetAt_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_GroupSubject(handle)
	return C.longlong(op.SetAt)
}

//export whatsapp_GroupSubject_SetAt_Set
func whatsapp_GroupSubject_SetAt_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_GroupSubject(handle)
	op.SetAt = int64(val)
}

//export whatsapp_GroupSubject_SetBy_Get
func whatsapp_GroupSubject_SetBy_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_GroupSubject(handle)
	return C.CString(op.SetBy)
}

//export whatsapp_GroupSubject_SetBy_Set
func whatsapp_GroupSubject_SetBy_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_GroupSubject(handle)
	op.SetBy = C.GoString(val)
}

// --- wrapping struct: whatsapp.Poll ---
//
//export whatsapp_Poll_CTor
func whatsapp_Poll_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Poll(&whatsapp.Poll{}))
}

//export whatsapp_Poll_Title_Get
func whatsapp_Poll_Title_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Poll(handle)
	return C.CString(op.Title)
}

//export whatsapp_Poll_Title_Set
func whatsapp_Poll_Title_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Poll(handle)
	op.Title = C.GoString(val)
}

//export whatsapp_Poll_Options_Get
func whatsapp_Poll_Options_Get(handle CGoHandle) CGoHandle {
	op := ptrFromHandle_whatsapp_Poll(handle)
	return handleFromPtr_Slice_whatsapp_PollOption(&op.Options)
}

//export whatsapp_Poll_Options_Set
func whatsapp_Poll_Options_Set(handle CGoHandle, val CGoHandle) {
	op := ptrFromHandle_whatsapp_Poll(handle)
	op.Options = deptrFromHandle_Slice_whatsapp_PollOption(val)
}

// --- wrapping struct: whatsapp.Album ---
//
//export whatsapp_Album_CTor
func whatsapp_Album_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Album(&whatsapp.Album{}))
}

//export whatsapp_Album_IsAlbum_Get
func whatsapp_Album_IsAlbum_Get(handle CGoHandle) C.char {
	op := ptrFromHandle_whatsapp_Album(handle)
	return boolGoToPy(op.IsAlbum)
}

//export whatsapp_Album_IsAlbum_Set
func whatsapp_Album_IsAlbum_Set(handle CGoHandle, val C.char) {
	op := ptrFromHandle_whatsapp_Album(handle)
	op.IsAlbum = boolPyToGo(val)
}

//export whatsapp_Album_ImageCount_Get
func whatsapp_Album_ImageCount_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Album(handle)
	return C.longlong(op.ImageCount)
}

//export whatsapp_Album_ImageCount_Set
func whatsapp_Album_ImageCount_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Album(handle)
	op.ImageCount = int(val)
}

//export whatsapp_Album_VideoCount_Get
func whatsapp_Album_VideoCount_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_Album(handle)
	return C.longlong(op.VideoCount)
}

//export whatsapp_Album_VideoCount_Set
func whatsapp_Album_VideoCount_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_Album(handle)
	op.VideoCount = int(val)
}

// --- wrapping struct: whatsapp.Avatar ---
//
//export whatsapp_Avatar_CTor
func whatsapp_Avatar_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_Avatar(&whatsapp.Avatar{}))
}

//export whatsapp_Avatar_ID_Get
func whatsapp_Avatar_ID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Avatar(handle)
	return C.CString(op.ID)
}

//export whatsapp_Avatar_ID_Set
func whatsapp_Avatar_ID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Avatar(handle)
	op.ID = C.GoString(val)
}

//export whatsapp_Avatar_URL_Get
func whatsapp_Avatar_URL_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_Avatar(handle)
	return C.CString(op.URL)
}

//export whatsapp_Avatar_URL_Set
func whatsapp_Avatar_URL_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_Avatar(handle)
	op.URL = C.GoString(val)
}

// --- wrapping struct: whatsapp.ChatState ---
//
//export whatsapp_ChatState_CTor
func whatsapp_ChatState_CTor() CGoHandle {
	return CGoHandle(handleFromPtr_whatsapp_ChatState(&whatsapp.ChatState{}))
}

//export whatsapp_ChatState_Kind_Get
func whatsapp_ChatState_Kind_Get(handle CGoHandle) C.longlong {
	op := ptrFromHandle_whatsapp_ChatState(handle)
	return C.longlong(int(op.Kind))
}

//export whatsapp_ChatState_Kind_Set
func whatsapp_ChatState_Kind_Set(handle CGoHandle, val C.longlong) {
	op := ptrFromHandle_whatsapp_ChatState(handle)
	op.Kind = whatsapp.ChatStateKind(int(val))
}

//export whatsapp_ChatState_JID_Get
func whatsapp_ChatState_JID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_ChatState(handle)
	return C.CString(op.JID)
}

//export whatsapp_ChatState_JID_Set
func whatsapp_ChatState_JID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_ChatState(handle)
	op.JID = C.GoString(val)
}

//export whatsapp_ChatState_GroupJID_Get
func whatsapp_ChatState_GroupJID_Get(handle CGoHandle) *C.char {
	op := ptrFromHandle_whatsapp_ChatState(handle)
	return C.CString(op.GroupJID)
}

//export whatsapp_ChatState_GroupJID_Set
func whatsapp_ChatState_GroupJID_Set(handle CGoHandle, val *C.char) {
	op := ptrFromHandle_whatsapp_ChatState(handle)
	op.GroupJID = C.GoString(val)
}

// ---- Slices ---

// ---- Maps ---

// ---- Constructors ---

//export whatsapp_NewGateway
func whatsapp_NewGateway() CGoHandle {
	_saved_thread := C.PyEval_SaveThread()
	defer C.PyEval_RestoreThread(_saved_thread)
	return handleFromPtr_Ptr_whatsapp_Gateway(whatsapp.NewGateway())

}

// ---- Functions ---

//export whatsapp_IsAnonymousJID
func whatsapp_IsAnonymousJID(id *C.char) C.char {
	_saved_thread := C.PyEval_SaveThread()
	defer C.PyEval_RestoreThread(_saved_thread)
	return boolGoToPy(whatsapp.IsAnonymousJID(C.GoString(id)))

}
