"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Probe = exports.ConnectionScheme = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _action = require("./_action");
var ConnectionScheme;
(function (ConnectionScheme) {
    /**
     * Use HTTP request for connecting to host.
     */
    ConnectionScheme["HTTP"] = "HTTP";
    /**
     * Use HTTPS request for connecting to host.
     */
    ConnectionScheme["HTTPS"] = "HTTPS";
})(ConnectionScheme = exports.ConnectionScheme || (exports.ConnectionScheme = {}));
/**
 * Probe describes a health check to be performed against a container to
 * determine whether it is alive or ready to receive traffic.
 */
class Probe {
    constructor(probeOptions, tcpSocketOptions, commandOptions, httpGetOptions) {
        this.probeOptions = probeOptions;
        this.tcpSocketOptions = tcpSocketOptions;
        this.commandOptions = commandOptions;
        this.httpGetOptions = httpGetOptions;
    }
    /**
     * Defines a probe based on an HTTP GET request to the IP address of the container.
     *
     * @param path The URL path to hit
     * @param options Options
     */
    static fromHttpGet(path, options = {}) {
        return new Probe(options, undefined, undefined, { path, ...options });
    }
    /**
     * Defines a probe based on a command which is executed within the container.
     *
     * @param command The command to execute
     * @param options Options
     */
    static fromCommand(command, options = {}) {
        return new Probe(options, undefined, { command, ...options }, undefined);
    }
    /**
     * Defines a probe based opening a connection to a TCP socket on the container.
     *
     * @param options Options
     */
    static fromTcpSocket(options = {}) {
        return new Probe(options, options, undefined, undefined);
    }
    /**
     * @internal
     */
    _toKube(cont) {
        const exec = this.commandOptions ? _action.Action.fromCommand(this.commandOptions.command) : undefined;
        const httpGet = this.httpGetOptions ? _action.Action.fromHttpGet(cont, this.httpGetOptions.path, this.httpGetOptions) : undefined;
        const tcpSocket = this.tcpSocketOptions ? _action.Action.fromTcpSocket(cont, this.tcpSocketOptions) : undefined;
        return {
            failureThreshold: this.probeOptions.failureThreshold ?? 3,
            initialDelaySeconds: this.probeOptions.initialDelaySeconds ? this.probeOptions.initialDelaySeconds.toSeconds() : undefined,
            periodSeconds: this.probeOptions.periodSeconds ? this.probeOptions.periodSeconds.toSeconds() : undefined,
            successThreshold: this.probeOptions.successThreshold,
            timeoutSeconds: this.probeOptions.timeoutSeconds ? this.probeOptions.timeoutSeconds.toSeconds() : undefined,
            exec: exec,
            httpGet,
            tcpSocket,
        };
    }
}
exports.Probe = Probe;
_a = JSII_RTTI_SYMBOL_1;
Probe[_a] = { fqn: "cdk8s-plus-23.Probe", version: "2.4.9" };
//# sourceMappingURL=data:application/json;base64,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