"""Pioneer AVR commands."""

from .const import Zone
from .decoders.amp import (
    Volume,
    SourceName,
    SourceId,
    Source,
    SpeakerMode,
    HdmiOut,
    Hdmi3Out,
    HdmiAudio,
    Pqls,
    Dimmer,
    RemoteLock,
    SleepTime,
    AmpMode,
    PanelLock,
)
from .decoders.audio import (
    SpeakerChannelLevel,
    SpeakerChannel,
    AvailableListeningMode,
    ToneMode,
    ToneBass,
    ToneTreble,
)
from .decoders.code_map import CodeMapBase, CodeMapBlank, CodeMapQuery
from .decoders.dsp import (
    McaccMemorySet,
    PhaseControl,
    PhaseControlPlus,
    VirtualSpeakers,
    VirtualSoundback,
    VirtualHeight,
    VirtualWide,
    VirtualDepth,
    SoundRetriever,
    SignalSelect,
    InputAttenuator,
    Equalizer,
    StandingWave,
    SoundDelay,
    DigitalNoiseReduction,
    DialogEnhancement,
    AudioScaler,
    HiBit,
    UpSampling,
    DigitalFilter,
    DualMono,
    FixedPcm,
    DynamicRange,
    LfeAttenuator,
    SacdGain,
    AutoDelay,
    CenterWidth,
    Panorama,
    Dimension,
    CenterImage,
    Effect,
    HeightGain,
    LoudnessManagement,
    CenterSpread,
    RenderingMode,
)
from .decoders.system import SpeakerSystem
from .decoders.tuner import Preset
from .decoders.video import (
    VideoResolution,
    VideoConverter,
    VideoPureCinema,
    VideoProgMotion,
    VideoStreamSmoother,
    AdvancedVideoAdjust,
    VideoYnr,
    VideoCnr,
    VideoBnr,
    VideoMnr,
    VideoDetail,
    VideoSharpness,
    VideoBrightness,
    VideoContrast,
    VideoHue,
    VideoChroma,
    VideoBlackSetup,
    VideoAspect,
    VideoSuperResolution,
)

PIONEER_COMMANDS: dict[
    str, dict[Zone | str, str | list[str] | list[type[CodeMapBase]]]
] = {
    "query_model": {Zone.Z1: ["?RGD", "RGD"]},
    "system_query_mac_addr": {Zone.Z1: ["?SVB", "SVB"]},
    "system_query_software_version": {Zone.Z1: ["?SSI", "SSI"]},
    "turn_on": {
        Zone.Z1: ["PO", "PWR"],
        Zone.Z2: ["APO", "APR"],
        Zone.Z3: ["BPO", "BPR"],
        Zone.HDZ: ["ZEO", "ZEP"],
    },
    "turn_off": {
        Zone.Z1: ["PF", "PWR"],
        Zone.Z2: ["APF", "APR"],
        Zone.Z3: ["BPF", "BPR"],
        Zone.HDZ: ["ZEF", "ZEP"],
    },
    "select_source": {
        Zone.Z1: ["FN", "FN"],
        Zone.Z2: ["ZS", "Z2F"],
        Zone.Z3: ["ZT", "Z3F"],
        Zone.HDZ: ["ZEA", "ZEA"],
        "args": [Source],
    },
    "volume_up": {
        Zone.Z1: ["VU", "VOL"],
        Zone.Z2: ["ZU", "ZV"],
        Zone.Z3: ["YU", "YV"],
        Zone.HDZ: ["HZU", "XV"],
    },
    "volume_down": {
        Zone.Z1: ["VD", "VOL"],
        Zone.Z2: ["ZD", "ZV"],
        Zone.Z3: ["YD", "YV"],
        Zone.HDZ: ["HZD", "XV"],
    },
    "set_volume_level": {
        Zone.Z1: ["VL", "VOL"],
        Zone.Z2: ["ZV", "ZV"],
        Zone.Z3: ["YV", "YV"],
        Zone.HDZ: ["HZV", "XV"],
        "args": [Volume],
    },
    "mute_on": {
        Zone.Z1: ["MO", "MUT"],
        Zone.Z2: ["Z2MO", "Z2MUT"],
        Zone.Z3: ["Z3MO", "Z3MUT"],
        Zone.HDZ: ["HZMO", "HZMUT"],
    },
    "mute_off": {
        Zone.Z1: ["MF", "MUT"],
        Zone.Z2: ["Z2MF", "Z2MUT"],
        Zone.Z3: ["Z3MF", "Z3MUT"],
        Zone.HDZ: ["HZMF", "HZMUT"],
    },
    "query_power": {
        Zone.Z1: ["?P", "PWR"],
        Zone.Z2: ["?AP", "APR"],
        Zone.Z3: ["?BP", "BPR"],
        Zone.HDZ: ["?ZEP", "ZEP"],
    },
    "query_volume": {
        Zone.Z1: ["?V", "VOL"],
        Zone.Z2: ["?ZV", "ZV"],
        Zone.Z3: ["?YV", "YV"],
        Zone.HDZ: ["?HZV", "XV"],
    },
    "query_mute": {
        Zone.Z1: ["?M", "MUT"],
        Zone.Z2: ["?Z2M", "Z2MUT"],
        Zone.Z3: ["?Z3M", "Z3MUT"],
        Zone.HDZ: ["?HZM", "HZMUT"],
    },
    "query_source": {
        Zone.Z1: ["?F", "FN"],
        Zone.Z2: ["?ZS", "Z2F"],
        Zone.Z3: ["?ZT", "Z3F"],
        Zone.HDZ: ["?ZEA", "ZEA"],
    },
    "query_listening_mode": {Zone.Z1: ["?S", "SR"]},
    "set_listening_mode": {Zone.Z1: ["SR", "SR"], "args": [AvailableListeningMode]},
    ## basic
    "query_basic_audio_information": {Zone.Z1: ["?AST", "AST"]},
    "query_basic_video_information": {Zone.Z1: ["?VST", "VST"]},
    ## amp
    "query_amp_speaker_mode": {Zone.Z1: ["?SPK", "SPK"]},
    "set_amp_speaker_mode": {Zone.Z1: ["SPK", "SPK"], "args": [SpeakerMode]},
    "query_amp_hdmi_out": {Zone.Z1: ["?HO", "HO"]},
    "set_amp_hdmi_out": {Zone.Z1: ["HO", "HO"], "args": [HdmiOut]},
    "query_amp_hdmi3_out": {Zone.Z1: ["?HDO", "HDO"]},
    "set_amp_hdmi3_out": {Zone.Z1: ["HDO", "HDO"], "args": [Hdmi3Out]},
    "query_amp_hdmi_audio": {Zone.Z1: ["?HA", "HA"]},
    "set_amp_hdmi_audio": {Zone.Z1: ["HA", "HA"], "args": [HdmiAudio]},
    "query_amp_pqls": {Zone.Z1: ["?PQ", "PQ"]},
    "set_amp_pqls": {Zone.Z1: ["PQ", "PQ"], "args": [Pqls]},
    "set_amp_dimmer": {Zone.Z1: ["SAA", "SAA"], "args": [Dimmer]},
    ## NOTE: no amp dimmer query command
    "query_amp_sleep_time": {Zone.Z1: ["?SAB", "SAB"]},
    "set_amp_sleep_time": {Zone.Z1: ["SAB", "SAB"], "args": [SleepTime]},
    "query_amp_mode": {Zone.Z1: ["?SAC", "SAC"]},
    "set_amp_mode": {Zone.Z1: ["SAC", "SAC"], "args": [AmpMode]},
    "query_amp_panel_lock": {Zone.Z1: ["?PKL", "PKL"]},
    "set_amp_panel_lock": {Zone.Z1: ["PKL", "PKL"], "args": [PanelLock]},
    "query_amp_remote_lock": {Zone.Z1: ["?RML", "RML"]},
    "set_amp_remote_lock": {Zone.Z1: ["RML", "RML"], "args": [RemoteLock]},
    ## dsp
    "query_dsp_mcacc_memory_query": {Zone.Z1: ["?MC", "MC"]},
    "set_dsp_mcacc_memory_set": {Zone.Z1: ["MC", "MC"], "args": [McaccMemorySet]},
    "query_dsp_phase_control": {Zone.Z1: ["?IS", "IS"]},
    "set_dsp_phase_control": {Zone.Z1: ["IS", "IS"], "args": [PhaseControl]},
    "query_dsp_phase_control_plus": {Zone.Z1: ["?ATE", "ATE"]},
    "set_dsp_phase_control_plus": {
        Zone.Z1: ["ATE", "ATE"],
        "args": [PhaseControlPlus],
    },
    "query_dsp_virtual_speakers": {Zone.Z1: ["?VSP", "VSP"]},
    "set_dsp_virtual_speakers": {Zone.Z1: ["VSP", "VSP"], "args": [VirtualSpeakers]},
    "query_dsp_virtual_sb": {Zone.Z1: ["?VSB", "VSB"]},
    "set_dsp_virtual_sb": {Zone.Z1: ["VSB", "VSB"], "args": [VirtualSoundback]},
    "query_dsp_virtual_height": {Zone.Z1: ["?VHT", "VHT"]},
    "set_dsp_virtual_height": {Zone.Z1: ["VHT", "VHT"], "args": [VirtualHeight]},
    "query_dsp_virtual_wide": {Zone.Z1: ["?VWD", "VWD"]},
    "set_dsp_virtual_wide": {Zone.Z1: ["VWD", "VWD"], "args": [VirtualWide]},
    "query_dsp_virtual_depth": {Zone.Z1: ["?VDP", "VDP"]},
    "set_dsp_virtual_depth": {Zone.Z1: ["VDP", "VDP"], "args": [VirtualDepth]},
    "query_dsp_sound_retriever": {Zone.Z1: ["?ATA", "ATA"]},
    "set_dsp_sound_retriever": {Zone.Z1: ["ATA", "ATA"], "args": [SoundRetriever]},
    "query_dsp_signal_select": {Zone.Z1: ["?SDA", "SDA"]},
    "set_dsp_signal_select": {Zone.Z1: ["SDA", "SDA"], "args": [SignalSelect]},
    "query_dsp_input_attenuator": {Zone.Z1: ["?SDB", "SDB"]},
    "set_dsp_input_attenuator": {Zone.Z1: ["SDB", "SDB"], "args": [InputAttenuator]},
    "query_dsp_eq": {Zone.Z1: ["?ATC", "ATC"]},
    "set_dsp_eq": {Zone.Z1: ["ATC", "ATC"], "args": [Equalizer]},
    "query_dsp_standing_wave": {Zone.Z1: ["?ATD", "ATD"]},
    "set_dsp_standing_wave": {Zone.Z1: ["ATD", "ATD"], "args": [StandingWave]},
    "query_dsp_sound_delay": {Zone.Z1: ["?ATF", "ATF"]},
    "set_dsp_sound_delay": {Zone.Z1: ["ATF", "ATF"], "args": [SoundDelay]},
    "query_dsp_digital_noise_reduction": {Zone.Z1: ["?ATG", "ATG"]},
    "set_dsp_digital_noise_reduction": {
        Zone.Z1: ["ATG", "ATG"],
        "args": [DigitalNoiseReduction],
    },
    "query_dsp_dialog_enhancement": {Zone.Z1: ["?ATH", "ATH"]},
    "set_dsp_dialog_enhancement": {
        Zone.Z1: ["ATH", "ATH"],
        "args": [DialogEnhancement],
    },
    "query_dsp_audio_scaler": {Zone.Z1: ["?ATY", "ATY"]},
    "set_dsp_audio_scaler": {Zone.Z1: ["ATY", "ATY"], "args": [AudioScaler]},
    "query_dsp_hi_bit": {Zone.Z1: ["?ATI", "ATI"]},
    "set_dsp_hi_bit": {Zone.Z1: ["ATI", "ATI"], "args": [HiBit]},
    "query_dsp_up_sampling": {Zone.Z1: ["?ATZ", "ATZ"]},
    "set_dsp_up_sampling": {Zone.Z1: ["ATZ", "ATZ"], "args": [UpSampling]},
    "query_dsp_digital_filter": {Zone.Z1: ["?ATV", "ATV"]},
    "set_dsp_digital_filter": {Zone.Z1: ["ATV", "ATV"], "args": [DigitalFilter]},
    "query_dsp_dual_mono": {Zone.Z1: ["?ATJ", "ATJ"]},
    "set_dsp_dual_mono": {Zone.Z1: ["ATJ", "ATJ"], "args": [DualMono]},
    "query_dsp_fixed_pcm": {Zone.Z1: ["?ATK", "ATK"]},
    "set_dsp_fixed_pcm": {Zone.Z1: ["ATK", "ATK"], "args": [FixedPcm]},
    "query_dsp_dynamic_range": {Zone.Z1: ["?ATL", "ATL"]},
    "set_dsp_dynamic_range": {Zone.Z1: ["ATL", "ATL"], "args": [DynamicRange]},
    "query_dsp_lfe_attenuator": {Zone.Z1: ["?ATM", "ATM"]},
    "set_dsp_lfe_attenuator": {Zone.Z1: ["ATM", "ATM"], "args": [LfeAttenuator]},
    "query_dsp_sacd_gain": {Zone.Z1: ["?ATN", "ATN"]},
    "set_dsp_sacd_gain": {Zone.Z1: ["ATN", "ATN"], "args": [SacdGain]},
    "query_dsp_auto_delay": {Zone.Z1: ["?ATO", "ATO"]},
    "set_dsp_auto_delay": {Zone.Z1: ["ATO", "ATO"], "args": [AutoDelay]},
    "query_dsp_center_width": {Zone.Z1: ["?ATP", "ATP"]},
    "set_dsp_center_width": {Zone.Z1: ["ATP", "ATP"], "args": [CenterWidth]},
    "query_dsp_panorama": {Zone.Z1: ["?ATQ", "ATQ"]},
    "set_dsp_panorama": {Zone.Z1: ["ATQ", "ATQ"], "args": [Panorama]},
    "query_dsp_dimension": {Zone.Z1: ["?ATR", "ATR"]},
    "set_dsp_dimension": {Zone.Z1: ["ATR", "ATR"], "args": [Dimension]},
    "query_dsp_center_image": {Zone.Z1: ["?ATS", "ATS"]},
    "set_dsp_center_image": {Zone.Z1: ["ATS", "ATS"], "args": [CenterImage]},
    "query_dsp_effect": {Zone.Z1: ["?ATT", "ATT"]},
    "set_dsp_effect": {Zone.Z1: ["ATT", "ATT"], "args": [Effect]},
    "query_dsp_height_gain": {Zone.Z1: ["?ATU", "ATU"]},
    "set_dsp_height_gain": {Zone.Z1: ["ATU", "ATU"], "args": [HeightGain]},
    "query_dsp_loudness_management": {Zone.Z1: ["?ATW", "ATW"]},
    "set_dsp_loudness_management": {
        Zone.Z1: ["ATW", "ATW"],
        "args": [LoudnessManagement],
    },
    "query_center_spread": {Zone.Z1: ["?ARA", "ARA"]},
    "set_dsp_center_spread": {Zone.Z1: ["ARA", "ARA"], "args": [CenterSpread]},
    "query_rendering_mode": {Zone.Z1: ["?ARB", "ARB"]},
    "set_dsp_rendering_mode": {Zone.Z1: ["ARB", "ARB"], "args": [RenderingMode]},
    ## tone
    "query_tone_status": {Zone.Z1: ["?TO", "TO"], Zone.Z2: ["?ZGA", "ZGA"]},
    "query_tone_bass": {Zone.Z1: ["?BA", "BA"], Zone.Z2: ["?ZGB", "ZGB"]},
    "query_tone_treble": {Zone.Z1: ["?TR", "TR"], Zone.Z2: ["?ZGC", "ZGC"]},
    "set_tone_mode": {
        Zone.Z1: ["TO", "TO"],
        Zone.Z2: ["ZGA", "ZGA"],
        "args": [ToneMode],
    },
    "set_tone_bass": {
        Zone.Z1: ["BA", "BA"],
        Zone.Z2: ["ZGB", "ZGB"],
        "args": [ToneBass],
    },
    "set_tone_treble": {
        Zone.Z1: ["TR", "TR"],
        Zone.Z2: ["ZGC", "ZGC"],
        "args": [ToneTreble],
    },
    ## channels
    "set_channel_levels": {
        Zone.Z1: ["CLV", "CLV"],
        Zone.Z2: ["ZGE", "ZGE"],
        Zone.Z3: ["ZHE", "ZHE"],
        "args": [SpeakerChannelLevel],
    },
    "query_channel_levels": {
        Zone.Z1: ["CLV", "CLV"],
        Zone.Z2: ["ZGE", "ZGE"],
        Zone.Z3: ["ZHE", "ZHE"],
        "args": [CodeMapQuery(SpeakerChannel)],
    },
    ## video
    "query_video_resolution": {Zone.Z1: ["?VTC", "VTC"]},
    "set_video_resolution": {Zone.Z1: ["VTC", "VTC"], "args": [VideoResolution]},
    "query_video_converter": {Zone.Z1: ["?VTB", "VTB"]},
    "set_video_converter": {Zone.Z1: ["VTB", "VTB"], "args": [VideoConverter]},
    "query_video_pure_cinema": {Zone.Z1: ["?VTD", "VTD"]},
    "set_video_pure_cinema": {Zone.Z1: ["VTD", "VTD"], "args": [VideoPureCinema]},
    "query_video_prog_motion": {Zone.Z1: ["?VTE", "VTE"]},
    "set_video_prog_motion": {Zone.Z1: ["VTE", "VTE"], "args": [VideoProgMotion]},
    "query_video_stream_smoother": {Zone.Z1: ["?VTF", "VTF"]},
    "set_video_stream_smoother": {
        Zone.Z1: ["VTF", "VTF"],
        "args": [VideoStreamSmoother],
    },
    "query_video_advanced_video_adjust": {Zone.Z1: ["?VTG", "VTG"]},
    "set_video_advanced_video_adjust": {
        Zone.Z1: ["VTG", "VTG"],
        "args": [AdvancedVideoAdjust],
    },
    "query_video_ynr": {Zone.Z1: ["?VTH", "VTH"]},
    "set_video_ynr": {Zone.Z1: ["VTH", "VTH"], "args": [VideoYnr]},
    "query_video_cnr": {Zone.Z1: ["?VTI", "VTI"]},
    "set_video_cnr": {Zone.Z1: ["VTI", "VTI"], "args": [VideoCnr]},
    "query_video_bnr": {Zone.Z1: ["?VTJ", "VTJ"]},
    "set_video_bnr": {Zone.Z1: ["VTJ", "VTJ"], "args": [VideoBnr]},
    "query_video_mnr": {Zone.Z1: ["?VTK", "VTK"]},
    "set_video_mnr": {Zone.Z1: ["VTK", "VTK"], "args": [VideoMnr]},
    "query_video_detail": {Zone.Z1: ["?VTL", "VTL"]},
    "set_video_detail": {Zone.Z1: ["VTL", "VTL"], "args": [VideoDetail]},
    "query_video_sharpness": {Zone.Z1: ["?VTM", "VTM"]},
    "set_video_sharpness": {Zone.Z1: ["VTM", "VTM"], "args": [VideoSharpness]},
    "query_video_brightness": {Zone.Z1: ["?VTN", "VTN"]},
    "set_video_brightness": {Zone.Z1: ["VTN", "VTN"], "args": [VideoBrightness]},
    "query_video_contrast": {Zone.Z1: ["?VTO", "VTO"]},
    "set_video_contrast": {Zone.Z1: ["VTO", "VTO"], "args": [VideoContrast]},
    "query_video_hue": {Zone.Z1: ["?VTP", "VTP"]},
    "set_video_hue": {Zone.Z1: ["VTP", "VTP"], "args": [VideoHue]},
    "query_video_chroma": {Zone.Z1: ["?VTQ", "VTQ"]},
    "set_video_chroma": {Zone.Z1: ["VTQ", "VTQ"], "args": [VideoChroma]},
    "query_video_black_setup": {Zone.Z1: ["?VTR", "VTR"]},
    "set_video_black_setup": {Zone.Z1: ["VTR", "VTR"], "args": [VideoBlackSetup]},
    "query_video_aspect": {Zone.Z1: ["?VTS", "VTS"]},
    "set_video_aspect": {Zone.Z1: ["VTS", "VTS"], "args": [VideoAspect]},
    "query_video_super_resolution": {Zone.Z1: ["?VTT", "VTT"]},
    "set_video_super_resolution": {
        Zone.Z1: ["VTT", "VTT"],
        "args": [VideoSuperResolution],
    },
    ## operation
    "operation_direct_access": {Zone.Z1: ["TAC", "TAC"]},
    "operation_tuner_digit": {Zone.Z1: ["TP", "TP"]},
    "operation_tuner_edit": {Zone.Z1: "02TN"},
    "operation_tuner_enter": {Zone.Z1: "03TN"},
    "operation_tuner_return": {Zone.Z1: "04TN"},
    "operation_tuner_mpx_noise_cut": {Zone.Z1: "05TN"},
    "operation_tuner_display": {Zone.Z1: "06TN"},
    "operation_tuner_pty_search": {Zone.Z1: "07TN"},
    "operation_ipod_play": {Zone.Z1: "00IP"},
    "operation_ipod_pause": {Zone.Z1: "01IP"},
    "operation_ipod_stop": {Zone.Z1: "02IP"},
    "operation_ipod_previous": {Zone.Z1: "03IP"},
    "operation_ipod_next": {Zone.Z1: "04IP"},
    "operation_ipod_rewind": {Zone.Z1: "05IP"},
    "operation_ipod_fastforward": {Zone.Z1: "06IP"},
    "operation_ipod_repeat": {Zone.Z1: "07IP"},
    "operation_ipod_shuffle": {Zone.Z1: "08IP"},
    "operation_ipod_display": {Zone.Z1: "09IP"},
    "operation_ipod_control": {Zone.Z1: "10IP"},
    "operation_ipod_cursor_up": {Zone.Z1: "13IP"},
    "operation_ipod_cursor_down": {Zone.Z1: "14IP"},
    "operation_ipod_cursor_left": {Zone.Z1: "16IP"},
    "operation_ipod_cursor_right": {Zone.Z1: "15IP"},
    "operation_ipod_enter": {Zone.Z1: "17IP"},
    "operation_ipod_return": {Zone.Z1: "18IP"},
    "operation_ipod_top_menu": {Zone.Z1: "19IP"},
    "operation_ipod_iphone_direct_control": {Zone.Z1: "20IP"},
    "operation_network_play": {Zone.Z1: "10NW"},
    "operation_network_pause": {Zone.Z1: "11NW"},
    "operation_network_stop": {Zone.Z1: "20NW"},
    "operation_network_fastforward": {Zone.Z1: "15NW"},
    "operation_network_rewind": {Zone.Z1: "14NW"},
    "operation_network_next": {Zone.Z1: "13NW"},
    "operation_network_previous": {Zone.Z1: "12NW"},
    "operation_network_repeat": {Zone.Z1: "34NW"},
    "operation_network_random": {Zone.Z1: "35NW"},
    "operation_adapaterport_play": {Zone.Z1: "10BT"},
    "operation_adapaterport_pause": {Zone.Z1: "11BT"},
    "operation_adapaterport_stop": {Zone.Z1: "12BT"},
    "operation_adapaterport_previous": {Zone.Z1: "13BT"},
    "operation_adapaterport_next": {Zone.Z1: "14BT"},
    "operation_adapaterport_rewind": {Zone.Z1: "15BT"},
    "operation_adapaterport_fastforward": {Zone.Z1: "16BT"},
    "operation_adapaterport_repeat": {Zone.Z1: "17BT"},
    "operation_adapaterport_random": {Zone.Z1: "18BT"},
    "operation_mhl_play": {Zone.Z1: "23MHL"},
    "operation_mhl_pause": {Zone.Z1: "25MHL"},
    "operation_mhl_stop": {Zone.Z1: "24MHL"},
    "operation_mhl_record": {Zone.Z1: "26MHL"},
    "operation_mhl_rewind": {Zone.Z1: "27MHL"},
    "operation_mhl_fastforward": {Zone.Z1: "28MHL"},
    "operation_mhl_eject": {Zone.Z1: "29MHL"},
    "operation_mhl_next": {Zone.Z1: "30MHL"},
    "operation_mhl_previous": {Zone.Z1: "31MHL"},
    "operation_amp_status_display": {Zone.Z1: "STS"},
    "operation_amp_cursor_up": {Zone.Z1: "CUP"},
    "operation_amp_cursor_down": {Zone.Z1: "CDN"},
    "operation_amp_cursor_right": {Zone.Z1: "CRI"},
    "operation_amp_cursor_left": {Zone.Z1: "CLE"},
    "operation_amp_cursor_enter": {Zone.Z1: "CEN"},
    "operation_amp_cursor_return": {Zone.Z1: "CRT"},
    "operation_amp_audio_parameter": {Zone.Z1: "ATA"},
    "operation_amp_output_parameter": {Zone.Z1: "HPA"},
    "operation_amp_video_parameter": {Zone.Z1: "VPA"},
    "operation_amp_channel_select": {Zone.Z1: "CLC"},
    "operation_amp_home_menu": {Zone.Z1: "HM"},
    "operation_amp_key_off": {Zone.Z1: "KOF"},
    ## tuner
    "query_tuner_am_step": {Zone.Z1: ["?SUQ", "SUQ"]},
    "query_tuner_preset": {Zone.Z1: ["?PR", "PR"]},
    "query_tuner_frequency": {Zone.Z1: ["?FR", "FR"]},
    "select_tuner_preset": {Zone.Z1: ["PR", "PR"], "args": [Preset]},
    "increase_tuner_preset": {Zone.Z1: ["TPI", "PR"]},
    "decrease_tuner_preset": {Zone.Z1: ["TPD", "PR"]},
    "set_tuner_band_am": {Zone.Z1: ["01TN", "FR"]},
    "set_tuner_band_fm": {Zone.Z1: ["00TN", "FR"]},
    "increase_tuner_frequency": {Zone.Z1: ["TFI", "FR"]},
    "decrease_tuner_frequency": {Zone.Z1: ["TFD", "FR"]},
    ## system
    "query_system_speaker_system": {Zone.Z1: ["?SSF", "SSF"]},
    "set_system_speaker_system": {Zone.Z1: ["?SSF", "SSF"], "args": [SpeakerSystem]},
    "query_source_name": {Zone.Z1: ["?RGB", "RGB"], "args": [CodeMapBlank(), SourceId]},
    "set_source_name": {Zone.Z1: ["1RGB", "RGB"], "args": [SourceName, SourceId]},
    "set_default_source_name": {
        Zone.Z1: ["0RGB", "RGB"],
        "args": [CodeMapBlank(), SourceId],
    },
    "query_system_home_menu_status": {Zone.Z1: ["?SSL", "SSL"]},
    "query_system_mcacc_diagnostics": {Zone.Z1: ["?SSJ", "SSJ"]},
    "query_system_standing_wave_status": {Zone.Z1: ["?SUU", "SUU"]},
    "query_system_standing_wave_sw_trim": {Zone.Z1: ["?SUV", "SUV"]},
    "query_system_surround_position": {Zone.Z1: ["?SSP", "SSP"]},
    "query_system_x_over": {Zone.Z1: ["?SSQ", "SSQ"]},
    "query_system_x_curve": {Zone.Z1: ["?SST", "SST"]},
    "query_system_loudness_plus": {Zone.Z1: ["?SSU", "SSU"]},
    "query_system_sbch_processing": {Zone.Z1: ["?SSV", "SSV"]},
    "query_system_speaker_setting": {Zone.Z1: ["?SSG", "SSG"]},
    "query_system_mcacc_channel_level": {Zone.Z1: ["?SSR", "SSR"]},
    "query_system_mcacc_speaker_distance": {Zone.Z1: ["?SSS", "SSS"]},
    "query_system_input_level": {Zone.Z1: ["?ILA", "ILA"]},
    "query_system_thx_ultraselect2": {Zone.Z1: ["?SSW", "SSW"]},
    "query_system_boundary_gain_compression": {Zone.Z1: ["?SSX", "SSX"]},
    "query_system_re_equalization": {Zone.Z1: ["?SSB", "SSB"]},
    "query_system_osd_language": {Zone.Z1: ["?SSE", "SSE"]},
    "query_system_network_dhcp": {Zone.Z1: ["?STA", "STA"]},
    "query_system_network_proxy_active": {Zone.Z1: ["?STG", "STG"]},
    "query_system_network_standby": {Zone.Z1: ["?STJ", "STJ"]},
    "query_system_friendly_name": {Zone.Z1: ["?SSO", "SSO"]},
    "query_system_parental_lock": {Zone.Z1: ["?STK", "STK"]},
    "query_system_parental_lock_password": {Zone.Z1: ["?STL", "STL"]},
    "query_system_ip_control_port": {Zone.Z1: ["?SUM", "SUM"]},
    "query_system_hdmi_control": {Zone.Z1: ["?STQ", "STQ"]},
    "query_system_hdmi_control_mode": {Zone.Z1: ["?STR", "STR"]},
    "query_system_hdmi_arc": {Zone.Z1: ["?STT", "STT"]},
    "query_system_pqls_for_backup": {Zone.Z1: ["?SVL", "SVL"]},
    "query_system_standby_passthrough": {Zone.Z1: ["?STU", "STU"]},
    "query_system_external_hdmi_trigger_1": {Zone.Z1: ["?STV", "STV"]},
    "query_system_external_hdmi_trigger_2": {Zone.Z2: ["?STW", "STW"]},
    "query_system_speaker_b_link": {Zone.Z1: ["?STX", "STX"]},
    "query_system_osd_overlay": {Zone.Z1: ["?SVA", "SVA"]},
    "query_system_additional_service": {Zone.Z1: ["?ADS", "ADS"]},
    "query_system_user_lock": {Zone.Z1: ["?SUT", "SUT"]},
    ## display
    "query_display_information": {Zone.Z1: ["?FL", "FL"]},
}
