# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
# ruff: noqa: PLR0904
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from pkgs.serialization import OpaqueKey
import uncountable.types.api.recipes.add_recipe_to_project as add_recipe_to_project_t
import uncountable.types.api.recipes.archive_recipes as archive_recipes_t
import uncountable.types.api.equipment.associate_equipment_input as associate_equipment_input_t
import uncountable.types.api.recipes.associate_recipe_as_input as associate_recipe_as_input_t
import uncountable.types.api.recipes.associate_recipe_as_lot as associate_recipe_as_lot_t
from uncountable.types import async_batch_t
from uncountable.types import base_t
import uncountable.types.api.chemical.convert_chemical_formats as convert_chemical_formats_t
import uncountable.types.api.entity.create_entities as create_entities_t
import uncountable.types.api.entity.create_entity as create_entity_t
import uncountable.types.api.inputs.create_inputs as create_inputs_t
import uncountable.types.api.recipes.create_recipe as create_recipe_t
import uncountable.types.api.recipe_links.create_recipe_link as create_recipe_link_t
import uncountable.types.api.recipes.create_recipes as create_recipes_t
import uncountable.types.api.recipes.disassociate_recipe_as_input as disassociate_recipe_as_input_t
import uncountable.types.api.recipes.edit_recipe_inputs as edit_recipe_inputs_t
from uncountable.types import entity_t
import uncountable.types.api.batch.execute_batch as execute_batch_t
import uncountable.types.api.batch.execute_batch_load_async as execute_batch_load_async_t
from uncountable.types import field_values_t
import uncountable.types.api.recipes.get_curve as get_curve_t
import uncountable.types.api.entity.get_entities_data as get_entities_data_t
import uncountable.types.api.inputs.get_input_data as get_input_data_t
import uncountable.types.api.input_groups.get_input_group_names as get_input_group_names_t
import uncountable.types.api.inputs.get_input_names as get_input_names_t
import uncountable.types.api.inputs.get_inputs_data as get_inputs_data_t
import uncountable.types.api.outputs.get_output_data as get_output_data_t
import uncountable.types.api.outputs.get_output_names as get_output_names_t
import uncountable.types.api.project.get_projects as get_projects_t
import uncountable.types.api.project.get_projects_data as get_projects_data_t
import uncountable.types.api.recipes.get_recipe_calculations as get_recipe_calculations_t
import uncountable.types.api.recipes.get_recipe_links as get_recipe_links_t
import uncountable.types.api.recipe_metadata.get_recipe_metadata_data as get_recipe_metadata_data_t
import uncountable.types.api.recipes.get_recipe_names as get_recipe_names_t
import uncountable.types.api.recipes.get_recipe_output_metadata as get_recipe_output_metadata_t
import uncountable.types.api.recipes.get_recipes_data as get_recipes_data_t
from uncountable.types import id_source_t
from uncountable.types import identifier_t
import uncountable.types.api.uploader.invoke_uploader as invoke_uploader_t
import uncountable.types.api.entity.list_entities as list_entities_t
import uncountable.types.api.id_source.list_id_source as list_id_source_t
import uncountable.types.api.entity.lock_entity as lock_entity_t
import uncountable.types.api.recipes.lock_recipes as lock_recipes_t
import uncountable.types.api.id_source.match_id_source as match_id_source_t
from uncountable.types import permissions_t
from uncountable.types import post_base_t
from uncountable.types import recipe_identifiers_t
from uncountable.types import recipe_links_t
from uncountable.types import recipe_metadata_t
from uncountable.types import recipe_workflow_steps_t
import uncountable.types.api.recipes.remove_recipe_from_project as remove_recipe_from_project_t
import uncountable.types.api.recipe_links.remove_recipe_link as remove_recipe_link_t
import uncountable.types.api.entity.resolve_entity_ids as resolve_entity_ids_t
import uncountable.types.api.outputs.resolve_output_conditions as resolve_output_conditions_t
import uncountable.types.api.triggers.run_trigger as run_trigger_t
import uncountable.types.api.permissions.set_core_permissions as set_core_permissions_t
import uncountable.types.api.inputs.set_input_attribute_values as set_input_attribute_values_t
import uncountable.types.api.inputs.set_input_category as set_input_category_t
import uncountable.types.api.inputs.set_input_subcategories as set_input_subcategories_t
import uncountable.types.api.inputs.set_intermediate_type as set_intermediate_type_t
import uncountable.types.api.recipes.set_recipe_inputs as set_recipe_inputs_t
import uncountable.types.api.recipes.set_recipe_metadata as set_recipe_metadata_t
import uncountable.types.api.recipes.set_recipe_output_annotations as set_recipe_output_annotations_t
import uncountable.types.api.recipes.set_recipe_outputs as set_recipe_outputs_t
import uncountable.types.api.recipes.set_recipe_tags as set_recipe_tags_t
import uncountable.types.api.entity.set_values as set_values_t
import uncountable.types.api.entity.transition_entity_phase as transition_entity_phase_t
import uncountable.types.api.recipes.unarchive_recipes as unarchive_recipes_t
import uncountable.types.api.entity.unlock_entity as unlock_entity_t
import uncountable.types.api.recipes.unlock_recipes as unlock_recipes_t
import uncountable.types.api.material_families.update_entity_material_families as update_entity_material_families_t
import uncountable.types.api.field_options.upsert_field_options as upsert_field_options_t
from abc import ABC, abstractmethod
import dataclasses

DT = typing.TypeVar("DT")


@dataclasses.dataclass(kw_only=True)
class APIRequest:
    method: str
    endpoint: str
    args: typing.Any


class ClientMethods(ABC):

    @abstractmethod
    def do_request(self, *, api_request: APIRequest, return_type: type[DT]) -> DT:
        ...

    def add_recipe_to_project(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        project_key: identifier_t.IdentifierKey,
    ) -> add_recipe_to_project_t.Data:
        """Adds a recipe to a project

        :param recipe_key: The identifier key of the recipe to add to the project
        :param project_key: The identifier key of the project to add the recipe to
        """
        args = add_recipe_to_project_t.Arguments(
            recipe_key=recipe_key,
            project_key=project_key,
        )
        api_request = APIRequest(
            method=add_recipe_to_project_t.ENDPOINT_METHOD,
            endpoint=add_recipe_to_project_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=add_recipe_to_project_t.Data)

    def archive_recipes(
        self,
        *,
        recipes: list[identifier_t.IdentifierKey],
        reason: typing.Optional[str] = None,
    ) -> archive_recipes_t.Data:
        """Archive the provided recipes and their children

        :param recipes: Identifier for the recipe
        :param reason: This reason will be written to the audit log archive entry
        """
        args = archive_recipes_t.Arguments(
            recipes=recipes,
            reason=reason,
        )
        api_request = APIRequest(
            method=archive_recipes_t.ENDPOINT_METHOD,
            endpoint=archive_recipes_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=archive_recipes_t.Data)

    def associate_equipment_input(
        self,
        *,
        equipment_key: identifier_t.IdentifierKey,
        material_family_ids: list[base_t.ObjectId],
    ) -> associate_equipment_input_t.Data:
        """Create or return the input association for equipment

        :param equipment_key: Identifier of the equipment to associate
        :param material_family_ids: The list of material families to add the input to. This must be non-empty
        """
        args = associate_equipment_input_t.Arguments(
            equipment_key=equipment_key,
            material_family_ids=material_family_ids,
        )
        api_request = APIRequest(
            method=associate_equipment_input_t.ENDPOINT_METHOD,
            endpoint=associate_equipment_input_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=associate_equipment_input_t.Data)

    def associate_recipe_as_input(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        input_key: typing.Optional[identifier_t.IdentifierKey] = None,
        show_in_listings: typing.Optional[bool] = None,
    ) -> associate_recipe_as_input_t.Data:
        """Create or return the input association for a recipe

        :param recipe_key: Identifier for the recipe
        :param input_key: Identifier for an input to use for the association.  Optionally supplied.  If not supplied, one is created
        :param show_in_listings: After associating the input should it be present in listings
        """
        args = associate_recipe_as_input_t.Arguments(
            recipe_key=recipe_key,
            input_key=input_key,
            show_in_listings=show_in_listings,
        )
        api_request = APIRequest(
            method=associate_recipe_as_input_t.ENDPOINT_METHOD,
            endpoint=associate_recipe_as_input_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=associate_recipe_as_input_t.Data)

    def associate_recipe_as_lot(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        ingredient_key: identifier_t.IdentifierKey,
    ) -> associate_recipe_as_lot_t.Data:
        """Create a new lot association for the provided recipe with the provided ingredient

        :param recipe_key: Identifier for the recipe
        :param ingredient_key: Identifier for the ingredient
        """
        args = associate_recipe_as_lot_t.Arguments(
            recipe_key=recipe_key,
            ingredient_key=ingredient_key,
        )
        api_request = APIRequest(
            method=associate_recipe_as_lot_t.ENDPOINT_METHOD,
            endpoint=associate_recipe_as_lot_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=associate_recipe_as_lot_t.Data)

    def convert_chemical_formats(
        self,
        *,
        source_chemical_structures: list[convert_chemical_formats_t.ChemicalStructureFile],
    ) -> convert_chemical_formats_t.Data:
        """Converts chemical formats, into the format used by Uncountable and usable in other APIs for eg. set_input_attribute_values

        """
        args = convert_chemical_formats_t.Arguments(
            source_chemical_structures=source_chemical_structures,
        )
        api_request = APIRequest(
            method=convert_chemical_formats_t.ENDPOINT_METHOD,
            endpoint=convert_chemical_formats_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=convert_chemical_formats_t.Data)

    def create_entities(
        self,
        *,
        definition_id: base_t.ObjectId,
        entity_type: typing.Union[typing.Literal[entity_t.EntityType.LAB_REQUEST], typing.Literal[entity_t.EntityType.APPROVAL], typing.Literal[entity_t.EntityType.CUSTOM_ENTITY], typing.Literal[entity_t.EntityType.INVENTORY_AMOUNT], typing.Literal[entity_t.EntityType.TASK], typing.Literal[entity_t.EntityType.PROJECT], typing.Literal[entity_t.EntityType.EQUIPMENT], typing.Literal[entity_t.EntityType.INV_LOCAL_LOCATIONS], typing.Literal[entity_t.EntityType.FIELD_OPTION_SET], typing.Literal[entity_t.EntityType.WEBHOOK]],
        entities_to_create: list[create_entities_t.EntityToCreate],
    ) -> create_entities_t.Data:
        """Creates new Uncountable entities

        :param definition_id: Definition id for the entities to create
        :param entity_type: The type of the entities to create
        :param entities_to_create: A list of the entities to create
        """
        args = create_entities_t.Arguments(
            definition_id=definition_id,
            entity_type=entity_type,
            entities_to_create=entities_to_create,
        )
        api_request = APIRequest(
            method=create_entities_t.ENDPOINT_METHOD,
            endpoint=create_entities_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_entities_t.Data)

    def create_entity(
        self,
        *,
        definition_id: base_t.ObjectId,
        entity_type: typing.Union[typing.Literal[entity_t.EntityType.LAB_REQUEST], typing.Literal[entity_t.EntityType.APPROVAL], typing.Literal[entity_t.EntityType.CUSTOM_ENTITY], typing.Literal[entity_t.EntityType.INVENTORY_AMOUNT], typing.Literal[entity_t.EntityType.TASK], typing.Literal[entity_t.EntityType.PROJECT], typing.Literal[entity_t.EntityType.EQUIPMENT], typing.Literal[entity_t.EntityType.INV_LOCAL_LOCATIONS], typing.Literal[entity_t.EntityType.FIELD_OPTION_SET], typing.Literal[entity_t.EntityType.WEBHOOK]],
        field_values: typing.Optional[typing.Optional[list[field_values_t.FieldRefNameValue]]] = None,
    ) -> create_entity_t.Data:
        """Creates a new Uncountable entity

        :param definition_id: Definition id of the entity to create
        :param entity_type: The type of the entities requested
        """
        args = create_entity_t.Arguments(
            definition_id=definition_id,
            entity_type=entity_type,
            field_values=field_values,
        )
        api_request = APIRequest(
            method=create_entity_t.ENDPOINT_METHOD,
            endpoint=create_entity_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_entity_t.Data)

    def external_create_inputs(
        self,
        *,
        inputs_to_create: list[create_inputs_t.InputToCreate],
    ) -> create_inputs_t.Data:
        """Creates new inputs

        :param inputs_to_create: A list of inputs to create
        """
        args = create_inputs_t.Arguments(
            inputs_to_create=inputs_to_create,
        )
        api_request = APIRequest(
            method=create_inputs_t.ENDPOINT_METHOD,
            endpoint=create_inputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_inputs_t.Data)

    def create_recipe(
        self,
        *,
        material_family_id: base_t.ObjectId,
        workflow_id: base_t.ObjectId,
        name: typing.Optional[str] = None,
        project_id: typing.Optional[base_t.ObjectId] = None,
        workflow_variant_id: typing.Optional[typing.Optional[base_t.ObjectId]] = None,
        recipe_metadata: typing.Optional[list[recipe_metadata_t.MetadataValue]] = None,
        identifiers: typing.Optional[recipe_identifiers_t.RecipeIdentifiers] = None,
        definition_key: typing.Optional[identifier_t.IdentifierKey] = None,
    ) -> create_recipe_t.Data:
        """Returns the id of the recipe being created.

        :param name: The name for the recipe
        :param material_family_id: The material family for the recipe
        :param project_id: The identifier of the project to create the recipe in
        :param workflow_id: The identifier of the workflow to create the recipe with
        :param workflow_variant_id: The identifier of the workflow variant to create the recipe with
        :param recipe_metadata: Metadata values to populate the recipe with
        :param identifiers: A recipe won't be created if it matches the identifier.  An identifier must be unique in the schema
        :param definition_key: The entity definition identifier, default is used if not supplied
        """
        args = create_recipe_t.Arguments(
            name=name,
            material_family_id=material_family_id,
            project_id=project_id,
            workflow_id=workflow_id,
            workflow_variant_id=workflow_variant_id,
            recipe_metadata=recipe_metadata,
            identifiers=identifiers,
            definition_key=definition_key,
        )
        api_request = APIRequest(
            method=create_recipe_t.ENDPOINT_METHOD,
            endpoint=create_recipe_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_recipe_t.Data)

    def create_recipe_link(
        self,
        *,
        recipe_from_key: identifier_t.IdentifierKey,
        recipe_to_key: identifier_t.IdentifierKey,
        link_type: typing.Union[typing.Literal[recipe_links_t.RecipeLinkType.CHILD], typing.Literal[recipe_links_t.RecipeLinkType.CONTROL], typing.Literal[recipe_links_t.RecipeLinkType.USER_LINK]],
        name: str,
    ) -> create_recipe_link_t.Data:
        """Create a link between two recipes.  Skip if the link already exists

        :param recipe_from_key: Identifier for the recipe the link comes from
        :param recipe_to_key: Identifier for the recipe the link goes to
        :param link_type: The type of link being created
        :param name: The name used for the link
        """
        args = create_recipe_link_t.Arguments(
            recipe_from_key=recipe_from_key,
            recipe_to_key=recipe_to_key,
            link_type=link_type,
            name=name,
        )
        api_request = APIRequest(
            method=create_recipe_link_t.ENDPOINT_METHOD,
            endpoint=create_recipe_link_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_recipe_link_t.Data)

    def create_recipes(
        self,
        *,
        material_family_id: base_t.ObjectId,
        recipe_definitions: list[create_recipes_t.CreateRecipeDefinition],
        project_id: typing.Optional[base_t.ObjectId] = None,
    ) -> create_recipes_t.Data:
        """Sets inputs values for an experiment. Values set can be numeric, text or categorical types in the Uncountable system

        :param material_family_id: The identifier of the material family to create the recipes in
        :param project_id: The identifier of the project to create the recipes in
        """
        args = create_recipes_t.Arguments(
            material_family_id=material_family_id,
            project_id=project_id,
            recipe_definitions=recipe_definitions,
        )
        api_request = APIRequest(
            method=create_recipes_t.ENDPOINT_METHOD,
            endpoint=create_recipes_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=create_recipes_t.Data)

    def disassociate_recipe_as_input(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
    ) -> disassociate_recipe_as_input_t.Data:
        """Remove any association between a recipe and ingredients

        :param recipe_key: Identifier for the recipe
        """
        args = disassociate_recipe_as_input_t.Arguments(
            recipe_key=recipe_key,
        )
        api_request = APIRequest(
            method=disassociate_recipe_as_input_t.ENDPOINT_METHOD,
            endpoint=disassociate_recipe_as_input_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=disassociate_recipe_as_input_t.Data)

    def edit_recipe_inputs(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_workflow_step_identifier: recipe_workflow_steps_t.RecipeWorkflowStepIdentifier,
        edits: list[edit_recipe_inputs_t.RecipeInputEdit],
    ) -> edit_recipe_inputs_t.Data:
        """Clear, update, or add inputs on a recipe

        :param recipe_key: Identifier for the recipe
        """
        args = edit_recipe_inputs_t.Arguments(
            recipe_key=recipe_key,
            recipe_workflow_step_identifier=recipe_workflow_step_identifier,
            edits=edits,
        )
        api_request = APIRequest(
            method=edit_recipe_inputs_t.ENDPOINT_METHOD,
            endpoint=edit_recipe_inputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=edit_recipe_inputs_t.Data)

    def execute_batch(
        self,
        *,
        requests: list[execute_batch_t.BatchRequest],
    ) -> execute_batch_t.Data:
        """Run multiple API calls via one request

        """
        args = execute_batch_t.Arguments(
            requests=requests,
        )
        api_request = APIRequest(
            method=execute_batch_t.ENDPOINT_METHOD,
            endpoint=execute_batch_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=execute_batch_t.Data)

    def execute_batch_load_async(
        self,
        *,
        requests: list[async_batch_t.AsyncBatchRequest],
    ) -> execute_batch_load_async_t.Data:
        """Run multiple API calls via one request

        """
        args = execute_batch_load_async_t.Arguments(
            requests=requests,
        )
        api_request = APIRequest(
            method=execute_batch_load_async_t.ENDPOINT_METHOD,
            endpoint=execute_batch_load_async_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=execute_batch_load_async_t.Data)

    def get_curve(
        self,
        *,
        recipe_output_id: typing.Optional[base_t.ObjectId] = None,
        recipe_input_id: typing.Optional[base_t.ObjectId] = None,
    ) -> get_curve_t.Data:
        """Returns an array of values for the specified curve id.

        :param recipe_output_id: The recipe output ID to fetch the curve for. This must be a curve recipe output. Recipe Outputs can be found from external_get_recipes_data
        :param recipe_input_id: The recipe input ID to fetch the curve for. This must be a curve recipe input. Recipe Inputs can be found from external_get_recipes_data
        """
        args = get_curve_t.Arguments(
            recipe_output_id=recipe_output_id,
            recipe_input_id=recipe_input_id,
        )
        api_request = APIRequest(
            method=get_curve_t.ENDPOINT_METHOD,
            endpoint=get_curve_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_curve_t.Data)

    def get_entities_data(
        self,
        *,
        entity_ids: list[base_t.ObjectId],
        entity_type: entity_t.EntityType,
    ) -> get_entities_data_t.Data:
        """Gets the details for a passed entity

        :param entity_ids: Ids of the entity to retrieve
        :param entity_type: The type of the entities requested, e.g. lab_request or approval
        """
        args = get_entities_data_t.Arguments(
            entity_ids=entity_ids,
            entity_type=entity_type,
        )
        api_request = APIRequest(
            method=get_entities_data_t.ENDPOINT_METHOD,
            endpoint=get_entities_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_entities_data_t.Data)

    def get_input_data(
        self,
        *,
        material_family_id: base_t.ObjectId,
        input_ids: typing.Optional[list[base_t.ObjectId]],
        is_parameter: typing.Optional[bool],
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> get_input_data_t.Data:
        """Gets the attribute, categorization and other metadata associated with a set of inputs. An input is either an ingredient or process parameter, with metadata and calculations assigned separately

        :param material_family_id: The material family ID to get the input values from.
        :param input_ids: The input IDs to get the data from. If this is not filled in, all inputs from a material family will be returned (in paginated form).
        :param offset: Used for pagination, where the number of results returned exceeds the limit. Results are always ordered by the input ID. [Pagination More Info](#pagination)
        :param is_parameter: Whether to get parameters or ingredients. By default both are returned. When set to true, only parameters are returned, and when set to false, only ingredients are returned
        :param limit: The maximum number of results to return. By default this is set to 1,000 and it cannot be set higher than 1,000. [Pagination More Info](#pagination)
        """
        args = get_input_data_t.Arguments(
            material_family_id=material_family_id,
            input_ids=input_ids,
            offset=offset,
            is_parameter=is_parameter,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_input_data_t.ENDPOINT_METHOD,
            endpoint=get_input_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_input_data_t.Data)

    def get_input_group_names(
        self,
        *,
        material_family_id: base_t.ObjectId,
    ) -> get_input_group_names_t.Data:
        """Gets the name of all input groups in a material family that either the user created, or are shared to all users.

        :param material_family_id: Required: The Material Family ID to get the input groups from.
        """
        args = get_input_group_names_t.Arguments(
            material_family_id=material_family_id,
        )
        api_request = APIRequest(
            method=get_input_group_names_t.ENDPOINT_METHOD,
            endpoint=get_input_group_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_input_group_names_t.Data)

    def get_input_names(
        self,
        *,
        material_family_id: base_t.ObjectId,
        is_parameter: typing.Optional[bool],
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> get_input_names_t.Data:
        """Gets the name of all inputs for a material family. An input is either an ingredient or process parameter, with metadata and calculations assigned separately

        :param material_family_id: The material family ID to get the input values from
        :param offset: Used for pagination, where the number of results returned exceeds the limit. Results are always ordered by the input ID. [Pagination More Info](#pagination)
        :param is_parameter: Whether to get parameters or ingredients. By default both are returned. When set to true, only parameters are returned, and when set to false, only ingredients are returned
        :param limit: The maximum number of results to return. By default this is set to 20,000 and it cannot be set higher than 20,000. [Pagination More Info](#pagination)
        """
        args = get_input_names_t.Arguments(
            material_family_id=material_family_id,
            offset=offset,
            is_parameter=is_parameter,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_input_names_t.ENDPOINT_METHOD,
            endpoint=get_input_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_input_names_t.Data)

    def get_inputs_data(
        self,
        *,
        input_ids: list[base_t.ObjectId],
    ) -> get_inputs_data_t.Data:
        """Gets the details for passed input ids

        :param input_ids: Ids of the inputs to retrieve
        """
        args = get_inputs_data_t.Arguments(
            input_ids=input_ids,
        )
        api_request = APIRequest(
            method=get_inputs_data_t.ENDPOINT_METHOD,
            endpoint=get_inputs_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_inputs_data_t.Data)

    def get_output_data(
        self,
        *,
        material_family_id: base_t.ObjectId,
        output_ids: typing.Optional[list[base_t.ObjectId]] = None,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
    ) -> get_output_data_t.Data:
        """Gets the attribute, categorization and other metadata associated with a set of outputs

        :param material_family_id: The material family ID to get the output values from.
        :param output_ids: The output IDs to get the data from. If this is not filled in, all outputs from a material family will be returned (in paginated form).
        :param offset: Used for pagination, where the number of results returned exceeds the limit. Results are always ordered by the output ID. [Pagination More Info](#pagination)
        :param limit: The maximum number of results to return. By default this is set to 1,000 and it cannot be set higher than 1,000. [Pagination More Info](#pagination)
        """
        args = get_output_data_t.Arguments(
            material_family_id=material_family_id,
            output_ids=output_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_output_data_t.ENDPOINT_METHOD,
            endpoint=get_output_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_output_data_t.Data)

    def get_output_names(
        self,
        *,
        material_family_id: base_t.ObjectId,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
    ) -> get_output_names_t.Data:
        """Gets the name of all outputs for a material family. An output represents a measurement value of any time (numeric, text, curve, etc). This includes calculations based off of other outputs, such as a calculated change over time

        :param material_family_id: The material family ID to get the output values from
        :param offset: Used for pagination, where the number of results returned exceeds the limit. Results are always ordered by the output ID. [Pagination More Info](#pagination)
        :param limit: The maximum number of results to return. By default this is set to 20,000 and it cannot be set higher than 20,000. [Pagination More Info](#pagination)
        """
        args = get_output_names_t.Arguments(
            material_family_id=material_family_id,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_output_names_t.ENDPOINT_METHOD,
            endpoint=get_output_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_output_names_t.Data)

    def get_projects(
        self,
        *,
        all_material_families: bool,
        material_family_id: typing.Optional[base_t.ObjectId],
    ) -> get_projects_t.Data:
        """Gets either all projects created in the platform, or the projects associated with a material family ID. Projects are where experiments are placed in Uncountable, similar to folders in a directory structure

        :param all_material_families: Whether to get projects from all material families. Material families are high level groupings of data, usually separated by functional area
        :param material_family_id: The specific material family ID to get projects from. Only fill this in if all_material_families is set to false
        """
        args = get_projects_t.Arguments(
            all_material_families=all_material_families,
            material_family_id=material_family_id,
        )
        api_request = APIRequest(
            method=get_projects_t.ENDPOINT_METHOD,
            endpoint=get_projects_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_projects_t.Data)

    def get_projects_data(
        self,
        *,
        project_ids: list[base_t.ObjectId],
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> get_projects_data_t.Data:
        """Gets either all data associated with a set of projects created in the platform.  Because Uncountables recipe structure is complex, various data values are exploded out to increase efficiency in parsing, and this page is paginated to prevent too large of return values

        :param project_ids: The projects to get the data from
        :param offset: Used for pagination. All pagination is done in order of Project ID. [Pagination More Info](#pagination)
        :param limit: The number of data points to return. If not filled in, it will be set to 100, and cannot be set higher than 100. [Pagination More Info](#pagination)
        """
        args = get_projects_data_t.Arguments(
            project_ids=project_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_projects_data_t.ENDPOINT_METHOD,
            endpoint=get_projects_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_projects_data_t.Data)

    def get_recipe_calculations(
        self,
        *,
        recipe_ids: list[base_t.ObjectId],
        calculation_ids: typing.Optional[list[base_t.ObjectId]] = None,
    ) -> get_recipe_calculations_t.Data:
        """Gets the calculations for the passed recipes

        :param recipe_ids: Ids of the Recipes to retrieve calculations for
        :param calculation_ids: Optionally a list of ids of calculations to retrieve
        """
        args = get_recipe_calculations_t.Arguments(
            recipe_ids=recipe_ids,
            calculation_ids=calculation_ids,
        )
        api_request = APIRequest(
            method=get_recipe_calculations_t.ENDPOINT_METHOD,
            endpoint=get_recipe_calculations_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_calculations_t.Data)

    def get_recipe_links(
        self,
        *,
        recipe_ids: list[base_t.ObjectId],
        depth: int = 1,
        link_types: typing.Optional[list[recipe_links_t.RecipeLinkType]],
    ) -> get_recipe_links_t.Data:
        """Gets the links for the passed recipes

        :param recipe_ids: Ids of the Recipes to retrieve links for
        :param depth: How many layers deep to look for links
        :param link_types: Optional filter to only desired link types
        """
        args = get_recipe_links_t.Arguments(
            recipe_ids=recipe_ids,
            depth=depth,
            link_types=link_types,
        )
        api_request = APIRequest(
            method=get_recipe_links_t.ENDPOINT_METHOD,
            endpoint=get_recipe_links_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_links_t.Data)

    def get_recipe_metadata_data(
        self,
        *,
        material_family_id: base_t.ObjectId,
        recipe_metadata_ids: typing.Optional[list[base_t.ObjectId]],
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> get_recipe_metadata_data_t.Data:
        """Gets the recipe metadata. Recipe metadata is data associated with experiments that is not an input, output or calculation, such as a sample ID.

        :param material_family_id: The material family ID to get the recipe metadata values from.
        :param recipe_metadata_ids: The recipe metadata IDs to get the data from. If this is not filled in, all metadata from a material family will be returned (in paginated form).
        :param offset: Used for pagination, where the number of results returned exceeds the limit. Results are always ordered by the metadata ID. [Pagination More Info](#pagination)
        :param limit: The maximum number of results to return. By default this is set to 1,000 and it cannot be set higher than 1,000. [Pagination More Info](#pagination)
        """
        args = get_recipe_metadata_data_t.Arguments(
            material_family_id=material_family_id,
            recipe_metadata_ids=recipe_metadata_ids,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_recipe_metadata_data_t.ENDPOINT_METHOD,
            endpoint=get_recipe_metadata_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_metadata_data_t.Data)

    def get_recipe_names(
        self,
        *,
        project_id: base_t.ObjectId,
    ) -> get_recipe_names_t.Data:
        """Gets the name of all recipes (or experiments, used as synonyms by Uncountable) for a project. The call external_get_projects can be used to find projects

        :param project_id: Required: The project ID to get the recipes/experiments from.
        """
        args = get_recipe_names_t.Arguments(
            project_id=project_id,
        )
        api_request = APIRequest(
            method=get_recipe_names_t.ENDPOINT_METHOD,
            endpoint=get_recipe_names_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_names_t.Data)

    def get_recipe_output_metadata(
        self,
        *,
        recipe_output_ids: list[base_t.ObjectId],
    ) -> get_recipe_output_metadata_t.Data:
        """Gets the metadata values for the passed recipe outputs

        :param recipe_output_ids: Ids of the Recipe Outputs to retrieve metadata for
        """
        args = get_recipe_output_metadata_t.Arguments(
            recipe_output_ids=recipe_output_ids,
        )
        api_request = APIRequest(
            method=get_recipe_output_metadata_t.ENDPOINT_METHOD,
            endpoint=get_recipe_output_metadata_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipe_output_metadata_t.Data)

    def get_recipes_data(
        self,
        *,
        recipe_ids: typing.Optional[typing.Optional[list[base_t.ObjectId]]] = None,
        project_id: typing.Optional[typing.Optional[base_t.ObjectId]] = None,
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> get_recipes_data_t.Data:
        """Gets all data associated with a set of recipes. Because Uncountables recipe structure is complex, various data values are exploded out to increase efficiency in parsing, and this page is paginated to prevent too large of return values

        :param recipe_ids: The recipes to get the data from. Either these or project_id must be filled in
        :param project_id: The projects to get the data from. Either these or recipe_ids must be filled in
        :param offset: Used for pagination. All pagination is done in order of Recipe ID. [Pagination More Info](#pagination)
        :param limit: The number of data points to return. If not filled in, it will be set to 100, and cannot be set higher than 100. [Pagination More Info](#pagination)
        """
        args = get_recipes_data_t.Arguments(
            recipe_ids=recipe_ids,
            project_id=project_id,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=get_recipes_data_t.ENDPOINT_METHOD,
            endpoint=get_recipes_data_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=get_recipes_data_t.Data)

    def invoke_uploader(
        self,
        *,
        file_ids: list[base_t.ObjectId],
        uploader_key: identifier_t.IdentifierKey,
        material_family_keys: list[identifier_t.IdentifierKey],
    ) -> invoke_uploader_t.Data:
        """Runs files through an uploader.

        """
        args = invoke_uploader_t.Arguments(
            file_ids=file_ids,
            uploader_key=uploader_key,
            material_family_keys=material_family_keys,
        )
        api_request = APIRequest(
            method=invoke_uploader_t.ENDPOINT_METHOD,
            endpoint=invoke_uploader_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=invoke_uploader_t.Data)

    def list_entities(
        self,
        *,
        config_reference: str,
        entity_type: typing.Optional[entity_t.EntityType] = None,
        attributes: typing.Optional[dict[OpaqueKey, base_t.JsonValue]] = None,
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> list_entities_t.Data:
        """Uses a structured loading configuration to list entities in the system

        :param entity_type: DEPRECATED: The type of the entities requested, e.g. lab_request, recipe
        :param config_reference: The configuration reference name for the listing config
        :param attributes: Attributes to pass to the configuration for parameterizing filters
        :param offset: Used for pagination. Pagination is done based on the sorting of the config. [Pagination More Info](#pagination)
        :param limit: The number of data points to return. If not filled in, it will be set to 100, and cannot be set higher than 100. [Pagination More Info](#pagination)
        """
        args = list_entities_t.Arguments(
            entity_type=entity_type,
            config_reference=config_reference,
            attributes=attributes,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=list_entities_t.ENDPOINT_METHOD,
            endpoint=list_entities_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=list_entities_t.Data)

    def list_id_source(
        self,
        *,
        spec: id_source_t.IdSourceSpec,
        search_label: str,
        offset: typing.Optional[typing.Optional[int]] = None,
        limit: typing.Optional[typing.Optional[int]] = None,
    ) -> list_id_source_t.Data:
        """Lists id and label pairs

        :param spec: The id source spec to use
        :param search_label: Text to search within the labels to search matches
        :param offset: Used for pagination. Pagination is done based on the sorting of the config. [Pagination More Info](#pagination)
        :param limit: The number of data points to return. If not filled in, it will be set to 100, and cannot be set higher than 100. [Pagination More Info](#pagination)
        """
        args = list_id_source_t.Arguments(
            spec=spec,
            search_label=search_label,
            offset=offset,
            limit=limit,
        )
        api_request = APIRequest(
            method=list_id_source_t.ENDPOINT_METHOD,
            endpoint=list_id_source_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=list_id_source_t.Data)

    def external_lock_entity(
        self,
        *,
        entity_key: identifier_t.IdentifierKey,
        entity_type: entity_t.EntityType,
        globally_removable: typing.Optional[bool] = None,
    ) -> lock_entity_t.Data:
        """Lock an entity

        :param entity_key: Identifier for the entity
        :param globally_removable: Should the lock be removable by any user or just admins
        """
        args = lock_entity_t.Arguments(
            entity_key=entity_key,
            entity_type=entity_type,
            globally_removable=globally_removable,
        )
        api_request = APIRequest(
            method=lock_entity_t.ENDPOINT_METHOD,
            endpoint=lock_entity_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=lock_entity_t.Data)

    def lock_recipes(
        self,
        *,
        type: lock_recipes_t.RecipeLockType = lock_recipes_t.RecipeLockType.ALL,
        recipes: list[identifier_t.IdentifierKey],
        globally_removable: bool,
        lock_samples: typing.Optional[bool] = None,
        comments: typing.Optional[str] = None,
    ) -> lock_recipes_t.Data:
        """Lock experiments. Experiments will require unlocking to be editable. Edits to the experiments are blocked while they are locked.

        :param type: The type of lock to set.
    All = both inputs and measurements are locked.
    Inputs Only = only inputs are locked from editing.

        :param recipes: The recipes to lock, a maximum of 100 can be sent
        :param globally_removable: If true any user can unlock the experiment. If false the locking user is the only user that can unlock.
        :param lock_samples: Should associated experiment test samples also be locked.
        :param comments: Optional comment describing the purpose of locking
        """
        args = lock_recipes_t.Arguments(
            type=type,
            recipes=recipes,
            globally_removable=globally_removable,
            lock_samples=lock_samples,
            comments=comments,
        )
        api_request = APIRequest(
            method=lock_recipes_t.ENDPOINT_METHOD,
            endpoint=lock_recipes_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=lock_recipes_t.Data)

    def match_id_source(
        self,
        *,
        spec: id_source_t.IdSourceSpec,
        names: list[str],
    ) -> match_id_source_t.Data:
        """Lists id and label pairs

        :param spec: The id source spec to use
        :param names: The names to match with the id source.  At most 10 are allowed at a time
        """
        args = match_id_source_t.Arguments(
            spec=spec,
            names=names,
        )
        api_request = APIRequest(
            method=match_id_source_t.ENDPOINT_METHOD,
            endpoint=match_id_source_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=match_id_source_t.Data)

    def remove_recipe_from_project(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        project_key: identifier_t.IdentifierKey,
    ) -> remove_recipe_from_project_t.Data:
        """Removes a recipe from a project

        :param recipe_key: The identifier key of the recipe to remove from the project
        :param project_key: The identifier key of the project to remove the recipe from
        """
        args = remove_recipe_from_project_t.Arguments(
            recipe_key=recipe_key,
            project_key=project_key,
        )
        api_request = APIRequest(
            method=remove_recipe_from_project_t.ENDPOINT_METHOD,
            endpoint=remove_recipe_from_project_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=remove_recipe_from_project_t.Data)

    def remove_recipe_link(
        self,
        *,
        recipe_from_key: identifier_t.IdentifierKey,
        recipe_to_key: identifier_t.IdentifierKey,
        link_type: typing.Union[typing.Literal[recipe_links_t.RecipeLinkType.CHILD], typing.Literal[recipe_links_t.RecipeLinkType.CONTROL], typing.Literal[recipe_links_t.RecipeLinkType.USER_LINK]],
    ) -> remove_recipe_link_t.Data:
        """Remove a link between two recipes.  Skip if the link doesn't already exist

        :param recipe_from_key: Identifier for the recipe the link comes from
        :param recipe_to_key: Identifier for the recipe the link goes to
        :param link_type: The type of link being removed
        """
        args = remove_recipe_link_t.Arguments(
            recipe_from_key=recipe_from_key,
            recipe_to_key=recipe_to_key,
            link_type=link_type,
        )
        api_request = APIRequest(
            method=remove_recipe_link_t.ENDPOINT_METHOD,
            endpoint=remove_recipe_link_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=remove_recipe_link_t.Data)

    def resolve_entity_ids(
        self,
        *,
        entity_ids: list[typing.Union[str, base_t.ObjectId]],
        entity_type: entity_t.EntityType,
    ) -> resolve_entity_ids_t.Data:
        """Gets the names for passed in ids

        :param entity_ids: Ids of the entity to retrieve
        :param entity_type: The type of the entities requested
        """
        args = resolve_entity_ids_t.Arguments(
            entity_ids=entity_ids,
            entity_type=entity_type,
        )
        api_request = APIRequest(
            method=resolve_entity_ids_t.ENDPOINT_METHOD,
            endpoint=resolve_entity_ids_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=resolve_entity_ids_t.Data)

    def resolve_output_conditions(
        self,
        *,
        requested_conditions: list[resolve_output_conditions_t.ConditionRequest],
    ) -> resolve_output_conditions_t.Data:
        """For the provided set of condition parameter id and values, returns the existing or newly created output condition id for that value and id pair.

        """
        args = resolve_output_conditions_t.Arguments(
            requested_conditions=requested_conditions,
        )
        api_request = APIRequest(
            method=resolve_output_conditions_t.ENDPOINT_METHOD,
            endpoint=resolve_output_conditions_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=resolve_output_conditions_t.Data)

    def run_trigger(
        self,
        *,
        trigger_ref_name: str,
        entity: typing.Optional[entity_t.Entity] = None,
    ) -> run_trigger_t.Data:
        """Runs a trigger.  Requires admin access

        """
        args = run_trigger_t.Arguments(
            entity=entity,
            trigger_ref_name=trigger_ref_name,
        )
        api_request = APIRequest(
            method=run_trigger_t.ENDPOINT_METHOD,
            endpoint=run_trigger_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=run_trigger_t.Data)

    def set_core_permissions(
        self,
        *,
        scope: set_core_permissions_t.PermissionsScope,
        permissions_types: list[permissions_t.CorePermissionType],
        update_type: post_base_t.UpdateType,
        user_group_ids: typing.Optional[list[int]] = None,
        user_ids: typing.Optional[list[int]] = None,
    ) -> set_core_permissions_t.Data:
        """Sets recipe related permissions

        :param scope: Scope of permissions to change
        :param user_group_ids: User group ids to grant permission to
        :param user_ids: User ids to grant permission to
        :param update_type: The type of update to perform
        """
        args = set_core_permissions_t.Arguments(
            scope=scope,
            user_group_ids=user_group_ids,
            user_ids=user_ids,
            permissions_types=permissions_types,
            update_type=update_type,
        )
        api_request = APIRequest(
            method=set_core_permissions_t.ENDPOINT_METHOD,
            endpoint=set_core_permissions_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_core_permissions_t.Data)

    def set_input_attribute_values(
        self,
        *,
        attribute_values: list[set_input_attribute_values_t.InputAttributeValue],
    ) -> set_input_attribute_values_t.Data:
        """Sets attribute values for an input

        :param attribute_values: The attributes of the input to set
        """
        args = set_input_attribute_values_t.Arguments(
            attribute_values=attribute_values,
        )
        api_request = APIRequest(
            method=set_input_attribute_values_t.ENDPOINT_METHOD,
            endpoint=set_input_attribute_values_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_input_attribute_values_t.Data)

    def external_set_input_category(
        self,
        *,
        input_key: identifier_t.IdentifierKey,
        category_id: int,
        material_family_ids: typing.Optional[list[int]] = None,
    ) -> set_input_category_t.Data:
        """Sets subcategories for an input

        :param input_key: Identifier for the input
        :param category_id: The subcategory identifiers to set
        :param material_family_ids: The material families to perform the update in
        """
        args = set_input_category_t.Arguments(
            input_key=input_key,
            category_id=category_id,
            material_family_ids=material_family_ids,
        )
        api_request = APIRequest(
            method=set_input_category_t.ENDPOINT_METHOD,
            endpoint=set_input_category_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_input_category_t.Data)

    def external_set_input_subcategories(
        self,
        *,
        input_key: identifier_t.IdentifierKey,
        subcategory_ids: list[int],
        update_type: post_base_t.UpdateType,
    ) -> set_input_subcategories_t.Data:
        """Sets subcategories for an input

        :param input_key: Identifier for the input
        :param subcategory_ids: The subcategory identifiers to set
        :param update_type: The type of update to perform
        """
        args = set_input_subcategories_t.Arguments(
            input_key=input_key,
            subcategory_ids=subcategory_ids,
            update_type=update_type,
        )
        api_request = APIRequest(
            method=set_input_subcategories_t.ENDPOINT_METHOD,
            endpoint=set_input_subcategories_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_input_subcategories_t.Data)

    def set_intermediate_type(
        self,
        *,
        input_key: identifier_t.IdentifierKey,
        intermediate_type: set_intermediate_type_t.IntermediateType,
    ) -> set_intermediate_type_t.Data:
        """Sets the type of an intermediate ingredient.

        :param input_key: The identifier key of the intermediate ingredient
        :param intermediate_type: The new type of the intermediate ingredient
        """
        args = set_intermediate_type_t.Arguments(
            input_key=input_key,
            intermediate_type=intermediate_type,
        )
        api_request = APIRequest(
            method=set_intermediate_type_t.ENDPOINT_METHOD,
            endpoint=set_intermediate_type_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_intermediate_type_t.Data)

    def set_recipe_inputs(
        self,
        *,
        input_data: list[set_recipe_inputs_t.RecipeInputValue],
    ) -> set_recipe_inputs_t.Data:
        """Sets inputs values for an experiment. Values set can be numeric, text or categorical types in the Uncountable system

        :param input_data: The inputs to set. Must be at most 100 entries long
        """
        args = set_recipe_inputs_t.Arguments(
            input_data=input_data,
        )
        api_request = APIRequest(
            method=set_recipe_inputs_t.ENDPOINT_METHOD,
            endpoint=set_recipe_inputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_recipe_inputs_t.Data)

    def set_recipe_metadata(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_metadata: list[recipe_metadata_t.MetadataValue],
    ) -> set_recipe_metadata_t.Data:
        """Set metadata values on a recipe

        :param recipe_key: Identifier for the recipe
        :param recipe_metadata: Metadata values to populate the recipe with
        """
        args = set_recipe_metadata_t.Arguments(
            recipe_key=recipe_key,
            recipe_metadata=recipe_metadata,
        )
        api_request = APIRequest(
            method=set_recipe_metadata_t.ENDPOINT_METHOD,
            endpoint=set_recipe_metadata_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_recipe_metadata_t.Data)

    def set_recipe_output_annotations(
        self,
        *,
        updates: list[set_recipe_output_annotations_t.RecipeOutputUpdateAnnotations],
    ) -> set_recipe_output_annotations_t.Data:
        """Update annotations for an experiments outputs

        :param updates: The output edits to perform. Must be at most 100 entries long
        """
        args = set_recipe_output_annotations_t.Arguments(
            updates=updates,
        )
        api_request = APIRequest(
            method=set_recipe_output_annotations_t.ENDPOINT_METHOD,
            endpoint=set_recipe_output_annotations_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_recipe_output_annotations_t.Data)

    def set_recipe_outputs(
        self,
        *,
        output_data: list[set_recipe_outputs_t.RecipeOutputValue],
    ) -> set_recipe_outputs_t.Data:
        """Sets output values for an experiment. Values set can be numeric, text or categorical types in the Uncountable system

        :param output_data: The outputs to set. Must be at most 100 entries long
        """
        args = set_recipe_outputs_t.Arguments(
            output_data=output_data,
        )
        api_request = APIRequest(
            method=set_recipe_outputs_t.ENDPOINT_METHOD,
            endpoint=set_recipe_outputs_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_recipe_outputs_t.Data)

    def set_recipe_tags(
        self,
        *,
        recipe_key: identifier_t.IdentifierKey,
        recipe_tag_update: set_recipe_tags_t.RecipeTagUpdate,
    ) -> set_recipe_tags_t.Data:
        """Modifies recipes tags for a recipe

        :param recipe_key: Identifier for the recipe
        :param recipe_tag_update: The update to perform on the recipe tags
        """
        args = set_recipe_tags_t.Arguments(
            recipe_key=recipe_key,
            recipe_tag_update=recipe_tag_update,
        )
        api_request = APIRequest(
            method=set_recipe_tags_t.ENDPOINT_METHOD,
            endpoint=set_recipe_tags_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_recipe_tags_t.Data)

    def set_values(
        self,
        *,
        entity: entity_t.Entity,
        values: list[field_values_t.ArgumentValueRefName],
    ) -> set_values_t.Data:
        """Sets field values for an entity

        """
        args = set_values_t.Arguments(
            entity=entity,
            values=values,
        )
        api_request = APIRequest(
            method=set_values_t.ENDPOINT_METHOD,
            endpoint=set_values_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=set_values_t.Data)

    def transition_entity_phase(
        self,
        *,
        entity: entity_t.Entity,
        transition: transition_entity_phase_t.TransitionIdentifier,
    ) -> transition_entity_phase_t.Data:
        """Transitions an entity from one phase to another

        """
        args = transition_entity_phase_t.Arguments(
            entity=entity,
            transition=transition,
        )
        api_request = APIRequest(
            method=transition_entity_phase_t.ENDPOINT_METHOD,
            endpoint=transition_entity_phase_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=transition_entity_phase_t.Data)

    def unarchive_recipes(
        self,
        *,
        recipes: list[identifier_t.IdentifierKey],
    ) -> unarchive_recipes_t.Data:
        """Unarchive/restore the provided recipes

        :param recipes: Identifier for the recipe
        """
        args = unarchive_recipes_t.Arguments(
            recipes=recipes,
        )
        api_request = APIRequest(
            method=unarchive_recipes_t.ENDPOINT_METHOD,
            endpoint=unarchive_recipes_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=unarchive_recipes_t.Data)

    def external_unlock_entity(
        self,
        *,
        entity_key: identifier_t.IdentifierKey,
        entity_type: entity_t.EntityType,
    ) -> unlock_entity_t.Data:
        """Unlock an entity

        :param entity_key: Identifier for the entity
        """
        args = unlock_entity_t.Arguments(
            entity_key=entity_key,
            entity_type=entity_type,
        )
        api_request = APIRequest(
            method=unlock_entity_t.ENDPOINT_METHOD,
            endpoint=unlock_entity_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=unlock_entity_t.Data)

    def unlock_recipes(
        self,
        *,
        type: unlock_recipes_t.RecipeUnlockType = unlock_recipes_t.RecipeUnlockType.STANDARD,
        recipes: list[identifier_t.IdentifierKey],
        unlock_samples: typing.Optional[bool] = None,
    ) -> unlock_recipes_t.Data:
        """Unlock experiments. Experiments will edtiable after unlocking if they are currently locked.

        :param type: The method to unlock recipes. Default is standard.
        :param recipes: The recipes to unlock, a maximum of 100 can be sent
        :param unlock_samples: Should associated experiment test samples also be unlocked.
        """
        args = unlock_recipes_t.Arguments(
            type=type,
            recipes=recipes,
            unlock_samples=unlock_samples,
        )
        api_request = APIRequest(
            method=unlock_recipes_t.ENDPOINT_METHOD,
            endpoint=unlock_recipes_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=unlock_recipes_t.Data)

    def update_entity_material_families(
        self,
        *,
        entity_key: identifier_t.IdentifierKey,
        entity_type: typing.Union[typing.Literal[entity_t.EntityType.RECIPE_METADATA], typing.Literal[entity_t.EntityType.INGREDIENT], typing.Literal[entity_t.EntityType.OUTPUT], typing.Literal[entity_t.EntityType.CONDITION_PARAMETER], typing.Literal[entity_t.EntityType.INGREDIENT_ATTRIBUTE]],
        material_family_ids: list[base_t.ObjectId],
        update_type: post_base_t.UpdateType,
    ) -> update_entity_material_families_t.Data:
        """Updates the material families that the entity is available in

        :param entity_key: The identifier for the entity to update across material families
        :param entity_type: The type of the entities requested
        :param material_family_ids: The material families to update
        :param update_type: The type of update to make
        """
        args = update_entity_material_families_t.Arguments(
            entity_key=entity_key,
            entity_type=entity_type,
            material_family_ids=material_family_ids,
            update_type=update_type,
        )
        api_request = APIRequest(
            method=update_entity_material_families_t.ENDPOINT_METHOD,
            endpoint=update_entity_material_families_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=update_entity_material_families_t.Data)

    def upsert_field_options(
        self,
        *,
        option_set_key: identifier_t.IdentifierKey,
        field_options: list[upsert_field_options_t.FieldOption],
    ) -> upsert_field_options_t.Data:
        """Creates or updates field options for an option set

        :param option_set_key: Identifier for the field option set
        :param field_options: Field options to upsert
        """
        args = upsert_field_options_t.Arguments(
            option_set_key=option_set_key,
            field_options=field_options,
        )
        api_request = APIRequest(
            method=upsert_field_options_t.ENDPOINT_METHOD,
            endpoint=upsert_field_options_t.ENDPOINT_PATH,
            args=args,
        )
        return self.do_request(api_request=api_request, return_type=upsert_field_options_t.Data)
