# DO NOT MODIFY -- This file is generated by type_spec
# flake8: noqa: F821
# ruff: noqa: E402 Q003
# fmt: off
# isort: skip_file
from __future__ import annotations
import typing  # noqa: F401
import datetime  # noqa: F401
from decimal import Decimal  # noqa: F401
from pkgs.strenum_compat import StrEnum
import dataclasses
from pkgs.serialization import serial_class
from pkgs.serialization import serial_union_annotation
from . import generic_upload_t
from . import secret_retrieval_t

__all__: list[str] = [
    "AuthRetrieval",
    "AuthRetrievalBase",
    "AuthRetrievalEnv",
    "AuthRetrievalType",
    "CronJobDefinition",
    "GenericUploadDataSource",
    "GenericUploadDataSourceBase",
    "GenericUploadDataSourceSFTP",
    "GenericUploadDataSourceType",
    "JobDefinition",
    "JobDefinitionBase",
    "JobDefinitionType",
    "JobExecutor",
    "JobExecutorBase",
    "JobExecutorGenericUpload",
    "JobExecutorScript",
    "JobExecutorType",
    "ProfileDefinition",
    "ProfileMetadata",
]


# DO NOT MODIFY -- This file is generated by type_spec
class JobDefinitionType(StrEnum):
    CRON = "cron"


# DO NOT MODIFY -- This file is generated by type_spec
class JobExecutorType(StrEnum):
    SCRIPT = "script"
    GENERIC_UPLOAD = "generic_upload"


# DO NOT MODIFY -- This file is generated by type_spec
class AuthRetrievalType(StrEnum):
    ENV = "env"


# DO NOT MODIFY -- This file is generated by type_spec
class GenericUploadDataSourceType(StrEnum):
    SFTP = "sftp"


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class JobExecutorBase:
    type: JobExecutorType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class JobExecutorScript(JobExecutorBase):
    type: typing.Literal[JobExecutorType.SCRIPT] = JobExecutorType.SCRIPT
    import_path: str


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class GenericUploadDataSourceBase:
    type: GenericUploadDataSourceType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class GenericUploadDataSourceSFTP(GenericUploadDataSourceBase):
    type: typing.Literal[GenericUploadDataSourceType.SFTP] = GenericUploadDataSourceType.SFTP
    host: str
    username: str
    pem_secret: secret_retrieval_t.SecretRetrieval


# DO NOT MODIFY -- This file is generated by type_spec
GenericUploadDataSource = typing.Annotated[
    typing.Union[GenericUploadDataSourceSFTP],
    serial_union_annotation(
        discriminator="type",
        discriminator_map={
            "sftp": GenericUploadDataSourceSFTP,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class JobExecutorGenericUpload(JobExecutorBase):
    type: typing.Literal[JobExecutorType.GENERIC_UPLOAD] = JobExecutorType.GENERIC_UPLOAD
    data_source: GenericUploadDataSource
    upload_strategy: generic_upload_t.GenericUploadStrategy
    remote_directories: list[generic_upload_t.GenericRemoteDirectoryScope]


# DO NOT MODIFY -- This file is generated by type_spec
JobExecutor = typing.Annotated[
    typing.Union[JobExecutorScript, JobExecutorGenericUpload],
    serial_union_annotation(
        discriminator="type",
        discriminator_map={
            "script": JobExecutorScript,
            "generic_upload": JobExecutorGenericUpload,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class JobDefinitionBase:
    id: str
    name: str
    executor: JobExecutor


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class CronJobDefinition(JobDefinitionBase):
    type: typing.Literal[JobDefinitionType.CRON] = JobDefinitionType.CRON
    cron_spec: str


# DO NOT MODIFY -- This file is generated by type_spec
JobDefinition = typing.Annotated[
    typing.Union[CronJobDefinition],
    serial_union_annotation(
        discriminator="type",
        discriminator_map={
            "cron": CronJobDefinition,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class AuthRetrievalBase:
    type: AuthRetrievalType


# DO NOT MODIFY -- This file is generated by type_spec
@serial_class(
    parse_require={"type"},
)
@dataclasses.dataclass(kw_only=True)
class AuthRetrievalEnv(AuthRetrievalBase):
    type: typing.Literal[AuthRetrievalType.ENV] = AuthRetrievalType.ENV


# DO NOT MODIFY -- This file is generated by type_spec
AuthRetrieval = typing.Annotated[
    typing.Union[AuthRetrievalEnv],
    serial_union_annotation(
        discriminator="type",
        discriminator_map={
            "env": AuthRetrievalEnv,
        },
    ),
]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class ProfileDefinition:
    auth_retrieval: AuthRetrieval
    base_url: str
    jobs: list[JobDefinition]


# DO NOT MODIFY -- This file is generated by type_spec
@dataclasses.dataclass(kw_only=True)
class ProfileMetadata:
    name: str
    base_url: str
    auth_retrieval: AuthRetrieval
# DO NOT MODIFY -- This file is generated by type_spec
