# pylint: disable=C0111,R0902,R0904,R0912,R0913,R0915,E1101
# Smartsheet Python SDK.
#
# Copyright 2018 Smartsheet.com, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License"): you may
# not use this file except in compliance with the License. You may obtain
# a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
# WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
# License for the specific language governing permissions and limitations
# under the License.

from __future__ import absolute_import

from ..types import Number, String
from ..util import deserialize
from .contact import Contact
from .object_value import CONTACT, ObjectValue


class ContactObjectValue(ObjectValue, Contact):
    """Smartsheet ContactObjectValue data model."""

    def __init__(self, props=None, base_obj=None):
        """Initialize the ContactObjectValue model."""
        ObjectValue.__init__(self, CONTACT, base_obj)
        Contact.__init__(self, None, base_obj)
        self._base = None
        if base_obj is not None:
            self._base = base_obj

        self._image_id = String()
        self._ref_index = Number()

        if props:
            deserialize(self, props)

        self.__initialized = True

    @property
    def image_id(self):
        return self._image_id.value

    @image_id.setter
    def image_id(self, value):
        self._image_id.value = value

    @property
    def ref_index(self):
        return self._ref_index.value

    @ref_index.setter
    def ref_index(self, value):
        self._ref_index.value = value
