from cursed_geobr.utils import select_metadata, download_gpkg


def read_urban_area(year=2015, simplified=True, verbose=False):
    """ Download official data of urbanized areas in Brazil as an sf object.
    
     This function reads the official data on the urban footprint of Brazilian cities
 in the years 2005 and 2015. Orignal data were generated by Institute of Geography
 and Statistics (IBGE)  For more information about the methodology, see deails at
 https://biblioteca.ibge.gov.br/visualizacao/livros/liv100639.pdf

    Parameters
    ----------
    year : int, optional
        Year of the data, by default 2015
    simplified: boolean, by default True
        Data 'type', indicating whether the function returns the 'original' dataset 
        with high resolution or a dataset with 'simplified' borders (Default)
    verbose : bool, optional
        by default False
    
    Returns
    -------
    gpd.GeoDataFrame
        Metadata and geopackage of selected states
    
    Raises
    ------
    Exception
        If parameters are not found or not well defined

    Example
    -------
    >>> from cursed_geobr import read_urban_area

    # Read specific state at a given year
    >>> df = read_urban_area(year=2015)
    """

    metadata = select_metadata("urban_area", year=year, simplified=simplified)

    gdf = download_gpkg(metadata)

    return gdf
