"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Aspects = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ASPECTS_SYMBOL = Symbol('cdk-aspects');
/**
 * Aspects can be applied to CDK tree scopes and can operate on the tree before synthesis.
 *
 * @stability stable
 */
class Aspects {
    // TODO(2.0): private readonly _aspects = new Array<IAspect>();
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * Returns the `Aspects` object associated with a construct scope.
     *
     * @param scope The scope for which these aspects will apply.
     * @stability stable
     */
    static of(scope) {
        let aspects = scope[ASPECTS_SYMBOL];
        if (!aspects) {
            aspects = new Aspects(scope);
            Object.defineProperty(scope, ASPECTS_SYMBOL, {
                value: aspects,
                configurable: false,
                enumerable: false,
            });
        }
        return aspects;
    }
    /**
     * Adds an aspect to apply this scope before synthesis.
     *
     * @param aspect The aspect to add.
     * @stability stable
     */
    add(aspect) {
        // TODO(2.0): this._aspects.push(aspect);
        this.scope.node._actualNode.applyAspect(aspect);
    }
    /**
     * The list of aspects which were directly applied on this scope.
     *
     * @stability stable
     */
    get aspects() {
        // TODO(2.0): return  [ ...this._aspects ];
        return [...this.scope.node._actualNode._aspects]; // clone
    }
}
exports.Aspects = Aspects;
_a = JSII_RTTI_SYMBOL_1;
Aspects[_a] = { fqn: "@aws-cdk/core.Aspects", version: "1.101.0" };
//# sourceMappingURL=data:application/json;base64,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