"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Intrinsic = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const stack_trace_1 = require("../stack-trace");
const token_1 = require("../token");
/**
 * Token subclass that represents values intrinsic to the target document language.
 *
 * WARNING: this class should not be externally exposed, but is currently visible
 * because of a limitation of jsii (https://github.com/aws/jsii/issues/524).
 *
 * This class will disappear in a future release and should not be used.
 *
 * @stability stable
 */
class Intrinsic {
    /**
     * @stability stable
     */
    constructor(value, options = {}) {
        var _b;
        if (isFunction(value)) {
            throw new Error(`Argument to Intrinsic must be a plain value object, got ${value}`);
        }
        this.creationStack = ((_b = options.stackTrace) !== null && _b !== void 0 ? _b : true) ? stack_trace_1.captureStackTrace() : [];
        this.value = value;
    }
    /**
     * Produce the Token's value at resolution time.
     *
     * @stability stable
     */
    resolve(_context) {
        return this.value;
    }
    /**
     * Convert an instance of this Token to a string.
     *
     * This method will be called implicitly by language runtimes if the object
     * is embedded into a string. We treat it the same as an explicit
     * stringification.
     *
     * @stability stable
     */
    toString() {
        return token_1.Token.asString(this);
    }
    /**
     * Turn this Token into JSON.
     *
     * Called automatically when JSON.stringify() is called on a Token.
     *
     * @stability stable
     */
    toJSON() {
        // We can't do the right work here because in case we contain a function, we
        // won't know the type of value that function represents (in the simplest
        // case, string or number), and we can't know that without an
        // IResolveContext to actually do the resolution, which we don't have.
        // We used to throw an error, but since JSON.stringify() is often used in
        // error messages to produce a readable representation of an object, if we
        // throw here we'll obfuscate that descriptive error with something worse.
        // So return a string representation that indicates this thing is a token
        // and needs resolving.
        return '<unresolved-token>';
    }
    /**
     * Creates a throwable Error object that contains the token creation stack trace.
     *
     * @param message Error message.
     * @stability stable
     */
    newError(message) {
        return new Error(`${message}\nToken created:\n    at ${this.creationStack.join('\n    at ')}\nError thrown:`);
    }
}
exports.Intrinsic = Intrinsic;
_a = JSII_RTTI_SYMBOL_1;
Intrinsic[_a] = { fqn: "@aws-cdk/core.Intrinsic", version: "1.101.0" };
function isFunction(x) {
    return typeof x === 'function';
}
//# sourceMappingURL=data:application/json;base64,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