import argparse
import json
import requests
import socket

# Here are some relevant snippets and URLs how to interact with
# ES for our purpoases

# curl -X GET 'http://{server:9200}/.kibana/_search?pretty=true&q=*:*'
# curl -X DELETE "http://{server:9200}/.kibana/index-pattern/logstash-*"
# curl -X DELETE "http://{server:9200}/.kibana/config/4.0.2"

# curl -X POST "http://{server:9200}/.kibana/index-pattern/logstash-*?op_type=create" -d '{
#        "timeFieldName" : "@timestamp",
#        "title" : "logstash-*",
#        "customFormats" : "{}"
#     }'

# curl -X POST "http://server:9200/.kibana/config/4.0.2?op_type=create" -d '{
#        "buildNum" : 6004,
#        "doc" : {
#           "buildNum" : 6004,
#           "defaultIndex" : "logstash-*"
#        },
#        "defaultIndex" : "logstash-*"
#     }'


class Kibana(object):
    DEFAULT_URL = 'http://{}:9200'.format(socket.gethostname())
    DEFAULT_FIELDS = [
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'logsource',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'indexed': False,
         u'name': u'_source',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'@version',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'severity_label',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'timestamp',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'indexed': True,
         u'name': u'_type',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'pid.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'facility',
         u'scripted': False,
         u'type': u'number'},
        {u'analyzed': False,
         u'count': 0,
         u'indexed': False,
         u'name': u'_id',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'host.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'priority',
         u'scripted': False,
         u'type': u'number'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'facility_label.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'host',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'program.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'message.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'timestamp.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'indexed': False,
         u'name': u'_index',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'logsource.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'severity',
         u'scripted': False,
         u'type': u'number'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'pid',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'message',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'@timestamp',
         u'scripted': False,
         u'type': u'date'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'program',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'severity_label.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'facility_label',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'geoip.location',
         u'scripted': False,
         u'type': u'geo_point'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'type',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'file',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'offset.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'offset',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'file.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'type.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'tags.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'tags',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'status.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'request_time.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'bytes_sent.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'request_time',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'request_id.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'scheme',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'gzip_ratio',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'upstream_response_time.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'connection',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'connection_requests',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'status',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'time_iso8601',
         u'scripted': False,
         u'type': u'date'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'scheme.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'request_length',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'upstream_response_time',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'connection_requests.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'gzip_ratio.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'request_uri.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'pipe',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'request_length.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'request_method.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'pipe.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': False,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'connection.raw',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'request_uri',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'request_method',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'request_id',
         u'scripted': False,
         u'type': u'string'},
        {u'analyzed': True,
         u'count': 0,
         u'doc_values': False,
         u'indexed': True,
         u'name': u'bytes_sent',
         u'scripted': False,
         u'type': u'string'}]

    def __init__(self, url):
        self.server = url.lstrip('/') + '/'
        self.config_url = self.server + '.kibana/config/4.0.2'
        self.index_url = self.server + '.kibana/index-pattern/logstash-*'
        self.search_url = self.server + '.kibana/_search?pretty=true&q=*:*'

    def show(self):
        r = requests.get(self.search_url)
        print(r.json())

    def reset(self):
        print('Deleting config')
        requests.delete(self.config_url)
        requests.delete(self.index_url)

    def configure(self):
        r = requests.get(self.config_url).json()
        if not r['found']:
            # Create new config
            config = {}
        else:
            # Update existing config if necessary
            config = r['_source']

        config.setdefault('defaultIndex', 'logstash-*')

        print('Setting config')
        data = {'doc': config, 'doc_as_upsert': True}
        r = requests.post(self.config_url + '/_update', data=json.dumps(data))
        r.raise_for_status()

        r = requests.get(self.index_url).json()
        if not r['found']:
            index = {}
            index['title'] = 'logstash-*'
            index['timeFieldName'] = '@timestamp'
            index['customFormats'] = '{}'
            # The refresh fields is a complex computation that we can initialize
            # with a default value. Users may need to press the "update fields"
            # button anyway, but this starts with something reasonable.
            index['fields'] = json.dumps(self.DEFAULT_FIELDS)
        else:
            index = r['_source']
        print('Setting index pattern')
        data = {'doc': index, 'doc_as_upsert': True}
        r = requests.post(self.index_url + '_update', data=json.dumps(data))
        r.raise_for_status()


def main():
    a = argparse.argument_parser(description='Set up Kibana default '
                                 'parameters automaticaaly.')
    a.add_argument('ACTION', choices=['reset', 'configure', 'show'])
    a.add_argument('-u', '--url', help='Kibana server URL',
                   default=Kibana.DEFAULT_URL)
    args = a.parse_args()
    kibana = Kibana(args.url)
    func = getattr(kibana, args.ACTION)
    func()
