// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles
parcelRequire = (function (modules, cache, entry, globalName) {
  // Save the require from previous bundle to this closure if any
  var previousRequire = typeof parcelRequire === 'function' && parcelRequire;
  var nodeRequire = typeof require === 'function' && require;

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire = typeof parcelRequire === 'function' && parcelRequire;
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error('Cannot find module \'' + name + '\'');
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = cache[name] = new newRequire.Module(name);

      modules[name][0].call(module.exports, localRequire, module, module.exports, this);
    }

    return cache[name].exports;

    function localRequire(x){
      return newRequire(localRequire.resolve(x));
    }

    function resolve(x){
      return modules[name][1][x] || x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [function (require, module) {
      module.exports = exports;
    }, {}];
  };

  var error;
  for (var i = 0; i < entry.length; i++) {
    try {
      newRequire(entry[i]);
    } catch (e) {
      // Save first error but execute all entries
      if (!error) {
        error = e;
      }
    }
  }

  if (entry.length) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(entry[entry.length - 1]);

    // CommonJS
    if (typeof exports === "object" && typeof module !== "undefined") {
      module.exports = mainExports;

    // RequireJS
    } else if (typeof define === "function" && define.amd) {
     define(function () {
       return mainExports;
     });

    // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }

  // Override the current require with this new one
  parcelRequire = newRequire;

  if (error) {
    // throw error from earlier, _after updating parcelRequire_
    throw error;
  }

  return newRequire;
})({"../../../../../../../../../../aws-sdk.external":[function(require,module,exports) {
module.exports=require('aws-sdk');
},{}],"index.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handler = void 0;

const aws_sdk_1 = require("aws-sdk");

const codecommit = new aws_sdk_1.CodeCommit();

const getProperties = props => ({
  approvalRuleTemplateName: props.ApprovalRuleTemplateName,
  approvalRuleTemplateDescription: props.ApprovalRuleTemplateDescription,
  template: {
    destinationReferences: props.Template.DestinationReferences,
    approvers: {
      numberOfApprovalsNeeded: props.Template.Approvers.NumberOfApprovalsNeeded,
      approvalPoolMembers: props.Template.Approvers.ApprovalPoolMembers
    }
  }
});

const buildTemplateContent = template => {
  const templateContent = {
    Version: '2018-11-08',
    DestinationReferences: template.destinationReferences || undefined,
    Statements: [{
      Type: 'Approvers',
      NumberOfApprovalsNeeded: template.approvers.numberOfApprovalsNeeded,
      ApprovalPoolMembers: template.approvers.approvalPoolMembers || undefined
    }]
  };
  return JSON.stringify(templateContent, null, 2);
};

const onCreate = async event => {
  const {
    approvalRuleTemplateName,
    approvalRuleTemplateDescription = '',
    template
  } = getProperties(event.ResourceProperties);
  const {
    approvalRuleTemplate
  } = await codecommit.createApprovalRuleTemplate({
    approvalRuleTemplateName,
    approvalRuleTemplateDescription,
    approvalRuleTemplateContent: buildTemplateContent(template)
  }).promise();
  return {
    PhysicalResourceId: approvalRuleTemplate.approvalRuleTemplateId,
    Data: {
      ApprovalRuleTemplateName: approvalRuleTemplate.approvalRuleTemplateName
    }
  };
};

const onUpdate = async event => {
  const newProps = getProperties(event.ResourceProperties);
  const oldProps = getProperties(event.OldResourceProperties);
  let approvalRuleTemplate;

  if (buildTemplateContent(newProps.template) !== buildTemplateContent(oldProps.template)) {
    const response = await codecommit.updateApprovalRuleTemplateContent({
      approvalRuleTemplateName: oldProps.approvalRuleTemplateName,
      newRuleContent: buildTemplateContent(newProps.template)
    }).promise();
    approvalRuleTemplate = response.approvalRuleTemplate;
  }

  if (newProps.approvalRuleTemplateDescription !== oldProps.approvalRuleTemplateDescription) {
    const response = await codecommit.updateApprovalRuleTemplateDescription({
      approvalRuleTemplateName: oldProps.approvalRuleTemplateName,
      approvalRuleTemplateDescription: newProps.approvalRuleTemplateDescription || ''
    }).promise();
    approvalRuleTemplate = response.approvalRuleTemplate;
  }

  if (newProps.approvalRuleTemplateName !== oldProps.approvalRuleTemplateName) {
    const response = await codecommit.updateApprovalRuleTemplateName({
      newApprovalRuleTemplateName: newProps.approvalRuleTemplateName,
      oldApprovalRuleTemplateName: oldProps.approvalRuleTemplateName
    }).promise();
    approvalRuleTemplate = response.approvalRuleTemplate;
  }

  if (!approvalRuleTemplate) {
    const response = await codecommit.getApprovalRuleTemplate({
      approvalRuleTemplateName: oldProps.approvalRuleTemplateName
    }).promise();
    approvalRuleTemplate = response.approvalRuleTemplate;
  }

  return {
    PhysicalResourceId: approvalRuleTemplate.approvalRuleTemplateId,
    Data: {
      ApprovalRuleTemplateName: approvalRuleTemplate.approvalRuleTemplateName
    }
  };
};

const onDelete = async event => {
  const {
    approvalRuleTemplateName
  } = getProperties(event.ResourceProperties);
  await codecommit.deleteApprovalRuleTemplate({
    approvalRuleTemplateName
  }).promise();
};

exports.handler = async event => {
  const requestType = event.RequestType;

  switch (requestType) {
    case 'Create':
      return onCreate(event);

    case 'Update':
      return onUpdate(event);

    case 'Delete':
      return onDelete(event);

    default:
      throw new Error(`Invalid request type: ${requestType}`);
  }
};
},{"aws-sdk":"../../../../../../../../../../aws-sdk.external"}]},{},["index.ts"], null)
//# sourceMappingURL=/index.js.map