from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.client_info import ClientInfo


T = TypeVar("T", bound="BRequestIXServicePortIFProvideSystemCryptPassword")


@_attrs_define
class BRequestIXServicePortIFProvideSystemCryptPassword:
    """
    Attributes:
        ci (Union[Unset, ClientInfo]): Contains the session ticket and the users language and country.
            Each Indexserver interface
             function, except the login, requires a <code>ClientInfo</code> object as parameter with a valid
             session ticket.
             <p>
             Copyright: Copyright (c) 2004
             </p>
             <p>
             Organisation: ELO Digital Office GmbH
             </p>
        encryption_set (Union[Unset, str]):
        pwd (Union[Unset, str]):
    """

    ci: Union[Unset, "ClientInfo"] = UNSET
    encryption_set: Union[Unset, str] = UNSET
    pwd: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        ci: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.ci, Unset):
            ci = self.ci.to_dict()

        encryption_set = self.encryption_set

        pwd = self.pwd

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if ci is not UNSET:
            field_dict["ci"] = ci
        if encryption_set is not UNSET:
            field_dict["encryptionSet"] = encryption_set
        if pwd is not UNSET:
            field_dict["pwd"] = pwd

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.client_info import ClientInfo

        d = src_dict.copy()
        _ci = d.pop("ci", UNSET)
        ci: Union[Unset, ClientInfo]
        if isinstance(_ci, Unset):
            ci = UNSET
        else:
            ci = ClientInfo.from_dict(_ci)

        encryption_set = d.pop("encryptionSet", UNSET)

        pwd = d.pop("pwd", UNSET)

        b_request_ix_service_port_if_provide_system_crypt_password = cls(
            ci=ci,
            encryption_set=encryption_set,
            pwd=pwd,
        )

        b_request_ix_service_port_if_provide_system_crypt_password.additional_properties = d
        return b_request_ix_service_port_if_provide_system_crypt_password

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
