from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="Feed")


@_attrs_define
class Feed:
    """This class represents a document feed. Each Sord can have at most one Feed object.
    A Feed
     contains of a list of Action objects which can be user comments, comments generated by scripts
     and actions generated by the system. The Feed object acts like a header for the list of actions.
     Its main purpose is the mapping between feed actions and a Sord object. In order to receive a
     feed of a Sord object inclusive all actions, call function
     {@link FeedService#findFirstActions(de.elo.ix.client.ClientInfo, FindActionsInfo, int, ActionZ)}.

        Attributes:
            create_date_iso (Union[Unset, str]): Create date. It holds the ISO formatted create date in the time zone of the
                client application.
                In order to convert this value into a date object, invoke function
                 {@link de.elo.ix.client.IXConnection#isoToDate}.
            t_stamp_sync (Union[Unset, str]): Timestamp of this object's last export by the replication.
            t_stamp (Union[Unset, str]): Time stamp. Time stamp of creation or modification.
            obj_guid (Union[Unset, str]): GUID of the associated Sord object.
            guid (Union[Unset, str]): Feed GUID.
    """

    create_date_iso: Union[Unset, str] = UNSET
    t_stamp_sync: Union[Unset, str] = UNSET
    t_stamp: Union[Unset, str] = UNSET
    obj_guid: Union[Unset, str] = UNSET
    guid: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        create_date_iso = self.create_date_iso

        t_stamp_sync = self.t_stamp_sync

        t_stamp = self.t_stamp

        obj_guid = self.obj_guid

        guid = self.guid

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if create_date_iso is not UNSET:
            field_dict["createDateIso"] = create_date_iso
        if t_stamp_sync is not UNSET:
            field_dict["TStampSync"] = t_stamp_sync
        if t_stamp is not UNSET:
            field_dict["tStamp"] = t_stamp
        if obj_guid is not UNSET:
            field_dict["objGuid"] = obj_guid
        if guid is not UNSET:
            field_dict["guid"] = guid

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        create_date_iso = d.pop("createDateIso", UNSET)

        t_stamp_sync = d.pop("TStampSync", UNSET)

        t_stamp = d.pop("tStamp", UNSET)

        obj_guid = d.pop("objGuid", UNSET)

        guid = d.pop("guid", UNSET)

        feed = cls(
            create_date_iso=create_date_iso,
            t_stamp_sync=t_stamp_sync,
            t_stamp=t_stamp,
            obj_guid=obj_guid,
            guid=guid,
        )

        feed.additional_properties = d
        return feed

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
