from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

if TYPE_CHECKING:
    from ..models.hash_map_to_integer import HashMapToInteger


T = TypeVar("T", bound="HtCloudData")


@_attrs_define
class HtCloudData:
    """
    Attributes:
        hash_tag_name_cloud (Union[Unset, HashMapToInteger]):
    """

    hash_tag_name_cloud: Union[Unset, "HashMapToInteger"] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        hash_tag_name_cloud: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.hash_tag_name_cloud, Unset):
            hash_tag_name_cloud = self.hash_tag_name_cloud.to_dict()

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if hash_tag_name_cloud is not UNSET:
            field_dict["hashTagNameCloud"] = hash_tag_name_cloud

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.hash_map_to_integer import HashMapToInteger

        d = src_dict.copy()
        _hash_tag_name_cloud = d.pop("hashTagNameCloud", UNSET)
        hash_tag_name_cloud: Union[Unset, HashMapToInteger]
        if isinstance(_hash_tag_name_cloud, Unset):
            hash_tag_name_cloud = UNSET
        else:
            hash_tag_name_cloud = HashMapToInteger.from_dict(_hash_tag_name_cloud)

        ht_cloud_data = cls(
            hash_tag_name_cloud=hash_tag_name_cloud,
        )

        ht_cloud_data.additional_properties = d
        return ht_cloud_data

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
