from typing import Any, Dict, List, Type, TypeVar, Union

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

T = TypeVar("T", bound="OcrInfoQueryLanguages")


@_attrs_define
class OcrInfoQueryLanguages:
    """This class describes a request for querying the supported languages of the OCR.

    Attributes:
        ctrl (Union[Unset, int]): Reserved.
    """

    ctrl: Union[Unset, int] = UNSET
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        ctrl = self.ctrl

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if ctrl is not UNSET:
            field_dict["ctrl"] = ctrl

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        ctrl = d.pop("ctrl", UNSET)

        ocr_info_query_languages = cls(
            ctrl=ctrl,
        )

        ocr_info_query_languages.additional_properties = d
        return ocr_info_query_languages

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
