import Link from 'next/link';

import styles from './css/Header.module.css';

export default function Header() {
  return (
    <div className={styles.header}>
      <Link href="/">
        <DagsterLogo />
      </Link>
    </div>
  );
}

function DagsterLogo() {
  return (
    <svg
      className={styles.svg}
      width="1120"
      height="320"
      viewBox="0 0 1120 320"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M424.577 57.2793H443.328V225.001H424.577V210.208H424.107C417.071 219.357 405.817 228.272 386.58 228.272C356.557 228.272 332.632 204.581 332.632 165.175C332.632 125.769 356.557 102.078 386.58 102.078C405.817 102.078 417.071 110.523 424.107 120.846H424.577V57.2793ZM424.577 165.175C424.577 137.031 410.74 118.498 388.458 118.498C363.828 118.498 351.392 141.719 351.392 165.175C351.392 188.631 363.828 211.852 388.458 211.852C410.74 211.852 424.577 193.319 424.577 165.175Z"
        fill="white"
      />
      <path
        d="M513.361 118.498C490.61 118.498 483.096 125.064 481.93 142.424H463.162C464.336 119.437 478.643 102.078 513.361 102.078C536.113 102.078 556.516 110.993 556.516 139.816V197.99C556.516 207.374 558.193 212.531 570.118 211.123V224.264C566.594 225.568 562.857 226.203 559.099 226.134C547.836 226.134 541.035 223.089 537.756 209.948H537.253C529.748 221.211 516.38 228.247 496.681 228.247C472.521 228.247 457.267 214.41 457.267 194.233C457.267 167.028 477.435 159.992 508.422 154.131C528.599 150.374 537.773 147.791 537.773 135.832C537.756 126.473 532.591 118.498 513.361 118.498ZM537.756 178.777V158.844C534.234 162.357 522.737 165.645 510.082 168.228C486.853 173.15 476.035 179.012 476.035 193.319C476.035 205.059 483.071 211.852 498.56 211.852C520.867 211.852 537.756 201.764 537.756 178.777Z"
        fill="white"
      />
      <path
        d="M664.721 105.365H683.49V218.418C683.49 250.286 663.321 266.504 630.481 266.504C597.641 266.504 578.169 249.145 576.298 228.767H595.117C597.465 240.96 607.319 250.11 629.6 250.11C651.882 250.11 664.78 240.491 664.78 218.242V200.128H664.311C657.275 210.443 646.02 218.888 626.313 218.888C596.761 218.888 572.835 199.894 572.835 160.487C572.835 121.081 596.761 102.078 626.313 102.078C646.02 102.078 657.275 110.993 664.311 120.142H664.78L664.721 105.365ZM664.721 160.487C664.721 132.335 650.884 118.498 628.603 118.498C603.973 118.498 591.544 137.031 591.544 160.487C591.544 183.943 603.973 202.468 628.603 202.468C650.918 202.468 664.721 188.631 664.721 160.487V160.487Z"
        fill="white"
      />
      <path
        d="M798.807 192.153C798.807 213.957 778.873 228.272 751.66 228.272C715.072 228.272 698.182 210.913 697.008 185.117H715.776C716.942 198.485 721.646 211.852 751.66 211.852C772.063 211.852 780.039 201.294 780.039 193.319C780.039 175.968 764.323 175.029 747.207 170.802C728.909 166.349 701.696 164.236 701.696 136.092C701.696 117.324 718.35 102.078 746.503 102.078C776.29 102.078 792.24 118.968 794.11 139.606H775.351C773.472 130.465 769.019 118.498 746.503 118.498C729.613 118.498 720.506 125.299 720.506 134.683C720.506 148.755 736.691 149.929 753.346 153.921C774.646 159.078 798.807 162.592 798.807 192.153Z"
        fill="white"
      />
      <path
        d="M862.23 121.784H838.749V193.787C838.749 207.398 846.297 209.721 862.23 208.572V225C857.603 225.968 852.886 226.441 848.158 226.409C832.225 226.409 820.006 220.078 820.006 195.682V121.801H802.396V105.364H820.006V65.4883H838.774V105.364H862.255L862.23 121.784Z"
        fill="white"
      />
      <path
        d="M961.958 188.161H980.726C974.621 210.443 957.505 228.272 927.718 228.272C891.356 228.272 869.309 202.703 869.309 165.175C869.309 125.299 891.825 102.078 926.779 102.078C964.306 102.078 982.605 127.647 982.605 170.098H888.077C888.077 191.684 900.975 211.852 927.013 211.852C950.939 211.852 959.845 196.371 961.958 188.161ZM888.077 153.72H963.837C963.837 134.482 949.295 118.498 926.779 118.498C904.262 118.498 888.077 134.432 888.077 153.72Z"
        fill="white"
      />
      <path
        d="M1060 102.783V121.551H1059.53C1033.53 117.358 1015.44 135.623 1015.44 161.192V225.002H996.668V105.366H1015.44V129.056H1015.91C1022.24 113.341 1031.84 102.078 1048.98 102.078C1052.67 102.04 1056.35 102.275 1060 102.783V102.783Z"
        fill="white"
      />
      <path
        d="M130.768 257.891C130.771 259.078 131.019 260.252 131.497 261.339C131.974 262.426 132.67 263.403 133.542 264.209C134.413 265.015 135.442 265.632 136.562 266.023C137.683 266.413 138.872 266.568 140.056 266.479C185.038 263.258 227.522 231.425 241.085 181.703C241.798 178.844 243.944 177.41 246.802 177.41C248.268 177.469 249.651 178.103 250.652 179.175C251.653 180.247 252.191 181.671 252.15 183.138C252.15 194.224 237.9 223.198 217.521 240.012C216.483 240.886 215.654 241.983 215.099 243.222C214.543 244.46 214.273 245.808 214.311 247.165C214.331 248.269 214.569 249.357 215.012 250.369C215.454 251.38 216.091 252.294 216.887 253.058C217.683 253.822 218.622 254.422 219.65 254.822C220.678 255.223 221.775 255.417 222.878 255.392C224.663 255.392 227.522 254.319 231.093 251.098C245.344 238.217 272.504 202.09 272.504 162.382C272.504 104.166 227.497 54 164.684 54C108.637 54 60.084 99.7881 60.084 152.73C60.084 187.783 87.9316 214.25 124.699 214.25C152.907 214.25 178.969 194.224 186.111 166.676C186.823 163.816 188.961 162.382 191.82 162.382C193.286 162.441 194.67 163.075 195.672 164.147C196.674 165.219 197.215 166.642 197.176 168.11C197.176 180.63 173.612 224.296 125.772 224.296C114.346 224.296 100.07 221.076 90.0692 215.349C88.7304 214.7 87.2721 214.334 85.7856 214.275C84.6474 214.231 83.5124 214.424 82.4521 214.84C81.3918 215.256 80.4291 215.888 79.6244 216.694C78.8198 217.501 78.1906 218.465 77.7766 219.527C77.3625 220.588 77.1725 221.724 77.2184 222.862C77.2646 224.321 77.6823 225.744 78.432 226.995C79.1816 228.247 80.2383 229.287 81.502 230.016C94.7133 237.563 110.423 241.463 126.484 241.463C166.47 241.463 202.885 214.275 213.598 174.215C214.311 171.355 216.457 169.921 219.307 169.921C220.773 169.98 222.157 170.614 223.159 171.686C224.162 172.758 224.702 174.181 224.663 175.649C224.663 192.102 195.391 245.044 138.983 249.337C136.8 249.499 134.755 250.462 133.238 252.041C131.722 253.62 130.842 255.703 130.768 257.891V257.891Z"
        fill="#DEDEFC"
      />
      <path
        d="M186.664 120.895C194.363 120.838 201.921 122.966 208.459 127.034C209.12 123.416 209.484 119.75 209.549 116.073C209.549 99.0913 196.606 83.8789 180.846 83.8789C168.591 83.8789 160.929 94.0345 160.929 106.58C160.87 113.357 163.251 119.93 167.635 125.097C173.575 122.263 180.084 120.826 186.664 120.895V120.895Z"
        fill="white"
      />
      <path
        d="M223.59 182.417C225.778 174.937 226.742 169.746 226.742 166.374C226.675 164.919 226.051 163.544 225 162.536C223.948 161.527 222.549 160.962 221.092 160.957C219.735 160.982 218.425 161.461 217.371 162.316C216.317 163.172 215.579 164.355 215.274 165.678C214.679 168.136 213.405 174.794 212.147 179.021C212.667 177.438 213.142 175.831 213.573 174.199C214.285 171.331 216.431 169.905 219.281 169.905C220.747 169.962 222.131 170.594 223.133 171.665C224.136 172.735 224.676 174.158 224.638 175.624C224.571 177.93 224.201 180.216 223.54 182.425L223.59 182.417Z"
        fill="#C9C6FA"
      />
      <path
        d="M253.936 174.599C253.867 173.145 253.244 171.773 252.194 170.765C251.145 169.758 249.749 169.191 248.294 169.182C246.938 169.209 245.63 169.688 244.578 170.543C243.526 171.399 242.789 172.581 242.485 173.903C241.881 176.419 240.582 183.178 239.308 187.396H239.366C239.987 185.518 240.565 183.614 241.043 181.677C241.755 178.809 243.901 177.383 246.76 177.383C248.225 177.44 249.608 178.073 250.609 179.143C251.61 180.214 252.149 181.637 252.108 183.103C252.067 184.883 251.823 186.653 251.379 188.377C253.156 182.138 253.936 177.626 253.936 174.599Z"
        fill="#C9C6FA"
      />
      <path
        d="M186.664 120.897C190.49 120.89 194.3 121.4 197.989 122.415C199.926 119.773 200.894 116.544 200.73 113.271C200.566 109.999 199.28 106.882 197.089 104.447C194.897 102.012 191.934 100.406 188.698 99.8996C185.462 99.3935 182.15 100.018 179.32 101.668L185.188 111.329L174.199 106.574C172.71 108.977 171.964 111.766 172.053 114.592C172.143 117.417 173.064 120.153 174.702 122.457C178.602 121.406 182.625 120.881 186.664 120.897V120.897Z"
        fill="#0E0F34"
      />
      <path
        d="M101.998 183.071C106.628 183.071 110.381 179.316 110.381 174.685C110.381 170.053 106.628 166.299 101.998 166.299C97.3683 166.299 93.6152 170.053 93.6152 174.685C93.6152 179.316 97.3683 183.071 101.998 183.071Z"
        fill="#C9C6FA"
      />
      <path
        d="M101.998 149.526C106.628 149.526 110.381 145.772 110.381 141.14C110.381 136.508 106.628 132.754 101.998 132.754C97.3683 132.754 93.6152 136.508 93.6152 141.14C93.6152 145.772 97.3683 149.526 101.998 149.526Z"
        fill="#C9C6FA"
      />
      <path
        d="M85.2324 166.298C89.8621 166.298 93.6152 162.543 93.6152 157.911C93.6152 153.28 89.8621 149.525 85.2324 149.525C80.6027 149.525 76.8496 153.28 76.8496 157.911C76.8496 162.543 80.6027 166.298 85.2324 166.298Z"
        fill="#C9C6FA"
      />
      <path
        d="M122.955 214.233H124.631C152.839 214.233 178.901 194.207 186.044 166.658C186.756 163.799 188.894 162.365 191.752 162.365C193.218 162.424 194.602 163.058 195.605 164.13C196.607 165.202 197.148 166.625 197.109 168.092C196.981 171.02 196.319 173.899 195.156 176.588C195.358 176.275 195.535 175.947 195.684 175.606C197.805 170.756 198.901 165.52 198.903 160.226C198.903 152 193.186 146.632 184.979 146.632C170.67 146.632 167.803 159.128 161.767 172.487C155.505 186.357 144.004 201.36 114.999 201.36C84.8634 201.36 53.8973 180.252 61.4502 137.332C61.5424 136.796 61.6179 136.318 61.6766 135.873C60.5699 141.418 60.0083 147.058 60 152.712C60.0838 187.263 87.068 213.428 122.955 214.233Z"
        fill="#C9C6FA"
      />
    </svg>
  );
}
