#!/usr/bin/env python


NAME = 'Trustwave ModSecurity'


def is_waf(self):
    for attack in self.attacks:
        r = attack(self)
        if r is None:
            return
        response, responsebody = r
        if any(i in responsebody for i in (b'This error was generated by Mod_Security',
            b'rules of the mod_security module', b'mod_security rules triggered', b'Protected by Mod Security',
            b'/modsecurity-errorpage/', b'ModSecurity IIS')):
            return True
        if response.reason == 'ModSecurity Action' and response.code == 403:
            return True
    if self.matchheader(('server', '(mod_security|Mod_Security|NOYB)')):
        return True
    return False