# Generated by Django 4.1.7 on 2023-04-19 05:30

import uuid

import colorfield.fields
import django.core.serializers.json
import django.db.models.deletion
import mptt.fields
import picklefield.fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("wbcore", "0001_initial_squashed_squashed_0010_preset_appliedpreset"),
        ("wbmailing", "0001_initial_squashed_squashed_0008_alter_mail_bcc_email_alter_mail_cc_email_and_more"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Report",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "permission_type",
                    models.CharField(
                        choices=[("INTERNAL", "Internal"), ("PUBLIC", "Public"), ("PRIVATE", "Private")],
                        default="PRIVATE",
                        max_length=8,
                    ),
                ),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
                (
                    "key",
                    models.CharField(
                        default="",
                        help_text="The key is like the family name: it represents the nature of the report.",
                        max_length=256,
                    ),
                ),
                (
                    "file_content_type",
                    models.CharField(
                        choices=[("PDF", "application/pdf"), ("CSV", "text/csv")], default="PDF", max_length=64
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=False, help_text="True if a report needs to be available for this product"
                    ),
                ),
                (
                    "file_disabled",
                    models.BooleanField(default=False, help_text="True if this version file needs to be disabled"),
                ),
                (
                    "base_color",
                    colorfield.fields.ColorField(default="#FFF000", image_field=None, max_length=64, samples=None),
                ),
                ("title", models.CharField(max_length=256)),
                ("namespace", models.CharField(default="", max_length=256)),
                ("logo_file", models.FileField(blank=True, max_length=256, null=True, upload_to="report/logo")),
                ("parameters", models.JSONField(default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ("lft", models.PositiveIntegerField(editable=False)),
                ("rght", models.PositiveIntegerField(editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(editable=False)),
            ],
            options={
                "verbose_name": "Report",
                "verbose_name_plural": "Reports",
                "abstract": False,
                "default_permissions": ("add", "change", "delete", "view", "administrate"),
            },
        ),
        migrations.CreateModel(
            name="ReportAsset",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("key", models.CharField(max_length=255, unique=True)),
                ("description", models.TextField(blank=True, null=True)),
                ("text", models.TextField(blank=True, null=True)),
                ("asset", models.FileField(blank=True, max_length=256, null=True, upload_to="report/assets")),
            ],
            options={
                "verbose_name": "Report Asset",
                "verbose_name_plural": "Report Assets",
            },
        ),
        migrations.CreateModel(
            name="ReportCategory",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=128)),
                ("order", models.IntegerField(default=0)),
            ],
            options={
                "verbose_name": "Report Category",
                "verbose_name_plural": "Report Categories",
            },
        ),
        migrations.CreateModel(
            name="ReportClass",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=256)),
                ("class_path", models.CharField(max_length=256)),
            ],
            options={
                "verbose_name": "Report Class",
                "verbose_name_plural": "Report Classes",
            },
        ),
        migrations.CreateModel(
            name="ReportVersion",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("uuid", models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ("lookup", models.CharField(default="", max_length=256, unique=True)),
                ("title", models.CharField(max_length=256)),
                ("parameters", models.JSONField(default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ("context", picklefield.fields.PickledObjectField(default=dict, editable=False)),
                ("version_date", models.DateField(blank=True, null=True)),
                ("creation_date", models.DateTimeField(auto_now_add=True)),
                ("update_date", models.DateTimeField(auto_now=True)),
                ("comment", models.TextField(default="")),
                (
                    "is_primary",
                    models.BooleanField(
                        default=False,
                        help_text="Only one Version from a report can be considered primary and is usually the last created one",
                    ),
                ),
                ("disabled", models.BooleanField(default=False, help_text="True if version needs to be disabled")),
                (
                    "report",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="versions",
                        to="wbreport.report",
                        verbose_name="Report",
                    ),
                ),
            ],
            options={
                "verbose_name": "Report Version",
                "verbose_name_plural": "Report Versions",
            },
        ),
        migrations.AddField(
            model_name="report",
            name="category",
            field=models.ForeignKey(
                blank=True,
                help_text="The Visual Report category",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="reports",
                to="wbreport.reportcategory",
                verbose_name="Report Category",
            ),
        ),
        migrations.AddField(
            model_name="report",
            name="content_type",
            field=models.ForeignKey(
                blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to="contenttypes.contenttype"
            ),
        ),
        migrations.AddField(
            model_name="report",
            name="creator",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="created_%(app_label)s_%(class)s",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="report",
            name="mailing_list",
            field=models.ForeignKey(
                blank=True,
                help_text="The Mailing List used to send the updated report link",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="reports",
                to="wbmailing.mailinglist",
                verbose_name="Report Mailing List",
            ),
        ),
        migrations.AddField(
            model_name="report",
            name="parent_report",
            field=mptt.fields.TreeForeignKey(
                blank=True,
                help_text="The Parent Report attached to this report",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="child_reports",
                to="wbreport.report",
                verbose_name="Parent Report",
            ),
        ),
        migrations.AddField(
            model_name="report",
            name="report_class",
            field=models.ForeignKey(
                blank=True,
                help_text="The method used to generate reports based on context",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="reports",
                to="wbreport.reportclass",
                verbose_name="Report Class",
            ),
        ),
        migrations.AddConstraint(
            model_name="report",
            constraint=models.UniqueConstraint(
                fields=("parent_report", "title"), name="unique_parent_report_and_report"
            ),
        ),
        migrations.AddConstraint(
            model_name="report",
            constraint=models.UniqueConstraint(
                fields=("key", "content_type", "object_id"), name="unique_content_object_and_key"
            ),
        ),
    ]
