# Generated by Django 4.2.9 on 2024-02-07 15:29

from contextlib import suppress

from django.contrib.contenttypes.models import ContentType
from django.db import migrations


def migrate_theme_portfolio(apps, schema_editor):
    from wbportfolio.models import Product
    from wbreport.models import Report

    PortfolioPortfolioThroughModel = apps.get_model("wbportfolio", "PortfolioPortfolioThroughModel")
    InstrumentPortfolioThroughModel = apps.get_model("wbportfolio", "InstrumentPortfolioThroughModel")
    for report in Report.objects.filter(content_type=ContentType.objects.get_for_model(Product)):
        theme_portfolio_id = None
        with suppress(InstrumentPortfolioThroughModel.DoesNotExist):
            asset_portfolio = InstrumentPortfolioThroughModel.objects.get(
                instrument_id=report.object_id, asset_portfolio=True
            ).portfolio
            if through_portfolio := PortfolioPortfolioThroughModel.objects.filter(
                portfolio=asset_portfolio, is_theme=True
            ).first():
                theme_portfolio_id = through_portfolio.dependency_portfolio.id
        report.parameters["theme_portfolio_id"] = theme_portfolio_id
        report.save()


class Migration(migrations.Migration):
    run_before = [("wbportfolio", "0054_portfolioinstrumentpreferredclassificationthroughmodel_and_more")]
    dependencies = [
        ("wbreport", "0010_auto_20240103_0947"),
    ]

    operations = [migrations.RunPython(migrate_theme_portfolio)]
