/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.EmptyPersistentStack;
import datastructures.PersistentStack;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\u001a0\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u00040\u0006H\u0086\b\u00f8\u0001\u0000\u001aB\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\b0\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\b0\nH\u0086\b\u00f8\u0001\u0000\u001a\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001\u001a%\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0082\u0010\u001a\"\u0010\r\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001H\u0002\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000b\u001a\u001e\u0010\u0016\u001a\n\u0012\u0004\u0012\u0002H\u0002\u0018\u00010\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0001\u001a*\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0019\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"persistentStackOf", "Ldatastructures/PersistentStack;", "T", "forEachElement", "", "action", "Lkotlin/Function1;", "mapToStackIndexed", "R", "transform", "Lkotlin/Function2;", "", "orEmpty", "persistentStackEquals", "", "other", "", "persistentStackHashCode", "persistentStackToString", "", "pop", "popCount", "popOrNull", "pushAll", "values", "", "GeneralUtils"})
@SourceDebugExtension(value={"SMAP\nPersistentStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentStack.kt\ndatastructures/PersistentStackKt\n+ 2 ExtStdlib.kt\nutils/ExtStdlibKt\n*L\n1#1,171:1\n89#1,6:172\n23#2:178\n*S KotlinDebug\n*F\n+ 1 PersistentStack.kt\ndatastructures/PersistentStackKt\n*L\n114#1:172,6\n139#1:178\n*E\n"})
public final class PersistentStackKt {
    public static final <T> void forEachElement(@NotNull PersistentStack<T> $this$forEachElement, @NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkNotNullParameter($this$forEachElement, "<this>");
        Intrinsics.checkNotNullParameter(action, "action");
        boolean $i$f$forEachElement = false;
        PersistentStack<T> current = $this$forEachElement;
        while (!current.isEmpty()) {
            action.invoke(current.getTop());
            current = current.pop();
        }
    }

    private static final <T> boolean persistentStackEquals(PersistentStack<T> $this$persistentStackEquals, Object other) {
        return other == $this$persistentStackEquals ? true : (other instanceof PersistentStack.Builder ? PersistentStackKt.persistentStackEquals($this$persistentStackEquals, ((PersistentStack.Builder)other).build()) : (!(other instanceof PersistentStack) ? false : PersistentStackKt.persistentStackEquals($this$persistentStackEquals, (PersistentStack)other)));
    }

    private static final <T> boolean persistentStackEquals(PersistentStack<T> $this$persistentStackEquals, PersistentStack<?> other) {
        boolean bl;
        while (true) {
            if (other == $this$persistentStackEquals) {
                bl = true;
                break;
            }
            if ($this$persistentStackEquals.isEmpty() && other.isEmpty()) {
                bl = true;
                break;
            }
            if ($this$persistentStackEquals.getSize() != other.getSize()) {
                bl = false;
                break;
            }
            if (!Intrinsics.areEqual($this$persistentStackEquals.getTop(), other.getTop())) {
                bl = false;
                break;
            }
            PersistentStack<T> persistentStack = $this$persistentStackEquals.pop();
            PersistentStack<?> persistentStack2 = other.pop();
            $this$persistentStackEquals = persistentStack;
            other = persistentStack2;
        }
        return bl;
    }

    private static final <T> int persistentStackHashCode(PersistentStack<T> $this$persistentStackHashCode) {
        int h = 0;
        PersistentStack<T> $this$forEachElement$iv = $this$persistentStackHashCode;
        boolean $i$f$forEachElement = false;
        PersistentStack<T> current$iv = $this$forEachElement$iv;
        while (!current$iv.isEmpty()) {
            T it = current$iv.getTop();
            boolean bl = false;
            T t = it;
            h += t != null ? t.hashCode() : 0;
            current$iv = current$iv.pop();
        }
        return h;
    }

    private static final <T> String persistentStackToString(PersistentStack<T> $this$persistentStackToString) {
        return CollectionsKt.joinToString$default($this$persistentStackToString, ", ", "[", "]", 0, null, new Function1<T, CharSequence>($this$persistentStackToString){
            final /* synthetic */ PersistentStack<T> $this_persistentStackToString;
            {
                this.$this_persistentStackToString = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(T it) {
                return it == this.$this_persistentStackToString ? (CharSequence)"(this Collection)" : (CharSequence)String.valueOf(it);
            }
        }, 24, null);
    }

    @NotNull
    public static final <T, R> PersistentStack<R> mapToStackIndexed(@NotNull PersistentStack<T> $this$mapToStackIndexed, @NotNull Function2<? super Integer, ? super T, ? extends R> transform2) {
        Intrinsics.checkNotNullParameter($this$mapToStackIndexed, "<this>");
        Intrinsics.checkNotNullParameter(transform2, "transform");
        boolean $i$f$mapToStackIndexed = false;
        PersistentStack<T> unreversed = $this$mapToStackIndexed;
        PersistentStack<Object> reversed = PersistentStackKt.persistentStackOf();
        while (!unreversed.isEmpty()) {
            reversed = reversed.push(unreversed);
            unreversed = unreversed.pop();
        }
        PersistentStack result2 = PersistentStackKt.persistentStackOf();
        while (!reversed.isEmpty()) {
            PersistentStack t = (PersistentStack)reversed.getTop();
            R r = transform2.invoke(result2.getSize(), t.getTop());
            if (result2 == t.pop() && Intrinsics.areEqual(r, t.getTop())) {
                PersistentStack $this$uncheckedAs$iv = t;
                boolean $i$f$uncheckedAs = false;
                result2 = (PersistentStack)((Object)$this$uncheckedAs$iv);
            } else {
                result2 = result2.push(r);
            }
            reversed = reversed.pop();
        }
        return result2;
    }

    @NotNull
    public static final <T> PersistentStack<T> pop(@NotNull PersistentStack<T> $this$pop, int popCount) {
        Intrinsics.checkNotNullParameter($this$pop, "<this>");
        PersistentStack<T> s = $this$pop;
        int i = 1;
        if (i <= popCount) {
            while (true) {
                s = s.pop();
                if (i == popCount) break;
                ++i;
            }
        }
        return s;
    }

    @Nullable
    public static final <T> PersistentStack<T> popOrNull(@NotNull PersistentStack<T> $this$popOrNull) {
        Intrinsics.checkNotNullParameter($this$popOrNull, "<this>");
        return $this$popOrNull.isEmpty() ? null : $this$popOrNull.pop();
    }

    @NotNull
    public static final <T> PersistentStack<T> pushAll(@NotNull PersistentStack<T> $this$pushAll, @NotNull Iterable<? extends T> values2) {
        Intrinsics.checkNotNullParameter($this$pushAll, "<this>");
        Intrinsics.checkNotNullParameter(values2, "values");
        PersistentStack<T> s = $this$pushAll;
        for (T v : values2) {
            s = s.push(v);
        }
        return s;
    }

    @NotNull
    public static final <T> PersistentStack<T> persistentStackOf() {
        return EmptyPersistentStack.Companion.invoke();
    }

    @NotNull
    public static final <T> PersistentStack<T> orEmpty(@Nullable PersistentStack<T> $this$orEmpty) {
        PersistentStack<T> persistentStack = $this$orEmpty;
        if (persistentStack == null) {
            persistentStack = PersistentStackKt.persistentStackOf();
        }
        return persistentStack;
    }

    public static final /* synthetic */ boolean access$persistentStackEquals(PersistentStack $receiver, Object other) {
        return PersistentStackKt.persistentStackEquals($receiver, other);
    }

    public static final /* synthetic */ int access$persistentStackHashCode(PersistentStack $receiver) {
        return PersistentStackKt.persistentStackHashCode($receiver);
    }

    public static final /* synthetic */ String access$persistentStackToString(PersistentStack $receiver) {
        return PersistentStackKt.persistentStackToString($receiver);
    }
}

