""" Code is generated by ucloud-model, DO NOT EDIT IT. """

from ucloud.core.typesystem import schema, fields
from ucloud.services.umem.schemas import models


""" UMem API Schema
"""


"""
API: CreateUMemSpace

创建UMem内存空间
"""


class CreateUMemSpaceRequestSchema(schema.RequestSchema):
    """ CreateUMemSpace - 创建UMem内存空间
    """

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "Password": fields.Base64(required=False, dump_to="Password"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Protocol": fields.Str(required=False, dump_to="Protocol"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class CreateUMemSpaceResponseSchema(schema.ResponseSchema):
    """ CreateUMemSpace - 创建UMem内存空间
    """

    fields = {"SpaceId": fields.Str(required=False, load_from="SpaceId")}


"""
API: CreateUMemcacheGroup

创建单机Memcache
"""


class CreateUMemcacheGroupRequestSchema(schema.RequestSchema):
    """ CreateUMemcacheGroup - 创建单机Memcache
    """

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ConfigId": fields.Str(required=False, dump_to="ConfigId"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Protocol": fields.Str(required=False, dump_to="Protocol"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=False, dump_to="Size"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Version": fields.Str(required=False, dump_to="Version"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class CreateUMemcacheGroupResponseSchema(schema.ResponseSchema):
    """ CreateUMemcacheGroup - 创建单机Memcache
    """

    fields = {"GroupId": fields.Str(required=False, load_from="GroupId")}


"""
API: CreateURedisGroup

创建主备redis
"""


class CreateURedisGroupRequestSchema(schema.RequestSchema):
    """ CreateURedisGroup - 创建主备redis
    """

    fields = {
        "AutoBackup": fields.Str(required=False, dump_to="AutoBackup"),
        "BackupId": fields.Str(required=False, dump_to="BackupId"),
        "BackupTime": fields.Int(required=False, dump_to="BackupTime"),
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ConfigId": fields.Str(required=False, dump_to="ConfigId"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "HighAvailability": fields.Str(required=True, dump_to="HighAvailability"),
        "MasterGroupId": fields.Str(required=False, dump_to="MasterGroupId"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "Password": fields.Base64(required=False, dump_to="Password"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=False, dump_to="Size"),
        "SlaveZone": fields.Str(required=False, dump_to="SlaveZone"),
        "SubnetId": fields.Str(required=False, dump_to="SubnetId"),
        "Tag": fields.Str(required=False, dump_to="Tag"),
        "VPCId": fields.Str(required=False, dump_to="VPCId"),
        "Version": fields.Str(required=False, dump_to="Version"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateURedisGroupResponseSchema(schema.ResponseSchema):
    """ CreateURedisGroup - 创建主备redis
    """

    fields = {"GroupId": fields.Str(required=False, load_from="GroupId")}


"""
API: DeleteUMemSpace

删除UMem内存空间
"""


class DeleteUMemSpaceRequestSchema(schema.RequestSchema):
    """ DeleteUMemSpace - 删除UMem内存空间
    """

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SpaceId": fields.Str(required=True, dump_to="SpaceId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DeleteUMemSpaceResponseSchema(schema.ResponseSchema):
    """ DeleteUMemSpace - 删除UMem内存空间
    """

    fields = {}


"""
API: DeleteUMemcacheGroup

删除单机Memcache
"""


class DeleteUMemcacheGroupRequestSchema(schema.RequestSchema):
    """ DeleteUMemcacheGroup - 删除单机Memcache
    """

    fields = {
        "GroupId": fields.Str(required=True, dump_to="GroupId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DeleteUMemcacheGroupResponseSchema(schema.ResponseSchema):
    """ DeleteUMemcacheGroup - 删除单机Memcache
    """

    fields = {}


"""
API: DeleteURedisGroup

删除主备redis
"""


class DeleteURedisGroupRequestSchema(schema.RequestSchema):
    """ DeleteURedisGroup - 删除主备redis
    """

    fields = {
        "GroupId": fields.Str(required=True, dump_to="GroupId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DeleteURedisGroupResponseSchema(schema.ResponseSchema):
    """ DeleteURedisGroup - 删除主备redis
    """

    fields = {}


"""
API: DescribeUMemPrice

获取UMem实例价格信息
"""


class DescribeUMemPriceRequestSchema(schema.RequestSchema):
    """ DescribeUMemPrice - 获取UMem实例价格信息
    """

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ProjectId": fields.Str(required=True, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RegionFlag": fields.Bool(required=False, dump_to="RegionFlag"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "Type": fields.Str(required=True, dump_to="Type"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUMemPriceResponseSchema(schema.ResponseSchema):
    """ DescribeUMemPrice - 获取UMem实例价格信息
    """

    fields = {
        "DataSet": fields.List(
            models.UMemPriceSetSchema(), required=False, load_from="DataSet"
        )
    }


"""
API: DescribeUMemSpace

获取UMem内存空间列表
"""


class DescribeUMemSpaceRequestSchema(schema.RequestSchema):
    """ DescribeUMemSpace - 获取UMem内存空间列表
    """

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SpaceId": fields.Str(required=False, dump_to="SpaceId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUMemSpaceResponseSchema(schema.ResponseSchema):
    """ DescribeUMemSpace - 获取UMem内存空间列表
    """

    fields = {
        "DataSet": fields.List(
            models.UMemSpaceSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUMemUpgradePrice

获取UMem升级价格信息
"""


class DescribeUMemUpgradePriceRequestSchema(schema.RequestSchema):
    """ DescribeUMemUpgradePrice - 获取UMem升级价格信息
    """

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "SpaceId": fields.Str(required=True, dump_to="SpaceId"),
        "Type": fields.Str(required=True, dump_to="Type"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUMemUpgradePriceResponseSchema(schema.ResponseSchema):
    """ DescribeUMemUpgradePrice - 获取UMem升级价格信息
    """

    fields = {"Price": fields.Float(required=False, load_from="Price")}


"""
API: DescribeUMemcacheGroup

显示Memcache
"""


class DescribeUMemcacheGroupRequestSchema(schema.RequestSchema):
    """ DescribeUMemcacheGroup - 显示Memcache
    """

    fields = {
        "GroupId": fields.Str(required=False, dump_to="GroupId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUMemcacheGroupResponseSchema(schema.ResponseSchema):
    """ DescribeUMemcacheGroup - 显示Memcache
    """

    fields = {
        "DataSet": fields.List(
            models.UMemcacheGroupSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUMemcachePrice

获取umemcache组价格信息
"""


class DescribeUMemcachePriceRequestSchema(schema.RequestSchema):
    """ DescribeUMemcachePrice - 获取umemcache组价格信息
    """

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeUMemcachePriceResponseSchema(schema.ResponseSchema):
    """ DescribeUMemcachePrice - 获取umemcache组价格信息
    """

    fields = {
        "DataSet": fields.List(
            models.UMemcachePriceSetSchema(), required=False, load_from="DataSet"
        )
    }


"""
API: DescribeUMemcacheUpgradePrice

获取umemcache升级价格信息
"""


class DescribeUMemcacheUpgradePriceRequestSchema(schema.RequestSchema):
    """ DescribeUMemcacheUpgradePrice - 获取umemcache升级价格信息
    """

    fields = {
        "GroupId": fields.Str(required=True, dump_to="GroupId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeUMemcacheUpgradePriceResponseSchema(schema.ResponseSchema):
    """ DescribeUMemcacheUpgradePrice - 获取umemcache升级价格信息
    """

    fields = {"Price": fields.Float(required=False, load_from="Price")}


"""
API: DescribeURedisBackup

查询主备redis备份
"""


class DescribeURedisBackupRequestSchema(schema.RequestSchema):
    """ DescribeURedisBackup - 查询主备redis备份
    """

    fields = {
        "GroupId": fields.Str(required=False, dump_to="GroupId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
    }


class DescribeURedisBackupResponseSchema(schema.ResponseSchema):
    """ DescribeURedisBackup - 查询主备redis备份
    """

    fields = {
        "DataSet": fields.List(
            models.URedisBackupSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeURedisBackupURL

获取主备Redis备份下载链接
"""


class DescribeURedisBackupURLRequestSchema(schema.RequestSchema):
    """ DescribeURedisBackupURL - 获取主备Redis备份下载链接
    """

    fields = {
        "BackupId": fields.Str(required=True, dump_to="BackupId"),
        "GroupId": fields.Str(required=True, dump_to="GroupId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RegionFlag": fields.Bool(required=False, dump_to="RegionFlag"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeURedisBackupURLResponseSchema(schema.ResponseSchema):
    """ DescribeURedisBackupURL - 获取主备Redis备份下载链接
    """

    fields = {
        "BackupPath": fields.Str(required=False, load_from="BackupPath"),
        "BackupURL": fields.Str(required=False, load_from="BackupURL"),
        "InnerBackupPath": fields.Str(required=False, load_from="InnerBackupPath"),
    }


"""
API: DescribeURedisGroup

查询主备Redis
"""


class DescribeURedisGroupRequestSchema(schema.RequestSchema):
    """ DescribeURedisGroup - 查询主备Redis
    """

    fields = {
        "GroupId": fields.Str(required=False, dump_to="GroupId"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeURedisGroupResponseSchema(schema.ResponseSchema):
    """ DescribeURedisGroup - 查询主备Redis
    """

    fields = {
        "DataSet": fields.List(
            models.URedisGroupSetSchema(), required=False, load_from="DataSet"
        ),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeURedisPrice

取uredis价格信息
"""


class DescribeURedisPriceRequestSchema(schema.RequestSchema):
    """ DescribeURedisPrice - 取uredis价格信息
    """

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "ProductType": fields.Str(required=False, dump_to="ProductType"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RegionFlag": fields.Bool(required=False, dump_to="RegionFlag"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeURedisPriceResponseSchema(schema.ResponseSchema):
    """ DescribeURedisPrice - 取uredis价格信息
    """

    fields = {
        "DataSet": fields.List(
            models.URedisPriceSetSchema(), required=False, load_from="DataSet"
        )
    }


"""
API: DescribeURedisUpgradePrice

获取uredis升级价格信息
"""


class DescribeURedisUpgradePriceRequestSchema(schema.RequestSchema):
    """ DescribeURedisUpgradePrice - 获取uredis升级价格信息
    """

    fields = {
        "GroupId": fields.Str(required=True, dump_to="GroupId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class DescribeURedisUpgradePriceResponseSchema(schema.ResponseSchema):
    """ DescribeURedisUpgradePrice - 获取uredis升级价格信息
    """

    fields = {"Price": fields.Float(required=False, load_from="Price")}


"""
API: GetUMemSpaceState

获取UMem内存空间列表
"""


class GetUMemSpaceStateRequestSchema(schema.RequestSchema):
    """ GetUMemSpaceState - 获取UMem内存空间列表
    """

    fields = {
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SpaceId": fields.Str(required=True, dump_to="SpaceId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class GetUMemSpaceStateResponseSchema(schema.ResponseSchema):
    """ GetUMemSpaceState - 获取UMem内存空间列表
    """

    fields = {"State": fields.Str(required=False, load_from="State")}


"""
API: ModifyUMemSpaceName

修改UMem内存空间名称
"""


class ModifyUMemSpaceNameRequestSchema(schema.RequestSchema):
    """ ModifyUMemSpaceName - 修改UMem内存空间名称
    """

    fields = {
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SpaceId": fields.Str(required=True, dump_to="SpaceId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ModifyUMemSpaceNameResponseSchema(schema.ResponseSchema):
    """ ModifyUMemSpaceName - 修改UMem内存空间名称
    """

    fields = {}


"""
API: ModifyURedisGroupName

修改主备redis名称
"""


class ModifyURedisGroupNameRequestSchema(schema.RequestSchema):
    """ ModifyURedisGroupName - 修改主备redis名称
    """

    fields = {
        "GroupId": fields.Str(required=True, dump_to="GroupId"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ModifyURedisGroupNameResponseSchema(schema.ResponseSchema):
    """ ModifyURedisGroupName - 修改主备redis名称
    """

    fields = {}


"""
API: ResizeUDredisSpace

调整内存空间容量
"""


class ResizeUDredisSpaceRequestSchema(schema.RequestSchema):
    """ ResizeUDredisSpace - 调整内存空间容量
    """

    fields = {
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "SpaceId": fields.Str(required=True, dump_to="SpaceId"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ResizeUDredisSpaceResponseSchema(schema.ResponseSchema):
    """ ResizeUDredisSpace - 调整内存空间容量
    """

    fields = {}


"""
API: ResizeUMemSpace

调整内存空间容量
"""


class ResizeUMemSpaceRequestSchema(schema.RequestSchema):
    """ ResizeUMemSpace - 调整内存空间容量
    """

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Str(required=False, dump_to="CouponId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "SpaceId": fields.Str(required=True, dump_to="SpaceId"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ResizeUMemSpaceResponseSchema(schema.ResponseSchema):
    """ ResizeUMemSpace - 调整内存空间容量
    """

    fields = {}


"""
API: ResizeURedisGroup

调整主备redis容量
"""


class ResizeURedisGroupRequestSchema(schema.RequestSchema):
    """ ResizeURedisGroup - 调整主备redis容量
    """

    fields = {
        "ChargeType": fields.Str(required=False, dump_to="ChargeType"),
        "CouponId": fields.Int(required=False, dump_to="CouponId"),
        "GroupId": fields.Str(required=True, dump_to="GroupId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Size": fields.Int(required=True, dump_to="Size"),
        "Type": fields.Str(required=False, dump_to="Type"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class ResizeURedisGroupResponseSchema(schema.ResponseSchema):
    """ ResizeURedisGroup - 调整主备redis容量
    """

    fields = {}


"""
API: RestartUMemcacheGroup

重启单机Memcache
"""


class RestartUMemcacheGroupRequestSchema(schema.RequestSchema):
    """ RestartUMemcacheGroup - 重启单机Memcache
    """

    fields = {
        "GroupId": fields.Str(required=True, dump_to="GroupId"),
        "ProjectId": fields.Str(required=False, dump_to="ProjectId"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=False, dump_to="Zone"),
    }


class RestartUMemcacheGroupResponseSchema(schema.ResponseSchema):
    """ RestartUMemcacheGroup - 重启单机Memcache
    """

    fields = {}
