"""
    IRN API v1

    Allows users to extract, create, update and configure IRN data.  # noqa: E501

    The version of the OpenAPI document: 1
    Contact: api@factset.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401
from multiprocessing.pool import ApplyResult
import typing

from fds.sdk.IRNNotes.api_client import ApiClient, Endpoint as _Endpoint
from fds.sdk.IRNNotes.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from fds.sdk.IRNNotes.exceptions import ApiException
from fds.sdk.IRNNotes.model.create_note_dto import CreateNoteDto
from fds.sdk.IRNNotes.model.new_item_dto import NewItemDto
from fds.sdk.IRNNotes.model.note_dto import NoteDto
from fds.sdk.IRNNotes.model.note_summary_dto import NoteSummaryDto
from fds.sdk.IRNNotes.model.problem_details import ProblemDetails
from fds.sdk.IRNNotes.model.update_note_dto import UpdateNoteDto





class NotesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        self.create_note_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 201: (NewItemDto,), 400: (ProblemDetails,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/notes',
                'operation_id': 'create_note',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'create_note_dto',
                    'x_irn_contributor_username',
                    'x_irn_contributor_serial',
                ],
                'required': [
                    'create_note_dto',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'x_irn_contributor_username',
                    'x_irn_contributor_serial',
                ]
            },
            root_map={
                'validations': {
                    ('x_irn_contributor_username',): {
                        'max_length': 30,
                        'min_length': 0,
                    },
                    ('x_irn_contributor_serial',): {
                        'max_length': 8,
                        'min_length': 0,
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'create_note_dto':
                        (CreateNoteDto,),
                    'x_irn_contributor_username':
                        (str,),
                    'x_irn_contributor_serial':
                        (str,),
                },
                'attribute_map': {
                    'x_irn_contributor_username': 'X-IRN-Contributor-Username',
                    'x_irn_contributor_serial': 'X-IRN-Contributor-Serial',
                },
                'location_map': {
                    'create_note_dto': 'body',
                    'x_irn_contributor_username': 'header',
                    'x_irn_contributor_serial': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )

        self.delete_note_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/notes/{noteId}',
                'operation_id': 'delete_note',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'note_id',
                ],
                'required': [
                    'note_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'note_id':
                        (str,),
                },
                'attribute_map': {
                    'note_id': 'noteId',
                },
                'location_map': {
                    'note_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_note_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: (NoteDto,), 404: (ProblemDetails,), 0: (ProblemDetails,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/notes/{noteId}',
                'operation_id': 'get_note',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'note_id',
                ],
                'required': [
                    'note_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'note_id':
                        (str,),
                },
                'attribute_map': {
                    'note_id': 'noteId',
                },
                'location_map': {
                    'note_id': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.get_notes_endpoint = _Endpoint(
            settings={
                'response_type': (
                  { 200: ([NoteSummaryDto],), 400: (ProblemDetails,),  },
                  None
                ),
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/notes',
                'operation_id': 'get_notes',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'start',
                    'end',
                    'identifiers',
                    'authors',
                    'subjects',
                    'recommendations',
                    'sentiments',
                    'limit',
                    'offset',
                    'modified_since',
                    'states',
                    'filter_on_related_symbols',
                    'include_related_entities',
                    'x_irn_include_deleted',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'start':
                        (str,),
                    'end':
                        (str,),
                    'identifiers':
                        ([str],),
                    'authors':
                        ([str],),
                    'subjects':
                        ([str],),
                    'recommendations':
                        ([str],),
                    'sentiments':
                        ([str],),
                    'limit':
                        (int,),
                    'offset':
                        (int,),
                    'modified_since':
                        (str,),
                    'states':
                        ([str],),
                    'filter_on_related_symbols':
                        (bool,),
                    'include_related_entities':
                        (bool,),
                    'x_irn_include_deleted':
                        (bool,),
                },
                'attribute_map': {
                    'start': 'start',
                    'end': 'end',
                    'identifiers': 'identifiers',
                    'authors': 'authors',
                    'subjects': 'subjects',
                    'recommendations': 'recommendations',
                    'sentiments': 'sentiments',
                    'limit': 'limit',
                    'offset': 'offset',
                    'modified_since': 'modifiedSince',
                    'states': 'states',
                    'filter_on_related_symbols': 'filterOnRelatedSymbols',
                    'include_related_entities': 'includeRelatedEntities',
                    'x_irn_include_deleted': 'X-IRN-Include-Deleted',
                },
                'location_map': {
                    'start': 'query',
                    'end': 'query',
                    'identifiers': 'query',
                    'authors': 'query',
                    'subjects': 'query',
                    'recommendations': 'query',
                    'sentiments': 'query',
                    'limit': 'query',
                    'offset': 'query',
                    'modified_since': 'query',
                    'states': 'query',
                    'filter_on_related_symbols': 'query',
                    'include_related_entities': 'query',
                    'x_irn_include_deleted': 'header',
                },
                'collection_format_map': {
                    'identifiers': 'multi',
                    'authors': 'multi',
                    'subjects': 'multi',
                    'recommendations': 'multi',
                    'sentiments': 'multi',
                    'states': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

        self.update_note_endpoint = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'FactSetApiKey',
                    'FactSetOAuth2'
                ],
                'endpoint_path': '/notes/{noteId}',
                'operation_id': 'update_note',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'note_id',
                    'update_note_dto',
                ],
                'required': [
                    'note_id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'note_id':
                        (str,),
                    'update_note_dto':
                        (UpdateNoteDto,),
                },
                'attribute_map': {
                    'note_id': 'noteId',
                },
                'location_map': {
                    'note_id': 'path',
                    'update_note_dto': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json-patch+json',
                    'application/json',
                    'text/json',
                    'application/*+json'
                ]
            },
            api_client=api_client
        )


    @staticmethod
    def apply_kwargs_defaults(kwargs, return_http_data_only, async_req):
        kwargs["async_req"] = async_req
        kwargs["_return_http_data_only"] = return_http_data_only
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")


    def create_note(
        self,
        create_note_dto,
        **kwargs
    ) -> NewItemDto:
        """Create a note  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            create_note_dto (CreateNoteDto):

        Keyword Args:
            x_irn_contributor_username (str): [optional]
            x_irn_contributor_serial (str): [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NewItemDto
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['create_note_dto'] = \
            create_note_dto
        return self.create_note_endpoint.call_with_http_info(**kwargs)

    def create_note_with_http_info(
        self,
        create_note_dto,
        **kwargs
    ) -> typing.Tuple[NewItemDto, int, typing.MutableMapping]:
        """Create a note  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            create_note_dto (CreateNoteDto):

        Keyword Args:
            x_irn_contributor_username (str): [optional]
            x_irn_contributor_serial (str): [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NewItemDto
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['create_note_dto'] = \
            create_note_dto
        return self.create_note_endpoint.call_with_http_info(**kwargs)

    def create_note_async(
        self,
        create_note_dto,
        **kwargs
    ) -> "ApplyResult[NewItemDto]":
        """Create a note  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            create_note_dto (CreateNoteDto):

        Keyword Args:
            x_irn_contributor_username (str): [optional]
            x_irn_contributor_serial (str): [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[NewItemDto]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['create_note_dto'] = \
            create_note_dto
        return self.create_note_endpoint.call_with_http_info(**kwargs)

    def create_note_with_http_info_async(
        self,
        create_note_dto,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[NewItemDto, int, typing.MutableMapping]]":
        """Create a note  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            create_note_dto (CreateNoteDto):

        Keyword Args:
            x_irn_contributor_username (str): [optional]
            x_irn_contributor_serial (str): [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(NewItemDto, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['create_note_dto'] = \
            create_note_dto
        return self.create_note_endpoint.call_with_http_info(**kwargs)


    def delete_note(
        self,
        note_id,
        **kwargs
    ) -> None:
        """Delete a Note  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            note_id (str):

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['note_id'] = \
            note_id
        return self.delete_note_endpoint.call_with_http_info(**kwargs)

    def delete_note_with_http_info(
        self,
        note_id,
        **kwargs
    ) -> typing.Tuple[None, int, typing.MutableMapping]:
        """Delete a Note  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            note_id (str):

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['note_id'] = \
            note_id
        return self.delete_note_endpoint.call_with_http_info(**kwargs)

    def delete_note_async(
        self,
        note_id,
        **kwargs
    ) -> "ApplyResult[None]":
        """Delete a Note  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            note_id (str):

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[None]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['note_id'] = \
            note_id
        return self.delete_note_endpoint.call_with_http_info(**kwargs)

    def delete_note_with_http_info_async(
        self,
        note_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[None, int, typing.MutableMapping]]":
        """Delete a Note  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            note_id (str):

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(None, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['note_id'] = \
            note_id
        return self.delete_note_endpoint.call_with_http_info(**kwargs)


    def get_note(
        self,
        note_id,
        **kwargs
    ) -> NoteDto:
        """Get details of a note  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            note_id (str): Note Id

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NoteDto
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['note_id'] = \
            note_id
        return self.get_note_endpoint.call_with_http_info(**kwargs)

    def get_note_with_http_info(
        self,
        note_id,
        **kwargs
    ) -> typing.Tuple[NoteDto, int, typing.MutableMapping]:
        """Get details of a note  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            note_id (str): Note Id

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            NoteDto
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['note_id'] = \
            note_id
        return self.get_note_endpoint.call_with_http_info(**kwargs)

    def get_note_async(
        self,
        note_id,
        **kwargs
    ) -> "ApplyResult[NoteDto]":
        """Get details of a note  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            note_id (str): Note Id

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[NoteDto]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['note_id'] = \
            note_id
        return self.get_note_endpoint.call_with_http_info(**kwargs)

    def get_note_with_http_info_async(
        self,
        note_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[NoteDto, int, typing.MutableMapping]]":
        """Get details of a note  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            note_id (str): Note Id

        Keyword Args:
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(NoteDto, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['note_id'] = \
            note_id
        return self.get_note_endpoint.call_with_http_info(**kwargs)


    def get_notes(
        self,
        **kwargs
    ) -> typing.List[NoteSummaryDto]:
        """Get all the notes in the specified date range filtered on the given identifiers  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only


        Keyword Args:
            start (str): StartDate. [optional]
            end (str): EndDate. [optional]
            identifiers ([str]): Set of identifiers to filter on. [optional]
            authors ([str]): Set of authors to filter on. [optional]
            subjects ([str]): Set of subjects to filter on. [optional]
            recommendations ([str]): Set of recommendations to filter on. [optional]
            sentiments ([str]): Set of sentiments to filter on. [optional]
            limit (int): Limit on the number of notes retrieved. [optional]
            offset (int): Fetch notes after the offset. [optional]
            modified_since (str): Only return notes which have been modified or created since a particular time. [optional]
            states ([str]): Set of states to filter on. [optional]
            filter_on_related_symbols (bool): Include notes whose related symbols match the identifier filter. [optional] if omitted the server will use the default value of False
            include_related_entities (bool): When set to true fetches notes tagged with all the entities related to identifiers param. [optional] if omitted the server will use the default value of False
            x_irn_include_deleted (bool): [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            typing.List[NoteSummaryDto]
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        return self.get_notes_endpoint.call_with_http_info(**kwargs)

    def get_notes_with_http_info(
        self,
        **kwargs
    ) -> typing.Tuple[typing.List[NoteSummaryDto], int, typing.MutableMapping]:
        """Get all the notes in the specified date range filtered on the given identifiers  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers


        Keyword Args:
            start (str): StartDate. [optional]
            end (str): EndDate. [optional]
            identifiers ([str]): Set of identifiers to filter on. [optional]
            authors ([str]): Set of authors to filter on. [optional]
            subjects ([str]): Set of subjects to filter on. [optional]
            recommendations ([str]): Set of recommendations to filter on. [optional]
            sentiments ([str]): Set of sentiments to filter on. [optional]
            limit (int): Limit on the number of notes retrieved. [optional]
            offset (int): Fetch notes after the offset. [optional]
            modified_since (str): Only return notes which have been modified or created since a particular time. [optional]
            states ([str]): Set of states to filter on. [optional]
            filter_on_related_symbols (bool): Include notes whose related symbols match the identifier filter. [optional] if omitted the server will use the default value of False
            include_related_entities (bool): When set to true fetches notes tagged with all the entities related to identifiers param. [optional] if omitted the server will use the default value of False
            x_irn_include_deleted (bool): [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            typing.List[NoteSummaryDto]
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        return self.get_notes_endpoint.call_with_http_info(**kwargs)

    def get_notes_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.List[NoteSummaryDto]]":
        """Get all the notes in the specified date range filtered on the given identifiers  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult


        Keyword Args:
            start (str): StartDate. [optional]
            end (str): EndDate. [optional]
            identifiers ([str]): Set of identifiers to filter on. [optional]
            authors ([str]): Set of authors to filter on. [optional]
            subjects ([str]): Set of subjects to filter on. [optional]
            recommendations ([str]): Set of recommendations to filter on. [optional]
            sentiments ([str]): Set of sentiments to filter on. [optional]
            limit (int): Limit on the number of notes retrieved. [optional]
            offset (int): Fetch notes after the offset. [optional]
            modified_since (str): Only return notes which have been modified or created since a particular time. [optional]
            states ([str]): Set of states to filter on. [optional]
            filter_on_related_symbols (bool): Include notes whose related symbols match the identifier filter. [optional] if omitted the server will use the default value of False
            include_related_entities (bool): When set to true fetches notes tagged with all the entities related to identifiers param. [optional] if omitted the server will use the default value of False
            x_irn_include_deleted (bool): [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[typing.List[NoteSummaryDto]]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        return self.get_notes_endpoint.call_with_http_info(**kwargs)

    def get_notes_with_http_info_async(
        self,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[typing.List[NoteSummaryDto], int, typing.MutableMapping]]":
        """Get all the notes in the specified date range filtered on the given identifiers  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult


        Keyword Args:
            start (str): StartDate. [optional]
            end (str): EndDate. [optional]
            identifiers ([str]): Set of identifiers to filter on. [optional]
            authors ([str]): Set of authors to filter on. [optional]
            subjects ([str]): Set of subjects to filter on. [optional]
            recommendations ([str]): Set of recommendations to filter on. [optional]
            sentiments ([str]): Set of sentiments to filter on. [optional]
            limit (int): Limit on the number of notes retrieved. [optional]
            offset (int): Fetch notes after the offset. [optional]
            modified_since (str): Only return notes which have been modified or created since a particular time. [optional]
            states ([str]): Set of states to filter on. [optional]
            filter_on_related_symbols (bool): Include notes whose related symbols match the identifier filter. [optional] if omitted the server will use the default value of False
            include_related_entities (bool): When set to true fetches notes tagged with all the entities related to identifiers param. [optional] if omitted the server will use the default value of False
            x_irn_include_deleted (bool): [optional] if omitted the server will use the default value of False
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(typing.List[NoteSummaryDto], int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        return self.get_notes_endpoint.call_with_http_info(**kwargs)


    def update_note(
        self,
        note_id,
        **kwargs
    ) -> None:
        """Updates a note by replacing existing note with new data  # noqa: E501

        This method makes a synchronous HTTP request. Returns the http data only

        Args:
            note_id (str): Note Id

        Keyword Args:
            update_note_dto (UpdateNoteDto): The new data for the note. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=False)
        kwargs['note_id'] = \
            note_id
        return self.update_note_endpoint.call_with_http_info(**kwargs)

    def update_note_with_http_info(
        self,
        note_id,
        **kwargs
    ) -> typing.Tuple[None, int, typing.MutableMapping]:
        """Updates a note by replacing existing note with new data  # noqa: E501

        This method makes a synchronous HTTP request. Returns http data, http status and headers

        Args:
            note_id (str): Note Id

        Keyword Args:
            update_note_dto (UpdateNoteDto): The new data for the note. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            None
                Response Object
            int
                Http Status Code
            dict
                Dictionary of the response headers
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=False)
        kwargs['note_id'] = \
            note_id
        return self.update_note_endpoint.call_with_http_info(**kwargs)

    def update_note_async(
        self,
        note_id,
        **kwargs
    ) -> "ApplyResult[None]":
        """Updates a note by replacing existing note with new data  # noqa: E501

        This method makes a asynchronous HTTP request. Returns the http data, wrapped in ApplyResult

        Args:
            note_id (str): Note Id

        Keyword Args:
            update_note_dto (UpdateNoteDto): The new data for the note. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[None]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=True, async_req=True)
        kwargs['note_id'] = \
            note_id
        return self.update_note_endpoint.call_with_http_info(**kwargs)

    def update_note_with_http_info_async(
        self,
        note_id,
        **kwargs
    ) -> "ApplyResult[typing.Tuple[None, int, typing.MutableMapping]]":
        """Updates a note by replacing existing note with new data  # noqa: E501

        This method makes a asynchronous HTTP request. Returns http data, http status and headers, wrapped in ApplyResult

        Args:
            note_id (str): Note Id

        Keyword Args:
            update_note_dto (UpdateNoteDto): The new data for the note. [optional]
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True. NOTE: if this API returns a file, it is the responsibility
                of the caller to close the file stream.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
        Returns:
            ApplyResult[(None, int, typing.Dict)]
        """
        self.apply_kwargs_defaults(kwargs=kwargs, return_http_data_only=False, async_req=True)
        kwargs['note_id'] = \
            note_id
        return self.update_note_endpoint.call_with_http_info(**kwargs)


