# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from ..._models import BaseModel

__all__ = ["ResponseFunctionShellToolCall", "Action"]


class Action(BaseModel):
    commands: List[str]

    max_output_length: Optional[int] = None
    """Optional maximum number of characters to return from each command."""

    timeout_ms: Optional[int] = None
    """Optional timeout in milliseconds for the commands."""


class ResponseFunctionShellToolCall(BaseModel):
    id: str
    """The unique ID of the function shell tool call.

    Populated when this item is returned via API.
    """

    action: Action
    """The shell commands and limits that describe how to run the tool call."""

    call_id: str
    """The unique ID of the function shell tool call generated by the model."""

    status: Literal["in_progress", "completed", "incomplete"]
    """The status of the shell call.

    One of `in_progress`, `completed`, or `incomplete`.
    """

    type: Literal["shell_call"]
    """The type of the item. Always `shell_call`."""

    created_by: Optional[str] = None
    """The ID of the entity that created this tool call."""
