# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulp_python.api_client import ApiClient
from pulpcore.client.pulp_python.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PypiLegacyApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, path, content, sha256_digest, **kwargs):  # noqa: E501
        """Upload a package  # noqa: E501

        Upload package to the index.  This is the endpoint that tools like Twine and Poetry use for their upload commands.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(path, content, sha256_digest, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str path: (required)
        :param file content: A Python package release file to upload to the index. (required)
        :param str sha256_digest: SHA256 of package to validate upload integrity. (required)
        :param str action: Defaults to `file_upload`, don't change it or request will fail!
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PackageUploadTaskResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_with_http_info(path, content, sha256_digest, **kwargs)  # noqa: E501

    def create_with_http_info(self, path, content, sha256_digest, **kwargs):  # noqa: E501
        """Upload a package  # noqa: E501

        Upload package to the index.  This is the endpoint that tools like Twine and Poetry use for their upload commands.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(path, content, sha256_digest, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str path: (required)
        :param file content: A Python package release file to upload to the index. (required)
        :param str sha256_digest: SHA256 of package to validate upload integrity. (required)
        :param str action: Defaults to `file_upload`, don't change it or request will fail!
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PackageUploadTaskResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'path',
            'content',
            'sha256_digest',
            'action'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'path' is set
        if self.api_client.client_side_validation and ('path' not in local_var_params or  # noqa: E501
                                                        local_var_params['path'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `path` when calling `create`")  # noqa: E501
        # verify the required parameter 'content' is set
        if self.api_client.client_side_validation and ('content' not in local_var_params or  # noqa: E501
                                                        local_var_params['content'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `content` when calling `create`")  # noqa: E501
        # verify the required parameter 'sha256_digest' is set
        if self.api_client.client_side_validation and ('sha256_digest' not in local_var_params or  # noqa: E501
                                                        local_var_params['sha256_digest'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `sha256_digest` when calling `create`")  # noqa: E501

        if self.api_client.client_side_validation and ('sha256_digest' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sha256_digest']) > 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sha256_digest` when calling `create`, length must be less than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('sha256_digest' in local_var_params and  # noqa: E501
                                                        len(local_var_params['sha256_digest']) < 64):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `sha256_digest` when calling `create`, length must be greater than or equal to `64`")  # noqa: E501
        if self.api_client.client_side_validation and ('action' in local_var_params and  # noqa: E501
                                                        len(local_var_params['action']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `action` when calling `create`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'path' in local_var_params:
            path_params['path'] = local_var_params['path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'content' in local_var_params:
            local_var_files['content'] = local_var_params['content']  # noqa: E501
        if 'action' in local_var_params:
            form_params.append(('action', local_var_params['action']))  # noqa: E501
        if 'sha256_digest' in local_var_params:
            form_params.append(('sha256_digest', local_var_params['sha256_digest']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data', 'application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pypi/{path}/legacy/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PackageUploadTaskResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
