# coding: utf-8

import pprint
import re

import six





class AuditReport:


    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """

    sensitive_list = []

    openapi_types = {
        'black_position': 'str'
    }

    attribute_map = {
        'black_position': 'black_position'
    }

    def __init__(self, black_position=None):
        """AuditReport - a model defined in huaweicloud sdk"""
        
        

        self._black_position = None
        self.discriminator = None

        if black_position is not None:
            self.black_position = black_position

    @property
    def black_position(self):
        """Gets the black_position of this AuditReport.

        疑似黑边位置信息，参数格式：top:bottom:left:right 

        :return: The black_position of this AuditReport.
        :rtype: str
        """
        return self._black_position

    @black_position.setter
    def black_position(self, black_position):
        """Sets the black_position of this AuditReport.

        疑似黑边位置信息，参数格式：top:bottom:left:right 

        :param black_position: The black_position of this AuditReport.
        :type: str
        """
        self._black_position = black_position

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                if attr in self.sensitive_list:
                    result[attr] = "****"
                else:
                    result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AuditReport):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
